 ;**********************************************************************
;*     ATT.ASP for Procomm Plus -                                     *
;* ATT command file for automatic logon and send/ receive to ATT GMS  *
;*     Network.  This script does an automatic send/receive to ATT    *
;*     Network if the outbound file exists.  If it doesn't exist a    *
;*     receive only is performed.                                     *
;*     All of the call logging information is written to a file       *
;*     called att.log.  This file is deleted at the begining of each  *
;*     session automatically.                                         *
;*                                                                    *
;*      DATE WRITTEN: 12-07-92                                        *
;*      REVISED:                                                      *
;*      BY:           Rick L. Leedy                                   *
;*                    American Business Computer                      *
;*     07-11-95       Jack Metkus
;*                    Sterling Software
;*   To invoke pcplus and this script from the command line, type:    *
;*          pcplus /fATT    <enter>                                   *
;*                                                                    *
;*   The following system variables must be updated prior to use:     *
;*                                                                    *
;* BAUDRATE 2400            ;* DESIRED BAUD RATE                      *
;* PORT COM1                ;* The COM port containing the modem      *
;*                                                                    *
;* You will also need to initialize the logon information in the file *
;* logon.att.  The parameters in this file are:                       *
;*                                                                    *
;* 1: "ATTOUT.DAT"          ;* ATT OUTBOUND FILE NAME                 *
;* 2: "ATTIN.DAT"           ;* ATTINBOUND FILE NAME                   *
;* 3: "USER-ID"             ;* USER ID                                *
;* 4: "PASSWORD"            ;* ATT Password                           *
;* 5: "PASSWORD2"           ;* Secondary ATT Password (if applicable) *
;* 6: "ATDT 1(800)624-5123  ;* ATT Dial Up phone Number               *
;* 7: "ATDT 1(###)###-####  ;* ATT Dial Up phone Number NUMBER 2      *
;* 8: "RCVTYPE"             ;* Receive Mode ( Y / N )                 *
;*                                                                    *
;**********************************************************************

DEFINE LOGNAME "ATT.LOG"

PROC MAIN

   SET BAUDRATE 2400           ;* desired BAUD rate
   SET PORT COM2               ;* COMM port containing the modem
   SET DATABITS 8
   SET PARITY NONE
   SET STOPBITS 1
   SET DUPLEX FULL
   set modem waitcnct 30
   SET SOUND OFF
   EMULATE ANSI                  ;* Use ANSI-BBS emulation for ANSI graphics *
   HANGUP                        ;* Make sure we are off-line
   STRING LOGONSTR ;*  Logon ID                         *
   STRING PASSWRD  ;*  Password                         *
   STRING PASSWRD2 ;*  Second Password  ( If Used )     *
   STRING PHONENUM ;*  Phone Number                     *
   STRING PHONENM2 ;*  Backup Phone Number              *
   STRING INFILE   ;*  Network incomming file name      *
   STRING OUTFILE  ;*  Network Outgoing File name       *
   STRING RCVTYPE  ;*  Y TO RECEIVE DATA                *
                   ;*  N FOR NO RECEIVE                 *

   STRING BUFFER
   INTEGER FLEND
   INTEGER X

         ;***************************************************
         ;**                 MAIN PROCEDURE                **
         ;***************************************************

   DELETE INFILE
   FOPEN 0 "LOGON.ATT" "RT"

   WHILE NOT FLEND
      FGETS 0 BUFFER

      STRCMP BUFFER "1:" 2
      IF SUCCESS
        SUBSTR OUTFILE BUFFER 2 34
        STRLEN OUTFILE X
        DEC X
        STRPOKE OUTFILE X 00
      ENDIF

      STRCMP BUFFER "2:" 2
      IF SUCCESS
        STRSET INFILE 00 34
        SUBSTR INFILE BUFFER 2 34
        STRLEN INFILE X
        DEC X
        STRPOKE INFILE X 00
      ENDIF

      STRCMP BUFFER "3:" 2
      IF SUCCESS
        SUBSTR LOGONSTR BUFFER 2 12               ;* Extended to max logon size jjm 071195
        STRCAT LOGONSTR "^M"
      ENDIF

      STRCMP BUFFER "4:" 2
      IF SUCCESS
        SUBSTR PASSWRD BUFFER 2 8
        STRCAT PASSWRD "^M"
      ENDIF

      STRCMP BUFFER "5:" 2
      IF SUCCESS
        SUBSTR PASSWRD2 BUFFER 2 8
        STRCAT PASSWRD2 "^M"
      ENDIF

      STRCMP BUFFER "6:" 2
      IF SUCCESS
        SUBSTR PHONENUM BUFFER 2 34
      ENDIF

      STRCMP BUFFER "7:" 2
      IF SUCCESS
        SUBSTR PHONENM2 BUFFER 2 34
      ENDIF

      STRCMP BUFFER "8:" 2
      IF SUCCESS
        SUBSTR RCVTYPE BUFFER 2 1
        STRUPR RCVTYPE          ;* Convert to uppercase
      ENDIF

      EOF 0 FLEND
   ENDWHILE

   FCLOSE 0

   ;***************END OF INITIALIZATION SECTION  **************************

   ;************************************************************************

   DELETE LOGNAME            ;* Remove old log file
   LOG OPEN LOGNAME

   MESSAGE "`n                    Dialing the ATT GMS Network...`n"
   TRANSMIT "ATDT "
   TRANSMIT PHONENUM
   TRANSMIT "^M"             ;* ATT Dial Up Phone Number
   WAITFOR "CONNECT" 60
   IF NOT WAITFOR
      MESSAGE "`n   FAILED TO CONNECT TO MAIN PHONE NUMBER...`n"
      MESSAGE "`n   TRYING SECOND PHONE NUMBER...`n"
      HANGUP
      TRANSMIT "ATDT "
      TRANSMIT PHONENM2      ;* ATT Dial Up phone Number 2
      TRANSMIT "^M"
      WAITFOR "CONNECT" 45
      IF NOT WAITFOR
         CALL ERROR WITH 1
      ENDIF
   ENDIF
   PAUSE 1                   ;*  Added ABCL30025 jjm 071195
   TRANSMIT "^M"
   PAUSE 1
   TRANSMIT "^M"
   PAUSE 1
   WAITFOR "Name:" 60
   IF NOT WAITFOR
      CALL ERROR WITH 2
   ENDIF

   MESSAGE LOGONSTR
   TRANSMIT LOGONSTR
   TRANSMIT "^M"

   WAITFOR "Password:" 30
   IF NOT WAITFOR
      CALL ERROR WITH 3
   ELSE
      WHEN 0 "word:" TRANSMIT PASSWRD2
      WHEN 1 "ion:"  TRANSMIT "1"

      TRANSMIT PASSWRD
      TRANSMIT "^M"

      WAITFOR "Welcome" 120
      IF NOT WAITFOR
         CALL ERROR WITH 4
      ENDIF
      CWHEN 0         ;* Cancel the WHEN command
      CWHEN 1         ;* Cancel the WHEN command
   ENDIF

           ;************************************************************
           ;*           Check for, prepare, and send a file            *
           ;************************************************************

   ISFILE OUTFILE
   IF SUCCESS

      TRANSMIT "^M"          ;* sync with menus
      WAITFOR "Command:" 60
      PAUSE 1

      STRFMT BUFFER "ATTFMT %s ATTRLL.SND" OUTFILE
      MESSAGE "^M          Formatting the outbound file..."
      MESSAGE "          Please Wait..."
      RUN BUFFER NOCLEAR
      IF FAILURE
         CALL ERROR WITH 5
      ENDIF

      TRANSMIT "^M"          ;* sync with menu
      WAITFOR "Command:" 60

      TRANSMIT "SDEUL USING XMODEM VERSION 2^M"
      WAITFOR "receive File" 60

      LOG SUSPEND

      IF WAITFOR
         SENDFILE XMODEM "ATTRLL.SND"
         LOG RESUME
         IF FAILURE
            CALL ERROR WITH 6
         ELSE
            WAITFOR "Command:" 60
            MESSAGE "`n   TRANSMISSION SUCCESSFUL...`n"
         ENDIF
      ENDIF
   ENDIF


           ;************************************************************
           ;*           If requested, receive a file.                  *
           ;************************************************************

   STRCMP RCVTYPE "Y" 1
   IF SUCCESS

      ISFILE INFILE
      IF SUCCESS
         CALL ERROR WITH 8
      ENDIF

      TRANSMIT "^M"          ;* sync with menu
      WAITFOR "Command:" 60

      LOG RESUME

      TRANSMIT "SDEDL IN.NEW USING XMODEM VERSION 2^M"

      WAITFOR "CANCELLED" 3  ;* No data to receive??
      IF NOT WAITFOR
         WAITFOR "SEND File" 120
         IF WAITFOR
            LOG SUSPEND
            GETFILE XMODEM INFILE
            LOG RESUME
            IF FAILURE
               CALL ERROR WITH 7
            ELSE
               MESSAGE "`n   FILE RECEIVED SUCCESSFULLY...`n"
            ENDIF
         ENDIF
      ENDIF

      TRANSMIT "^M"             ;* Sync the prompts
      WAITFOR "Command:" 120
   ENDIF


                      ;***********************************************
                      ;*            Log Off the network              *
                      ;***********************************************

   TRANSMIT "QUIT^M"
   PAUSE 2
   LOG CLOSE
   HANGUP
   QUIT
ENDPROC

         ;***************************************************************
         ;**                ERROR HANDLING PROCEDURE                   **
         ;***************************************************************

PROC ERROR
   INTPARM ERRNUM

   SWITCH ERRNUM
      CASE 1
         MESSAGE "`n   CONNECTION TO ATT GMS NETWORK FAILED..."
      ENDCASE

      CASE 2
         MESSAGE "`n   NO RESPONSE FROM NETWORK AFTER MODEM CONNECTION..."
      ENDCASE

      CASE 3
         MESSAGE "`n   NO PASSWORD REQUEST RECEIVED AFTER SUPPLYING LOGON ID..."
      ENDCASE

      CASE 4
         MESSAGE "`n   LOGON WAS NOT SUCCESSFUL...CHECK LOGON ID AND PASSWORD..."
      ENDCASE

      CASE 5
         MESSAGE "`n    ERROR ATTEMPTING TO FORMAT DATA USING ATTFMT...   "
      ENDCASE

      CASE 6
         MESSAGE "`n   FILE UPLOAD FAILED...   "
      ENDCASE

      CASE 7
         MESSAGE "`n   FILE DOWNLOAD FAILED...   "
      ENDCASE

      CASE 8
         MESSAGE "`n   INFILE ALREADY EXISTS...DOWNLOAD FAILED...   "
      ENDCASE
   ENDSWITCH

   MESSAGE "`n   EXECUTION OF SCRIPT AND COMMUNICATION SESSION TERMINATED "
   MESSAGE "`n   DUE TO ABOVE ERROR..."

   ALARM 2

   TRANSMIT "QUIT^M"
   PAUSE 2
   HANGUP
   QUIT
ENDPROC
