{$I-}
{$M 4096,0,0}

program process;

uses crt,dos,strings;

const
  buflen = 1024;

var
  dirinfo       : searchrec;
  mypath        : string;
  path          : string;
  batchfilename : string;
  batchfile     : text;
  batchfilebad  : boolean;
  line          : string;
  lineptr       : pchar;
  datafilename  : string;
  datafile      : text;
  buffer        : array[1..buflen] of char;
  bufptr        : array[1..128] of pchar;
  numdatalines  : word;
  comspec       : string;
  i,j,k         : word;

begin

  if (paramcount=0) or (paramstr(1) = '/?') then
    begin
      writeln('PROCESS: checks, runs and deletes all batch files in directory(s) - 7 Mar 1995.');
      writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
      writeln;
      writeln('SYNTAX: PROCESS <path> [<path>..]');
      halt(1)
    end;

  comspec:=getenv('comspec');

  getdir(0,mypath);

  datafilename:=copy(paramstr(0),1,length(paramstr(0))-3)+'DAT';
{  datafilename:='process.dat';  }
  assign(datafile,datafilename);
  reset(datafile);
  if IOResult<>0 then
    writeln('Control file '+datafilename+' not found.')
  else
    writeln('Reading data file '+datafilename+'...');

  i:=1;
  bufptr[1] := @buffer[1];
  j:=2;

  while not (eof(datafile) or (i=buflen)) do
    begin
      read(datafile,buffer[i]);
      write(buffer[i]);
      if eoln(datafile) then
        begin
          inc(i);
          buffer[i]:=' ';
          inc(i);
          buffer[i]:=chr(0);
          inc(i);
          repeat
            read(datafile,buffer[i])
          until (buffer[i] in ['@'..'~']) or eof(datafile);
          writeln;
          if not eof(datafile) then
            begin
              bufptr[j]:=@buffer[i];
              inc(j);
              write(buffer[i]);
            end;
        end;
      inc(i);
    end;

  numdatalines:=j-1;

  close(datafile);

  for i := 1 to paramcount do
    begin

      path := paramstr(i);
      if not (path[length(path)] in [':','\']) then path := path + '\';

      findfirst(path+'*.bat',0,dirinfo);

      if doserror=0 then
        repeat
          batchfilename:=path+dirinfo.name;
          assign(batchfile,batchfilename);
          reset(batchfile);
          batchfilebad:=false;
          writeln('Checking '+batchfilename+'...');
          while not (batchfilebad or eof(batchfile)) do
            begin
              readln(batchfile,line);
              if line<>'' then
                begin
                  if pos('|',line)=0 then
                    begin
                      line := line + ^@;
                      lineptr:=@line[1];
                      j:=1;
                      while (j<=numdatalines) and
                        (strlicomp(lineptr,bufptr[j],strlen(bufptr[j]))<>0)
                          do inc(j);
                      if j>numdatalines then batchfilebad:=true;
                    end
                  else batchfilebad := true;
                end;
              if not batchfilebad then writeln(line+' - OK');
            end;

          if batchfilebad then
              writeln(batchfilename+' has bad line '+line)
          else
            begin
              writeln('Running '+batchfilename+'...');
              exec(comspec,'/c '+batchfilename);
            end;

          chdir(mypath);
          close(batchfile);
          if not batchfilebad then
            begin
              erase(batchfile);
              if IOResult=0 then
                writeln(batchfilename+' deleted.')
              else
                writeln(batchfilename+' not deleted.');
            end;

          findnext(dirinfo);
        until doserror<>0
      else
        writeln('No batch files found as '+path+'*.bat');
    end;
end.