/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyUtils.c,v $
   $Revision: 1.10.14.1 $ $Date: 1995/06/09 22:00:24 $
   Checkin by: $Author: poirierm $

   This file contains a subset of the SOFTIMAGE's utility functions.

   Written by: Colin Hui

   (c) Copyright 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#define __TINY_UTILS_H__ 1

#include "tinySoftType.h"
#include "tinySceneToken.h"
#include "tinySpline.h"
#include "tinyUtils.h"

/* static variables */
static int DK_animIndentLength = 0;

/*******************************************************************************

   $$L DK_in_animToken

   This function gets a token from the input file.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animToken
    (
     FILE *file    /* file io pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    return(TRUE);
}

/*******************************************************************************

   $$L DK_in_animSValue

   This function gets a DK_SVALUE (short) from the input file.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animSValue
    (
     FILE *file,     /* file io pointer */
    DK_SVALUE *value   /* DK_animSValue pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    *value = (DK_SVALUE) atoi(DK_animToken);
    return(TRUE);
}


/*******************************************************************************

   $$L DK_in_animSValue_na

   This function gets a DK_SVALUE from the input file and assigns it to the
   global variable DK_animSValue.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animSValue_na
    (
     FILE *file    /* file io pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    DK_animSValue = (DK_SVALUE) atoi(DK_animToken);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_in_animFValue

   This function gets a DK_FVALUE (float) from the input file.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animFValue
    (
     FILE *file,     /* file io pointer */
    DK_FVALUE *value   /* DK_animFValue pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    *value = (DK_FVALUE) atof(DK_animToken);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_in_animFValue_na

   This function gets a DK_FVALUE from the input file and assigns it to the
   global variable DK_animFValue.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animFValue_na
    (
     FILE *file     /* file io pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    DK_animFValue = (DK_FVALUE) atof(DK_animToken);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_in_animLValue

   This function gets a (long) from the input file.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_in_animLValue
    (
     FILE *file,     /* file io pointer */
    long *value     /* DK_animSValue pointer */
    )
{
    int ci, i;

    _DK_IN_TOKEN();
    *value = (long) atoi(DK_animToken);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_stringReadAsciiAnimation

   This function gets an ascii string from the input file.

   Returned Value: TRUE or FALSE

*******************************************************************************/

char *DK_stringReadAsciiAnimation
    (
         FILE *file
    )
{
    int ci, i;
    char *c;

    /* skip white space */
    DK_animTokenLine[0] = '\0';
    while ((ci = fgetc(file)) != EOF && 
	(ci == ' ' || ci == '\t' || ci == '\n'))
	_DK_NOP();
    if (ci == EOF)
	return(NULL);

    /* read up to and including the next single quote */
    DK_animTokenLine[0] = ci;
    i = 1;
    while ((ci = fgetc(file)) != EOF && ci != 047)
    {
	DK_animTokenLine[i++] = ci;
	if (i >= (DK_MAXLINE - 1))
	    i = DK_MAXLINE - 2;
    }
    DK_animTokenLine[i++] = ci;
    DK_animTokenLine[i] = '\0';

    if (DK_animToken[0] == 047 && DK_animToken[1] == 047)
    {
	return(NULL);
    }
    c = _DK_CALLOC(char, strlen(DK_animToken), -1);
    strcpy(c, DK_animToken + 1);
    c[strlen(DK_animToken) - 2] = '\0';
    return(c);
}

/*******************************************************************************

   $$L DK_setIndentLength

   This function sets the indent length.

   Returned Value: TRUE or FALSE

*******************************************************************************/

void DK_setIndentLength
    (
	int len   
    )
{
    DK_animIndentLength = len;
}

/*******************************************************************************

   $$L DK_incIndent

   This function creates the indentation string.

   Returned Value: TRUE or FALSE

*******************************************************************************/

void DK_incIndent
    (
	int inc   /* indent increment */
    )
{
    int i, n;

    if (DK_animIndentString != NULL)
	_DK_FREE(DK_animIndentString, - 1);
    DK_animIndentLength += inc;
    if (DK_animIndentLength <= 0)
    {
	DK_animIndentLength = 0;
        DK_animIndentString = _DK_CALLOC(char, 2, -1);
	DK_animIndentString[0] = '\n';
	DK_animIndentString[1] = '\0';
    }
    else
    {
        n = DK_animIndentLength * 3;
        DK_animIndentString = _DK_CALLOC(char, n + 2, -1);
	DK_animIndentString[0] = '\n';
        for (i = 1; i < (n + 1); i++)
	    DK_animIndentString[i] = ' ';
        DK_animIndentString[i] = '\0';
    }
}

/*******************************************************************************

   $$L DK_vectorWriteAsciiAnimation

   This function writes a vector.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_vectorWriteAsciiAnimation
    (
	 FILE *file, 	/* file io pointer */
	DK_Vector *vpos	/* vector pointer */
    )
{
    if (vpos == NULL)
	return(FALSE);

    DK_incIndent(1);
    _DK_OUT_INDENT();
    _DK_OUT_FVALUE(vpos->x);
    _DK_OUT_FVALUE(vpos->y);
    _DK_OUT_FVALUE(vpos->z);
    DK_incIndent(-1);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_vectorReadAsciiAnimation

   This function reads a vector.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_vectorReadAsciiAnimation
    (
	 FILE *file,	/* file io pointer */
	DK_Vector *vpos    /* vector pointer */
    )
{
    DK_FVALUE v1, v2, v3;

    DK_in_animFValue(file, &v1);
    DK_in_animFValue(file, &v2);
    DK_in_animFValue(file, &v3);

    if (vpos == NULL)
	return(FALSE);

    vpos->x = (float) v1;
    vpos->y = (float) v2;
    vpos->z = (float) v3;

    return(TRUE);
}

/*******************************************************************************

   $$L DK_hvectorWriteAsciiAnimation

   This function writes a homogeneous vector.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_hvectorWriteAsciiAnimation
    (
	 FILE *file, 	/* file io pointer */
	DK_HVector *vpos   /* hvector pointer */
    )
{
    if (vpos == NULL)
	return(FALSE);

    DK_incIndent(1);
    _DK_OUT_INDENT();
    _DK_OUT_FVALUE(vpos->x);
    _DK_OUT_FVALUE(vpos->y);
    _DK_OUT_FVALUE(vpos->z);
    _DK_OUT_FVALUE(vpos->w);
    DK_incIndent(-1);
    return(TRUE);
}

/*******************************************************************************

   $$L DK_hvectorReadAsciiAnimation

   This function reads a homogeneous vector.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_hvectorReadAsciiAnimation
    (
	 FILE *file,	/* file io pointer */
	DK_HVector *vpos   /* hvector pointer */
    )
{
    DK_FVALUE v1, v2, v3, v4;

    DK_in_animFValue(file, &v1);
    DK_in_animFValue(file, &v2);
    DK_in_animFValue(file, &v3);
    DK_in_animFValue(file, &v4);

    if (vpos == NULL)
	return(FALSE);

    vpos->x = (float) v1;
    vpos->y = (float) v2;
    vpos->z = (float) v3;
    vpos->w = (float) v4;

    return(TRUE);
}

/*******************************************************************************

   $$L DK_valueWriteAsciiAnimation

   This function writes an animation value.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_valueWriteAsciiAnimation
    (
	 FILE *file,		/* file io pointer */
	float value,		/* static value */
	DK_Fcurve *fcv 		/* animation fcurve */
    )
{

    if (fcv == NULL || !DK_WRITE_ANIMATION ) 
    {
        _DK_OUT_FVALUE(value);
    }
    else 
    {
	DK_fcurveWriteAsciiAnimation(file, fcv);
    }
    return(TRUE);
}

/*******************************************************************************

   $$L DK_valueReadAsciiAnimation

   This function reads an animation value.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_valueReadAsciiAnimation
    (
	 FILE *file,		/* file io pointer */
	float *value,		/* static value pointer */
	DK_Fcurve **fcv,    	/* fcurve pointer */
	int input		/* get input DK_animToken */
    )
{
    float fv;
    int rtn = TRUE;

    if (input)
        if (DK_in_animToken(file) == FALSE)
	    return(FALSE);
    if (strcmp(DK_A_FCV_TYPE_TOKEN, DK_animToken) == 0)
	rtn = DK_fcurveReadAsciiAnimation(file, fcv);
    else
    {
	fv = (DK_FVALUE) atof(DK_animToken);
	if (value != NULL)
	    *value = fv;
	DK_in_animToken(file);
    }
    return(rtn);
}

/*******************************************************************************

   $$L DK_value3WriteAsciiAnimation

   This function writes 3 animation values.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_value3WriteAsciiAnimation
    (
	 FILE *file,	/* file io pointer */
	float v1, 	/* static values */
	float v2,
	float v3,
	DK_Fcurve *fcv1,	/* animation fcurves */
	DK_Fcurve *fcv2,
	DK_Fcurve *fcv3
    )
{
    if (fcv1 == NULL || !DK_WRITE_ANIMATION ) 
    {
        _DK_OUT_FVALUE(v1);
        _DK_OUT_FVALUE(v2);
        _DK_OUT_FVALUE(v3);
    }
    else 
    {
	DK_fcurveWriteAsciiAnimation(file, fcv1);
	DK_fcurveWriteAsciiAnimation(file, fcv2);
	DK_fcurveWriteAsciiAnimation(file, fcv3);
    }
    return(TRUE);
}

/*******************************************************************************

   $$L DK_value3ReadAsciiAnimation

   This function reads 3 animation values.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_value3ReadAsciiAnimation
    (
	 FILE *file,	 /* file io pointer */
	float *v1,	 /* static values */
	float *v2,
	float *v3,
	DK_Fcurve **fcv1,	 /* animation fcurves */
	DK_Fcurve **fcv2,
	DK_Fcurve **fcv3
    )
{
    float fv1, fv2, fv3;
    int rtn = TRUE;

    if (DK_in_animToken(file) == FALSE)
	return(FALSE);
    if (strcmp(DK_A_FCV_TYPE_TOKEN, DK_animToken) == 0)
    {
	rtn = DK_fcurveReadAsciiAnimation(file, fcv1);
 	rtn |= DK_fcurveReadAsciiAnimation(file, fcv2);
	rtn |= DK_fcurveReadAsciiAnimation(file, fcv3);
    }
    else
    {
	fv1 = (DK_FVALUE) atof(DK_animToken);
	DK_in_animFValue(file, &fv2);
	DK_in_animFValue(file, &fv3);
	if (v1 != NULL)
            *v1 = fv1;
	if (v2 != NULL)
            *v2 = fv2;
	if (v3 != NULL)
            *v3 = fv3;
        DK_in_animToken(file);
    }
    return(rtn);
}


/*******************************************************************************

   $$L DK_positionWriteAsciiAnimation

   This function writes a translation position (path, explicit, constraint
   or static value).

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_positionWriteAsciiAnimation
    (
	 FILE *file, 		/* file io pointer */
	DK_Vector *vpos,		/* static position */
	DK_Fcurve *fpos,		/* fcurve for DK_spline path */
	struct DK_spline *spos,	/* DK_spline path (old format) */
	DK_String constraint_name,/* constraint name */
	short  constraint_type,	/* constraint type */
	DK_Fcurve *xfcv1,		/* explicit fcurves */
	DK_Fcurve *xfcv2,
	DK_Fcurve *xfcv3,
	DK_String path_name	/* for new v2.5 path scene file format */
    )
{

    if( !DK_WRITE_ANIMATION )
    {
	_DK_OUT_TOKEN(DK_A_POS_STATIC_TOKEN);
        DK_vectorWriteAsciiAnimation(file, vpos);
        return(TRUE);
    }

    if( constraint_name != NULL ) 
    {
	_DK_OUT_TOKEN(DK_A_POS_CONSTRAINT_TOKEN);
        _DK_OUT_SVALUE( constraint_type);
        _DK_OUT_STRING(constraint_name);
    }
    else if (path_name != NULL )
    {
	_DK_OUT_TOKEN(DK_A_POS_MODEL_TOKEN);
        DK_fcurveWriteAsciiAnimation(file, fpos);
	DK_incIndent(1);
	_DK_OUT_INDENT();
	_DK_OUT_TOKEN(DK_A_SPLINE_NAME_TOKEN);
        _DK_OUT_STRING(path_name);
	DK_incIndent(-1);
    }
    else if (spos) 
    {
	_DK_OUT_TOKEN(DK_A_POS_FCV_TOKEN);
        DK_fcurveWriteAsciiAnimation(file, fpos);
        DK_splineWriteAsciiAnimation(file, spos);
    }
    else if (xfcv1 != NULL) 
    {
	_DK_OUT_TOKEN(DK_A_POS_EXPLICIT_TOKEN);
	DK_fcurveWriteAsciiAnimation(file, xfcv1);
	DK_fcurveWriteAsciiAnimation(file, xfcv2);
	DK_fcurveWriteAsciiAnimation(file, xfcv3);
    }
    else 
    {
	_DK_OUT_TOKEN(DK_A_POS_STATIC_TOKEN);
        DK_vectorWriteAsciiAnimation(file, vpos);
    }
    return(TRUE);
}

/*******************************************************************************

   $$L DK_positionReadAsciiAnimation

   This function allocates and reads a translation position 
   (path, explicit, constraint or static value).

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_positionReadAsciiAnimation
    (
	 FILE *file,		/* file io pointer */
	DK_Vector *vpos, 		/* static vector */
	DK_Fcurve **fpos,		/* DK_spline fcurve */
	struct DK_spline **spos,	/* DK_spline path */
	DK_String *constraint_name,/* contraint name */
	short  *constraint_type,/* constraint name type */
	DK_Fcurve **xfcv1,		/* explicit fcurves */
	DK_Fcurve **xfcv2,
	DK_Fcurve **xfcv3,   	
	DK_String *path_name	/* for new v2.5 path scene file format */
    )
{
    if (DK_in_animToken(file) == FALSE)
	return(FALSE);
    if (strcmp( DK_A_POS_CONSTRAINT_TOKEN, DK_animToken) == 0)
    {
	DK_in_animSValue_na(file);
	*constraint_type = DK_animSValue;
        *constraint_name = DK_stringReadAsciiAnimation(file);
	DK_in_animToken(file);
    }
    else if (strcmp( DK_A_POS_FCV_TOKEN, DK_animToken) == 0)
    {
	DK_in_animToken(file);
        DK_fcurveReadAsciiAnimation(file, fpos);
	*spos = DK_splineAllocate();
        DK_splineReadAsciiAnimation(file, *spos);
    }
    else if (strcmp( DK_A_POS_EXPLICIT_TOKEN, DK_animToken) == 0)
    {
	DK_in_animToken(file);
	DK_fcurveReadAsciiAnimation(file, xfcv1);
	DK_fcurveReadAsciiAnimation(file, xfcv2);
	DK_fcurveReadAsciiAnimation(file, xfcv3);
    }
    else if (strcmp( DK_A_POS_MODEL_TOKEN, DK_animToken) == 0)
    {
	DK_in_animToken(file);
        DK_fcurveReadAsciiAnimation(file, fpos);
	*path_name = DK_stringReadAsciiAnimation(file);
	DK_in_animToken(file);
    }
    else if (strcmp( DK_A_POS_STATIC_TOKEN, DK_animToken) == 0)
    {
        DK_vectorReadAsciiAnimation(file, vpos);
	DK_in_animToken(file);
    }
    else 
    {
	if ( DK_option.verbose == TRUE)
	    fprintf( DK_option.msgFd,"PositionReadAsciiAnimation: \
error, unknown DK_animToken '%s'.\n",DK_animToken);
	DK_in_animToken(file);
    }

    return(TRUE);
}


