/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyScnDump.c,v $
   $Revision: 1.10.14.1 $ $Date: 1995/06/09 21:59:45 $
   Checkin by: $Author: poirierm $

   "tinyScnDump.c"

   This file includes code to print the contents of a DKit scene.

   (c) Copyright 1993 Softimage Inc.

********************************************************************************
*******************************************************************************/

static char rcsid[]     = "$Header: /drive3/SI2/creative/RCS/DKit/src/tinyScnDump.c,v 1.10.14.1 1995/06/09 21:59:45 poirierm Exp $";
static char copyright[] = "(c) Copyright 1994 Softimage Inc.";

#include <stdio.h>
#include "tinySoftType.h"
#include "tinyFcurve.h"
#include "tinyModel.h"
#include "tinyLight.h"
#include "tinyCluster.h"
#include "tinyDynamics.h"
#include "tinyScene.h"
#include "tinyScnDump.h"

/*******************************************************************************

   DK_aniDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_aniDump
   (
      DK_Fcurve		**ptr,
      DK_actFcurve	*act,
      int		nbfcvs
   )
{
   DK_Fcurve	*fcv;
   int		i;

   for ( i = 0; i < nbfcvs; i++ )
   {
      fcv = ptr[i];
      if ( fcv != NULL )
      {
	 fprintf( stderr,"     %d) type (%d) nbkeys (%d)",i,fcv->type,fcv->size);
	 if ( act[i].active )
	    fprintf( stderr," act\n");
	 else
	    fprintf( stderr," deact\n");
      }

      fcv = act[i].fcv;
      if ( fcv != NULL )
	 fprintf( stderr,"            actfcv nbkeys (%d)\n", fcv->size );
   }
}

/*******************************************************************************

   DK_constraintDump

   <DESCRIPTION>

   (c) Copyright 1994 Softimage Inc.

*******************************************************************************/
void DK_constraintDump
   (
      DK_Constraint	*cns_list
   )
{
   DK_Constraint	*cns = cns_list;

   for( ; cns != NULL; cns = cns->next )
   {
      fprintf( stderr,"     constraint [%s] of type [%i] data(%d)\n",
		     cns->name, cns->reltype, cns->reldata );
   }
}

/*******************************************************************************

   DK_t2dDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_t2dDump
   (
      DK_Texture	*t2d,
      int		global
   )
{
   char		*str;

   str = ( global ? "Global" : "Local" );
   fprintf( stderr,"   %s 2D Texture [%s|%s] .... \n    uses Picture [%s]\n",
		  str,t2d->txt_prefix,t2d->txt_name,t2d->pic_name);
   DK_aniDump( t2d->fcv, t2d->active_fcv, DK_FCV_TXT_NUM );

   if ( t2d->constr_list != NULL )
      DK_constraintDump( t2d->constr_list );
}

/*******************************************************************************

   DK_t3dDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_t3dDump
   (
      DK_Texture3D	*t3d,
      int		global
   )
{
   char		*str;

   str = ( global ? "Global" : "Local" );
   fprintf( stderr,"   %s 3D Texture [%s|%s] ..........................\n",
			str,t3d->prefix,t3d->name);
   DK_aniDump( t3d->fcv, t3d->active_fcv, DK_FCV_TXT3D_NUM );

   if ( t3d->constr_list != NULL )
      DK_constraintDump( t3d->constr_list );
}

/*******************************************************************************

   DK_matDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_matDump
   (
      DK_Material	*mat
   )
{
   DK_Texture	*t2d;

   fprintf( stderr,"   Material [%s|%s] ..........................\n",
				mat->prefix, mat->name);
   DK_aniDump( mat->fcv, mat->active_fcv, DK_FCV_MAT_NUM );

   t2d = mat->textures;
   while ( t2d != NULL )
   {
      DK_t2dDump( t2d, FALSE );
      t2d = t2d->next;
   }

   if ( mat->textures3D != NULL )
      DK_t3dDump( mat->textures3D, FALSE );

   if ( mat->constr_list != NULL )
      DK_constraintDump( mat->constr_list );
}

/*******************************************************************************

   DK_latDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_latDump
   (
      DK_Lattice	*lat,
      int		tree,
      int		nb
   )
{
   fprintf( stderr,"   Lattice (tree = %d)(nb = %d).................\n",tree,nb);
   /* Lattice animation curves are in the model array of curves */
}

/*******************************************************************************

   DK_modelDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_modelDump
   (
      DK_Model	*mdl
   )
{
   DK_Material	*mat;
   DK_Texture	*t2d;
   DK_Kluster	*cls;
   DK_DynaConstrInfo *dync;
   int		i;

   fprintf( stderr,"Model [%s|%s] root(%d) ------------------------\n",
	  mdl->prefix, mdl->name, (int)(mdl->parent == NULL ? TRUE : FALSE ) );
   if ( mdl->constr_list )
   {
      DK_constraintDump( mdl->constr_list );
   }
   else
   {
      if ( mdl->pos_constraint_name != NULL )
	 fprintf( stderr,"     constraint [%s]\n",mdl->pos_constraint_name);
      if ( mdl->path_name != NULL )
	 fprintf( stderr,"     path [%s]\n",mdl->path_name);
   }

   /*----- SHAPES ------*/
   if ( mdl->nbshape > 0 && mdl->shapes != NULL )
   {
      fprintf( stderr,"     shapes (nb = %d) shapes=%d\n",mdl->nbshape,mdl->shapes);
      fprintf( stderr,"     fcv[SHP] = %d\n",mdl->fcv[DK_FCV_MDL_SHAPE]);
      for ( i = 0; i < mdl->nbshape; i++ )
	 fprintf( stderr,"     wfcv[%d] = %d\n",i,mdl->wfcv[i]);
   }

   /*----- CLUSTERS ------*/
   cls = mdl->klusters;
   while ( cls != NULL )
   {
      fprintf( stderr,"     cluster [%s]\n",cls->name);
      if ( cls->anim )
      {
	 fprintf( stderr,"       animated (nbkeys=%d)\n",cls->anim->nbClusterKey);
      }
      cls = cls->next;
   }

   /*----- LATTICES ------*/
   if ( mdl->nodelat )
      DK_latDump( mdl->nodelat, FALSE, mdl->nbnodelat );
   if ( mdl->treelat )
      DK_latDump( mdl->treelat, TRUE, mdl->nbtreelat );

   /*----- FITTING ------*/
   if ( mdl->nodefit )
      fprintf( stderr,"     node spline fitting [%s]\n",mdl->nodefit->name);
   if ( mdl->brchfit )
      fprintf( stderr,"     branch spline fitting [%s]\n",mdl->brchfit->name);
   if ( mdl->nodepfit )
      fprintf( stderr,"     node patch fitting [%s]\n",mdl->nodepfit->name);
   if ( mdl->brchpfit )
      fprintf( stderr,"     branch patch fitting [%s]\n",mdl->brchpfit->name);
   dync = mdl->dcinfo;
   while ( dync != NULL )
   {
      fprintf( stderr,"     dyna constr type (%d) [%s]\n",dync->type,dync->model_name);
      dync = dync->next;
   }
   DK_aniDump( mdl->fcv, mdl->active_fcv, DK_FCV_MDL_NUM );

   mat = mdl->materials;
   while ( mat != NULL )
   {
      DK_matDump( mat );
      mat = mat->next;
   }

   t2d = mdl->textures;
   while ( t2d != NULL )
   {
      DK_t2dDump( t2d, TRUE );
      t2d = t2d->next;
   }

   if ( mdl->textures3D != NULL )
      DK_t3dDump( mdl->textures3D, TRUE );

   /* recursive descent */
   if ( mdl->child != NULL )
      DK_modelDump( mdl->child );
   if ( mdl->sibling != NULL )
      DK_modelDump( mdl->sibling );
}

/*******************************************************************************

   DK_camDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_camDump
   (
      DK_Camera	*cam
   )
{
   fprintf( stderr,"Camera ---------------------------\n");
   fprintf( stderr,"position (%f %f %f)\n",
			cam->position.x,cam->position.y,cam->position.z);
   fprintf( stderr,"interest (%f %f %f)\n",
			cam->interest.x,cam->interest.y,cam->interest.z);
   if ( cam->constr_list )
   {
      DK_constraintDump( cam->constr_list );
   }
   else
   {
      if ( cam->pos_constraint_name != NULL )
	 fprintf( stderr,"     constraint [%s]\n",cam->pos_constraint_name);
      if ( cam->int_constraint_name != NULL )
	 fprintf( stderr,"     int constraint [%s]\n",cam->int_constraint_name);
      if ( cam->pos_path_name != NULL )
	 fprintf( stderr,"     path [%s]\n",cam->pos_path_name);
      if ( cam->int_path_name != NULL )
	 fprintf( stderr,"     int path [%s]\n",cam->int_path_name);
   }
   DK_aniDump( cam->fcv, cam->active_fcv, DK_FCV_CAM_NUM );
}

/*******************************************************************************

   DK_ligDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_ligDump
   (
      DK_Light	*lig
   )
{
   char		*str;

   fprintf( stderr,"Light [%s|%s] ------------------------\n", lig->prefix, lig->name);
   switch ( lig->type )
   {
      case DK_LIGHT_POINT:	str = "POINT";		break;
      case DK_LIGHT_SPOT:	str = "SPOT";		break;
      case DK_LIGHT_INFINITE:	str = "INFINITE";	break;
      case DK_LIGHT_SUN:	str = "SUN";		break;
   }
   fprintf( stderr,"type DK_LIGHT_%s\n",str);
   fprintf( stderr,"position (%f %f %f)\n",
			lig->position.x,lig->position.y,lig->position.z);
   if ( lig->constr_list )
   {
      DK_constraintDump( lig->constr_list );
   }
   else
   {
      if ( lig->pos_constraint_name != NULL )
	 fprintf( stderr,"     constraint [%s]\n",lig->pos_constraint_name);
      if ( lig->int_constraint_name != NULL )
	 fprintf( stderr,"     int constraint [%s]\n",lig->int_constraint_name);
      if ( lig->pos_path_name != NULL )
	 fprintf( stderr,"     path [%s]\n",lig->pos_path_name);
      if ( lig->int_path_name != NULL )
	 fprintf( stderr,"     int path [%s]\n",lig->int_path_name);
   }
   DK_aniDump( lig->fcv, lig->active_fcv, DK_FCV_LIG_NUM );
}

/*******************************************************************************

   DK_wavDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_wavDump
   (
      DK_Wave	*wav
   )
{
   fprintf( stderr,"Wave [%s|%s] ------------------------\n", 
					wav->wave_prefix, wav->wave_name);
   if ( wav->w_amodel != NULL )
      fprintf( stderr,"     affected model [%s] branch(%d)\n",
		   wav->w_amodel->model_name,wav->w_amodel->model_branch);
   if ( wav->constr_list )
   {
      DK_constraintDump( wav->constr_list );
   }
   else
   {
      if ( wav->path_name != NULL )
	 fprintf( stderr,"     path [%s]\n",wav->path_name);
   }

   DK_aniDump( wav->fcv, wav->active_fcv, DK_FCV_WAVE_NUM );
}

/*******************************************************************************

   DK_renderSetupDump

   <DESCRIPTION>

   (c) Copyright 1994 Softimage Inc.

*******************************************************************************/
void DK_renderSetupDump
   (
      DK_RenderingSetup	*ren
   )
{
   fprintf( stderr, "type                   (%d)\n", ren->type                );
   fprintf( stderr, "sequence               start(%d) end(%d) step(%d)\n", 
				ren->start, ren->end, ren->step      );
   fprintf( stderr, "frameBuffer            (%d)\n", ren->frameBuffer         );
   fprintf( stderr, "pictureFile            (%d)\n", ren->pictureFile         );
   fprintf( stderr, "pictureFileName        [%s]\n", ren->pictureFileName     );
   fprintf( stderr, "resolution             (%d)(%d) pixelRatio(%f)\n", 
		 ren->xResolution, ren->yResolution, ren->pixelRatio );
   fprintf( stderr, "picFormat              (%d)\n", ren->picFormat           );
   fprintf( stderr, "aspectRatio            (%f)\n", ren->aspectRatio         );
   fprintf( stderr, "aspectWidth            (%f)\n", ren->aspectWidth         );
   fprintf( stderr, "aspectHeight           (%f)\n", ren->aspectHeight        );
   fprintf( stderr, "rayMaxDepth            (%d)\n", ren->rayMaxDepth         );
   fprintf( stderr, "rayTrianglesPerLeaf    (%d)\n", ren->rayTrianglesPerLeaf );
   fprintf( stderr, "rayMaxTreeDepth        (%d)\n", ren->rayMaxTreeDepth     );
   fprintf( stderr, "preFrameFile           [%s]\n", ren->preFrameFile        );
   fprintf( stderr, "postFrameFile          [%s]\n", ren->postFrameFile       );
   fprintf( stderr, "statTiming             (%d)\n", ren->statTiming          );
   fprintf( stderr, "statMemory             (%d)\n", ren->statMemory          );
   fprintf( stderr, "statTree               (%d)\n", ren->statTree            );
   fprintf( stderr, "statLine               (%d)\n", ren->statLine            );
   fprintf( stderr, "antialiasType          (%d)\n", ren->antialiasType       );
   fprintf( stderr, "   samplingFilter      (%d)\n", ren->samplingFilter      );
   fprintf( stderr, "   maxLevel            (%d)\n", ren->maxLevel            );
   fprintf( stderr, "   adaptiveThreshold   (%f)\n", ren->adaptiveThreshold   );
   fprintf( stderr, "backCulling            (%d)\n", ren->backCulling         );
   fprintf( stderr, "fade.active            (%d)\n", ren->fade.active         );
   fprintf( stderr, "fade.start             (%f)\n", ren->fade.start          );
   fprintf( stderr, "fade.end               (%f)\n", ren->fade.end            );
   fprintf( stderr, "fade.colour.r          (%f)\n", ren->fade.colour.r       );
   fprintf( stderr, "fade.colour.g          (%f)\n", ren->fade.colour.g       );
   fprintf( stderr, "fade.colour.b          (%f)\n", ren->fade.colour.b       );
   fprintf( stderr, "fade.transparency      (%f)\n", ren->fade.transparency   );
   fprintf( stderr, "fog.active             (%d)\n", ren->fog.active          );
   fprintf( stderr, "fog.start              (%f)\n", ren->fog.start           );
   fprintf( stderr, "fog.end                (%f)\n", ren->fog.end             );
   fprintf( stderr, "fog.colour.r           (%f)\n", ren->fog.colour.r        );
   fprintf( stderr, "fog.colour.g           (%f)\n", ren->fog.colour.g        );
   fprintf( stderr, "fog.colour.b           (%f)\n", ren->fog.colour.b        );
   fprintf( stderr, "fog.density            (%f)\n", ren->fog.density         );
   fprintf( stderr, "fog.base               (%f)\n", ren->fog.base            );
   fprintf( stderr, "fog.thickness          (%f)\n", ren->fog.thickness       );
   fprintf( stderr, "ambiance.r             (%f)\n", ren->ambiance.r          );
   fprintf( stderr, "ambiance.g             (%f)\n", ren->ambiance.g          );
   fprintf( stderr, "ambiance.b             (%f)\n", ren->ambiance.b          );
   fprintf( stderr, "motion_blur            (%d)\n", ren->motion_blur         );
   fprintf( stderr, "shutter_speed          (%f)\n", ren->shutter_speed       );
   fprintf( stderr, "min_movement           (%f)\n", ren->min_movement        );
   fprintf( stderr, "onfields               (%d)\n", ren->onfields            );
   fprintf( stderr, "firstfield             (%d)\n", ren->firstfield          );
   fprintf( stderr, "do_dither              (%d)\n", ren->do_dither           );
   fprintf( stderr, "add_noise              (%d)\n", ren->add_noise           );
   fprintf( stderr, "noise_amount           (%f)\n", ren->noise_amount        );
}

/*******************************************************************************

   DK_scnDump

   <DESCRIPTION>

   (c) Copyright 1993 Softimage Inc.

*******************************************************************************/
void DK_scnDump
   (
      DK_Scene	*scn
   )
{
   DK_Model	*mdl;
   DK_Light	*lig;
   DK_Wave	*wav;

   fprintf( stderr,"Scene [%s] ==============================\n",scn->name);
   DK_aniDump( scn->render.fade.fcv, scn->render.fade.active_fcv, DK_FCV_FAD_NUM );

   mdl = scn->model;
   while ( mdl != NULL )
   {
      DK_modelDump( mdl );
      mdl = mdl->next;
   }
   lig = scn->light;
   while ( lig != NULL )
   {
      DK_ligDump( lig );
      lig = lig->next;
   }
   wav = scn->wave;
   while ( wav != NULL )
   {
      DK_wavDump( wav );
      wav = wav->next;
   }
   DK_camDump( &(scn->camera) );

   fprintf( stderr, "setup file [%s]\n", scn->setup_filename );
   DK_renderSetupDump( &(scn->render) );
   fprintf( stderr,"================================\n");

}
