/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyPatch.c,v $
   $Revision: 1.9.14.2 $ $Date: 1995/07/20 22:26:18 $
   Checkin by: $Author: scoy $

   This file contains a subset of the SOFTIMAGE's patch functions,
   its content is sufficient to read, write and manage patch data structure
   into SOFTIMAGE's file format...

   Written by: Laurent Lauzon

   (c) Copyright 1990, 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include "tinyByteswap.h"
#include "tinySoftType.h"
#include "tinyPatch.h"

extern DK_String DK_SplineTypeName[];

/******************************************************************************/
/*** Static function prototypes ***********************************************/
/******************************************************************************/

static void DK_controlPointsReadAscii(  FILE *, DK_Patch * );
static void DK_taggedPointsReadAscii(  FILE *, DK_Patch *);

/******************************************************************************/
/*** Global functions *********************************************************/
/******************************************************************************/

DK_Patch *DK_patchAllocate( void )
{
   DK_Patch *ptch;

   if( ptch = (DK_Patch *) calloc( 1, sizeof( DK_Patch ) ) )
   {
      ptch->uType      =  DK_SPL_LINEAR;
      ptch->vType      =  DK_SPL_LINEAR;
      ptch->uNbPoints  = 0;
      ptch->vNbPoints  = 0;
      ptch->points     = NULL;
      ptch->sel        = NULL;
      ptch->uClose     = FALSE;
      ptch->vClose     = FALSE;
      ptch->uTension   = 0.0;
      ptch->vTension   = 0.0;
      ptch->uStep      = 3;
      ptch->vStep      = 3;
      ptch->uCurve     = 1;
      ptch->vCurve     = 1;
      ptch->uBottom    = FALSE;
      ptch->vBottom    = FALSE;
      ptch->uTop       = FALSE;
      ptch->vTop       = FALSE;
      ptch->faceted    = FALSE;
      ptch->approx_type   = DK_PARAMETRIC;
      ptch->approx.viewDep = FALSE;
      ptch->approx.spacial = 5.0;
      ptch->approx.curv_u = 5.0;
      ptch->approx.curv_v = 5.0;
      ptch->approx.recMin = 1;
      ptch->approx.recMax = 10;
      ptch->approx.recursion = FALSE;
   }

   return( ptch );
}

void DK_patchDispose( DK_Patch **ptch )
{
   if( *ptch != NULL )
   {
      if( (*ptch)->points )
         free( (*ptch)->points );
      free( *ptch );
      *ptch = NULL;
   }
}

DK_Vector *DK_patchAllocatePoints( int nbu, int nbv )
{
   DK_Vector	*pnts, *ptr;
   int		 i, nbp;

   nbp = nbu * nbv;
   if( (ptr = pnts = (DK_Vector *) calloc( nbp, sizeof( DK_Vector ) )) != NULL )
   {
      for( i = 0; i < nbp; i++, ptr++ )
         ptr->x = ptr->y = ptr->z = 0.0;
   }
   return( pnts );
}

DK_Patch *DK_patchReadAscii(  FILE *file )
{
   DK_Patch	*ptch;
   int		len;
   char		 str[ 80 ], type[ 80 ];


printf(" dans DK_patchReadAscii\n" ); 
   if( (ptch = DK_patchAllocate()) == NULL )
      return( NULL );

   fscanf( file, "%s", str );
   if( strcmp( str, "{" ) != 0 )
      return( ptch );

   do
   {
      fscanf( file, "%s", str );

      if( strcmp( "utype", str ) == 0 )
      {
         fscanf( file, "%s", type );
         ptch->uType = DK_splineGetTypeByName( type );
      }
      else if( strcmp( "vtype", str ) == 0 )
      {
         fscanf( file, "%s", type );
         ptch->vType = DK_splineGetTypeByName( type );
      }
      else if( strcmp( "upoint", str ) == 0 )
         fscanf( file, "%hd", &ptch->uNbPoints );
      else if( strcmp( "vpoint", str ) == 0 )
         fscanf( file, "%hd", &ptch->vNbPoints );
      else if( strcmp( "uclose", str ) == 0 )
         ptch->uClose = TRUE;
      else if( strcmp( "vclose", str ) == 0 )
         ptch->vClose = TRUE;
      else if( strcmp( "utension", str ) == 0 )
         fscanf( file, "%f", &ptch->uTension );
      else if( strcmp( "vtension", str ) == 0 )
         fscanf( file, "%f", &ptch->vTension );
      else if( strcmp( "ustep", str ) == 0 )
         fscanf( file, "%hd", &ptch->uStep );
      else if( strcmp( "vstep", str ) == 0 )
         fscanf( file, "%hd", &ptch->vStep );
      else if( strcmp( "ucurve", str ) == 0 )
         fscanf( file, "%hd", &ptch->uCurve );
      else if( strcmp( "vcurve", str ) == 0 )
         fscanf( file, "%hd", &ptch->vCurve );
      else if( strcmp( "ubottom", str ) == 0 )
         ptch->uBottom = TRUE;
      else if( strcmp( "vbottom", str ) == 0 )
         ptch->vBottom = TRUE;
      else if( strcmp( "utop", str ) == 0 )
         ptch->uTop = TRUE;
      else if( strcmp( "vtop", str ) == 0 )
         ptch->vTop = TRUE;
      else if( strcmp( "controlPoints", str ) == 0 )
         DK_controlPointsReadAscii( file, ptch );
      else if( strcmp( "approx_type", str ) == 0 )
         fscanf( file, "%hd", &ptch->approx_type);
      else if( strcmp( "viewDep", str ) == 0 )
      {
         fscanf( file, "%d", &len);
         if( len )
            ptch->approx.viewDep = TRUE;
         else
            ptch->approx.viewDep = FALSE;
      }
      else if( strcmp( "spacial", str ) == 0 )
         fscanf( file, "%f", &ptch->approx.spacial);
      else if( strcmp( "curv_u", str ) == 0 )
         fscanf( file, "%f", &ptch->approx.curv_u);
      else if( strcmp( "curv_v", str ) == 0 )
         fscanf( file, "%f", &ptch->approx.curv_v);
      else if( strcmp( "recMin", str ) == 0 )
         fscanf( file, "%hd", &ptch->approx.recMin);
      else if( strcmp( "recMax", str ) == 0 )
         fscanf( file, "%hd", &ptch->approx.recMax);
      else if( strcmp( "recursion", str ) == 0 )
      {
         fscanf( file, "%d", &len);
         if( len )
            ptch->approx.recursion = TRUE;
         else
            ptch->approx.recursion = FALSE;
      }
      else if( strcmp( "taggedPoints", str ) == 0 )
         DK_taggedPointsReadAscii( file, ptch );

   } while( strcmp( "}", str ) != 0 );

   return( ptch );
}

static void DK_controlPointsReadAscii(  FILE *file, DK_Patch *ptch )
{
   char		 str[ 80 ];
   int		 i, nbp;
   DK_Vector	*pnts = NULL;

   nbp = ptch->uNbPoints * ptch->vNbPoints;
   ptch->points = (DK_Vector *) calloc( nbp, sizeof( DK_Vector ) );
   for( i = 0, pnts = ptch->points; i < nbp; i++, pnts++ )
      pnts->x = pnts->y = pnts->z = 0.0;

   fscanf( file, "%s", str );
   if( strcmp( str, "{" ) != 0 )
      return;

   pnts = NULL;
   do
   {
      fscanf( file, "%s", str );

      if( str[0] == '[' )
      {
         if( pnts == NULL )
            pnts = ptch->points;
         else
            pnts++;
      }
      else if( strcmp( str, "position" ) == 0 )
         fscanf( file, "%f %f %f", &pnts->x, &pnts->y, &pnts->z );

   } while( strcmp( "}", str ) != 0 );
}

static void DK_taggedPointsReadAscii(  FILE *file, DK_Patch *ptch )
{
   char		 str[ 80 ];
   int		 nbp, tmp;
   short	*pnts = NULL;

   nbp = ptch->uNbPoints * ptch->vNbPoints;
   ptch->sel = (short *) calloc( nbp, sizeof( short ) );

   fscanf( file, "%s", str );
   if( strcmp( str, "{" ) != 0 )
      return;

   pnts = ptch->sel;
   do
   {
      fscanf( file, "%s", str );

      if( strcmp( str, "tagged" ) == 0 )
      {
         fscanf( file, "%d", &tmp );
	 *pnts++ = tmp;
      }
      
   } while( strcmp( "}", str ) != 0 );
}

DK_Patch *DK_patchReadBinary(  FILE *file, DK_FileProt *prot )
{
   DK_Patch	*ptch;
   short		len;
   short	 tok, nb, *sel;
   int		 i, ind = 0;
   DK_Vector	*pnt;

   if( ptch = DK_patchAllocate() )
   {
      if( (prot != NULL) && (prot->patch != NULL) )
         tok = prot->patch[ ind ++ ];
      else
         DK_byteswap_fread( &tok, 2, 1, file );
      while( tok != 0 /* End of patch definition */ )
      {
         switch( tok )
         {
            case 1: /* U type */
               DK_byteswap_fread( &nb, 2, 1, file );
               ptch->uType = (DK_SplineType) nb;
               break;

            case 2: /* V type */
               DK_byteswap_fread( &nb, 2, 1, file );
               ptch->vType = (DK_SplineType) nb;
               break;

            case 3: /* Control Points list */
               DK_byteswap_fread( &ptch->uNbPoints, 2, 1, file );
               DK_byteswap_fread( &ptch->vNbPoints, 2, 1, file );
               pnt = ptch->points = (DK_Vector *) calloc( 
		   ptch->uNbPoints * ptch->vNbPoints, sizeof( DK_Vector ) );
               sel = ptch->sel = (short *) calloc( 
		   ptch->uNbPoints * ptch->vNbPoints, sizeof( short ) );
               for( i = 0; i < ptch->uNbPoints * ptch->vNbPoints; i++, pnt++ )
                  DK_Vector_fread( pnt, sizeof( DK_Vector ), 1, file );
               break;

            case 4: /* U close */
               DK_byteswap_fread( &ptch->uClose, 2, 1, file );
               break;

            case 5: /* V close */
               DK_byteswap_fread( &ptch->vClose, 2, 1, file );
               break;

            case 6: /* U Tension */
               DK_byteswap_fread( &ptch->uTension, 4, 1, file );
               break;

            case 7: /* V Tension */
               DK_byteswap_fread( &ptch->vTension, 4, 1, file );
               break;

            case 8: /* U drawing Step */
               DK_byteswap_fread( &ptch->uStep, 2, 1, file );
               break;

            case 9: /* V drawing Step */
               DK_byteswap_fread( &ptch->vStep, 2, 1, file );
               break;

            case 10: /* U curve */
               DK_byteswap_fread( &ptch->uCurve, 2, 1, file );
               break;

            case 11: /* V Curve */
               DK_byteswap_fread( &ptch->vCurve, 2, 1, file );
               break;

            case 12: /* U Bottom */
               DK_byteswap_fread( &ptch->uBottom, 2, 1, file );
               break;

            case 13: /* U Top */
               DK_byteswap_fread( &ptch->uTop, 2, 1, file );
               break;

            case 14: /* V Bottom */
               DK_byteswap_fread( &ptch->vBottom, 2, 1, file );
               break;

            case 15: /* V Top */
               DK_byteswap_fread( &ptch->vTop, 2, 1, file );
               break;

            case 16: /* faceted */
               DK_byteswap_fread( &ptch->faceted, 2, 1, file );
               break;

	    case 17: /* type approx */
		DK_byteswap_fread( &ptch->approx_type, sizeof(unsigned short), 1, file);
		break;
    
	    case 18: /* view Dep */
	        DK_byteswap_fread( &len, sizeof( short ), 1, file );
		if( len )
		   ptch->approx.viewDep = TRUE;
		else
		   ptch->approx.viewDep = FALSE;
		break;
    
	    case 19: /* spacial */
		DK_byteswap_fread( &ptch->approx.spacial, sizeof(float), 1, file);
		break;
    
	    case 20: /* curv_u */
		DK_byteswap_fread( &ptch->approx.curv_u, sizeof(float), 1, file);
		break;
    
	    case 21: /* curv_v */
		DK_byteswap_fread( &ptch->approx.curv_v, sizeof(float), 1, file);
		break;
    
	    case 22: /* recMin */
		DK_byteswap_fread( &ptch->approx.recMin, sizeof(unsigned short), 1, file);
		break;
    
	    case 23: /* recMax */
		DK_byteswap_fread( &ptch->approx.recMax, sizeof(unsigned short), 1, file);
		break;
    
	    case 24: /* recurtion */
	        DK_byteswap_fread( &len, sizeof( short ), 1, file );
		if( len )
		   ptch->approx.recursion = TRUE;
		else
		   ptch->approx.recursion = FALSE;
		break;
      
	    case 25: /* tagged points */
		sel = ptch->sel;
		for( i = ptch->uNbPoints * ptch->vNbPoints; i > 0; i--, sel++ )
		   DK_byteswap_fread( sel, sizeof( short ), 1, file );
	        break;

            default:
               DK_fileSkipField( file, tok );

         }
         if( (prot != NULL) && (prot->patch != NULL) )
            tok = prot->patch[ ind ++ ];
         else
            DK_byteswap_fread( &tok, 2, 1, file );
      }
   }
   return( ptch );
}

DK_Boolean DK_patchWriteAscii(  FILE *file, DK_Patch *ptch, DK_String space )
{
   char		 sspace[80];
   DK_Vector	*pnt;
   short	 u, v, *sel;

   sprintf( sspace, "%s  ", space );

   fprintf( file, "\n%spatch\n", space );
   fprintf( file, "%s{\n", space );
   fprintf( file, "%s  utype     %s\n", space, DK_SplineTypeName[ ptch->uType ] );
   fprintf( file, "%s  upoint    %hd\n", space, ptch->uNbPoints );
   if( ptch->uClose )
      fprintf( file, "%s  uclose\n", space );
   fprintf( file, "%s  utension  %*.*f\n", space,  DK_FM,  DK_FD, ptch->uTension );
   fprintf( file, "%s  ustep     %hd\n", space, ptch->uStep );
   fprintf( file, "%s  ucurve    %hd\n", space, ptch->uCurve );
   if( ptch->uTop )
      fprintf( file, "%s  utop\n", space );
   if( ptch->uBottom )
      fprintf( file, "%s  ubottom\n", space );

   fprintf( file, "\n" );
   fprintf( file, "%s  vtype     %s\n", space, DK_SplineTypeName[ ptch->vType ] );
   fprintf( file, "%s  vpoint    %hd\n", space, ptch->vNbPoints );
   if( ptch->vClose )
      fprintf( file, "%s  vclose\n", space );
   fprintf( file, "%s  vtension  %*.*f\n", space,  DK_FM,  DK_FD, ptch->vTension );
   fprintf( file, "%s  vstep     %hd\n", space, ptch->vStep );
   fprintf( file, "%s  vcurve    %hd\n", space, ptch->vCurve );
   if( ptch->vTop )
      fprintf( file, "%s  vtop\n", space );
   if( ptch->vBottom )
      fprintf( file, "%s  vbottom\n", space );

   fprintf( file, "\n%s  controlPoints\n", space );
   fprintf( file, "%s  {\n", space );
   pnt = ptch->points;
   for( u = 0; u < ptch->uNbPoints; u++ )
   {
      if( u != 0 )
         fprintf( file, "\n" );
      for( v = 0; v < ptch->vNbPoints; v++, pnt++ )
         fprintf( file, "%s    [%1hd,%1hd]  position  %*.*f  %*.*f  %*.*f\n",
                  space, u, v,  DK_FM,  DK_FD, pnt->x,  DK_FM,  DK_FD, pnt->y,  DK_FM,  DK_FD, pnt->z );
   }
   fprintf( file, "%s  }\n", space );
   
   fprintf( file, "%s approx_type   %hd\n", space, ptch->approx_type);
   fprintf( file, "%s viewDep	%d\n", space, ptch->approx.viewDep);
   fprintf( file, "%s spacial	%*.*f\n", space, DK_FM, DK_FD, ptch->approx.spacial);
   fprintf( file, "%s curv_u	%*.*f\n", space, DK_FM, DK_FD, ptch->approx.curv_u);
   fprintf( file, "%s curv_v	%*.*f\n", space, DK_FM, DK_FD, ptch->approx.curv_v);
   fprintf( file, "%s recMin	%hd\n", space, ptch->approx.recMin);
   fprintf( file, "%s recMax	%hd\n", space, ptch->approx.recMax);
   fprintf( file, "%s recursion	%d\n", space, ptch->approx.recursion);

   fprintf( file, "\n%s  taggedPoints\n", space );
   fprintf( file, "%s  {\n", space );
   sel = ptch->sel;
   for( u = 0; u < ptch->uNbPoints; u++ )
   {
      if( u != 0 )
         fprintf( file, "\n" );
      for( v = 0; v < ptch->vNbPoints; v++, sel++ )
         fprintf( file, "%s    [%1hd,%1hd]  tagged  %hd \n", space, u, v, *sel );
   }
   fprintf( file, "%s  }\n", space );

   fprintf( file, "%s}\n", space );

   return( TRUE );
}

DK_Boolean DK_patchWriteBinary(  FILE *file, DK_Patch *ptch, DK_FileProt *prot )
{
   short      nb, *sel; 
   short	len;
   int        i, j;
   DK_Vector     *pnt;

   for( i = 0; i < prot->nbPatch; i++ )
   {
      switch( prot->patch[ i ] )
      {
         case 0:	/* end of patch definition */
            break;

         case 1:	/* U type */
            nb = (short) ptch->uType;
            DK_byteswap_fwrite( &nb, 2, 1, file );
            break;
 
         case 2:	/* V type */
            nb = (short) ptch->vType;
            DK_byteswap_fwrite( &nb, 2, 1, file );
            break;
 
         case 3:	/* Control Points list */
            DK_byteswap_fwrite( &ptch->uNbPoints, 2, 1, file );
            DK_byteswap_fwrite( &ptch->vNbPoints, 2, 1, file );
            pnt = ptch->points;
            for( j = ptch->uNbPoints * ptch->vNbPoints; j > 0; j--, pnt++ )
               DK_Vector_fwrite( pnt, sizeof( DK_Vector ), 1, file );
            break;

         case 4:	/* U close */
            DK_byteswap_fwrite( &ptch->uClose, 2, 1, file );
            break;

         case 5:	/* V close */
            DK_byteswap_fwrite( &ptch->vClose, 2, 1, file );
            break;

         case 6:	/* U Tension */
            DK_byteswap_fwrite( &ptch->uTension, 4, 1, file );
            break;

         case 7:	/* V Tension */
            DK_byteswap_fwrite( &ptch->vTension, 4, 1, file );
            break;

         case 8:	/* U drawing Step */
            DK_byteswap_fwrite( &ptch->uStep, 2, 1, file );
            break;

         case 9:	/* V drawing Step */
            DK_byteswap_fwrite( &ptch->vStep, 2, 1, file );
            break;

         case 10:	/* U Curves */
            DK_byteswap_fwrite( &ptch->uCurve, 2, 1, file );
            break;

         case 11:	/* V Curves */
            DK_byteswap_fwrite( &ptch->vCurve, 2, 1, file );
            break;

         case 12:	/* U Bottom */
            DK_byteswap_fwrite( &ptch->uBottom, 2, 1, file );
            break;

         case 13:	/* U Top */
            DK_byteswap_fwrite( &ptch->uTop, 2, 1, file );
            break;

         case 14:	/* V Bottom */
            DK_byteswap_fwrite( &ptch->vBottom, 2, 1, file );
            break;

         case 15:	/* V Top */
            DK_byteswap_fwrite( &ptch->vTop, 2, 1, file );
            break;

         case 16: /* faceted */
            DK_byteswap_fwrite( &ptch->faceted, 2, 1, file );
            break;

	 case 17: /* type approx */
	    DK_byteswap_fwrite( &ptch->approx_type, sizeof(unsigned short), 1, file);
	    break;

	 case 18: /* view Dep */
	    len = (short) ptch->approx.viewDep;
	    DK_byteswap_fwrite( &len, sizeof(short), 1, file);
	    break;

	 case 19: /* spacial */
	    DK_byteswap_fwrite( &ptch->approx.spacial, sizeof(float), 1, file);
	    break;

	 case 20: /* curv_u */
	    DK_byteswap_fwrite( &ptch->approx.curv_u, sizeof(float), 1, file);
	    break;

	 case 21: /* curv_v */
	    DK_byteswap_fwrite( &ptch->approx.curv_v, sizeof(float), 1, file);
	    break;

	 case 22: /* recMin */
	    DK_byteswap_fwrite( &ptch->approx.recMin, sizeof(unsigned short), 1, file);
	    break;

	 case 23: /* recMax */
	    DK_byteswap_fwrite( &ptch->approx.recMax, sizeof(unsigned short), 1, file);
	    break;

	 case 24: /* recurtion */
	    len = (short) ptch->approx.recursion;
	    DK_byteswap_fwrite( &len, sizeof(short), 1, file);
	    break;

	 case 25: /* tagged points */
	   for( j = ptch->uNbPoints * ptch->vNbPoints, sel = ptch->sel; j > 0; 
								  j--, sel++ )
	       DK_byteswap_fwrite( sel, sizeof( short), 1, file );
	    break;

         default:
	    if ( DK_option.verbose == TRUE)
                fprintf( DK_option.msgFd, "Error: %s %d): illegal token: %hd\n",
                                          __FILE__, __LINE__, prot->patch[i] );
            break;
      }
   }
   return( TRUE );
}


