/******************************************************************************
*******************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyMental.c,v $
   $Revision: 1.8.14.1 $ $Date: 1995/06/09 22:00:07 $
   Checkin by: $Author: poirierm $

   <Description>

   File supervisor: Martin LeFrancois

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************
******************************************************************************/

#include <string.h>
#include "tinyByteswap.h"
#include "tinyMental.h"

/*----------------------------------------------------------------------*/
/* Constants								*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Macros								*/
/*----------------------------------------------------------------------*/
#define	_dk_IsOldUdfVersion(ver)	( ver < 2.67906 ||		\
					 (ver>=2.69&&ver<=2.99900))

/*----------------------------------------------------------------------*/
/* Local Type Definitions						*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Local Prototypes							*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Local Variables							*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Public Variables							*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Public Functions							*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Local Functions							*/
/*----------------------------------------------------------------------*/
static void DK_udfReadOldBinary( FILE*, DK_FileProt * );

/*******************************************************************************

   $$L DK_udfCopy

   Create a copy of DK_UDF structure passed in parameter.

   Returned Value : DK_UDF * (the copy)

   History : 
      Martin LeFrancois,	October 18 1993,	<Description> 

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_UDF *DK_udfCopy
   (
      DK_UDF	*shader
   )
{
   DK_UDF *copy = NULL;

   if( shader == NULL )
      return( NULL );

   copy = DK_udfAllocate();

   if (shader->name)
      copy->name = strdup( shader->name );

   if (shader->description)
       copy->description = strdup( shader->description );

   copy->active = shader->active;
   copy->order    = shader->order;
   copy->internal = shader->internal;

   return( copy );
}

/*******************************************************************************

   $$L DK_udfAllocate

   Allocate DK_UDF struct and initialise Char to NULL

   Returned Value : DK_UDF * (the copy)

   History : 
      Martin LeFrancois,	October 18 1993,	<Description> 

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_UDF *DK_udfAllocate(void )
{
   DK_UDF *shader = NULL;

   shader = _DK_MALLOC( DK_UDF, sizeof( DK_UDF ), -1 );
   shader->name = NULL;
   shader->description = NULL;
   shader->active = FALSE;
   shader->order       = 0;
   shader->internal    = 0;

   return(shader);
}

/*******************************************************************************

   $$L DK_udfDispose

   Free the DK_UDF struct.

   History : 
      Martin LeFrancois,	October 18 1993,	<Description> 

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
void DK_udfDispose
   (
      DK_UDF   **shader
   )
{
   DK_UDF * shd = *shader;
   
   if( *shader == NULL)
      return;
      
   /* The macro _FREE check if the params are NULL */
   _DK_FREE(shd->name, -1);
   _DK_FREE(shd->description, -1);

   _DK_FREE(*shader, -1);
   *shader = NULL;
   
}

/*******************************************************************************
   $$G DK_udfWriteBinary

   This function write to disk in binary format all the information contained
   by the shader.

   Note : We could have NULL parameters inside shader ( verify )

   Returned Value : FALSE if shader is NULL

   History :
      Martin LeFrancois,        October 14 1993,        First draw

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_Boolean DK_udfWriteBinary
   (
      FILE	    *file, 
      DK_FileProt   *prot,
      DK_UDF	    *shader
   )
{

    short   i;
    long    l;

    /*---- Verify parameters. */
    if ( prot == NULL || prot->nbUdf == 0 || prot->udf == NULL )
        return( FALSE );
    
    for( i = 0; prot->udf[ i ] != 0; i++ )
    {
	switch( prot->udf[ i ] ) {
	
	case 1:  /*  name of picture */
	    if( shader == NULL )
		DK_stringWriteBinary( file, "" );
	    else
		DK_stringWriteBinary( file, shader->name );
	    break;
	case 2: /* Active flag (long)*/
            if ( shader == NULL )
               l = 0L;
	    else
               l = (long) shader->active;
            DK_byteswap_fwrite( &l, sizeof(long), 1, file );
	    break;

	case 3: /* Internal (long) */
            if ( shader == NULL )
               l = 0L;
	    else
               l = (long) shader->internal;
            DK_byteswap_fwrite( &l, sizeof(long), 1, file );
	    break;

	case 4: /* Order (long)  */
            if ( shader == NULL )
               l = 0L;
	    else
               l = (long) shader->order;
            DK_byteswap_fwrite( &l, sizeof(long), 1, file );
	    break;

        default:
	    if ( DK_option.verbose == TRUE)
                fprintf( DK_option.msgFd, "Error: %s %d): illegal token: %hd\n",
                                       __FILE__, __LINE__, prot->texture[ i ] );
            break;
      }
   }

   return( TRUE );

}


/*******************************************************************************
   $$G DK_udfReadBinary

   This function read from disk in binary format all the information contained
   by the shader.

   Note : Maybe the shader is not NULL at the beginning, we may have to
          free the struct before allocating new memory.

   Returned Value : Structure of the shader with info

   History :
      Martin LeFrancois,        October 14 1993,        First draw

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_UDF *DK_udfReadBinary
(
   FILE         *file,
   DK_FileProt   *prot
)
{
   short       tok, nb, ind = 0;
   long        l;
   DK_UDF  *shader;

   /*---- Make sure we can read betasite's old formats. */
   if ( _dk_IsOldUdfVersion( SI_versionInput ) )
   {
      DK_udfReadOldBinary( file, prot );
      return( NULL );
   }

   /* Initialisation */
   shader = DK_udfAllocate();
   if ( shader == NULL )
      return( NULL );


   if( prot != NULL && prot->udf != NULL )
      tok = prot->udf[ ind ++ ];
   else {
      /***********************************************************************/
      /* There is no UDF shader prototype so we will read the five fields    */
      /* for the shader manually. We, therefore set tok to 1. The while      */
      /* loop below will actually be a for loop with tok going from 1        */
      /* to 5, at each iteration the corresponding shader field is read      */
      /* (there are currently 5 fields in the UDF shader). If the UDF shader */
      /* is modifed to have more/less fields then this function will have to */
      /* be modified appropriately (i.e. occurrences of 5 changed to the     */
      /* new number of fields). I hate these prototypes...                   */
      /***********************************************************************/
      tok = 1;
   }

   while( tok != 0  ) /* End of UDF definition */
   {
      switch( tok )
      {
         case 1:  /* name of shader */
            shader->name = DK_stringReadBinary( file );
            break;

         case 2:
            DK_byteswap_fread( &l, sizeof( long ), 1, file );
            shader->active = (short) l;
            break;

         case 3:
            DK_byteswap_fread( &l, sizeof( long ), 1, file );
            shader->internal = (short) l;
            break;

         case 4:
            DK_byteswap_fread( &l, sizeof( long ), 1, file );
            shader->order = (short) l;
            break;

         default:
            DK_fileSkipField( file, tok );
      }
      if( prot != NULL && prot->udf != NULL )
         tok = prot->udf[ ind ++ ];
      else {
         /*****************/
         /* Increment tok */
         /*****************/
         tok++;

         /*********************************************************************/
         /* If we have finished reading the shader's fields then set tok to 0 */
         /*********************************************************************/
         if (tok == 5) tok = 0;
      }
   }

   /* If the shader was save with a name NULL ||
      an empty string "", then no shader is on */
   if (shader->name && 
	((strcmp(shader->name, "NULL") == 0) || (strlen(shader->name) == 0)))
   {
      _DK_FREE(shader->name, -1);
      _DK_FREE(shader,-1);
      shader = NULL;
   }

   return( shader );
}

/*******************************************************************************
   $$G DK_udfReadAscii

   History :
      Martin LeFrancois,        October 14 1993,        First draw

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_UDF *DK_udfReadAscii(  FILE *file )
{
   char		 str[ 80 ], str2[ 80 ];
   DK_UDF	*udf;

   if( (udf = DK_udfAllocate()) == NULL )
      return( NULL );

   fscanf( file, "%s", str );
   if( strcmp( str, "{" ) != 0 )
      return( udf );

   do
   {
      fscanf( file, "%s", str );
      if( strcmp( str, "name" ) == 0 )              /* Name     */
         udf->name = DK_stringReadAscii( file );
      else if( strcmp( str, "active" ) == 0 )       /* Active   */
	 udf->active = TRUE;
      else if( strcmp( str, "internal" ) == 0 )     /* Internal */
	 udf->internal = TRUE;
      else if( strcmp( str, "order" ) == 0 )        /* Order    */
         {
         int   ord;

	 fscanf( file, "%d", &ord );
	 udf->order = ord; 
         }
    } while( strcmp( str, "}" ) != 0 );

   return( udf );
      
}

/*******************************************************************************
   $$G DK_udfWriteAscii

   History :
      Martin LeFrancois,        October 14 1993,        First draw

   (c) Copyright 1993, SOFTIMAGE Inc.

*******************************************************************************/
DK_Boolean DK_udfWriteAscii
(  
    FILE *file, 
    DK_UDF *udf, 
    DK_String space,
    DK_String Uname 
)
{
   if( udf == NULL )
      return( FALSE );

   if ( udf->name == NULL || strlen(udf->name)<1 )
     return( FALSE );

   fprintf( file, "\n%s%s\n", space, Uname );
   fprintf( file, "%s{\n", space );
   if( udf->name )
       fprintf( file, "%s  name		\"%s\"\n", space, udf->name );
   if( udf->active )
       fprintf( file, "%s  active\n", space);
   if( udf->internal )
       fprintf( file, "%s  internal\n", space);
   fprintf( file, "%s  order         %d\n", space, udf->order );
   fprintf( file, "%s}\n", space );
   
   return( TRUE );
}



/*******************************************************************************
   $$S DK_udfReadOldBinary -- Patch for previous UDF versions.

   History :
      Claude Benoit,            September 1994

   (c) Copyright 1994, SOFTIMAGE Inc.

*******************************************************************************/
static void DK_udfReadOldBinary(
   FILE		*file, 
   DK_FileProt	*prot )
{
   short	dummy1;
   int		dummy2;
   short	tok;
   char		*ptr;

   tok = 1;
   while ( tok != 0 )
   {
      switch( tok )
      {
         case 1:  /* name of shader */
            ptr = DK_stringReadBinary( file );
            free( ptr );
            break;

         case 2: /* parameters */
            ptr = DK_stringReadBinary( file );
            free( ptr );
            break;

         case 3: /* param_ids */
            ptr = DK_stringReadBinary( file );
            free( ptr );
            break;

         case 4: /* active flag */
            DK_byteswap_fread( &dummy1, sizeof( short ), 1, file );
            break;

         case 5: /* command */
            DK_byteswap_fread( &dummy2, sizeof( int ), 1, file );
            break;

         default:
            DK_fileSkipField( file, tok );
      }

      /*****************/
      /* Increment tok */
      /*****************/
      tok++;

      /*************************************/
      /* If we have finished reading the   */
      /* shader's fields then set tok to 0 */
      /*************************************/
      if (tok == 6) tok = 0;
   }
}
