/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyFile.c,v $
   $Revision: 1.43.14.2 $ $Date: 1995/07/21 23:08:14 $
   Checkin by: $Author: alain $

   This file contains a subset of the SOFTIMAGE's files facilities,
   its content helps you to controls input and output of SOFTIMAGE's
   file format...

   Written by: Laurent Lauzon

   (c) Copyright 1990, 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include "tinyByteswap.h"
#include "tinySoftType.h"
#include "tinyFile.h"
#include "tinyMental.h"

#ifdef _WIN32
#include <fcntl.h>
#include <io.h>
#endif

/******************************************************************************/
/*** Control Variables ********************************************************/
/******************************************************************************/

/* 
*** Variable to control compatibility with SOFTIMAGE 4D Creative Environment
*** versions: DK_v2_5, DK_v2_6, DK_v2_6_2, DK_v2_6_5, DK_v2_6_6, DK_v3_0
*/

int	DK_VERSION = DK_v3_0;	


/* Variables to control the format of float when print in ASCII */
/* according the printf sequence conversion (% DK_FM. DK_FDf) */

int	 DK_FM = 5;
int	 DK_FD = 3;


/* Variable to control the writing of mesh normals */

DK_Boolean DK_NORMAL = TRUE;
DK_Boolean DK_WRITE_ANIMATION = TRUE;


/******************************************************************************/
/*** Global functions *********************************************************/
/******************************************************************************/

/*
   Set stdin and stdout to binary translation mode.
*/
void DK_streamInitialize (void)
{
#ifdef _WIN32
   _setmode (_fileno (stdin), _O_BINARY);
   _setmode (_fileno (stdout), _O_BINARY);
#endif /* _WIN32 */
}

DK_Boolean DK_prototypeInitModel( DK_FileProt **prot, DK_Boolean alloc  )
{
   int	nbProt;

   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if ( DK_VERSION >= DK_v3_0 ) {
      (*prot)->nbModel  = 24;

   } else if ( DK_VERSION >= DK_v2_6 ) {
      (*prot)->nbModel  = 21;

   } else {
      (*prot)->nbModel  = 19;
   }

   if( ( (*prot)->model = 
	(short *) calloc( (*prot)->nbModel, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }

   nbProt = 0;
   (*prot)->model[nbProt++]  = 1;		/* name */
   (*prot)->model[nbProt++]  = 2;		/* type */
   (*prot)->model[nbProt++]  = 3;		/* definition */

   (*prot)->model[nbProt++]  = 12;		/* shape interp type */

   (*prot)->model[nbProt++]  = 4;		/* scaling */
   (*prot)->model[nbProt++]  = 5;		/* rotation */
   (*prot)->model[nbProt++]  = 6;		/* translation */
   (*prot)->model[nbProt++]  = 7;		/* materials list */
   (*prot)->model[nbProt++]  = 8;		/* textures list */
   (*prot)->model[nbProt++]  = 9;		/* 3D textures list */

   (*prot)->model[nbProt++] = 14;		/* physical properties info */
   (*prot)->model[nbProt++] = 16;		/* algotype */
   (*prot)->model[nbProt++] = 17;		/* envelope info */
   (*prot)->model[nbProt++] = 18;		/* dynamic  DK_options */
   (*prot)->model[nbProt++] = 19;		/* joint dynamic properties */
   (*prot)->model[nbProt++] = 20;		/* inverse kinematic data */

   if( DK_VERSION >= DK_v2_6 )
   {
      (*prot)->model[nbProt++] = 21;		/* cluster data */
      (*prot)->model[nbProt++] = 22;		/* userData */
   }

   if( DK_VERSION >= DK_v3_0 )
   {
      (*prot)->model[nbProt++] = 23;		/* visibilityFlags */
      (*prot)->model[nbProt++] = 24;		/* motionBlurFlags */
      (*prot)->model[nbProt++] = 25;		/* rigid env. init. trsfos. */
   }
   
   (*prot)->model[nbProt++] = 10;		/* child */
   (*prot)->model[nbProt++] = 11;		/* sibling */
   (*prot)->model[nbProt++] = 0;		/* end of definition */

   DK_prototypeInitFace( prot, FALSE );
   DK_prototypeInitMesh( prot, FALSE );
   DK_prototypeInitPatch( prot, FALSE );
   DK_prototypeInitMaterial( prot, FALSE );
   DK_prototypeInitTexture3D( prot, FALSE );
   DK_prototypeInitTexture( prot, FALSE );

   DK_prototypeInitPhysical( prot, FALSE );
   DK_prototypeInitJoint( prot, FALSE );
   DK_prototypeInitEnvelopeData( prot, FALSE );
   DK_prototypeInitEnvelopeVertex( prot, FALSE );

   if ( DK_VERSION >= DK_v2_6 )
   {
       DK_prototypeInitCluster( prot, FALSE );
       DK_prototypeInitMetaball( prot, FALSE );
   }
   if ( DK_VERSION >= DK_v3_0 )
   {
       DK_prototypeInitUDF( prot, FALSE );
       DK_prototypeInitNurbsCrv( prot, FALSE );
       DK_prototypeInitNurbsSrf( prot, FALSE );
       DK_prototypeInitNurbsCompCrv( prot, FALSE );
   }

   return( TRUE );
}

DK_Boolean DK_prototypeInitFace( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if ( DK_VERSION < DK_v3_0 )
      (*prot)->nbFace  = 3;
   else
      (*prot)->nbFace  = 5;

   if( ( (*prot)->face = (short *) calloc( (*prot)->nbFace, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   if ( DK_VERSION < DK_v3_0 )
   {
      (*prot)->face[0]  = 1;		/* exterior */
      (*prot)->face[1]  = 2;		/* holes list */
      (*prot)->face[2]  = 0;		/* end of face definition */
      DK_prototypeInitSpline( prot, FALSE );
   }
   else
   {
      /* NURBS face */
      (*prot)->face[0]  = 3;           /* isSpline */
      (*prot)->face[1]  = 1;           /* exterior */
      (*prot)->face[2]  = 2;           /* holes list */
      (*prot)->face[3]  = 4;           /* NURBS face list */
      (*prot)->face[4]  = 0;           /* end of face definition */

      /* est-ce que ca doit rester la ? */
      DK_prototypeInitSpline( prot, FALSE );
      DK_prototypeInitNurbsCrv( prot, FALSE );
   }


   return( TRUE );
}

DK_Boolean DK_prototypeInitSpline( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbSpline  = 8;

   if( ( (*prot)->spline = (short *) calloc( (*prot)->nbSpline, sizeof(short))) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }

   (*prot)->spline[0]  = 8;	/* name */
   (*prot)->spline[1]  = 1;	/* type */
   (*prot)->spline[2]  = 7;	/* keys list */
   (*prot)->spline[3]  = 3;	/* close */
   (*prot)->spline[4]  = 4;	/* tension */
   (*prot)->spline[5]  = 5;	/* drawing step */
   (*prot)->spline[6]  = 6;	/* automatic phantom */
   (*prot)->spline[7]  = 0;	/* end of spline definition */

   (*prot)->nbSplKey  = 7;
   if( ( (*prot)->splKey = (short *) calloc( (*prot)->nbSplKey, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->splKey[0]  = 1;	/* previous */
   (*prot)->splKey[1]  = 2;	/* position */
   (*prot)->splKey[2]  = 3;	/* next */
   (*prot)->splKey[3]  = 4;	/* constraint */
   (*prot)->splKey[4]  = 5;	/* segment */
   (*prot)->splKey[5]  = 6;	/* flag */
   (*prot)->splKey[6]  = 0;	/* end of spline key definition */

   return( TRUE );
}

DK_Boolean DK_prototypeInitMesh( DK_FileProt **prot, DK_Boolean alloc  )
{
   if (alloc) 
      if ((*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbMesh  = 6;
   if (((*prot)->mesh = 
	(short *) calloc ((*prot)->nbMesh, sizeof (short))) == NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
      (*prot)->mesh[0]  = 6;	/* flag */
      (*prot)->mesh[1]  = 2;	/* discontinuity angle */
      (*prot)->mesh[2]  = 7;	/* LONG vertices list */
      (*prot)->mesh[3]  = 8;	/* LONG polygons list */
      (*prot)->mesh[4]  = 9;	/* LONG edges list */
      (*prot)->mesh[5]  = 0;	/* end of mesh definition */
   }

   (*prot)->nbVertex  = 3;
   if (((*prot)->vertex = (short *) calloc ((*prot)->nbVertex, 
				       	    sizeof (short))) == NULL ) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
      (*prot)->vertex[0]  = 1;	/* position */
      (*prot)->vertex[1]  = 4;	/* flag */
      (*prot)->vertex[2]  = 0;	/* end of vertex definition */
   }

   (*prot)->nbPolygon = (DK_VERSION >= DK_v3_0) + 3;
   if (((*prot)->polygon = (short *) calloc((*prot)->nbPolygon, 
					   sizeof(short))) == NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
     int polIdx = 0;
     (*prot)->polygon[polIdx++]  = 2;	/* nodes list */
     (*prot)->polygon[polIdx++]  = 3;	/* material index */
     if (DK_VERSION >= DK_v3_0) {
       (*prot)->polygon[polIdx++]  = 4;	/* flag */
     }
     (*prot)->polygon[polIdx++]  = 0;	/* end of polygon definition */
   }


   (*prot)->nbPolNode  = (DK_VERSION >= DK_v3_0) + (DK_NORMAL == TRUE) + 2;
   if (((*prot)->polNode = (short *) calloc ((*prot)->nbPolNode, 
				             sizeof (short))) == NULL) {
         DK_prototypeDispose( prot );
         return( FALSE );
   } else {
     int polIdx = 0;
     (*prot)->polNode[polIdx++]  = 3;	/* LONG vertex index */
     if (DK_NORMAL == TRUE) {
       (*prot)->polNode[polIdx++]  = 2;	/* normal */
     }
     if (DK_VERSION >= DK_v3_0) {
       (*prot)->polNode[polIdx++]  = 4;	/* uv texture coordinate */
     }
     (*prot)->polNode[polIdx++]  = 0;	/* end of polygon node definition */
   }

   (*prot)->nbEdge  = 3;
   if (((*prot)->edge = (short *) calloc ((*prot)->nbEdge, 
					   sizeof (short))) == NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
       (*prot)->edge[0]  = 4;	/* LONG vertex */
       (*prot)->edge[1]  = 3;	/* flag */
       (*prot)->edge[2]  = 0;	/* end of edge definition */
   }

   return( TRUE );
}


DK_Boolean DK_prototypeInitPatch( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if (DK_VERSION >= DK_v3_0) {
       (*prot)->nbPatch  = 26;
   } else {
       (*prot)->nbPatch  = 17;
   }

   if (((*prot)->patch =
        (short *) calloc ((*prot)->nbPatch, sizeof (short))) == NULL ) {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->patch[0]  = 1;   /* U type */
   (*prot)->patch[1]  = 2;   /* V type */
   (*prot)->patch[2]  = 3;   /* Control points */
   (*prot)->patch[3]  = 4;   /* U close */
   (*prot)->patch[4]  = 5;   /* V close */
   (*prot)->patch[5]  = 6;   /* U Tension */
   (*prot)->patch[6]  = 7;   /* V Tension */
   (*prot)->patch[7]  = 8;   /* U drawing step */
   (*prot)->patch[8]  = 9;   /* V drawing step */
   (*prot)->patch[9]  = 10;  /* U curve */
   (*prot)->patch[10] = 11;  /* V curve */
   (*prot)->patch[11] = 12;  /* U bottom */
   (*prot)->patch[12] = 13;  /* U top */
   (*prot)->patch[13] = 14;  /* V bottom */
   (*prot)->patch[14] = 15;  /* V top */
   (*prot)->patch[15] = 16;   /* faceted */
   if (DK_VERSION >= DK_v3_0)
   {
	  (*prot)->patch[16] = 17;  /* approx_type */
	  (*prot)->patch[17] = 18;  /* approx.viewDep */
	  (*prot)->patch[18] = 19;  /* approx.spacial */
	  (*prot)->patch[19] = 20;  /* approx.curv_u */
	  (*prot)->patch[20] = 21;  /* approx.curv_v */
	  (*prot)->patch[21] = 22;  /* approx.recMin */
	  (*prot)->patch[22] = 23;  /* approx.recMax */
	  (*prot)->patch[23] = 24;  /* approx.recursion */
	  (*prot)->patch[24] = 25;  /* Tagged points */
	  (*prot)->patch[25] = 0;   /* end of patch definition */
   } else {
    	  (*prot)->patch[16] = 0;   /* end of patch definition */
   }

   return( TRUE );
}

DK_Boolean DK_prototypeInitNurbsCrv( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbNurbsCrv = 8;

   if( ( (*prot)->nurbsCrv= 
	(short *) calloc( (*prot)->nbNurbsCrv, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->nurbsCrv[0]  = 1;   /* order */
   (*prot)->nurbsCrv[1]  = 2;   /* noPoints*/
   (*prot)->nurbsCrv[2]  = 3;   /* closed*/
   (*prot)->nurbsCrv[3]  = 4;   /* uniformity */
   (*prot)->nurbsCrv[4]  = 5;   /* start, end */
   (*prot)->nurbsCrv[5] = 6;   /* display step */
   (*prot)->nurbsCrv[6] = 7;   /* closing information */
   (*prot)->nurbsCrv[7]  = 0;   /* end of patch definition */
   return( TRUE );
}
  
DK_Boolean DK_prototypeInitNurbsSrf( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbNurbsSrf= 26;

   if( ( (*prot)->nurbsSrf=
        (short *) calloc( (*prot)->nbNurbsSrf, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->nurbsSrf[0]  = 1;   /* order in U, V  */
   (*prot)->nurbsSrf[1]  = 2;   /* noPoints*/
   (*prot)->nurbsSrf[2]  = 3;   /* closed*/
   (*prot)->nurbsSrf[3]  = 4;   /* uniformity */
   (*prot)->nurbsSrf[4]  = 5;   /* start, end */
   (*prot)->nurbsSrf[5]  = 6;   /* autoBorder */
   (*prot)->nurbsSrf[6]  = 7;   /* trims */
   (*prot)->nurbsSrf[7] = 8;   /* u display step */
   (*prot)->nurbsSrf[8] = 9;   /* v display step */
   (*prot)->nurbsSrf[9] = 10;  /* u drawing curve */
   (*prot)->nurbsSrf[10] = 11; /* v drawing curve */
   (*prot)->nurbsSrf[11] = 12; /* cappind U bottom */
   (*prot)->nurbsSrf[12] = 13; /* cappind U top */
   (*prot)->nurbsSrf[13] = 14; /* cappind V bottom */
   (*prot)->nurbsSrf[14] = 15; /* cappind V top */
   (*prot)->nurbsSrf[15] = 16; /* U closing information */
   (*prot)->nurbsSrf[16] = 17; /* V closing information */
   (*prot)->nurbsSrf[17] = 18; /* approx_type */
   (*prot)->nurbsSrf[18] = 19; /* approx.viewDep */
   (*prot)->nurbsSrf[19] = 20; /* approx.spacial */
   (*prot)->nurbsSrf[20] = 21; /* approx.curv_u */
   (*prot)->nurbsSrf[21] = 22; /* approx.curv_v */
   (*prot)->nurbsSrf[22] = 23; /* approx.recMin */
   (*prot)->nurbsSrf[23] = 24; /* approx.recMax */
   (*prot)->nurbsSrf[24] = 25; /* approx.recursion */
   (*prot)->nurbsSrf[25] = 0;  /* end of patch definition */

   return( TRUE );
}

DK_Boolean DK_prototypeInitNurbsCompCrv( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbNurbsCompCrv = 3;
   if( ( (*prot)->nurbsCompCrv=
        (short *) calloc( (*prot)->nbNurbsCompCrv, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->nurbsCompCrv[0]  = 1;   /* boundary*/
   (*prot)->nurbsCompCrv[1]  = 2;   /* composite curves*/
   (*prot)->nurbsCompCrv[2] = 0;   /* end of patch definition */

   return( TRUE );
}

DK_Boolean DK_prototypeInitMaterial( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if( DK_VERSION >=  DK_v3_0 ) {
      (*prot)->nbMaterial  = 20;
   } else if (DK_VERSION >= DK_v2_6 ) {
      (*prot)->nbMaterial  = 17;
   } else {
      (*prot)->nbMaterial  = 14;
   }

   if (((*prot)->material = (short *) calloc ((*prot)->nbMaterial, 
					      sizeof(short))) == NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   }


   if (DK_VERSION >= DK_v2_5)
   {
      (*prot)->material[0]  = 1;	/* material name */
      (*prot)->material[1]  = 2;	/* shading model */
      (*prot)->material[2]  = 14;	/* glow */
      (*prot)->material[3]  = 15;	/* coc */
      (*prot)->material[4]  = 3;	/* ambient color */
      (*prot)->material[5]  = 4;	/* diffuse color */
      (*prot)->material[6]  = 5;	/* specular color */
      (*prot)->material[7]  = 6;	/* specular exponent */
      (*prot)->material[8]  = 7;	/* transparency */
      (*prot)->material[9]  = 13;	/* reflection */
      (*prot)->material[10] = 11;	/* refractive index */
      (*prot)->material[11] = 16;	/* local texture list */
      (*prot)->material[12] = 17;	/* local 3D texture list */
      (*prot)->material[13] = 0;	/* end of definition */
   }
   if (DK_VERSION >= DK_v2_6)
   {
	  (*prot)->material[13] = 18;	/* static blur */
	  (*prot)->material[14] = 19;	/* static blur width */
	  (*prot)->material[15] = 20;	/* static blur decay value */
	  (*prot)->material[16] = 0;	/* end of definition */
   }
   if (DK_VERSION >= DK_v3_0)
   {
	(*prot)->material[16] = 21;	/* UDF matter shader */
	(*prot)->material[17] = 22;	/* UDF volume shader */
        (*prot)->material[18] = 23;	/* UDF shadow shader */
        (*prot)->material[19] = 0;	/* end of  definition */
        DK_prototypeInitUDF( prot, FALSE );
   }
    
   return( TRUE );
}

DK_Boolean DK_prototypeInitTexture( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if( DK_VERSION >= DK_v3_0 ) {
      (*prot)->nbTexture  = 37;
   } else if( DK_VERSION >= DK_v2_6_5 ) {
      (*prot)->nbTexture  = 34;
   } else {
      (*prot)->nbTexture  = 30;
   }

   if (((*prot)->texture = (short *) calloc ((*prot)->nbTexture, 
					     sizeof(short))) == NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->texture[0]  = 1;	/* name */
   (*prot)->texture[1]  = 2;	/* animation type */
   (*prot)->texture[2]  = 3;	/* U repetition */
   (*prot)->texture[3]  = 4;	/* V repetition */
   (*prot)->texture[4]  = 5;	/* U scaling */
   (*prot)->texture[5]  = 6;	/* V scaling */
   (*prot)->texture[6]  = 7;	/* U offset */
   (*prot)->texture[7]  = 8;	/* V offset */
   (*prot)->texture[8]  = 9;	/* pixel interpolation */
   (*prot)->texture[9]  = 10;	/* application method */
   (*prot)->texture[10] = 11;	/* ambient factor */
   (*prot)->texture[11] = 12;	/* diffuse */
   (*prot)->texture[12] = 13;	/* specular */
   (*prot)->texture[13] = 14;	/* roughness */
   (*prot)->texture[14] = 15;	/* transparency */
   (*prot)->texture[15] = 16;	/* reflection */
   (*prot)->texture[16] = 18;	/* environment rotation */
   (*prot)->texture[17] = 20;	/* blending factor */
   (*prot)->texture[18] = 21;	/* cropping */
   (*prot)->texture[19] = 22;	/* crop umin */
   (*prot)->texture[20] = 23;	/* crop vmin */
   (*prot)->texture[21] = 24;	/* crop umax */
   (*prot)->texture[22] = 25;	/* crop vmax */
   (*prot)->texture[23] = 26;	/* UV swap */
   (*prot)->texture[24] = 27;	/* U mirror */
   (*prot)->texture[25] = 28;	/* V mirror */
   (*prot)->texture[26] = 29;	/* reflectivity */
   (*prot)->texture[27] = 30;	/* mask channel */
   (*prot)->texture[28] = 31;	/* effect channel */
   (*prot)->texture[29] = 0;	/* end of texture definition */

   if (DK_VERSION >= DK_v2_6_5)
   {
	(*prot)->texture[29] = 32;     /* txtsup rot */
	(*prot)->texture[30] = 33;     /* txtsup scal */
	(*prot)->texture[31] = 34;     /* txtsup trans */
	(*prot)->texture[32] = 35;     /* Mapping Black/White */
	(*prot)->texture[33] = 0;	/* end of texture definition */
   }
   if  (DK_VERSION >= DK_v3_0) {
	(*prot)->texture[33] = 36;  /* UDF shader */
	(*prot)->texture[34] = 37;  /* displacement */
	(*prot)->texture[35] = 50;	/* global name */
	(*prot)->texture[36] = 0;	/* end of texture definition */
        DK_prototypeInitUDF( prot, FALSE );
   }

   return( TRUE );
}

DK_Boolean DK_prototypeInitTexture3D( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );


   if( DK_VERSION >= DK_v3_0 ) {
      (*prot)->nbTexture3D  = 30;
   } else {
      (*prot)->nbTexture3D  = 28;
   }
      
   if (((*prot)->texture3D = (short *) calloc ((*prot)->nbTexture3D, 
						sizeof(short))) ==NULL) {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->texture3D[0]  = 1;	/* texture name */
   (*prot)->texture3D[1]  = 2;	/* texture type */
   (*prot)->texture3D[2]  = 3;	/* number of iteration */
   (*prot)->texture3D[3]  = 4;	/* strenght */
   (*prot)->texture3D[4]  = 5;	/* spacing */
   (*prot)->texture3D[5]  = 22;	/* color 1 */
   (*prot)->texture3D[6]  = 23;	/* color 2 */
   (*prot)->texture3D[7]  = 24;	/* color 3 */
   (*prot)->texture3D[8]  = 25;	/* color 4 */
   (*prot)->texture3D[9]  = 26;	/* color 5 */
   (*prot)->texture3D[10] = 10;	/* factor 2 */
   (*prot)->texture3D[11] = 27;	/* factor 3 */
   (*prot)->texture3D[12] = 28;	/* factor 4 */
   (*prot)->texture3D[13] = 11;	/* scaling */
   (*prot)->texture3D[14] = 12;	/* rotation */
   (*prot)->texture3D[15] = 13;	/* translation */
   (*prot)->texture3D[16] = 14;	/* ambient factor */
   (*prot)->texture3D[17] = 15;	/* diffuse factor */
   (*prot)->texture3D[18] = 16;	/* specular factor */
   (*prot)->texture3D[19] = 17;	/* roughness factor */
   (*prot)->texture3D[20] = 18;	/* transparency */
   (*prot)->texture3D[21] = 19;	/* reflection factor */
   (*prot)->texture3D[22] = 21;	/* power */
   (*prot)->texture3D[23] = 29;	/* taper */
   (*prot)->texture3D[24] = 31;	/* blending */
   (*prot)->texture3D[25] = 32;	/* mask */
   (*prot)->texture3D[26] = 33;	/* effect channel */
   (*prot)->texture3D[27] = 0;	/* end of texture 3D definition */

   if( DK_VERSION >= DK_v3_0 ) {
      (*prot)->texture3D[27] = 34;	/* UDF shader */
      (*prot)->texture3D[28] = 35;	/* displacement */
      (*prot)->texture3D[29] = 0;	/* end of texture 3D definition */
      DK_prototypeInitUDF( prot, FALSE );
   }

   return( TRUE );
}

DK_Boolean DK_prototypeInitPhysical( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbPhysical  = 8;
   if (((*prot)->physical = (short *) calloc ((*prot)->nbPhysical, 
					      sizeof (short))) == NULL ) {
      DK_prototypeDispose( prot );
      return( FALSE );
   }

   (*prot)->physical[0]  = 1;   /* density */
   (*prot)->physical[1]  = 2;   /* roughness (static) */
   (*prot)->physical[2]  = 3;   /* elasticity */
   (*prot)->physical[3]  = 4;   /* rigidity */
   (*prot)->physical[4]  = 5;   /* plasticity */
   (*prot)->physical[5]  = 6;   /* roughness (kinetic) */
   (*prot)->physical[6]  = 7;   /* node coll. detection level */
   (*prot)->physical[7]  = 0;   /* end of physical definition */

   return( TRUE );
}

DK_Boolean DK_prototypeInitJoint( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbJoint  = 2;
   if( ( (*prot)->joint = 
	(short *) calloc( (*prot)->nbJoint, sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->joint[0]  = 1;   /* friction */
   (*prot)->joint[1]  = 0;   /* end of joint definition */

   return( TRUE );
}

DK_Boolean DK_prototypeInitEnvelopeData( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if ( DK_VERSION >= DK_v2_6 ) {
      (*prot)->nbEnvelopeData  = 21;
   } else {
      (*prot)->nbEnvelopeData  = 18;
   }

   if (((*prot)->envelopeData = (short *) calloc ((*prot)->nbEnvelopeData, 
						   sizeof (short))) == NULL ) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
     int	nbProt = 0;

     (*prot)->envelopeData[nbProt++]  = 1;   /* level */
     (*prot)->envelopeData[nbProt++]  = 2;   /* initvrot */
     if ( DK_VERSION >= DK_v2_6 )
     {
        (*prot)->envelopeData[nbProt++] = 22;  /* root init scal */
        (*prot)->envelopeData[nbProt++] = 23;  /* root init rot */
        (*prot)->envelopeData[nbProt++] = 24;  /* root init trs */
     }
     (*prot)->envelopeData[nbProt++]  = 5;   /* joint area */
     (*prot)->envelopeData[nbProt++]  = 4;   /* inner curve type */
     (*prot)->envelopeData[nbProt++]  = 7;   /* inner curve beginning */
     (*prot)->envelopeData[nbProt++]  = 8;   /* inner curve end */
     (*prot)->envelopeData[nbProt++]  = 9;   /* inner curve amplitude */
     (*prot)->envelopeData[nbProt++]  = 11;  /* inner curve scaling */
     (*prot)->envelopeData[nbProt++]  = 12;  /* outer curve type */
     (*prot)->envelopeData[nbProt++]  = 13;  /* outer curve beginning */
     (*prot)->envelopeData[nbProt++] = 14;  /* outer curve end */
     (*prot)->envelopeData[nbProt++] = 15;  /* outer curve amplitude */
     (*prot)->envelopeData[nbProt++] = 16;  /* outer curve scaling */
     (*prot)->envelopeData[nbProt++] = 17;  /* inner curve data */
     (*prot)->envelopeData[nbProt++] = 18;  /* outer curve data */
     (*prot)->envelopeData[nbProt++] = 20;  /* list of envelopes */
     (*prot)->envelopeData[nbProt++] = 21;  /* segment vertices */
     (*prot)->envelopeData[nbProt++] = 0;   /* end of envelopeData definition */
   }

   return( TRUE );
}

DK_Boolean DK_prototypeInitEnvelopeVertex( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   if ( DK_VERSION >= DK_v2_6 )
      (*prot)->nbEnvelopeVertex  = 5;
   else
      (*prot)->nbEnvelopeVertex  = 4;
   if (((*prot)->envelopeVertex = (short *) calloc ((*prot)->nbEnvelopeVertex, 
						    sizeof (short))) == NULL ) {
      DK_prototypeDispose( prot );
      return( FALSE );
   } else {
     int	nbProt = 0;

     (*prot)->envelopeVertex[nbProt++]  = 1;   /* index */
     (*prot)->envelopeVertex[nbProt++]  = 3;   /* ratio */
     (*prot)->envelopeVertex[nbProt++]  = 4;   /* thickness */
     if ( DK_VERSION >= DK_v2_6 ) {
        (*prot)->envelopeVertex[nbProt++]  = 6;   /* weight */
     }
     (*prot)->envelopeVertex[nbProt++]  = 0;   /* end of envelopeVertex def. */
   }
   return( TRUE );
}

DK_Boolean DK_prototypeInitCluster( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbCluster  = 5;
   if( ( (*prot)->cluster = (short *) calloc( (*prot)->nbCluster, 
		sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->cluster[0]  = 1;   /* cluster name */
   (*prot)->cluster[1]  = 2;   /* nb of cv's in cluster */
   (*prot)->cluster[2]  = 3;   /* cluster indexes */
   (*prot)->cluster[3]  = 4;   /* cluster state */
   (*prot)->cluster[4]  = 0;   /* end of cluster definition */
   return( TRUE );
}

DK_Boolean DK_prototypeInitMetaball( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbMetaball  = 5;
   if( ( (*prot)->metaball = (short *) calloc( (*prot)->nbMetaball,
                sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->metaball[0]  = 4;   /* ratio */
   (*prot)->metaball[1]  = 5;   /* weight */
   (*prot)->metaball[2]  = 6;   /* exponent */
   (*prot)->metaball[3]  = 7;   /* centerMat */
   (*prot)->metaball[4]  = 0;   /* end of metaball definition */

   (*prot)->nbMetaSystem  = 6;
   if( ( (*prot)->metaSystem = (short *) calloc( (*prot)->nbMetaSystem,
                sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->metaSystem[0]  = 1;   /* wf_resolution */
   (*prot)->metaSystem[1]  = 2;   /* ren_resolution */
   (*prot)->metaSystem[2]  = 3;   /* showSurface */
   (*prot)->metaSystem[3]  = 4;   /* group list */
   (*prot)->metaSystem[4]  = 5;   /* unblend list */
   (*prot)->metaSystem[5]  = 0;   /* end of metasystem definition */

   (*prot)->nbMetaGroup  = 3;
   if( ( (*prot)->metaGroup = (short *) calloc( (*prot)->nbMetaGroup,
                sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->metaGroup[0]  = 1;   /* group name */
   (*prot)->metaGroup[1]  = 2;   /* list of Prims */
   (*prot)->metaGroup[2]  = 0;   /* end of metaGroup definition */

   (*prot)->nbMetaUnblend  = 2;
   if( ( (*prot)->metaUnblend = (short *) calloc( (*prot)->nbMetaUnblend, 
		sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->metaUnblend[0]  = 1;   /* 2 group names */
   (*prot)->metaUnblend[1]  = 0;   /* end of metaUnblend definition */
   return( TRUE );
}

DK_Boolean DK_prototypeInitUDF( DK_FileProt **prot, DK_Boolean alloc  )
{
   if( alloc )
      if( (*prot = DK_prototypeAllocate()) == NULL )
         return( FALSE );

   (*prot)->nbUdf  = 5;
   if( ( (*prot)->udf = (short *) calloc( (*prot)->nbUdf, 
		sizeof( short ) ) ) == NULL )
   {
      DK_prototypeDispose( prot );
      return( FALSE );
   }
   (*prot)->udf[0]  = 1;   /* shader name */
   (*prot)->udf[1]  = 2;   /* active */
   (*prot)->udf[2]  = 3;   /* internal */
   (*prot)->udf[3]  = 4;   /* order */
   (*prot)->udf[4]  = 0;   /* end of shader definition */
   return( TRUE );
}


DK_Boolean DK_prototypeWrite( FILE *file, DK_FileProt *prot )
{
   short   end;
   short   tok;

   DK_String_fwrite( "PROT", 4, 1, file );
   if( prot->nbModel )
   {
      tok = 5;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbModel, 2, 1, file );
      DK_byteswap_fwrite( prot->model, 2, prot->nbModel, file );
   }
   if( prot->nbSpline )
   {
      tok = 3;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbSpline, 2, 1, file );
      DK_byteswap_fwrite( prot->spline, 2, prot->nbSpline, file );
   }
   if( prot->nbSplKey )
   {
      tok = 18;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbSplKey, 2, 1, file );
      DK_byteswap_fwrite( prot->splKey, 2, prot->nbSplKey, file );
   }
   if( prot->nbPatch )
   {
      tok = 6;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbPatch, 2, 1, file );
      DK_byteswap_fwrite( prot->patch, 2, prot->nbPatch, file );
   }
   if( prot->nbFace )
   {
      tok = 7;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbFace, 2, 1, file );
      DK_byteswap_fwrite( prot->face, 2, prot->nbFace, file );
   }
   if( prot->nbMesh )
   {
      tok = 8;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMesh, 2, 1, file );
      DK_byteswap_fwrite( prot->mesh, 2, prot->nbMesh, file );
   }
   if( prot->nbVertex )
   {
      tok = 12;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbVertex, 2, 1, file );
      DK_byteswap_fwrite( prot->vertex, 2, prot->nbVertex, file );
   }
   if( prot->nbPolygon )
   {
      tok = 10;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbPolygon, 2, 1, file );
      DK_byteswap_fwrite( prot->polygon, 2, prot->nbPolygon, file );
   }
   if( prot->nbPolNode )
   {
      tok = 11;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbPolNode, 2, 1, file );
      DK_byteswap_fwrite( prot->polNode, 2, prot->nbPolNode, file );
   }
   if( prot->nbEdge )
   {
      tok = 9;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbEdge, 2, 1, file );
      DK_byteswap_fwrite( prot->edge, 2, prot->nbEdge, file );
   }
   if( prot->nbMaterial )
   {
      tok = 13;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMaterial, 2, 1, file );
      DK_byteswap_fwrite( prot->material, 2, prot->nbMaterial, file );
   }
   if( prot->nbTexture )
   {
      tok = 14;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbTexture, 2, 1, file );
      DK_byteswap_fwrite( prot->texture, 2, prot->nbTexture, file );
   }
   if( prot->nbTexture3D )
   {
      tok = 15;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbTexture3D, 2, 1, file );
      DK_byteswap_fwrite( prot->texture3D, 2, prot->nbTexture3D, file );
   }
   if( prot->nbPhysical )
   {
      tok = 19;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbPhysical, 2, 1, file );
      DK_byteswap_fwrite( prot->physical, 2, prot->nbPhysical, file );
   }
   if( prot->nbJoint )
   {
      tok = 20;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbJoint, 2, 1, file );
      DK_byteswap_fwrite( prot->joint, 2, prot->nbJoint, file );
   }
   if( prot->nbEnvelopeData )
   {
      tok = 21;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbEnvelopeData, 2, 1, file );
      DK_byteswap_fwrite( prot->envelopeData, 2, prot->nbEnvelopeData, file );
   }
   if( prot->nbEnvelopeVertex )
   {
      tok = 22;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbEnvelopeVertex, 2, 1, file );
      DK_byteswap_fwrite( prot->envelopeVertex, 2, prot->nbEnvelopeVertex, file );
   }
   if( prot->nbCluster )
   {
      tok = 23;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbCluster, 2, 1, file );
      DK_byteswap_fwrite( prot->cluster, 2, prot->nbCluster, file );
   }
   if( prot->nbBezier )
   {
      tok = 16;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbBezier, 2, 1, file );
      DK_byteswap_fwrite( prot->bezier, 2, prot->nbBezier, file );
   }
   if( prot->nbBezKey )
   {
      tok = 17;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbBezKey, 2, 1, file );
      DK_byteswap_fwrite( prot->bezKey, 2, prot->nbBezKey, file );
   }
   if( prot->nbMetaball )
   {
      tok = 24;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMetaball, 2, 1, file );
      DK_byteswap_fwrite( prot->metaball, 2, prot->nbMetaball, file );
   }
   if( prot->nbMetaSystem )
   {
      tok = 25;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMetaSystem, 2, 1, file );
      DK_byteswap_fwrite( prot->metaSystem, 2, prot->nbMetaSystem, file );
   }
   if( prot->nbMetaGroup )
   {
      tok = 26;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMetaGroup, 2, 1, file );
      DK_byteswap_fwrite( prot->metaGroup, 2, prot->nbMetaGroup, file );
   }
   if( prot->nbMetaUnblend )
   {
      tok = 27;
      DK_byteswap_fwrite( &tok, 2, 1, file );
      DK_byteswap_fwrite( &prot->nbMetaUnblend, 2, 1, file );
      DK_byteswap_fwrite( prot->metaUnblend, 2, prot->nbMetaUnblend, file );
   }
   if ( prot->nbUdf)
   {
      tok = 28;
      DK_byteswap_fwrite(  &tok, 2, 1, file);
      DK_byteswap_fwrite( &prot->nbUdf, 2, 1, file );
      DK_byteswap_fwrite( prot->udf, 2, prot->nbUdf, file );

   }   
   if ( prot->nbNurbsCrv)
   {
      tok = 29;
      DK_byteswap_fwrite(  &tok, 2, 1, file);
      DK_byteswap_fwrite( &prot->nbNurbsCrv, 2, 1, file );
      DK_byteswap_fwrite( prot->nurbsCrv, 2, prot->nbNurbsCrv, file );
   }
   if ( prot->nbNurbsSrf)
   {
      tok = 30;
      DK_byteswap_fwrite(  &tok, 2, 1, file);
      DK_byteswap_fwrite( &prot->nbNurbsSrf, 2, 1, file );
      DK_byteswap_fwrite( prot->nurbsSrf, 2, prot->nbNurbsSrf, file );
   }
   if ( prot->nbNurbsCompCrv)
   {
      tok = 31;
      DK_byteswap_fwrite(  &tok, 2, 1, file);
      DK_byteswap_fwrite( &prot->nbNurbsCompCrv, 2, 1, file );
      DK_byteswap_fwrite( prot->nurbsCompCrv, 2, prot->nbNurbsCompCrv, file );

   }
   

   end = 0;
   DK_byteswap_fwrite( &end, 2, 1, file );
   return( TRUE );
}

DK_FileProt *DK_prototypeRead(  FILE *file )
{
   DK_FileProt   *prot;
   short       tok, nb, *ptr;
   int         i;

   if( prot = DK_prototypeAllocate() )
   {
      DK_byteswap_fread( &tok, 2, 1, file );
      while( tok )
      {
         DK_byteswap_fread( &nb, 2, 1, file );
         switch( tok )
         {
            case 3:  /* spline */
               ptr = prot->spline = (short *) calloc( nb, sizeof( short ) );
               prot->nbSpline = nb;
               break;
            case 5:  /* model */
               ptr = prot->model = (short *) calloc( nb, sizeof( short ) );
               prot->nbModel = nb;
               break;
            case 6:  /* patch */
               ptr = prot->patch = (short *) calloc( nb, sizeof( short ) );
               prot->nbPatch = nb;
               break;
            case 7:  /* face */
               ptr = prot->face = (short *) calloc( nb, sizeof( short ) );
               prot->nbFace = nb;
               break;
            case 8:  /* mesh */
               ptr = prot->mesh = (short *) calloc( nb, sizeof( short ) );
               prot->nbMesh = nb;
               break;
            case 9:  /* edge */
               ptr = prot->edge = (short *) calloc( nb, sizeof( short ) );
               prot->nbEdge = nb;
               break;
            case 10:  /* polygon */
               ptr = prot->polygon = (short *) calloc( nb, sizeof( short ) );
               prot->nbPolygon = nb;
               break;
            case 11:  /* node */
               ptr = prot->polNode = (short *) calloc( nb, sizeof( short ) );
               prot->nbPolNode = nb;
               break;
            case 12:  /* vertex */
               ptr = prot->vertex = (short *) calloc( nb, sizeof( short ) );
               prot->nbVertex = nb;
               break;
            case 13:  /* material */
               ptr = prot->material = (short *) calloc( nb, sizeof( short ) );
               prot->nbMaterial = nb;
               break;
            case 14:  /* texture */
               ptr = prot->texture = (short *) calloc( nb, sizeof( short ) );
               prot->nbTexture = nb;
               break;
            case 15:  /* texture 3D */
               ptr = prot->texture3D = (short *) calloc( nb, sizeof( short ) );
               prot->nbTexture3D = nb;
               break;
            case 16:  /* bezier */
               ptr = prot->bezier = (short *) calloc( nb, sizeof( short ) );
               prot->nbBezier = nb;
               break;
            case 17:  /* bezier key */
               ptr = prot->bezKey = (short *) calloc( nb, sizeof( short ) );
               prot->nbBezKey = nb;
               break;
            case 18:  /* spline key */
               ptr = prot->splKey = (short *) calloc( nb, sizeof( short ) );
               prot->nbSplKey = nb;
               break;
            case 19:  /* physical properties */
               ptr = prot->physical = (short *) calloc( nb, sizeof( short ) );
               prot->nbPhysical = nb;
               break;
            case 20:  /* joint dynamic properties */
               ptr = prot->joint = (short *) calloc( nb, sizeof( short ) );
               prot->nbJoint = nb;
               break;
            case 21:  /* envelope data */
               ptr = prot->envelopeData = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbEnvelopeData = nb;
               break;
            case 22:  /* envelope vertices data */
               ptr = prot->envelopeVertex = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbEnvelopeVertex = nb;
               break;
            case 23:  /* cluster data */
               ptr = prot->cluster = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbCluster = nb;
               break;
            case 24:  /* metaball */
               ptr = prot->metaball  =
			(short *) calloc( nb, sizeof( short ) );
               prot->nbMetaball = nb;
               break;
            case 25:  /* metaSystem */
               ptr = prot->metaSystem = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbMetaSystem = nb;
               break;
            case 26:  /* metaGroup */
               ptr = prot->metaGroup = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbMetaGroup = nb;
               break;
            case 27:  /* metaUnblend */
               ptr = prot->metaUnblend = 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbMetaUnblend = nb;
               break;
            case 28:  /* User Define Function */
               ptr = prot->udf= (short *) calloc( nb, sizeof( short ) );
               prot->nbUdf = nb;
               break;
            case 29:  /* Nurbs curve */
               ptr = prot->nurbsCrv= 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbNurbsCrv = nb;
               break;
            case 30:  /* Nurbs surface */
               ptr = prot->nurbsSrf= 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbNurbsSrf = nb;
               break;
            case 31:  /* Nurbs composite curve*/
               ptr = prot->nurbsCompCrv= 
			(short *) calloc( nb, sizeof( short ) );
               prot->nbNurbsCompCrv = nb;
               break;
            default:
	       if ( DK_option.verbose == TRUE)
                   fprintf( DK_option.msgFd, "Error: %s %d): illegal token: %hd\n",
                                                      __FILE__, __LINE__, tok );
               break;
         } 
         for( i = 0; i < nb; i++, ptr++ )
            DK_byteswap_fread( ptr, 2, 1, file );
         DK_byteswap_fread( &tok, 2, 1, file );
      }
   }
   return( prot );
}

DK_FileProt *DK_prototypeAllocate( void )
{
   DK_FileProt   *prot;

   if( prot = (DK_FileProt *) calloc( 1, sizeof( DK_FileProt ) ) )
   {
      prot->nbModel	= 0;
      prot->nbFace	= 0;
      prot->nbPatch	= 0;
      prot->nbMesh	= 0;
      prot->nbPolygon	= 0;
      prot->nbPolNode	= 0;
      prot->nbEdge	= 0;
      prot->nbVertex	= 0;
      prot->nbSpline	= 0;
      prot->nbSplKey	= 0;
      prot->nbBezier	= 0;
      prot->nbBezKey	= 0;
      prot->nbMaterial	= 0;
      prot->nbTexture	= 0;
      prot->nbTexture3D	= 0;
      prot->nbPhysical	= 0;
      prot->nbJoint	= 0;
      prot->nbEnvelopeData= 0;
      prot->nbEnvelopeVertex= 0;
      prot->nbCluster	= 0;
      prot->nbMetaball    = 0;
      prot->nbMetaSystem  = 0;
      prot->nbMetaGroup   = 0;
      prot->nbMetaUnblend = 0;
      prot->nbNurbsCrv	= 0;
      prot->nbNurbsSrf = 0;
      prot->nbNurbsCompCrv = 0;
      prot->nbUdf 	= 0;

      prot->model	= NULL;
      prot->face	= NULL;
      prot->patch	= NULL;
      prot->mesh	= NULL;
      prot->polygon	= NULL;
      prot->polNode	= NULL;
      prot->edge	= NULL;
      prot->vertex	= NULL;
      prot->spline	= NULL;
      prot->splKey	= NULL;
      prot->bezier	= NULL;
      prot->bezKey	= NULL;
      prot->material	= NULL;
      prot->texture	= NULL;
      prot->texture3D	= NULL;
      prot->physical	= NULL;
      prot->joint	= NULL;
      prot->envelopeData= NULL;
      prot->envelopeVertex= NULL;
      prot->cluster	= NULL;
      prot->metaball    = NULL;
      prot->metaSystem  = NULL;
      prot->metaGroup   = NULL;
      prot->metaUnblend = NULL;
      prot->nurbsCrv 	= NULL;
      prot->nurbsSrf	= NULL;
      prot->nurbsCompCrv= NULL;
      prot->udf		= NULL;

   }
   return( prot );
}

void DK_prototypeDispose( DK_FileProt **prot )
{
   if( *prot != NULL )
   {
      if( (*prot)->model != NULL )
         free( (*prot)->model );
      if( (*prot)->face != NULL )
         free( (*prot)->face );
      if( (*prot)->patch != NULL )
         free( (*prot)->patch );
      if( (*prot)->mesh != NULL )
         free( (*prot)->mesh );
      if( (*prot)->polygon != NULL )
         free( (*prot)->polygon );
      if( (*prot)->polNode != NULL )
         free( (*prot)->polNode );
      if( (*prot)->edge != NULL )
         free( (*prot)->edge );
      if( (*prot)->vertex != NULL )
         free( (*prot)->vertex );
      if( (*prot)->spline != NULL )
         free( (*prot)->spline );
      if( (*prot)->splKey != NULL )
         free( (*prot)->splKey );
      if( (*prot)->bezier != NULL )
         free( (*prot)->bezier );
      if( (*prot)->bezKey != NULL )
         free( (*prot)->bezKey );
      if( (*prot)->material != NULL )
         free( (*prot)->material );
      if( (*prot)->texture != NULL )
         free( (*prot)->texture );
      if( (*prot)->texture3D != NULL )
         free( (*prot)->texture3D );
      if( (*prot)->physical != NULL )
         free( (*prot)->physical );
      if( (*prot)->joint != NULL )
         free( (*prot)->joint );
      if( (*prot)->envelopeData != NULL )
         free( (*prot)->envelopeData );
      if( (*prot)->envelopeVertex != NULL )
         free( (*prot)->envelopeVertex );
      if( (*prot)->cluster != NULL )
         free( (*prot)->cluster );
      if( (*prot)->metaball != NULL )
         free( (*prot)->metaball );
      if( (*prot)->metaSystem != NULL )
         free( (*prot)->metaSystem );
      if( (*prot)->metaGroup != NULL )
         free( (*prot)->metaGroup );
      if( (*prot)->metaUnblend != NULL )
         free( (*prot)->metaUnblend );
      if( (*prot)->nurbsCrv!= NULL )
         free( (*prot)->nurbsCrv);
      if( (*prot)->nurbsSrf!= NULL )
         free( (*prot)->nurbsSrf);
      if( (*prot)->nurbsCompCrv!= NULL )
         free( (*prot)->nurbsCompCrv);
      if( (*prot)->udf != NULL )
         free( (*prot)->udf );

      free( *prot );
      *prot = NULL;
   }
}

DK_Boolean DK_headerWriteAscii(  FILE *file, DK_String ID )
{
   fprintf( file, "%s: ", ID );
   fprintf( file, "%s v%3.2f\n", DK_ASCII_FILE_HEADER, DK_VERSION_NAME[DK_VERSION] );
   fprintf( file, "\n" );

   return( TRUE );
}

/* This function must be used with version 2.6 and over */
DK_Boolean DK_newheaderWriteBinary
   (  
      FILE *file, 
      long magic_nb,	/* as defined in tinyFile.h */ 
      DK_String comment
   )
{
   DK_BinaryHeader   header;

   header.ID = magic_nb;
   header.version = DK_VERSION_NAME[DK_VERSION];
   if( comment != NULL )
      strncpy( header.comment, (const char *) comment, 80 );
   else
      strncpy( header.comment, "No comment...", 80 );
   DK_BinaryHeader_fwrite( &header, sizeof( DK_BinaryHeader ), 1, file );

   return( TRUE );
}

/* This function must be used up to version  2.5 */
DK_Boolean DK_headerWriteBinary(  FILE *file, DK_String comment )
{
   DK_BinaryHeader   header;

   header.ID = DK_BINARY_MAGIC_NUMBER;
   header.version = DK_VERSION_NAME[DK_VERSION];
   if( comment != NULL )
      strncpy( header.comment, (const char *) comment, 80 );
   else
      strncpy( header.comment, "No comment...", 80 );
   DK_BinaryHeader_fwrite( &header, sizeof( DK_BinaryHeader ), 1, file );

   return( TRUE );
}

DK_Boolean DK_stringWriteBinary(  FILE *file, DK_String str )
{
   if( str == NULL )
   {
      fputc( '\0', file );
      return( FALSE );
   }

   for( ; (*str) != NULL ; str++ )
      fputc( *str, file );
   fputc( *str, file );

   return( TRUE );
}


long DK_headerReadAscii(  FILE *file, float *vers )
{
   long		 ID;
   char		str[ 200 ];
   char		*pVer;
   char		*pComment;

   DK_byteswap_fread( &ID, 4, 1, file );
   pComment = fgets( str, 80, file );
   *vers = 0.0;
   if ( pComment != NULL )
      {
      pVer = strrchr( str, 'v' );
      if ( pVer != NULL )
         *vers = atof( pVer );
      }
   SI_versionInput = *vers;
   return( ID );
}

long DK_headerReadBinary(  FILE *file, float *vers, DK_String comment )
{
   DK_BinaryHeader	 header;
   long		 ID;

   DK_BinaryHeader_fread( &header, sizeof( DK_BinaryHeader ), 1, file );
   if( header.ID < DK_MAGIC_START_SI_BIN || header.ID > DK_MAGIC_END_SI_BIN )
      return( 0L );
   if( vers != NULL )
      *vers = header.version;
   SI_versionInput = header.version;

   /* STOP if version is later than DKit release version */
   if (header.version > DK_RELEASE_NUMBER)
   {
      if ( DK_option.verbose == TRUE)
      {
         fprintf( DK_option.msgFd,"Warning, file version %g is later than \
DKit release version %g\n",header.version, DK_RELEASE_NUMBER);
         fprintf(  DK_option.msgFd, "Attempt to read: An error may occur...\n" );
      }
   }

   if( comment != NULL )
      strncpy( comment, header.comment, 80 );
   DK_byteswap_fread( &ID, 4, 1, file );
   return( ID );
}


DK_String DK_stringReadBinary(  FILE *file )
{
   char   buf[256];
   int    nb, car;

   nb = 0;
   while( ((car = fgetc( file )) != EOF) && (car != 0) )
      buf[ nb++ ] = (char) car;
   buf[ nb++ ] = 0;
   return( strdup( buf ) );
}

DK_String DK_stringReadAscii(  FILE *file )
{
   int		i = 0, car;
   char		buf[ 255 ];

   /* skip characters before starting quote */
   while( ((car = fgetc( file )) != EOF) && (car != 34) )
      ;
   if( car == EOF )
      return( NULL );

   while( ((car = fgetc( file )) != EOF) && (car != 34) )
      buf[ i++ ] = (char) car;
   buf[ i ] = 0;

   return( strdup( buf ) );
}


void DK_userDataWriteAscii(  FILE *file, DK_UserNode *node, DK_String sspace )
{
   int	i, nb;

   fprintf( file, "\n%suserData \"%c%c%c%c\"\n", sspace, node->type[0],
			 node->type[1], node->type[2], node->type[3] );

   fprintf( file, "%ssize %d\n", sspace, node->size );
   fprintf( file, "%s{\n", sspace );

   for( i = nb = 0; i < node->size; i++ )
   {
      if( nb == 0 )
         fprintf( file, "\t" );
      if( node->data[i] < 16 )
         fprintf( file, "0"  );
      fprintf( file, "%1x ", node->data[i] );
      nb++;
      if( nb == 24 )
      {
         fprintf( file, "\n" );
         nb = 0;
      }
   }

   if( nb != 0 )
      fprintf( file, "\n" );

   fprintf( file, "%s}\n", sspace );
}

DK_UserNode *DK_userDataReadAscii(  FILE *file )
{
   int	     i, nb;
   DK_UserNode  *node;
   DK_String    type;
   char      str[ 80 ];

   node = _DK_CALLOC( DK_UserNode, 1, -1 );

   type = DK_stringReadAscii( file );
   strncpy ( node->type, type, 4 );
   _DK_FREE( type, -1 );
   
   do
   {
      fscanf( file, "%s", str );

      if( strcmp( "size", str ) == 0 )
      {
         fscanf( file, "%d", &node->size );
         node->data = _DK_MALLOC( char, node->size, -1 );
      }
      else if( strcmp( "{", str ) == 0 )
      {
         for( i = 0; i < node->size; i++ )
         {
            fscanf( file, "%x", &nb );
            node->data[i] = nb;
         }
      }
   } while( strcmp( "}", str ) != 0 );

   return( node );
}


/*******************************************************************************

   $$L DK_fileSkipField

   Skip in a binary file the contents associate with an unknown token

   Note : To be able to do so, the new token (post v2.67) & data should
	  follow a convention:

	  let take a token <0xhhll>:

	  - if high byte is 0 (hh == 00), then it is an old structure,
	    and it should had been read before getting here.
	
	  - if high byt is between 1 & 254) (1 <= hh <= 254), then the
	    data has a lenght of hh bytes 

          - if high byte is 255 (hh == 255), then the 4 next bytes (a long)
            indicate the lenght of the data...

   Returned Value : TRUE is able to skip it & FALSE otherwise (hh == 0)

   History : 
      Laurent Lauzon,	September 20 1994,	Implementation

   (c) Copyright 1994, SOFTIMAGE Inc.

*******************************************************************************/
DK_Boolean DK_fileSkipField( FILE *file, short tok )
{
   char       tmpBuffer[256];
   long       len = 0xff & ((tok & 0xff00) >> 8);

   if( len > 0 && len < 255 )
   {
      DK_byteswap_fread( tmpBuffer, len, 1, file );
   }
   else if( len == 255 )
   {
      DK_byteswap_fread( &len, 4, 1, file );
      DK_byteswap_fread( tmpBuffer, len, 1, file );
   }
   else	   /* len == 0 */
   {
      return( FALSE );
   }
   return( TRUE );
}

/*******************************************************************************

   $$L DK_fileMarkPlace

   Write 0 as a size of structure (4 bytes) & returns the offset in the file),
   to allowed to rewrite the exact size after work...

   Returned Value : The offset in the file...

   History : 
      Laurent Lauzon,	September 20 1994,	Implementation

   (c) Copyright 1994, SOFTIMAGE Inc.

*******************************************************************************/
long DK_fileMarkPlace( FILE *file )
{
   long      addr, zero = 0;

   addr = ftell( file );
   DK_byteswap_fwrite( &zero, 4, 1, file );
   return( addr );
}

/*******************************************************************************

   $$L DK_fileBackWriteLength

   Computes the size of data written in file since a certain offset, and go
   back to rewrite it...

   Returned Value : TRUE if successful...

   History : 
      Laurent Lauzon,	September 20 1994,	Implementation

   (c) Copyright 1994, SOFTIMAGE Inc.

*******************************************************************************/
DK_Boolean DK_fileBackWriteLength( FILE *file, long addr )
{
   long      curr, len;

   curr = ftell( file );
   len = curr - addr - 4;
   fseek( file, addr, SEEK_SET );
   DK_byteswap_fwrite( &len, 4, 1, file );
   fseek( file, curr, SEEK_SET );

   return( TRUE );
}

