/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyConstr.c,v $
   $Revision: 1.5.14.1 $ $Date: 1995/06/09 21:59:46 $
   Checkin by: $Author: poirierm $

   <DESCRIPTION>

   File supervisor: Super-User

   (c) Copyright 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include "tinyConstr.h"


/*******************************************************************************

   $$L DK_constraintAllocate 

   This function allocates a constraint structure.

   Returned Value: DK_Constraint structure

*******************************************************************************/
DK_Constraint *DK_constraintAllocate
   (
      DK_Constraint *cns_list
   )
{
   DK_Constraint	*cns;

   if ( cns = (DK_Constraint *) calloc( 1, sizeof( DK_Constraint ) ) )
   {
      cns->reltype = 0;
      cns->cnstype = 0;
      cns->prefix = (DK_String)NULL;
      cns->name = (DK_String)NULL;
      cns->actfcv.active = FALSE;
      cns->actfcv.fcv = (DK_Fcurve *)NULL;
      cns->reldata = (DK_Pointer *)NULL;
      cns->next = (DK_Constraint *)NULL;

      if ( cns_list )
      {
	 cns->next = cns_list;
      }
   }

   return( cns );
}


/*******************************************************************************

   $$L DK_constraintDispose 

   This function disposes a constraint structure.

   Returned Value: None.

*******************************************************************************/
void DK_constraintDispose
   (
      DK_Constraint **cns_list
   )
{
   DK_Constraint        *tmp_cns, *cns = *cns_list;
   int			i;

   while( cns )
   {
      _DK_FREE( cns->prefix, -1 );
      _DK_FREE( cns->name, -1 );

      switch( cns->reltype )
      {
	 case DK_REL_EXPRESSION:
	 {
	    DK_ExpressionData	*exprData = (DK_ExpressionData *)cns->reldata;

	    for( i = 0; i < exprData->nb_of_vars; i ++ )
	    {
	       _DK_FREE( exprData->vars_array[i].var_name, -1 );
	       _DK_FREE( exprData->vars_array[i].var_expression, -1 );
	    }
	    if ( exprData->nb_of_vars > 0 )
	       _DK_FREE( exprData->vars_array, -1 );

	    _DK_FREE( exprData->expression, -1 );
	 }

	 default:
	    break;
      }

      _DK_FREE( cns->reldata, -1 );

      DK_fcurveDispose( &cns->actfcv.fcv );

      tmp_cns = cns->next;

      _DK_FREE( cns, -1 );

      cns = tmp_cns;
   }

   *cns_list = NULL;
}


