/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit/src/tinyCamera.c,v $
   $Revision: 1.13.14.1 $ $Date: 1995/06/09 21:59:47 $
   Checkin by: $Author: poirierm $

   This file contains a subset of the SOFTIMAGE's camera functions.

   Written by: Colin Hui

   (c) Copyright 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include "tinySoftType.h"
#include "tinyCamera.h"
#include "tinySceneToken.h"
#include "tinyUtils.h"

/*******************************************************************************

   $$L DK_cameraInitialize

   This function initialize a camera.

   Returned Value: TRUE or FALSE

*******************************************************************************/

void DK_cameraInitialize
    (
	DK_Camera *camera	/* camera pointer */
    )
{
   int i;

   camera->pos_constraint_name = NULL;
   camera->pos_constraint_type = 0;
   camera->int_constraint_name = NULL;
   camera->int_constraint_type = 0;
   camera->pos_path = NULL;
   camera->int_path = NULL;
   camera->pos_path_name = NULL;
   camera->int_path_name = NULL;

   camera->constr_list   = NULL;

   for (i = 0; i < DK_FCV_CAM_NUM; i++)
   {
      camera->fcv[i] = NULL;
      camera->active_fcv[i].active = FALSE;
      camera->active_fcv[i].fcv = NULL;
   }

   camera->position.x = 0.0;
   camera->position.y = 2.0;
   camera->position.z = 20.0;

   camera->interest.x = 0.0;
   camera->interest.y = 0.0;
   camera->interest.z = 0.0;

   camera->roll = 0.0;
   camera->pitch = 0.0;
   camera->yaw = 0.0;

   camera->nearPlane = 0.1;
   camera->farPlane = 32768.0;
   camera->focalLength = 50.0;
   camera->fstop = 5.6;
   camera->focalDistance = 20.0;

   camera->fieldOfView = 0.725;
   camera->depthOfField = DK_CAM_DOF_OFF;
   camera->nearFocus = 11.817;
   camera->farFocus = 65.033;
   camera->outOfFocus = 133.95;
   camera->maxCOC = 0.00289;
   camera->enlargeNearObjects = FALSE;

   camera->wire_colour = DK_DEFAULT_WIRE_COLOUR;
   camera->line_type = DK_HIDDEN;
   camera->selected = FALSE;
   camera->hidden = FALSE;
   camera->schem_posx = 0.0;
   camera->schem_posy = 0.0;
   camera->schem_intx = 0.0;
   camera->schem_inty = 0.0;
   camera->schem_userppos = 0;
   camera->schem_userpint = 0;
}


/*******************************************************************************

   $$L DK_cameraWriteAsciiAnimation

   This function writes a camera.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_cameraWriteAsciiAnimation
    (
	 FILE *file, 	/* file io pointer */
	DK_Camera *cam	/* camera pointer */
    )
{
    if (cam == NULL)
	return(FALSE);

    DK_incIndent(1);
    /* write camera data */

    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_POS_TOKEN);
    DK_positionWriteAsciiAnimation(file, &cam->position,
	cam->fcv[DK_FCV_CAM_POS], cam->pos_path,
	cam->pos_constraint_name,
	cam->pos_constraint_type, cam->fcv[DK_FCV_CAM_EPOSX], 
	cam->fcv[DK_FCV_CAM_EPOSY], cam->fcv[DK_FCV_CAM_EPOSZ],
	cam->pos_path_name);

    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_INT_TOKEN);
    DK_positionWriteAsciiAnimation(file, &cam->interest, 
	cam->fcv[DK_FCV_CAM_INT], cam->int_path,
	cam->int_constraint_name,
	cam->int_constraint_type, cam->fcv[DK_FCV_CAM_EINTX], 
	cam->fcv[DK_FCV_CAM_EINTY], cam->fcv[DK_FCV_CAM_EINTZ],
	cam->int_path_name);

    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_ROLL_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->roll, cam->fcv[DK_FCV_CAM_ROLL]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_YAW_TOKEN);
    DK_value3WriteAsciiAnimation(file, cam->yaw, cam->pitch, cam->roll,
	NULL, NULL, NULL);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_NEAR_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->nearPlane, cam->fcv[DK_FCV_CAM_NEAR]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FAR_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->farPlane, cam->fcv[DK_FCV_CAM_FAR]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FLEN_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->focalLength, cam->fcv[DK_FCV_CAM_FFCL]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FSTOP_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->fstop, cam->fcv[DK_FCV_CAM_FSTP]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FDIST_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->focalDistance, cam->fcv[DK_FCV_CAM_FDST]);

    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FOV_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->fieldOfView, cam->fcv[DK_FCV_CAM_FOV]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_DOF_TOKEN);
    switch (cam->depthOfField)
    {
	case DK_CAM_DOF_OFF:
	    _DK_OUT_TOKEN(DK_A_CAMERA_DOF_OFF_TOKEN);
	    break;
	case DK_CAM_DOF_AUTOMATIC:
	    _DK_OUT_TOKEN(DK_A_CAMERA_DOF_AUTOMATIC_TOKEN);
	    break;
	case DK_CAM_DOF_CUSTOM:
	    _DK_OUT_TOKEN(DK_A_CAMERA_DOF_CUSTOM_TOKEN);
	    break;
    }
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_NFOCUS_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->nearFocus, cam->fcv[DK_FCV_CAM_FNFC]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FFOCUS_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->farFocus, cam->fcv[DK_FCV_CAM_FFFC]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_FOFOCUS_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->outOfFocus, cam->fcv[DK_FCV_CAM_FOUT]);
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_COC_TOKEN);
    DK_valueWriteAsciiAnimation(file, cam->maxCOC, cam->fcv[DK_FCV_CAM_FCOC]);
    
    /* the 0.0 value is a dummy value */
    if (cam->fcv[DK_FCV_CAM_HIDDEN] != NULL)
    {
        _DK_OUT_INDENT();
        _DK_OUT_TOKEN( DK_A_CAMERA_HIDDEN_TOKEN);
        DK_valueWriteAsciiAnimation(file, 0.0, cam->fcv[DK_FCV_CAM_HIDDEN]);
    }
    
    _DK_OUT_INDENT();
    _DK_OUT_TOKEN( DK_A_CAMERA_ENL_TOKEN);
    if (cam->enlargeNearObjects)
	_DK_OUT_TOKEN(DK_A_ACTIVE_TOKEN);
    else
	_DK_OUT_TOKEN(DK_A_INACTIVE_TOKEN);

    DK_incIndent(-1);

    return(TRUE);
}

/*******************************************************************************

   $$L DK_cameraReadAsciiAnimation

   This function reads a camera.

   Returned Value: TRUE or FALSE

*******************************************************************************/

int DK_cameraReadAsciiAnimation
    (
	 FILE *file, 	/* file io pointer */
	DK_Camera *cam	/* camera pointer */
    )
{
    int first = TRUE;

    while (TRUE)
    {
        if (strcmp( DK_A_CAMERA_TYPE_TOKEN, DK_animToken) == 0)
	{
	    DK_in_animSValue_na(file);
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	}
        else if (strcmp( DK_A_CAMERA_STEREO_TOKEN, DK_animToken) == 0)
	{
	    DK_in_animSValue_na(file);
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	}
        else if (strcmp( DK_A_CAMERA_POS_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	    {
	        DK_positionReadAsciiAnimation(file, &cam->position,
		    &cam->fcv[DK_FCV_CAM_POS], &cam->pos_path, 
		    &cam->pos_constraint_name, 
		    &cam->pos_constraint_type, 
		    &cam->fcv[DK_FCV_CAM_EPOSX], &cam->fcv[DK_FCV_CAM_EPOSY],
		    &cam->fcv[DK_FCV_CAM_EPOSZ],
		    &cam->pos_path_name);
	    }
	    else
	        DK_positionReadAsciiAnimation(file, NULL, NULL, NULL, NULL, NULL,
		    NULL, NULL, NULL, NULL);
	}
        else if (strcmp( DK_A_CAMERA_INT_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_positionReadAsciiAnimation(file, &cam->interest, 
		    &cam->fcv[DK_FCV_CAM_INT], &cam->int_path, 
		    &cam->int_constraint_name, 
		    &cam->int_constraint_type, 
		    &cam->fcv[DK_FCV_CAM_EINTX], &cam->fcv[DK_FCV_CAM_EINTY],
		    &cam->fcv[DK_FCV_CAM_EINTZ],
		    &cam->int_path_name);
	    else
	        DK_positionReadAsciiAnimation(file, NULL, NULL, NULL, NULL, NULL,
		    NULL, NULL, NULL, NULL);
	}
        else if (strcmp( DK_A_CAMERA_ROLL_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->roll, &cam->fcv[DK_FCV_CAM_ROLL], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_YAW_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_value3ReadAsciiAnimation(file, &cam->yaw, &cam->pitch, &cam->roll,
		    NULL, NULL, NULL);
	    else
	        DK_value3ReadAsciiAnimation(file, NULL, NULL, NULL, NULL, NULL, NULL);
	}
        else if (strcmp( DK_A_CAMERA_NEAR_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->nearPlane, &cam->fcv[DK_FCV_CAM_NEAR],
			TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FAR_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->farPlane, &cam->fcv[DK_FCV_CAM_FAR],
			TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FLEN_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->focalLength, 
			&cam->fcv[DK_FCV_CAM_FFCL], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FSTOP_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->fstop, 
			&cam->fcv[DK_FCV_CAM_FSTP], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FDIST_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->focalDistance, 
			&cam->fcv[DK_FCV_CAM_FDST], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FOV_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->fieldOfView, 
			&cam->fcv[DK_FCV_CAM_FOV], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_DOF_TOKEN, DK_animToken) == 0)
	{
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	    if (cam != NULL)
	    {
		if (strcmp(DK_A_CAMERA_DOF_OFF_TOKEN, DK_animToken) == 0)
	            cam->depthOfField = DK_CAM_DOF_OFF;
		else if (strcmp(DK_A_CAMERA_DOF_AUTOMATIC_TOKEN, DK_animToken) == 0)
	            cam->depthOfField = DK_CAM_DOF_AUTOMATIC;
		else if (strcmp(DK_A_CAMERA_DOF_CUSTOM_TOKEN, DK_animToken) == 0)
	            cam->depthOfField = DK_CAM_DOF_CUSTOM;
	        else if ( DK_option.verbose == TRUE)
	            fprintf( DK_option.msgFd, "DK_CameraReadAsciiAnimation: \
error, unknown depth of field DK_animToken '%s'.\n",DK_animToken);
	    }
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	}
        else if (strcmp( DK_A_CAMERA_NFOCUS_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->nearFocus,
			&cam->fcv[DK_FCV_CAM_FNFC], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FFOCUS_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->farFocus,
			&cam->fcv[DK_FCV_CAM_FFFC], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_FOFOCUS_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->outOfFocus, 
			&cam->fcv[DK_FCV_CAM_FOUT], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_COC_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, &cam->maxCOC, 
			&cam->fcv[DK_FCV_CAM_FCOC], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_HIDDEN_TOKEN, DK_animToken) == 0)
	{
	    if (cam != NULL)
	        DK_valueReadAsciiAnimation(file, NULL, &cam->fcv[DK_FCV_CAM_HIDDEN], TRUE);
	    else
	        DK_valueReadAsciiAnimation(file, NULL, NULL, TRUE);
	}
        else if (strcmp( DK_A_CAMERA_ENL_TOKEN, DK_animToken) == 0)
	{
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	    if (cam != NULL)
	    {
	        if (strcmp(DK_A_ACTIVE_TOKEN, DK_animToken) == 0)
	            cam->enlargeNearObjects = TRUE;
	        else if (strcmp(DK_A_INACTIVE_TOKEN, DK_animToken) == 0)
	            cam->enlargeNearObjects = FALSE;
	        else if ( DK_option.verbose == TRUE)
	            fprintf( DK_option.msgFd, "DK_CameraReadAsciiAnimation: \
error, unknown enlarge active DK_animToken '%s'.\n",DK_animToken);
	    }
	    if (DK_in_animToken(file) == FALSE)
		return(FALSE);
	}
	else
	{
	    if (first)
		DK_in_animToken(file);

	    return(TRUE);
	}
	first = FALSE;
    }
}
