/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/DKit_h/tinySceneToken.h,v $
   $Revision: 1.15 $ $Date: 1994/07/04 22:58:46 $
   Checkin by: $Author: d_eu $

   This file contains all the tokens for binary and ascii scene files.

   File supervisor: Colin Hui

   (c) Copyright 1991, 1992 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#ifndef __TINY_SCENETOKEN_H__
#define __TINY_SCENETOKEN_H__

/* ================= binary =================== */

#define  DK_B_END_TOKEN          0
#define  DK_B_STATIC_VALUE_TOKEN 1
#define  DK_B_FCV_TOKEN          2

#define  DK_B_OBJ_PATH_TOKEN 1
#define  DK_B_TEX_PATH_TOKEN 2
#define  DK_B_PIC_PATH_TOKEN 3
#define  DK_B_MAT_LIB_TOKEN  4
#define  DK_B_TEX_LIB_TOKEN  5
#define  DK_B_PAL_LIB_TOKEN  6

#define  DK_B_SCENE_SFRAME_TOKEN          1
#define  DK_B_SCENE_EFRAME_TOKEN          2
#define  DK_B_SCENE_CFRAME_TOKEN          3
#define  DK_B_SCENE_FSTEP_TOKEN           4
#define  DK_B_SCENE_PAUSE_TOKEN           5
#define  DK_B_SCENE_RATE_TOKEN            6
#define  DK_B_SCENE_OPATH_TOKEN           7
#define  DK_B_SCENE_MPATH_TOKEN           8
#define  DK_B_SCENE_CAMERA_TOKEN          9
#define  DK_B_SCENE_LIGHT_TOKEN           10
#define  DK_B_SCENE_HIER_TOKEN            11
#define  DK_B_SCENE_SELECT_TOKEN          12
#define  DK_B_SCENE_LAYOUT_TOKEN          13
#define  DK_B_SCENE_SPLINE_TOKEN          14
#define  DK_B_SCENE_CAMERA_VISIBLE_TOKEN  15
#define  DK_B_SCENE_PATH_TOKEN            16
#define  DK_B_SCENE_WAVE_TOKEN            17
#define  DK_B_SCENE_CLASSIC_SCALING_TOKEN 18

#define  DK_B_WAVE_FILE_TOKEN 1
#define  DK_B_WAVE_NODE_TOKEN 2

#define  DK_B_WAVE_NODE_NAME_TOKEN      1
#define  DK_B_WAVE_NODE_SCALE_TOKEN     2
#define  DK_B_WAVE_NODE_ROTATE_TOKEN    3
#define  DK_B_WAVE_NODE_TRANSLATE_TOKEN 4
#define  DK_B_WAVE_NODE_DECAY_TOKEN     5
#define  DK_B_WAVE_NODE_SPREAD_TOKEN    6
#define  DK_B_WAVE_NODE_MODEL_TOKEN     7

#define  DK_B_LIGHT_NAME_TOKEN               1
#define  DK_B_LIGHT_TYPE_TOKEN               2
#define  DK_B_LIGHT_COLOUR_TOKEN             3
#define  DK_B_LIGHT_FSTART_TOKEN             4
#define  DK_B_LIGHT_FEND_TOKEN               5
#define  DK_B_LIGHT_SFACT_TOKEN              6
#define  DK_B_LIGHT_POS_TOKEN                7
#define  DK_B_LIGHT_INT_TOKEN                8
#define  DK_B_LIGHT_CONE_TOKEN               9
#define  DK_B_LIGHT_SPRD_TOKEN               10
#define  DK_B_LIGHT_DECAY_TOKEN              11 /* not in use */
#define  DK_B_LIGHT_WIRE_COLOUR_TOKEN        12
#define  DK_B_LIGHT_LINE_TYPE_TOKEN          13
#define  DK_B_LIGHT_SELECTED_TOKEN           14
#define  DK_B_LIGHT_ANIM_TYPE_TOKEN          15 /* not in use */
#define  DK_B_LIGHT_HIDDEN_TOKEN             15
#define  DK_B_LIGHT_SHADOW_TYPE_TOKEN        16
#define  DK_B_LIGHT_SHADOW_MAP_RES_TOKEN     17
#define  DK_B_LIGHT_SHADOW_FILTER_SIZE_TOKEN 18
#define  DK_B_LIGHT_SHADOW_FILTER_STEP_TOKEN 19
#define  DK_B_LIGHT_SHADOW_FADE_START_TOKEN  20
#define  DK_B_LIGHT_SHADOW_FADE_RATE_TOKEN   21
#define  DK_B_LIGHT_WIRE_COLOUR_INDEX_TOKEN  22
#define  DK_B_LIGHT_AREA_BOOLEAN		23
#define  DK_B_LIGHT_AREA_TYPE			24
#define  DK_B_LIGHT_AREA_U_SAMPLE		25
#define  DK_B_LIGHT_AREA_V_SAMPLE		26
#define  DK_B_LIGHT_AREA_GEO			27
#define  DK_B_LIGHT_AREA_LOCAL_BOOLEAN		28
#define  DK_B_LIGHT_AREA_SCALE			29
#define  DK_B_LIGHT_AREA_ROTATION		30
#define  DK_B_LIGHT_AREA_ROTATION_MAT		31

#define  DK_B_CAMERA_TYPE_TOKEN      1
#define  DK_B_CAMERA_STEREO_TOKEN    2
#define  DK_B_CAMERA_POS_TOKEN       3
#define  DK_B_CAMERA_INT_TOKEN       4
#define  DK_B_CAMERA_ROLL_TOKEN      5
#define  DK_B_CAMERA_YAW_TOKEN       6
#define  DK_B_CAMERA_NEAR_TOKEN      7
#define  DK_B_CAMERA_FAR_TOKEN       8
#define  DK_B_CAMERA_FLEN_TOKEN      9
#define  DK_B_CAMERA_FSTOP_TOKEN     10
#define  DK_B_CAMERA_FDIST_TOKEN     11
#define  DK_B_CAMERA_FOV_TOKEN       12
#define  DK_B_CAMERA_DOF_TOKEN       13
#define  DK_B_CAMERA_NFOCUS_TOKEN    14
#define  DK_B_CAMERA_FFOCUS_TOKEN    15
#define  DK_B_CAMERA_FOFOCUS_TOKEN   16
#define  DK_B_CAMERA_COC_TOKEN       17
#define  DK_B_CAMERA_ENL_TOKEN       18
#define  DK_B_CAMERA_ANIM_TYPE_TOKEN 19 /* not in use */
#define  DK_B_CAMERA_HIDDEN_TOKEN    19 

#define  DK_B_FCV_KEY_TIME_TOKEN    1
#define  DK_B_FCV_KEY_VALUE_TOKEN   2
#define  DK_B_FCV_KEY_LSLOPE_TOKEN  3
#define  DK_B_FCV_KEY_RSLOPE_TOKEN  4
#define  DK_B_FCV_KEY_INTERP_TOKEN  5
#define  DK_B_FCV_KEY_SFLAG_TOKEN   6
#define  DK_B_FCV_KEY_KTYPE_TOKEN   7
#define  DK_B_FCV_KEY_SPINDEX_TOKEN 8

#define  DK_B_FCV_TYPE_TOKEN     1
#define  DK_B_FCV_NBKEYS_TOKEN   2
#define  DK_B_FCV_PRE_EXP_TOKEN  3
#define  DK_B_FCV_POST_EXP_TOKEN 4
#define  DK_B_FCV_FLAG_TOKEN     5
#define  DK_B_FCV_INTERP_TOKEN   6
#define  DK_B_FCV_KEYS_TOKEN     7

#define  DK_B_POS_STATIC_TOKEN     1
#define  DK_B_POS_FCV_TOKEN        2
#define  DK_B_POS_CONSTRAINT_TOKEN 3
#define  DK_B_POS_EXPLICIT_TOKEN   4
#define  DK_B_POS_MODEL_TOKEN      5

#define  DK_B_SPLINE_KEY_PREV_TOKEN       1
#define  DK_B_SPLINE_KEY_POS_TOKEN        2
#define  DK_B_SPLINE_KEY_NEXT_TOKEN       3
#define  DK_B_SPLINE_KEY_CONSTRAINT_TOKEN 4
#define  DK_B_SPLINE_KEY_SEGMENT_TOKEN    5
#define  DK_B_SPLINE_KEY_FLAG_TOKEN       6

#define  DK_B_SPLINE_TYPE_TOKEN              1
#define  DK_B_SPLINE_NB_TOKEN                2
#define  DK_B_SPLINE_CLOSE_TOKEN             3
#define  DK_B_SPLINE_TENSION_TOKEN           4
#define  DK_B_SPLINE_STEP_TOKEN              5
#define  DK_B_SPLINE_WIRE_COLOUR_TOKEN       6
#define  DK_B_SPLINE_LINE_TYPE_TOKEN         7
#define  DK_B_SPLINE_SELECTED_TOKEN          8
#define  DK_B_SPLINE_PHANTOM_TOKEN           9
#define  DK_B_SPLINE_KEYLIST_TOKEN           10
#define  DK_B_SPLINE_NAME_TOKEN              11
#define  DK_B_SPLINE_KEYFRAME_FLAG_TOKEN     12
#define  DK_B_SPLINE_WIRE_COLOUR_INDEX_TOKEN 13

#define  DK_B_LATTICE_ACTIVE_TOKEN  1
#define  DK_B_LATTICE_NBARRAY_TOKEN 2
#define  DK_B_LATTICE_INTERP_TOKEN  3
#define  DK_B_LATTICE_KEYS_TOKEN    4
#define  DK_B_LATTICE_FCV_TOKEN     5
#define  DK_B_LATTICE_MIN_TOKEN     6
#define  DK_B_LATTICE_MAX_TOKEN     7
#define  DK_B_LATTICE_SCL_TOKEN     8

#define  DK_B_SHAPE_FCV_TOKEN    1
#define  DK_B_SHAPE_NAME_TOKEN   2
#define  DK_B_SHAPE_WEIGHT_TOKEN 3

#define  DK_B_CLUSTER_FILENAME_TOKEN 1
#define  DK_B_CLUSTER_ACTIVE_TOKEN   2
#define  DK_B_CLUSTER_NODE_TOKEN     3

#define  DK_B_CLUSTER_NODE_NAME_TOKEN   1
#define  DK_B_CLUSTER_NODE_ACTIVE_TOKEN 2
#define  DK_B_CLUSTER_NODE_INTERP_TOKEN 3
#define  DK_B_CLUSTER_NODE_FCV_TOKEN    4
#define  DK_B_CLUSTER_NODE_WEIGHT_TOKEN 5

#define  DK_B_MAT_NAME_TOKEN    1
#define  DK_B_MAT_AMB_TOKEN     2
#define  DK_B_MAT_DIFF_TOKEN    3
#define  DK_B_MAT_SPEC_TOKEN    4
#define  DK_B_MAT_SPECE_TOKEN   5
#define  DK_B_MAT_TRANSP_TOKEN  6
#define  DK_B_MAT_TRANSPJ_TOKEN 7
#define  DK_B_MAT_REFL_TOKEN    8
#define  DK_B_MAT_REFLJ_TOKEN   9
#define  DK_B_MAT_RIND_TOKEN    10
#define  DK_B_MAT_ATTEN_TOKEN   11
#define  DK_B_MAT_NREFL_TOKEN   12
#define  DK_B_MAT_MTRANSP_TOKEN 13

#define  DK_B_TXT_NAME_TOKEN    1
#define  DK_B_TXT_USCL_TOKEN    2
#define  DK_B_TXT_VSCL_TOKEN    3
#define  DK_B_TXT_UOFF_TOKEN    4
#define  DK_B_TXT_VOFF_TOKEN    5
#define  DK_B_TXT_AMB_TOKEN     6
#define  DK_B_TXT_DIFF_TOKEN    7
#define  DK_B_TXT_SPEC_TOKEN    8
#define  DK_B_TXT_ROUGH_TOKEN   9
#define  DK_B_TXT_TRANSP_TOKEN  10
#define  DK_B_TXT_REFLM_TOKEN   11
#define  DK_B_TXT_REFR_TOKEN    12
#define  DK_B_TXT_ENV_ROT_TOKEN 13
#define  DK_B_TXT_BLEND_TOKEN   14
#define  DK_B_TXT_REFL_TOKEN    15

#define  DK_B_TXT3D_NAME_TOKEN     1
#define  DK_B_TXT3D_STDK_REN_TOKEN 2
#define  DK_B_TXT3D_SPAC_TOKEN     3
#define  DK_B_TXT3D_STRETCH_TOKEN  4 /* not in use */
#define  DK_B_TXT3D_COL0_TOKEN     5
#define  DK_B_TXT3D_COL1_TOKEN     6
#define  DK_B_TXT3D_COL2_TOKEN     7
#define  DK_B_TXT3D_FAC1_TOKEN     8
#define  DK_B_TXT3D_SCL_TOKEN      9
#define  DK_B_TXT3D_ROT_TOKEN      10
#define  DK_B_TXT3D_TRAN_TOKEN     11
#define  DK_B_TXT3D_AMB_TOKEN      12
#define  DK_B_TXT3D_DIFF_TOKEN     13
#define  DK_B_TXT3D_SPEC_TOKEN     14
#define  DK_B_TXT3D_ROUGH_TOKEN    15
#define  DK_B_TXT3D_TRANSP_TOKEN   16
#define  DK_B_TXT3D_REFL_TOKEN     17
#define  DK_B_TXT3D_RIND_TOKEN     18 /* not in use */
#define  DK_B_TXT3D_POWER_TOKEN    19
#define  DK_B_TXT3D_TAPER_TOKEN    20
#define  DK_B_TXT3D_COL3_TOKEN     21
#define  DK_B_TXT3D_COL4_TOKEN     22
#define  DK_B_TXT3D_FAC2_TOKEN     23
#define  DK_B_TXT3D_FAC3_TOKEN     24
#define  DK_B_TXT3D_BLEND_TOKEN    25
#define  DK_B_TXT3D_COL0A_TOKEN    26
#define  DK_B_TXT3D_COL1A_TOKEN    27
#define  DK_B_TXT3D_COL2A_TOKEN    28
#define  DK_B_TXT3D_COL3A_TOKEN    29
#define  DK_B_TXT3D_COL4A_TOKEN    30

#define  DK_B_REN_TYPE_TOKEN         50
#define  DK_B_REN_SFRAME_TOKEN       51
#define  DK_B_REN_EFRAME_TOKEN       52
#define  DK_B_REN_FSTEP_TOKEN        53
#define  DK_B_REN_fBUF_TOKEN         54
#define  DK_B_REN_OUTFILE_TOKEN      55
#define  DK_B_REN_XRES_TOKEN         56
#define  DK_B_REN_YRES_TOKEN         57
#define  DK_B_REN_PICFORMAT_TOKEN    58
#define  DK_B_REN_RATIO_TOKEN        59
#define  DK_B_REN_FILTER_TOKEN       60
#define  DK_B_REN_RDEPTH_TOKEN       61
#define  DK_B_REN_TLEAF_TOKEN        62
#define  DK_B_REN_TDEPTH_TOKEN       63
#define  DK_B_REN_PRESCRIPT_TOKEN    64
#define  DK_B_REN_POSTSCRIPT_TOKEN   65
#define  DK_B_REN_FADE_START_TOKEN   66
#define  DK_B_REN_FADE_END_TOKEN     67
#define  DK_B_REN_FADE_COLOUR_TOKEN  68
#define  DK_B_REN_FADE_TRANSP_TOKEN  69
#define  DK_B_REN_FADE_ACTIVE_TOKEN  70
#define  DK_B_REN_AMBIENCE_TOKEN     71
#define  DK_B_REN_BACK_CULLING_TOKEN 72
#define  DK_B_REN_TIME_STAT_TOKEN    73
#define  DK_B_REN_MEMORY_STAT_TOKEN  74
#define  DK_B_REN_TREE_STAT_TOKEN    75
#define  DK_B_REN_LINE_STAT_TOKEN    76
#define  DK_B_REN_ANTIALIAS_TOKEN    77
#define  DK_B_REN_MOTIONBLUR_TOKEN   78
#define  DK_B_REN_SHUTTERSPEED_TOKEN 79
#define  DK_B_REN_MINMOVEMENT_TOKEN  80
#define  DK_B_REN_ONFIELD_TOKEN      81
#define  DK_B_REN_FIRSTFIELD_TOKEN   82
#define  DK_B_REN_FOG_START_TOKEN   	83
#define  DK_B_REN_FOG_END_TOKEN     	84
#define  DK_B_REN_FOG_COLOUR_TOKEN  	85
#define  DK_B_REN_FOG_DENS_TOKEN  	86
#define  DK_B_REN_FOG_ACTIVE_TOKEN  	87
#define  DK_B_REN_FOG_BASE_TOKEN  	88
#define  DK_B_REN_FOG_THICK_TOKEN  	89


#define  DK_B_PIC_TYPE_TOKEN   1
#define  DK_B_PIC_ASPECT_TOKEN 2
#define  DK_B_PIC_SIZE_TOKEN   3

#define  DK_B_MDL_NAME_TOKEN              1
#define  DK_B_MDL_SCL_TOKEN               2
#define  DK_B_MDL_ROT_TOKEN               3
#define  DK_B_MDL_TRANS_TOKEN             4
#define  DK_B_MDL_NLAT_TOKEN              5
#define  DK_B_MDL_TLAT_TOKEN              6
#define  DK_B_MDL_MAT_TOKEN               7
#define  DK_B_MDL_TXT_TOKEN               8
#define  DK_B_MDL_TXT3D_TOKEN             9
#define  DK_B_MDL_SHAPE_TOKEN             10
#define  DK_B_MDL_NFIT_TOKEN              11
#define  DK_B_MDL_TFIT_TOKEN              12
#define  DK_B_MDL_PNFIT_TOKEN             13
#define  DK_B_MDL_PTFIT_TOKEN             14
#define  DK_B_MDL_WIRE_COLOUR_TOKEN       15
#define  DK_B_MDL_LINE_TYPE_TOKEN         16
#define  DK_B_MDL_SELECTED_TOKEN          17
#define  DK_B_MDL_SHAPE_INTERP_TOKEN      18
#define  DK_B_MDL_ANIM_TYPE_TOKEN         19 /* not in use */
#define  DK_B_MDL_MATERIAL_INDEX_TOKEN    19 
#define  DK_B_MDL_LTXT_TOKEN              20
#define  DK_B_MDL_LTXT3D_TOKEN            21
#define  DK_B_MDL_BBOX_TOKEN              22
#define  DK_B_MDL_DYNASETUP_TOKEN         23
#define  DK_B_MDL_DYNACONST_TOKEN         24
#define  DK_B_MDL_HID_TOKEN               25
#define  DK_B_MDL_ALGO_TOKEN              26
#define  DK_B_MDL_DYNAMATTERANIM_TOKEN    27
#define  DK_B_MDL_CLUSTER_TOKEN  	  28
#define  DK_B_MDL_COLLAPSE_TOKEN          29
#define  DK_B_MDL_SCHEMPOS_TOKEN          30
#define  DK_B_MDL_WIRE_COLOUR_INDEX_TOKEN 31


#define DK_B_DYNCONS_TYPE_TOKEN      1
#define DK_B_DYNCONS_PRIO_TOKEN      2
#define DK_B_DYNCONS_NAME_TOKEN      3
#define DK_B_DYNCONS_OBSTACLE_TOKEN  4


#define DK_B_DYNSETUP_RCPOS_TOKEN       1
#define DK_B_DYNSETUP_RCPOSAXE_TOKEN    2
#define DK_B_DYNSETUP_RCPOSACC_TOKEN    3
#define DK_B_DYNSETUP_RCORI_TOKEN       4
#define DK_B_DYNSETUP_RCORIAXE_TOKEN    5
#define DK_B_DYNSETUP_RCORIACC_TOKEN    6
#define DK_B_DYNSETUP_DOWIND_TOKEN      7
#define DK_B_DYNSETUP_DOGRAV_TOKEN      8
#define DK_B_DYNSETUP_CHKCOLL_TOKEN     9
#define DK_B_DYNSETUP_DETECTL_TOKEN     10
#define DK_B_DYNSETUP_WINDL_TOKEN       11
#define DK_B_DYNSETUP_GEOMUPD_TOKEN     12
#define DK_B_DYNSETUP_ANIM_RCPOS_TOKEN  13

#define DK_B_DYNMATTERANIM_ELAST_TOKEN  1
#define DK_B_DYNMATTERANIM_MU_S_TOKEN   2
#define DK_B_DYNMATTERANIM_MU_K_TOKEN   3
/* ..down to here */

#define  DK_B_OBJ_FILE_TOKEN                    1
#define  DK_B_OBJ_NODE_TOKEN                    2
#define  DK_B_OBJ_SUBSTITUTION_TOKEN            3
#define  DK_B_OBJ_SUBSTITUTION_PRESCRIPT_TOKEN  4
#define  DK_B_OBJ_SUBSTITUTION_POSTSCRIPT_TOKEN 5

#define  DK_B_SFIT_SCL_TOKEN     1
#define  DK_B_SFIT_ROLL_TOKEN    2
#define  DK_B_SFIT_TRN_TOKEN     3
#define  DK_B_SFIT_SPL_TOKEN     4
#define  DK_B_SFIT_MODEL_TOKEN   5
#define  DK_B_SFIT_ACTIVE_TOKEN  6

#define  DK_B_PFIT_SCL_TOKEN    1
#define  DK_B_PFIT_ROT_TOKEN    2
#define  DK_B_PFIT_TRN_TOKEN    3
#define  DK_B_PFIT_MODEL_TOKEN  4
#define  DK_B_PFIT_ACTIVE_TOKEN 5

#define  DK_B_LAYOUT_L0_FRONT_TOKEN 1
#define  DK_B_LAYOUT_L1_FRONT_TOKEN 2
#define  DK_B_LAYOUT_L0_RIGHT_TOKEN 3
#define  DK_B_LAYOUT_L1_RIGHT_TOKEN 4
#define  DK_B_LAYOUT_L0_TOP_TOKEN   5
#define  DK_B_LAYOUT_L1_TOP_TOKEN   6
#define  DK_B_LAYOUT_L0_PERSP_TOKEN 7
#define  DK_B_LAYOUT_L1_PERSP_TOKEN 8

#define  DK_B_LAYOUT_CAM_FRONT_TOKEN     1
#define  DK_B_LAYOUT_CAM_TOP_TOKEN       2
#define  DK_B_LAYOUT_CAM_RIGHT_TOKEN     3
#define  DK_B_LAYOUT_CAM_PERSP_TOKEN     4
#define  DK_B_LAYOUT_CAM_FCURVE_TOKEN    5
#define  DK_B_LAYOUT_CAM_SCHEMATIC_TOKEN 6

#define  DK_B_LAYOUT_WINDOW_TYPE_TOKEN   1 
#define  DK_B_LAYOUT_GRID_TOKEN          2 
#define  DK_B_LAYOUT_DISPLAY_TYPE_TOKEN  3 
#define  DK_B_LAYOUT_PICTURE_TOKEN       4 
#define  DK_B_LAYOUT_MIN_MAX_TOKEN       5  /* not in use */
#define  DK_B_LAYOUT_DEPTHCUE_TOKEN      6 
#define  DK_B_LAYOUT_CAMERA_TYPE_TOKEN   7
#define  DK_B_LAYOUT_CAM_POS_TOKEN       8
#define  DK_B_LAYOUT_CAM_INT_TOKEN       9
#define  DK_B_LAYOUT_CAM_FOV_TOKEN       10
#define  DK_B_LAYOUT_CAM_ASPECT_TOKEN    11
#define  DK_B_LAYOUT_CAM_NEAR_TOKEN      12

/* ================= ascii ===================*/


#define DK_A_LINEAR_SHAPE_INTERP_TOKEN   "LINEAR"
#define DK_A_CARDINAL_SHAPE_INTERP_TOKEN "CARDINAL"
#define DK_A_WEIGHT_SHAPE_INTERP_TOKEN   "WEIGHT"

#define DK_A_LINEAR_CLUSTER_INTERP_TOKEN   DK_A_LINEAR_SHAPE_INTERP_TOKEN
#define DK_A_CARDINAL_CLUSTER_INTERP_TOKEN DK_A_CARDINAL_SHAPE_INTERP_TOKEN
#define DK_A_WEIGHT_CLUSTER_INTERP_TOKEN   DK_A_WEIGHT_SHAPE_INTERP_TOKEN

#define DK_A_FILE_INFO_TOKEN "Softimage 4D Creative Environment"
#define DK_A_SCENE_ID_TOKEN  "SSCN"
#define DK_A_END_TOKEN       "END_DEF"

#define DK_A_OBJ_PATH_TOKEN "OBJECT_PATH"
#define DK_A_TEX_PATH_TOKEN "TEXTURE_PATH"
#define DK_A_PIC_PATH_TOKEN "PICTURE_PATH"
#define DK_A_MAT_LIB_TOKEN  "MATERIAL_LIB"
#define DK_A_TEX_LIB_TOKEN  "TEXTURE_LIB"
#define DK_A_PAL_LIB_TOKEN  "PALETTE_LIB"

#define DK_A_STATIC_VALUE_TOKEN 1
#define DK_A_FCV_TOKEN          2

#define DK_A_ACTIVE_TOKEN   "ACTIVE"
#define DK_A_INACTIVE_TOKEN "INACTIVE"

#define DK_A_YES_TOKEN "YES"
#define DK_A_NO_TOKEN  "NO"

#define DK_A_UNSELECTED_TOKEN       "UNSELECTED"
#define DK_A_NODE_SELECTED_TOKEN    "NODE_SELECTED"
#define DK_A_BRANCH_SELECTED_TOKEN  "BRANCH_SELECTED"
#define DK_A_INHERIT_SELECTED_TOKEN "INHERIT_SELECTED"

#define DK_A_CONSTANT_INTERP_TOKEN "CONSTANT"
#define DK_A_LINEAR_INTERP_TOKEN   "LINEAR"
#define DK_A_HERMITE_INTERP_TOKEN  "SPLINE"

#define DK_A_SCENE_FRAME_TOKEN           "FRAME"
#define DK_A_SCENE_PAUSE_TOKEN           "PAUSE"
#define DK_A_SCENE_RATE_TOKEN            "RATE"
#define DK_A_SCENE_CAMERA_TOKEN          "CAMERA"
#define DK_A_SCENE_LIGHT_TOKEN           "LIGHT"
#define DK_A_SCENE_HIER_TOKEN            "HIERARCHY"
#define DK_A_SCENE_SELECT_TOKEN          "MULTI_SELECT"
#define DK_A_SCENE_LAYOUT_TOKEN          "WINDOW_LAYOUT"
#define DK_A_SCENE_SPLINE_TOKEN          "SPLINE"
#define DK_A_SCENE_CAMERA_VISIBLE_TOKEN  "CAMERA_VISIBLE"
#define DK_A_SCENE_PATH_TOKEN            "FILE_PATH"
#define DK_A_SCENE_WAVE_TOKEN            "WAVE"
#define DK_A_SCENE_CLASSIC_SCALING_TOKEN "CLASSIC_SCALING"

#define DK_A_WAVE_FILE_TOKEN "WAVE_FILE"
#define DK_A_WAVE_NODE_TOKEN "WAVE_NAME"

#define DK_A_WAVE_NODE_NAME_TOKEN      "WAVE_NAME"
#define DK_A_WAVE_NODE_SCALE_TOKEN     "WAVE_SCALE"
#define DK_A_WAVE_NODE_ROTATE_TOKEN    "WAVE_ROTATE"
#define DK_A_WAVE_NODE_TRANSLATE_TOKEN "WAVE_TRANSLATE"
#define DK_A_WAVE_NODE_DECAY_TOKEN     "WAVE_DECAY"
#define DK_A_WAVE_NODE_SPREAD_TOKEN    "WAVE_SPREAD"
#define DK_A_WAVE_NODE_MODEL_TOKEN     "WAVE_MODEL"

#define DK_A_LIGHT_NAME_TOKEN          "LIGHT_NAME"
#define DK_A_LIGHT_TYPE_TOKEN          "LIGHT_TYPE"
#define DK_A_LIGHT_POINT_TYPE_TOKEN    "POINT"
#define DK_A_LIGHT_SPOT_TYPE_TOKEN     "SPOT"
#define DK_A_LIGHT_INFINITE_TYPE_TOKEN "INFINITE"

#define DK_A_LIGHT_COLOUR_TOKEN             "COLOUR"
#define DK_A_LIGHT_FSTART_TOKEN             "FALL_OFF_START"
#define DK_A_LIGHT_FEND_TOKEN               "FALL_OFF_END"
#define DK_A_LIGHT_SFACT_TOKEN              "SHADOW_FACTOR"
#define DK_A_LIGHT_POS_TOKEN                "POSITION"
#define DK_A_LIGHT_INT_TOKEN                "INTEREST"
#define DK_A_LIGHT_CONE_TOKEN               "CONE_ANGLE"
#define DK_A_LIGHT_SPRD_TOKEN               "SPREAD_ANGLE"
#define DK_A_LIGHT_DECAY_TOKEN              "DECAY" /* not in use */
#define DK_A_LIGHT_WIRE_COLOUR_TOKEN        "WIRE_COLOUR"
#define DK_A_LIGHT_LINE_TYPE_TOKEN          "LINE_TYPE"
#define DK_A_LIGHT_SELECTED_TOKEN           "SELECTED"
#define DK_A_LIGHT_ANIM_TYPE_TOKEN          "ANIM_TYPE" /* not in use */
#define DK_A_LIGHT_HIDDEN_TOKEN             "HIDDEN" 
#define DK_A_LIGHT_SHADOW_TYPE_TOKEN        "SHADOW_TYPE" 
#define DK_A_LIGHT_SHADOW_MAP_RES_TOKEN     "SHADOW_MAP_RES" 
#define DK_A_LIGHT_SHADOW_FILTER_SIZE_TOKEN "SHADOW_FILTER_SIZE" 
#define DK_A_LIGHT_SHADOW_FILTER_STEP_TOKEN "SHADOW_FILTER_STEP" 
#define DK_A_LIGHT_SHADOW_FADE_START_TOKEN  "SHADOW_FADE_START" 
#define DK_A_LIGHT_SHADOW_FADE_RATE_TOKEN   "SHADOW_FADE_RATE" 
#define DK_A_LIGHT_WIRE_COLOUR_INDEX_TOKEN  "WIRE_COLOUR_INDEX"
#define DK_A_LIGHT_AREA_BOOLEAN 		"AREA_LIGHT"
#define DK_A_LIGHT_AREA_TYPE 			"AREA_TYPE"
#define DK_A_LIGHT_AREA_U_SAMPLE 		"AREA_U_SAMPLE"
#define DK_A_LIGHT_AREA_V_SAMPLE 		"AREA_V_SAMPLE"
#define DK_A_LIGHT_AREA_GEO 			"AREA_GEOMETRY"
#define DK_A_LIGHT_AREA_LOCAL_BOOLEAN 		"AREA_LOCAL_COORDS"
#define DK_A_LIGHT_AREA_SCALE 			"AREA_SCALE"
#define DK_A_LIGHT_AREA_ROTATION 		"AREA_ROTATION"
#define DK_A_LIGHT_AREA_ROTATION_MAT 		"AREA_ROTATION_MAT"
#define DK_A_LIGHT_AREA_SELECTED		"AREA_SELECTED"

#define DK_A_CAMERA_TYPE_TOKEN          "TYPE"
#define DK_A_CAMERA_STEREO_TOKEN        "STEREO"
#define DK_A_CAMERA_POS_TOKEN           "POSITION"
#define DK_A_CAMERA_INT_TOKEN           "INTEREST"
#define DK_A_CAMERA_ROLL_TOKEN          "ROLL"
#define DK_A_CAMERA_YAW_TOKEN           "YAW_PITCH_ROLL"
#define DK_A_CAMERA_NEAR_TOKEN          "NEAR"
#define DK_A_CAMERA_FAR_TOKEN           "FAR"
#define DK_A_CAMERA_FLEN_TOKEN          "FOCAL_LENGTH"
#define DK_A_CAMERA_FSTOP_TOKEN         "F_STOP"
#define DK_A_CAMERA_FDIST_TOKEN         "FOCAL_DISTANCE"
#define DK_A_CAMERA_FOV_TOKEN           "FIELD_OF_VIEW"
#define DK_A_CAMERA_DOF_TOKEN           "DEPTH_OF_FIELD"
#define DK_A_CAMERA_DOF_OFF_TOKEN       "OFF"
#define DK_A_CAMERA_DOF_AUTOMATIC_TOKEN "AUTOMATIC"
#define DK_A_CAMERA_DOF_CUSTOM_TOKEN    "CUSTOM"

#define DK_A_CAMERA_NFOCUS_TOKEN    "NEAR_FOCUS"
#define DK_A_CAMERA_FFOCUS_TOKEN    "FAR_FOCUS"
#define DK_A_CAMERA_FOFOCUS_TOKEN   "OUT_OF_FOCUS"
#define DK_A_CAMERA_COC_TOKEN       "MAXIMUM_COC"
#define DK_A_CAMERA_ENL_TOKEN       "ENLARGE"
#define DK_A_CAMERA_ANIM_TYPE_TOKEN "ANIM_TYPE" /* not in use */
#define DK_A_CAMERA_HIDDEN_TOKEN    "HIDDEN"

#define DK_A_FCV_FREEFORM_TOKEN    "FREEFORM"
#define DK_A_FCV_KEYFRAME_TOKEN    "KEYFRAME"
#define DK_A_FCV_KEYPATH_TOKEN     "KEYPATH"
#define DK_A_FCV_RAWDATA_TOKEN     "RAWDATA"
#define DK_A_FCV_KEY_TIME_TOKEN    "TIME"
#define DK_A_FCV_KEY_VALUE_TOKEN   "VALUE"
#define DK_A_FCV_KEY_LSLOPE_TOKEN  "LEFT_SLOPE"
#define DK_A_FCV_KEY_RSLOPE_TOKEN  "RIGHT_SLOPE"
#define DK_A_FCV_KEY_INTERP_TOKEN  "INTERPOLATION"
#define DK_A_FCV_KEY_SFLAG_TOKEN   "FLAG"
#define DK_A_FCV_KEY_KTYPE_TOKEN   "KEYTYPE"
#define DK_A_FCV_KEY_SPINDEX_TOKEN "SPLINE_INDEX"

#define DK_A_FCV_TYPE_TOKEN     "CURVE_TYPE"
#define DK_A_FCV_NBKEYS_TOKEN   "KEYS"
#define DK_A_FCV_PRE_EXP_TOKEN  "PRE_EXTRAPOLATION"
#define DK_A_FCV_POST_EXP_TOKEN "POST_EXTRAPOLATION"
#define DK_A_FCV_FLAG_TOKEN     "FLAGS"
#define DK_A_FCV_INTERP_TOKEN   "INTERPOLATION"

#define DK_A_POS_STATIC_TOKEN     "STATIC"
#define DK_A_POS_FCV_TOKEN        "PATH"
#define DK_A_POS_MODEL_TOKEN      "PATH_MODEL"
#define DK_A_POS_CONSTRAINT_TOKEN "CONSTRAINT"
#define DK_A_POS_EXPLICIT_TOKEN   "EXPLICIT"

#define DK_A_SPLINE_KEY_PREV_TOKEN       "PREVIOUS"
#define DK_A_SPLINE_KEY_POS_TOKEN        "POSITION"
#define DK_A_SPLINE_KEY_NEXT_TOKEN       "NEXT"
#define DK_A_SPLINE_KEY_CONSTRAINT_TOKEN "CONSTRAINT"
#define DK_A_SPLINE_KEY_SEGMENT_TOKEN    "SEGMENT"
#define DK_A_SPLINE_KEY_FLAG_TOKEN       "FLAG"

#define DK_A_SPLINE_TYPE_TOKEN              "SPLINE"
#define DK_A_SPLINE_NB_TOKEN                "POINTS"
#define DK_A_SPLINE_CLOSE_TOKEN             "CLOSE"
#define DK_A_SPLINE_TENSION_TOKEN           "TENSION"
#define DK_A_SPLINE_STEP_TOKEN              "STEP"
#define DK_A_SPLINE_WIRE_COLOUR_TOKEN       "WIRE_COLOUR"
#define DK_A_SPLINE_LINE_TYPE_TOKEN         "LINE_TYPE"
#define DK_A_SPLINE_SELECTED_TOKEN          "SELECTED"
#define DK_A_SPLINE_PHANTOM_TOKEN           "PHANTOM"
#define DK_A_SPLINE_KEYLIST_TOKEN           "KEYLIST"
#define DK_A_SPLINE_NAME_TOKEN              "NAME"
#define DK_A_SPLINE_KEYFRAME_FLAG_TOKEN     "KEYFRAME"
#define DK_A_SPLINE_WIRE_COLOUR_INDEX_TOKEN "WIRE_COLOUR_INDEX"

#define DK_A_SPLINE_LINEAR_TYPE_TOKEN   "LINEAR"
#define DK_A_SPLINE_BEZIER_TYPE_TOKEN   "BEZIER"
#define DK_A_SPLINE_BSPLINE_TYPE_TOKEN  "BSPLINE"
#define DK_A_SPLINE_CARDINAL_TYPE_TOKEN "CARDINAL"
#define DK_A_SPLINE_BETA2_TYPE_TOKEN    "BETA2"

#define DK_A_LATTICE_ACTIVE_TOKEN  "ACTIVE"
#define DK_A_LATTICE_NBARRAY_TOKEN "NB_KEYS"
#define DK_A_LATTICE_INTERP_TOKEN  "INTERPOLATION"
#define DK_A_LATTICE_KEYS_TOKEN    "KEYS"
#define DK_A_LATTICE_FCV_TOKEN     "ANIMATION"
#define DK_A_LATTICE_MIN_TOKEN     "MINIMUM"
#define DK_A_LATTICE_MAX_TOKEN     "MAXIMUM"
#define DK_A_LATTICE_SCL_TOKEN     "SCALING"

#define DK_A_SHAPE_FCV_TOKEN    "INTERP_FCURVE"
#define DK_A_SHAPE_NAME_TOKEN   "SHAPE_NAME"
#define DK_A_SHAPE_WEIGHT_TOKEN "WEIGHT_FCURVES"

#define DK_A_CLUSTER_FILENAME_TOKEN "CLUSTER_FILENAME"
#define DK_A_CLUSTER_ACTIVE_TOKEN   "CLUSTER_ACTIVE"
#define DK_A_CLUSTER_NODE_TOKEN     "CLUSTER_NODE"

#define DK_A_CLUSTER_NODE_NAME_TOKEN   "CLUSTER_NODE_NAME"
#define DK_A_CLUSTER_NODE_ACTIVE_TOKEN "ACTIVE"
#define DK_A_CLUSTER_NODE_INTERP_TOKEN "INTERP_TYPE"
#define DK_A_CLUSTER_NODE_FCV_TOKEN    "INTERP_FCURVE"
#define DK_A_CLUSTER_NODE_WEIGHT_TOKEN "WEIGHT_FCURVES"

#define DK_A_MAT_NAME_TOKEN    "MATERIAL_NAME"
#define DK_A_MAT_AMB_TOKEN     "AMBIENT"
#define DK_A_MAT_DIFF_TOKEN    "DIFFUSE"
#define DK_A_MAT_SPEC_TOKEN    "SPECULAR"
#define DK_A_MAT_TRANSP_TOKEN  "TRANSPARENCY"
#define DK_A_MAT_REFL_TOKEN    "REFLECTION"
#define DK_A_MAT_RIND_TOKEN    "REFRACTION"
#define DK_A_MAT_ATTEN_TOKEN   "ATTENUATION"
#define DK_A_MAT_MTRANSP_TOKEN "MOTION_TRANSPARENCY"

#define DK_A_TXT_NAME_TOKEN    "TEXTURE_NAME"
#define DK_A_TXT_USCL_TOKEN    "U_SCALING"
#define DK_A_TXT_VSCL_TOKEN    "V_SCALING"
#define DK_A_TXT_UOFF_TOKEN    "U_OFFSET"
#define DK_A_TXT_VOFF_TOKEN    "V_OFFSET"
#define DK_A_TXT_AMB_TOKEN     "AMBIENT"
#define DK_A_TXT_DIFF_TOKEN    "DIFFUSE"
#define DK_A_TXT_SPEC_TOKEN    "SPECULAR"
#define DK_A_TXT_ROUGH_TOKEN   "ROUGHNESS"
#define DK_A_TXT_TRANSP_TOKEN  "TRANSPARENCY"
#define DK_A_TXT_REFLM_TOKEN   "REFLECTION"
#define DK_A_TXT_REFR_TOKEN    "REFRACTION"
#define DK_A_TXT_ENV_ROT_TOKEN "ROTATION"
#define DK_A_TXT_BLEND_TOKEN   "BLEND"
#define DK_A_TXT_REFL_TOKEN    "REFLECTION2"

#define DK_A_TXT3D_NAME_TOKEN     "TEXTURE_3D_NAME"
#define DK_A_TXT3D_STDK_REN_TOKEN "STRENGTH"
#define DK_A_TXT3D_SPAC_TOKEN     "SPACING"
#define DK_A_TXT3D_STRETCH_TOKEN  "STRETCH" /* not in use */
#define DK_A_TXT3D_COL0_TOKEN     "COLOUR_1"
#define DK_A_TXT3D_COL1_TOKEN     "COLOUR_2"
#define DK_A_TXT3D_COL2_TOKEN     "COLOUR_3"
#define DK_A_TXT3D_FAC1_TOKEN     "COLOUR_POS_1"
#define DK_A_TXT3D_SCL_TOKEN      "SCALING"
#define DK_A_TXT3D_ROT_TOKEN      "ROTATION"
#define DK_A_TXT3D_TRAN_TOKEN     "TRANSLATION"
#define DK_A_TXT3D_AMB_TOKEN      "AMBIENT"
#define DK_A_TXT3D_DIFF_TOKEN     "DIFFUSE"
#define DK_A_TXT3D_SPEC_TOKEN     "SPECULAR"
#define DK_A_TXT3D_ROUGH_TOKEN    "ROUGHNESS"
#define DK_A_TXT3D_TRANSP_TOKEN   "TRANSPARENCY"
#define DK_A_TXT3D_REFL_TOKEN     "REFLECTION"
#define DK_A_TXT3D_RIND_TOKEN     "REFRACTION" /* not in use */
#define DK_A_TXT3D_POWER_TOKEN    "POWER"
#define DK_A_TXT3D_TAPER_TOKEN    "TAPER"
#define DK_A_TXT3D_COL3_TOKEN     "COLOUR_4"
#define DK_A_TXT3D_COL4_TOKEN     "COLOUR_5"
#define DK_A_TXT3D_FAC2_TOKEN     "COLOUR_POS_2"
#define DK_A_TXT3D_FAC3_TOKEN     "COLOUR_POS_3"
#define DK_A_TXT3D_BLEND_TOKEN    "BLEND"
#define DK_A_TXT3D_COL0A_TOKEN    "ALPHA_1"
#define DK_A_TXT3D_COL1A_TOKEN    "ALPHA_2"
#define DK_A_TXT3D_COL2A_TOKEN    "ALPHA_3"
#define DK_A_TXT3D_COL3A_TOKEN    "ALPHA_4"
#define DK_A_TXT3D_COL4A_TOKEN    "ALPHA_5"

#define DK_A_REN_TYPE_TOKEN          "RENDERING_TYPE"
#define DK_A_REN_WIRE_TYPE_TOKEN     "WIRE_FRAME"
#define DK_A_REN_HIDDEN_TYPE_TOKEN   "HIDDEN_LINE"
#define DK_A_REN_RENDER_TYPE_TOKEN   "RENDERING_LINE"
#define DK_A_REN_HARDWARE_TYPE_TOKEN "HARDWARE_LINE"

#define DK_A_REN_FRAME_TOKEN      "RENDERING_FRAME"
#define DK_A_REN_fBUF_TOKEN       "FRAME_BUFFER"
#define DK_A_REN_OUTFILE_TOKEN    "OUTPUT_FILE"
#define DK_A_REN_RES_TOKEN        "RESOLUTION"
#define DK_A_REN_PICFORMAT_TOKEN  "PICTURE"
#define DK_A_REN_RATIO_TOKEN      "PIXEL_RATIO"
#define DK_A_REN_FILTER_TOKEN     "FILTER"
#define DK_A_REN_RDEPTH_TOKEN     "MAX_RAY_DEPTH"
#define DK_A_REN_TLEAF_TOKEN      "MAX_TRIA_DEPTH"
#define DK_A_REN_TDEPTH_TOKEN     "MAX_TREE_DEPTH"
#define DK_A_REN_PRESCRIPT_TOKEN  "PRE_RENDERING"
#define DK_A_REN_POSTSCRIPT_TOKEN "POST_RENDERING"

#define DK_A_REN_FOG_ACTIVE_TOKEN  	"FOG"
#define DK_A_REN_FOG_START_TOKEN   	"FOG_START"
#define DK_A_REN_FOG_END_TOKEN     	"FOG_END"
#define DK_A_REN_FOG_COLOUR_TOKEN  	"FOG_COLOUR"
#define DK_A_REN_FOG_DENS_TOKEN  	"FOG_DENSITY"
#define DK_A_REN_FOG_BASE_TOKEN  	"FOG_BASE"
#define DK_A_REN_FOG_THICK_TOKEN  	"FOG_THICKNESS"
#define DK_A_REN_FADE_ACTIVE_TOKEN  "FADE"
#define DK_A_REN_FADE_START_TOKEN   "FADE_START"
#define DK_A_REN_FADE_END_TOKEN     "FADE_END"
#define DK_A_REN_FADE_COLOUR_TOKEN  "FADE_COLOUR"
#define DK_A_REN_FADE_TRANSP_TOKEN  "FADE_TRANSPARENCY"
#define DK_A_REN_AMBIENCE_TOKEN     "AMBIENCE"
#define DK_A_REN_BACK_CULLING_TOKEN "BACK_CULLING"
#define DK_A_REN_TIME_STAT_TOKEN    "TIME_STATISTICS"
#define DK_A_REN_MEMORY_STAT_TOKEN  "MEMORY_STATISTICS"
#define DK_A_REN_TREE_STAT_TOKEN    "TREE_STATISTICS"
#define DK_A_REN_LINE_STAT_TOKEN    "LINE_STATISTICS"
#define DK_A_REN_MOTIONBLUR_TOKEN   "MOTION_BLUR"
#define DK_A_REN_SHUTTERSPEED_TOKEN "SHUTTER_SPEED"
#define DK_A_REN_MINMOVEMENT_TOKEN  "MIN_MOVEMENT"
#define DK_A_REN_ONFIELD_TOKEN      "ON_FIELD"
#define DK_A_REN_FIRSTFIELD_TOKEN   "FIRST_FIELD"

#define DK_A_REN_ANTIALIAS_TOKEN "ANTIALIAS"
#define DK_A_REN_FIXED_TOKEN     "FIXED"
#define DK_A_REN_ADAPTIVE_TOKEN  "ADAPTIVE"

#define DK_A_PIC_TYPE_TOKEN               "FORMAT_TYPE"
#define DK_A_PIC_35_137_TYPE_TOKEN        "35MM_137"
#define DK_A_PIC_35_166_TYPE_TOKEN        "35MM_166"
#define DK_A_PIC_35_185_TYPE_TOKEN        "35MM_185"
#define DK_A_PIC_70_PAN_TYPE_TOKEN        "70MM_PANAVISION"
#define DK_A_PIC_70_IMAX_TYPE_TOKEN       "70MM_IMAX"
#define DK_A_PIC_70_OMNI_TYPE_TOKEN       "70MM_OMNIMAX"
#define DK_A_PIC_NTSC_TYPE_TOKEN          "NTSC"
#define DK_A_PIC_PAL_TYPE_TOKEN           "PAL"
#define DK_A_PIC_HDTV_TYPE_TOKEN          "HDTV"
#define DK_A_PIC_SLIDE_35_TYPE_TOKEN      "SLIDE_35MM"
#define DK_A_PIC_6X6_TYPE_TOKEN           "6CM_X_6CM"
#define DK_A_PIC_6X9_TYPE_TOKEN           "6CM_X_9CM"
#define DK_A_PIC_4X5_TYPE_TOKEN           "4IN_X_5IN"
#define DK_A_PIC_CUSTOM_ASPECT_TYPE_TOKEN "CUSTOM_ASPECT"
#define DK_A_PIC_CUSTOM_SIZE_TYPE_TOKEN   "CUSTOM_SIZE"

#define DK_A_PIC_ASPECT_TOKEN "ASPECT"
#define DK_A_PIC_WIDTH_TOKEN  "WIDTH"
#define DK_A_PIC_HEIGHT_TOKEN "HEIGHT"


#define DK_A_MDL_NAME_TOKEN              "MODEL"
#define DK_A_MDL_SCL_TOKEN               "SCALING"
#define DK_A_MDL_ROT_TOKEN               "ROTATION"
#define DK_A_MDL_TRANS_TOKEN             "TRANSLATION"
#define DK_A_MDL_NLAT_TOKEN              "NODE_LATTICE"
#define DK_A_MDL_TLAT_TOKEN              "TREE_LATTICE"
#define DK_A_MDL_MAT_TOKEN               "MATERIAL"
#define DK_A_MDL_TXT_TOKEN               "TEXTURE"
#define DK_A_MDL_TXT3D_TOKEN             "TEXTURE_3D"
#define DK_A_MDL_SHAPE_TOKEN             "SHAPE"
#define DK_A_MDL_NFIT_TOKEN              "SPLINE_NODE"
#define DK_A_MDL_TFIT_TOKEN              "SPLINE_TREE"
#define DK_A_MDL_PNFIT_TOKEN             "PATCH_NODE"
#define DK_A_MDL_PTFIT_TOKEN             "PATCH_TREE"
#define DK_A_MDL_WIRE_COLOUR_TOKEN       "WIRE_COLOUR"
#define DK_A_MDL_LINE_TYPE_TOKEN         "LINE_TYPE"
#define DK_A_MDL_SELECTED_TOKEN          "SELECTED"
#define DK_A_MDL_SHAPE_INTERP_TOKEN      "SHAPE_INTERP_TYPE"
#define DK_A_MDL_ANIM_TYPE_TOKEN         "ANIM_TYPE" /* not in use */
#define DK_A_MDL_MATERIAL_INDEX_TOKEN    "MATERIAL_INDEX"
#define DK_A_MDL_LTXT_TOKEN              "LTEXTURE"
#define DK_A_MDL_LTXT3D_TOKEN            "LTEXTURE_3D"
#define DK_A_MDL_BBOX_TOKEN              "BOUNDING_BOX"
#define DK_A_MDL_DYNASETUP_TOKEN         "DYNA_SETUP"
#define DK_A_MDL_DYNAMATTERANIM_TOKEN    "DYNA_MATTER"
#define DK_A_MDL_DYNACONST_TOKEN         "DYNA_CONST"
#define DK_A_MDL_HID_TOKEN               "HIDDEN"
#define DK_A_MDL_ALGO_TOKEN              "ALGORITHM_TYPE"
#define DK_A_MDL_CLUSTER_TOKEN           "CLUSTER"
#define DK_A_MDL_COLLAPSE_TOKEN          "COLLAPSE"
#define DK_A_MDL_SCHEMPOS_TOKEN          "SCHEMPOS"
#define DK_A_MDL_WIRE_COLOUR_INDEX_TOKEN "WIRE_COLOUR_INDEX"

#define DK_A_DYNCONS_TYPE_TOKEN      "DYNCNS_TYPE"
#define DK_A_DYNCONS_PRIO_TOKEN      "DYNCNS_PRIO"
#define DK_A_DYNCONS_NAME_TOKEN      "DYNCNS_NAME"
#define DK_A_DYNCONS_OBSTACLE_TOKEN  "DYNCNS_OBSTACLE"

#define DK_A_DYNCONS_GRAVITY_TOKEN     "GRAVITY"
#define DK_A_DYNCONS_POS_ATTACH_TOKEN  "POS_ATTACH"
#define DK_A_DYNCONS_ORI_ATTACH_TOKEN  "ORI_ATTACH"
#define DK_A_DYNCONS_EXT_FORCE_TOKEN   "EXT_FORCE"
#define DK_A_DYNCONS_EXT_TORQUE_TOKEN  "EXT_TORQUE"
#define DK_A_DYNCONS_IMPULSE_TOKEN     "IMPULSE"
#define DK_A_DYNCONS_WIND_TOKEN        "WIND"
#define DK_A_DYNCONS_FAN_TOKEN         "FAN"
#define DK_A_DYNCONS_NAIL_TOKEN        "NAIL"
#define DK_A_DYNCONS_POSITION_TOKEN    "POSITION"
#define DK_A_DYNCONS_ORIENTATION_TOKEN "ORIENTATION"
#define DK_A_DYNCONS_COLLISION_TOKEN   "COLLISION"
#define DK_A_DYNCONS_DEF_GRAVITY_TOKEN "DEF_GRAVITY"
#define DK_A_DYNCONS_DEF_WIND_TOKEN    "DEF_WIND"
#define DK_A_DYNCONS_DEF_FLOOR_TOKEN   "DEF_FLOOR"

#define DK_A_DYNSETUP_RCPOS_TOKEN       "DYNSET_RCPOS"
#define DK_A_DYNSETUP_ANIM_RCPOS_TOKEN  "DYNSET_ANIM_RCPOS"
#define DK_A_DYNSETUP_RCPOSAXE_TOKEN    "DYNSET_RCPOSAXE"
#define DK_A_DYNSETUP_RCPOSACC_TOKEN    "DYNSET_RCPOSACC"
#define DK_A_DYNSETUP_RCORI_TOKEN       "DYNSET_RCORI"
#define DK_A_DYNSETUP_RCORIAXE_TOKEN    "DYNSET_RCORIAXE"
#define DK_A_DYNSETUP_RCORIACC_TOKEN    "DYNSET_RCORIACC"
#define DK_A_DYNSETUP_DOWIND_TOKEN      "DYNSET_DOWIND"
#define DK_A_DYNSETUP_DOGRAV_TOKEN      "DYNSET_DOGRAV"
#define DK_A_DYNSETUP_CHKCOLL_TOKEN     "DYNSET_CHKCOLL"
#define DK_A_DYNSETUP_DETECTL_TOKEN     "DYNSET_DETECTL"
#define DK_A_DYNSETUP_WINDL_TOKEN       "DYNSET_WINDL"
#define DK_A_DYNSETUP_GEOMUPD_TOKEN     "DYNSET_GEOMUPD"

#define DK_A_DYNSETUP_BSPHERE_TOKEN "BSPHERE"
#define DK_A_DYNSETUP_BBOX_TOKEN    "BBOX"
#define DK_A_DYNSETUP_SHAPE_TOKEN   "SHAPE"
#define DK_A_DYNSETUP_BPLANE_TOKEN  "BSPLANE"

#define DK_A_DYNMATTERANIM_ELAST_TOKEN  "DYNMATTER_ANIM_ELAST"
#define DK_A_DYNMATTERANIM_MU_S_TOKEN   "DYNMATTER_ANIM_MU_S"
#define DK_A_DYNMATTERANIM_MU_K_TOKEN   "DYNMATTER_ANIM_MU_K"
/* ..down to here */

#define DK_A_OBJ_FILE_TOKEN 1
#define DK_A_OBJ_NODE_TOKEN                    "MODEL"
#define DK_A_OBJ_SUBSTITUTION_TOKEN            "MODEL_SUBSTITUTION"
#define DK_A_OBJ_SUBSTITUTION_PRESCRIPT_TOKEN  "MODEL_SUBSTITUTION_PRESCRIPT"
#define DK_A_OBJ_SUBSTITUTION_POSTSCRIPT_TOKEN "MODEL_SUBSTITUTION_POSTSCRIPT"

#define DK_A_SFIT_SCL_TOKEN     "SCALING"
#define DK_A_SFIT_ROLL_TOKEN    "ROLL"
#define DK_A_SFIT_TRN_TOKEN     "TRANSLATION"
#define DK_A_SFIT_SPL_TOKEN     "ANIMATION"
#define DK_A_SFIT_MODEL_TOKEN   "SPLINE_NAME"
#define DK_A_SFIT_ACTIVE_TOKEN  "ACTIVE"

#define DK_A_PFIT_SCL_TOKEN    "SCALING"
#define DK_A_PFIT_ROT_TOKEN    "ROTATION"
#define DK_A_PFIT_TRN_TOKEN    "TRANSLATION"
#define DK_A_PFIT_MODEL_TOKEN  "PATCH_NAME"
#define DK_A_PFIT_ACTIVE_TOKEN "ACTIVE"

#define DK_A_LAYOUT_L0_FRONT_TOKEN "L0_FRONT"
#define DK_A_LAYOUT_L1_FRONT_TOKEN "L1_FRONT"
#define DK_A_LAYOUT_L0_RIGHT_TOKEN "L0_RIGHT"
#define DK_A_LAYOUT_L1_RIGHT_TOKEN "L1_RIGHT"
#define DK_A_LAYOUT_L0_TOP_TOKEN   "L0_TOP"
#define DK_A_LAYOUT_L1_TOP_TOKEN   "L1_TOP"
#define DK_A_LAYOUT_L0_PERSP_TOKEN "L0_PERSPECTIVE"
#define DK_A_LAYOUT_L1_PERSP_TOKEN "L1_PERSPECTIVE"
#define DK_A_LAYOUT_NONE_TOKEN     "NONE"

#define DK_A_LAYOUT_CAM_FRONT_TOKEN     "FRONT"
#define DK_A_LAYOUT_CAM_TOP_TOKEN       "TOP"
#define DK_A_LAYOUT_CAM_RIGHT_TOKEN     "RIGHT"
#define DK_A_LAYOUT_CAM_PERSP_TOKEN     "PERSPECTIVE"
#define DK_A_LAYOUT_CAM_FCURVE_TOKEN    "FCURVE"
#define DK_A_LAYOUT_CAM_SCHEMATIC_TOKEN "SCHEMATIC"

#define DK_A_LAYOUT_WINDOW_TYPE_TOKEN   "WINDOW_TYPE" 
#define DK_A_LAYOUT_CAMERA_TYPE_TOKEN   "CAMERA_TYPE" 
#define DK_A_LAYOUT_CAM_POS_TOKEN       "CAMERA_POSITION" 
#define DK_A_LAYOUT_CAM_INT_TOKEN       "CAMERA_INTEREST" 
#define DK_A_LAYOUT_CAM_FOV_TOKEN       "CAMERA_FOV" 
#define DK_A_LAYOUT_CAM_ASPECT_TOKEN    "CAMERA_ASPECT" 
#define DK_A_LAYOUT_CAM_NEAR_TOKEN      "CAMERA_NEAR" 
#define DK_A_LAYOUT_SHADED_TOKEN        "SHADED" 
#define DK_A_LAYOUT_GRID_TOKEN          "GRID_VISIBLE" 
#define DK_A_LAYOUT_AXIS_TOKEN          "AXIS_VISIBLE" 
#define DK_A_LAYOUT_RULER_TOKEN         "RULER_VISIBLE" 
#define DK_A_LAYOUT_FIELD_TOKEN         "FIELD_VISIBLE" 
#define DK_A_LAYOUT_XLOCK_TOKEN         "X_AXIS_LOCK" 
#define DK_A_LAYOUT_YLOCK_TOKEN         "Y_AXIS_LOCK" 
#define DK_A_LAYOUT_ZLOCK_TOKEN         "Z_AXIS_LOCK" 
#define DK_A_LAYOUT_DELTA_TOKEN         "DELTA" 
#define DK_A_LAYOUT_DISPLAY_TYPE_TOKEN  "DISPLAY_TYPE" 
#define DK_A_LAYOUT_PICTURE_TOKEN       "PICTURE" 
#define DK_A_LAYOUT_PICTURE_FRAME_TOKEN "PICTURE_FRAME" 
#define DK_A_LAYOUT_MIN_TOKEN           "MINIMUM_VIEW"  /* not in use */
#define DK_A_LAYOUT_MAX_TOKEN           "MAXIMUM_VIEW"  /* not in use */
#define DK_A_LAYOUT_DEPTHCUE_TOKEN      "DEPTH_CUE" 

/* ================= general =================== */

#define DK_HEADER_LENGTH  80
#define DK_MAXLINE       240

#define DK_STATUS_MSG  0
#define DK_ERROR_MSG   1
#define DK_WARNING_MSG 2

typedef short DK_SVALUE;
typedef float DK_FVALUE;

#endif  /* ifndef __TINY_SCENETOKEN_H__ */
