#include <math.h>
#include "tinyModel.h"
#include "DK_filter.h"

void printUsage();
void modelToSphere( Model *mdl, float radius );

main( int argc, char *argv[] )
{
   Model	*mdl;
   String	 inname = NULL;
   String	 outname = NULL;
   FileFormat	 fmt = FIL_BINARY;
   float	 radius;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if( argc != 4 )
      printUsage();

   inname = argv[1];
   radius = atof( argv[2] );
   outname = argv[3];

printf( "toSphere %s %f %s\n", inname, radius, outname );

   if( mdl = modelReadFile( inname ) )
   {
      modelToSphere( mdl, radius );
      if( ! modelWriteFile( outname, mdl, fmt ) )
        printf( "ERROR: Cannot write output file: %s(.hrc)\n", outname );
   }
   else
     printf( "ERROR: Cannot read input file: %s(.hrc)\n", inname );
}

void printUsage()
{
   printf( "usage: toSphere <infile> <radius> <outfile>\n" );
   printf( "\n" );
   exit( -1 );
}

void modelToSphere( Model *mdl, float radius )
{
   Mesh		*msh;
   Vertex	*vrt;
   Vector	*vct;
   Patch	*ptch;
   int		 i, nbp;
   float	 dist;

   switch( mdl->type )
   {
      case MDL_MESH:
         msh = (Mesh *) mdl->definition;
         for( i = 0, vrt = msh->vertices; i < msh->nbVertices; i++, vrt++ )
         {
            dist = sqrt( vrt->position.x * vrt->position.x +
                         vrt->position.y * vrt->position.y +
                         vrt->position.z * vrt->position.z   );
            if( dist > 0.001 )
            {
               float	fact = radius / dist;

               vrt->position.x *= fact;
               vrt->position.y *= fact;
               vrt->position.z *= fact;
            }
         }
         break;

      case MDL_PTCH:
         ptch = (Patch *) mdl->definition;

         nbp = ptch->uNbPoints * ptch->vNbPoints;
         for( i = 0, vct = ptch->points; i < nbp; i++, vct++ )
         {
            dist = sqrt( vct->x * vct->x + vct->y * vct->y + vct->z * vct->z );
            if( dist > 0.001 )
            {
               float	fact = radius / dist;

               vct->x *= fact;
               vct->y *= fact;
               vct->z *= fact;
            }
         }
         break;
   }

   if( mdl->sibling )
      modelToSphere( mdl->sibling, radius );

   if( mdl->child )
      modelToSphere( mdl->child, radius );
}
