#include <getopt.h>
#include "tinyTexture.h"
#include "DK_filter.h"

static int versionMaxIdx = sizeof(DK_VERSION_NAME) / sizeof(float) - 1;

void printUsage(char *execName)
{
   int i;
   printf("\n\n\n%s - Version %5.2f\n", execName, DK_VERSION_NAME[versionMaxIdx]);
   printf("(c) Copyright 1993, SOFTIMAGE Inc.\n");
   printf("----------------------------------\n\n");

   printf("Usage : %s <infile> <outfile> [-a] [-v <version>]\n", execName );
   printf("\n");
   printf("-a          : outputs in ASCII format\n" );
   printf("-v          : outfile versions can be\n");
   for (i = 0; i < versionMaxIdx; i++) {
      printf("                   %5.2f,\n", DK_VERSION_NAME[i]);
   }
   printf("                   %5.2f\n", DK_VERSION_NAME[versionMaxIdx]);
   printf("              DEFAULT: version %5.2f\n",
                         DK_VERSION_NAME[versionMaxIdx]);
}

main( int argc, char *argv[] )
{
   Texture3D	*txt;
   int		 i;
   String	 inname = NULL;
   String	 outname = NULL;
   FileFormat	 fmt = FIL_BINARY;
   int          err_flag = 0;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if (argc >= 3) {
      int               c;
      extern int        optind, opterr;


      inname = argv[1];
      outname = argv[2];
      optind = 3;
      opterr = 0;
      while ((c = getopt(argc, argv, "av:")) != GETOPTDONE ) {
         switch (c) {
           case 'a':
              fmt = FIL_ASCII;
              break;
           case 'v': {
              int i;
              float version = atof (optarg);
              for (i = 0;
                   i <= versionMaxIdx && version != DK_VERSION_NAME[i];
                   i++);
              if (i > versionMaxIdx) {
                 err_flag++;
              } else {
                 DK_VERSION = i;
              }
              break;
            }
            case '?' :
              err_flag++;
              break;
         }
      }
   } else {
      err_flag++;
   }

   if ( err_flag || inname == NULL || outname == NULL ) {
      printUsage(argv[0]);
      exit( -1 );
   }

   if( txt = texture3DReadFile( inname ) )
   {
      if( ! texture3DWriteFile( outname, txt, fmt ) )
        printf( "ERROR: Cannot write output file: %s(.t3D)\n", outname );
   }
   else
     printf( "ERROR: Cannot read input file: %s(.t3D)\n", inname );
}
