/*******************************************************************************
********************************************************************************

   scene.c
   Written by: Colin Hui

   This file reads and writes an ascii scene file.

   (c) Copyright 1991 Softimage Inc.

********************************************************************************
*******************************************************************************/

static char copyright[] = "(c) Copyright 1991 Softimage Inc.";

#include <getopt.h>
#include "DK_filter.h"
#include "tinySoftType.h"
#include "tinyFile.h"
#include "tinySceneToken.h"
#include "tinyScene.h"

static int versionMaxIdx = sizeof(DK_VERSION_NAME) / sizeof(float) - 1;

void printUsage(char *execName)
{
   int i;
   printf("\n\n\n%s - Version %5.2f\n", execName, DK_VERSION_NAME[versionMaxIdx]);
   printf("(c) Copyright 1993, SOFTIMAGE Inc.\n");
   printf("----------------------------------\n\n");

   printf("Usage : %s <ascii scene infile> <ascii scene outfile> [-v <version>]\n", execName );
   printf("\n");
   printf("-v          : outfile versions can be\n");
   for (i = 0; i < versionMaxIdx; i++) {
      printf("                   %5.2f,\n", DK_VERSION_NAME[i]);
   }
   printf("                   %5.2f\n", DK_VERSION_NAME[versionMaxIdx]);
   printf("              DEFAULT: version %5.2f\n",
                         DK_VERSION_NAME[versionMaxIdx]);
}

main( int argc, char *argv[] )
{
   Scene	*scn;
   float 	version;
   int		i;
   String	inname = NULL;
   String	outname = NULL;
   int          err_flag = 0;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if (argc >= 3) {
      int               c;
      extern int        optind, opterr;

      inname = argv[1];
      outname = argv[2];
      optind = 3;
      opterr = 0;
      while ((c = getopt(argc, argv, "v:")) != GETOPTDONE ) {
         switch (c) {
           case 'v': {
              int i;

              version = atof (optarg);
              for (i = 0;
                   i <= versionMaxIdx && version != DK_VERSION_NAME[i];
                   i++);
              if (i > versionMaxIdx) {
                 err_flag++;
              } else {
                 DK_VERSION = i;
              }
              break;
            }
            case '?' :
              err_flag++;
              break;
         }
      }
   } else {
      err_flag++;
   }

   if ( err_flag || inname == NULL || outname == NULL ) {
      printUsage(argv[0]);
      exit( -1 );
   }


   scn = DK_sceneAllocate();
   scn->name = strdup( inname );
   if ( DK_sceneReadAsciiAnimation ( &version, scn ) == TRUE )
   {
      printf("input  scene: version %f \n",version);
      printf("output scene: version %f \n",VERSION_NAME[VERSION]);

      scn->name = strdup( outname );
      DK_sceneWriteAsciiAnimation( ASCII_FILE_HEADER, VERSION_NAME[VERSION], scn );
   }
   DK_sceneDispose(&scn);
}
