#include "tinyPicture.h"
#include "DK_filter.h"

main( int argc, char *argv[] )
{
   Picture		*pic;
   FILE			*inFile;
   FILE			*outFile;
   ChannelPacket	*inPck, *outPck = NULL, *ptr;
   int			 i, j;
   char			*col;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if( argc != 3 )
   {
      printf( "usage: negate <input picture> <output picture>\n" );
      exit( -1 );
   }

   if( (pic = pictureAllocate()) == NULL )
   {
      printf( "Cannot allocate picture\n" );
      exit( -1 );
   }

   if( (inFile = pictureReadFileHeader( argv[1], pic, &inPck )) == NULL )
   {
      pictureDispose( &pic );
      printf( "Cannot open file: %s(.pic)\n", argv[1] );
      exit( -1 );
   }

   if( (outFile = pictureWriteFileHeader( argv[2], pic, &outPck )) == NULL )
   {
      pictureDispose( &pic );
      fclose( inFile );
      printf( "Cannot open file: %s(.pic)\n", argv[2] );
      exit( -1 );
   }

   for( ptr = inPck; ptr != NULL; ptr = ptr->next )
   {
      if( ptr->channels & RED_CHANNEL )
         pic->red   = (unsigned char *) malloc( pic->width );
      if( ptr->channels & GREEN_CHANNEL )
         pic->green = (unsigned char *) malloc( pic->width );
      if( ptr->channels & BLUE_CHANNEL )
         pic->blue  = (unsigned char *) malloc( pic->width );
      if( ptr->channels & ALPHA_CHANNEL )
         pic->alpha = (unsigned char *) malloc( pic->width );
   }

   for( i = pic->height - 1; i >= 0; i-- )
   {
      pic->ptrRed   = pic->red;
      pic->ptrGreen = pic->green;
      pic->ptrBlue  = pic->blue;
      pic->ptrAlpha = pic->alpha;
      pictureReadScanline( inFile, pic, inPck );

      if( (col = (char *) pic->red) != NULL )
         for( j = pic->width; j > 0; j--, col++ )
            *col = 255 - *col;

      if( (col = (char *) pic->green) != NULL )
         for( j = pic->width; j > 0; j--, col++ )
            *col = 255 - *col;

      if( (col = (char *) pic->blue) != NULL )
         for( j = pic->width; j > 0; j--, col++ )
            *col = 255 - *col;

      pic->ptrRed   = pic->red;
      pic->ptrGreen = pic->green;
      pic->ptrBlue  = pic->blue;
      pic->ptrAlpha = pic->alpha;
      pictureWriteScanline( outFile, pic, outPck );
   }

   pictureDispose( &pic );

   fclose( inFile );
   channelPacketDispose( &inPck );
   fclose( outFile );
   channelPacketDispose( &outPck );

}

