#include "tinyPicture.h"
#include "DK_filter.h"

main( int argc, char *argv[] )
{
   Picture	*pic;
   int		 i;
   char		*col;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if( argc != 3 )
   {
      printf( "usage: negate <input picture> <output picture>\n" );
      exit( -1 );
   }

   if( (pic = pictureReadFile( argv[1] )) != NULL )
   {
      pic->ptrRed   = pic->red;
      pic->ptrGreen = pic->green;
      pic->ptrBlue  = pic->blue;

      for( i = pic->height - 1; i >= 0; i-- )
      {
         pic->ptrRed   += pic->width;
         pic->ptrGreen += pic->width;
         pic->ptrBlue  += pic->width;
      }

      if( (col = (char *) pic->red) != NULL )
         for( i = pic->width * pic->height; i > 0; i--, col++ )
            *col = 255 - *col;

      if( (col = (char *) pic->green) != NULL )
         for( i = pic->width * pic->height; i > 0; i--, col++ )
            *col = 255 - *col;

      if( (col = (char *) pic->blue) != NULL )
         for( i = pic->width * pic->height; i > 0; i--, col++ )
            *col = 255 - *col;

      pictureWriteFile( argv[2], pic, NULL );
   }

}

