#include "tinyPicture.h"
#include "DK_filter.h"

main( int argc, char *argv[] )
{
   Picture		*pic0,  *pic1, *pic2;
   FILE			*file0, *file1, *file2;
   ChannelPacket	*pck0 = NULL, *pck1 = NULL, *pck2 = NULL, *ptr;
   int			 i;
   unsigned char	*red, *green, *blue, *alpha;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   if( argc != 4 )
   {
      printf( "usage: mergeField <fields_1> <fields_2> <output picture>\n" );
      exit( -1 );
   }

  /*****************
   Allocate pictures
   *****************/

   pic0 = pictureAllocate();
   pic1 = pictureAllocate();
   pic2 = pictureAllocate();
   if( pic0 == NULL || pic1 == NULL || pic2 == NULL )
   {
      printf( "Cannot allocate pictures\n" );
      exit( -1 );
   }

  /**********
   Open files
   **********/
  
   file0 = pictureReadFileHeader( argv[1], pic0, &pck0 );
   file1 = pictureReadFileHeader( argv[2], pic1, &pck1 );
   if( file0 == NULL || file1 == NULL )
   {
      printf( "Cannot open picture file\n" );
      exit( -1 );
   }

  /*********************************
   Verify that picture can merges...
   *********************************/
   if(    pic0->width != pic1->width
       || pic0->height != pic1->height
       || (    ( pic0->fields != ODD_FIELD || pic1->fields != EVEN_FIELD )
            && ( pic0->fields != EVEN_FIELD || pic1->fields != ODD_FIELD )
          )
      )
   {
      printf( "Cannot merge input picture\n" );
      exit( -1 );
   }
   
   pic2->width = pic0->width;
   pic2->height = pic0->height + pic1->height; 
   pic2->fields = FULL_FRAME;

   for( ptr = pck0; ptr != NULL; ptr = ptr->next )
   {
      if( ptr->channels & RED_CHANNEL )
         pic2->red   = red    = (unsigned char *) malloc( pic0->width );
      if( ptr->channels & GREEN_CHANNEL )
         pic2->green = green  = (unsigned char *) malloc( pic0->width );
      if( ptr->channels & BLUE_CHANNEL )
         pic2->blue  = blue   = (unsigned char *) malloc( pic0->width );
      if( ptr->channels & ALPHA_CHANNEL )
         pic2->alpha = alpha  = (unsigned char *) malloc( pic0->width );
   }

   file2 = pictureWriteFileHeader( argv[3], pic2, &pck2 );

   for( i = pic0->height - 1; i >= 0; i-- )
   {
      pic0->ptrRed   = red;
      pic0->ptrGreen = green;
      pic0->ptrBlue  = blue;
      pic0->ptrAlpha = alpha;
      pictureReadScanline( file0, pic0, pck0 );

      pic2->ptrRed   = red;
      pic2->ptrGreen = green;
      pic2->ptrBlue  = blue;
      pic2->ptrAlpha = alpha;
      pictureWriteScanline( file2, pic2, pck2 );

      pic1->ptrRed   = red;
      pic1->ptrGreen = green;
      pic1->ptrBlue  = blue;
      pic1->ptrAlpha = alpha;
      pictureReadScanline( file1, pic1, pck1 );

      pic2->ptrRed   = red;
      pic2->ptrGreen = green;
      pic2->ptrBlue  = blue;
      pic2->ptrAlpha = alpha;
      pictureWriteScanline( file2, pic2, pck2 );
   }

   pictureDispose( &pic0 );
   pictureDispose( &pic1 );
   pictureDispose( &pic2 );

   fclose( file0 );
   fclose( file1 );
   fclose( file2 );

   channelPacketDispose( &pck0 );
   channelPacketDispose( &pck1 );
   channelPacketDispose( &pck2 );
}


