
/*******************************************************************************
********************************************************************************

   fcurve.c
   Written by: Colin Hui

   This program reads an ascii scene file format fcurve and evaluates the
   points on the fcurve.

   (c) Copyright 1992 Softimage Inc.

********************************************************************************
*******************************************************************************/

static char copyright[] = "(c) Copyright 1992 Softimage Inc.";

#include "tinySoftType.h"
#include "tinySceneToken.h"
#include "tinyFcurve.h"
#include "tinyScene.h"
#include "tinyUtils.h"
#include "DK_filter.h"

static int 	writeRawFcurve ( char *, char *, int, float, float, int, int);

main(argc, argv)
int argc;
char *argv[];
{
    int frameRate = 30, userStartEnd = FALSE, frameOutput = FALSE, i;
    float timeStart, timeEnd;

#ifdef _WIN32
   DK_streamInitialize();
#endif

    /* set scene file version number -- It's IMPORTANT to set this
       since it will terminate the read after the flag is read for
       2.02 or earlier versions */
    animFileVersion = 2.5;

    if (argc > 3)
    {
	for (i = 1; i < argc; i++)
	{
	    if (argv[i][0] == '-')
	    {
		switch (argv[i][1])
		{
		    case 's':
			timeStart = atof(argv[i+1]);
			timeEnd = atof(argv[i+2]);
			userStartEnd = TRUE;
			break;
		    case 'f':
			frameOutput = TRUE;
			break;
		}
	    }
	}
	frameRate = atoi(argv[3]);
	writeRawFcurve(argv[1], argv[2], frameRate, timeStart, timeEnd,
		userStartEnd, frameOutput);
    }
    else
    {
	printf("\nUsage: fcurve <infile> <outfile> frameRate [-s start end] [-f]\n");
	printf("This program reads in a fcurve and writes the fcurve's value for each \ntime increment/frame.\n\n");
	printf("options: -s 	user specified start and end time\n");
	printf("         -f 	output the frame instead of the time\n\n");
    }
}




static int writeRawFcurve
    (
	char *infile,
	char *outfile,
	int frameRate,
	float timeStart,
	float timeEnd,
	int userStartEnd,
	int frameOutput
    )
{
    FILE *fpin, *fpout;
    Fcurve *fcv = NULL;
    float time, end, incre;
    int frame, rtn;

    if (frameRate <= 0 || timeStart > timeEnd)
    {
        printf("Invalid frame rate %d or start/end time %g %g\n",frameRate,
		timeStart, timeEnd);
	return(FALSE);
    }

    /* open the input file */
    if (infile == NULL || (fpin = fopen(infile, "r")) == NULL)
    {
        printf("Unable to open file '%s'.\n",infile);
	return(FALSE);
    }
    /* create the output file */
    if (outfile == NULL || (fpout = fopen(outfile, "w")) == NULL)
    {
        printf("Unable to create file '%s'.\n",outfile);
	fclose(fpin);
	return(FALSE);
    }
    
    /* read the fcurve token */
    in_animToken(fpin);
    if (strcmp(A_FCV_TYPE_TOKEN, animToken) != 0)
    {
	printf("Not a fcurve\n");
	fclose(fpin);
	fclose(fpout);
	return(FALSE);
    }
    /* read the fcurve */
    fcurveReadAsciiAnimation(fpin, &fcv);

    /* write the fcurve value at each frame */
    if (fcv != NULL && fcv->size > 0)
    {
	incre = 1.0 / frameRate;
	if (userStartEnd == TRUE)
	{
	    time = timeStart;
	    end = timeEnd;
	}
	else
	{
	    time = fcv->keys[0].time;
	    end = fcv->keys[fcv->size - 1].time;
	}
	frame = time / incre;
	while (time <= end)
	{
	    if (frameOutput == TRUE)
	        fprintf(fpout,"%d %g\n",frame,fcurveValue(fcv, time));
	    else
	        fprintf(fpout,"%g %g\n",time,fcurveValue(fcv, time));
	    time += incre;
	    frame++;
	}
	fcurveDispose(&fcv);
        rtn = TRUE;
    }
    else
	rtn = FALSE;
    fclose(fpin);
    fclose(fpout);
    return(rtn);
}
