/*******************************************************************************
********************************************************************************

   Test program for the libdbdk functions.

   File supervisor: Rejean Gagne

   To use this program, replace the string constants by the constants of 
   your environment...

   (c) Copyright 1993, SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include <sys/types.h>
#include <malloc.h>
#include "tinySoftType.h" 
#include "tinyScene.h" 
#include "tinyScnDump.h"
#include "libdbdk.h"

#define RSRC_PATH	"/usr/softimage/rsrc"
#define TEST_DB1	"/../../DB1"
#define TEST_DB2	"/../../"
#define DB2_NAME	"DB2"
#define TEST_SCN1	"test-Dkit"
#define TEST_SCN2	"scn2delete"


main()
{
   DK_Database	*db1,*db2;
   int		latest,oldtest,countv;
   DK_String	scn_name;
   char		str[512];
   DK_Boolean	lock;
   DK_Scene	*scn;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   /*--------------------------------------*/
   /* Init the Database and dictionaries   */
   /* (we won't read any DatabaseDir.rsrc) */ 
   /*--------------------------------------*/
   DK_dbInit( RSRC_PATH, FALSE );


   /*----------------------------------------------*/
   /* Let's open a work database at the given path */
   /*----------------------------------------------*/
   db1 = (DK_Database *) DK_dbOpen( TEST_DB1 );
   if ( db1 == NULL )
      exit( -1 );

   /*----------------------------------------------------*/
   /* Get some information about a scene in the database */
   /*----------------------------------------------------*/
   latest  = DK_dbSceneGetLastVersNum( TEST_SCN1, db1 );
   oldtest = DK_dbSceneGetFirstVersNum( TEST_SCN1, db1 );
   countv  = DK_dbSceneGetVersCount( TEST_SCN1, db1 );

   printf( " Total no. of version for scene [%s] = %d\n",TEST_SCN1, countv );
   printf( " Oldest version = %d   Latest version = %d\n",oldtest, latest );

   /*-------------------------------*/
   /* Build name for latest version */
   /*-------------------------------*/
   scn_name = DK_dbSceneGetVersName( TEST_SCN1, latest );

   /*-------------------------------------*/
   /* Check if it is locked, then lock it */
   /*-------------------------------------*/
   lock = DK_dbSceneIsLocked( scn_name, db1 );
   printf( " Scene [%s] locked ? %d\n",scn_name, lock );
   if ( !lock )
   {
      DK_dbSceneSetLock( scn_name, db1 );
      lock = DK_dbSceneIsLocked( scn_name, db1 );
      printf( " Scene [%s] locked ? %d\n",scn_name, lock );
   }


   /*--------------------------------------------------*/
   /* Load the scene, change its name and save it back */
   /*--------------------------------------------------*/
   scn = DK_dbSceneLoad( scn_name, db1 );

   /*-------------------------*/
   /* Dump the scene contents */
   /*-------------------------*/
   DK_scnDump( scn );

   /*----------------------------------------*/
   /* Change the scene name and save it back */
   /*----------------------------------------*/
   free( scn->name );   
   scn->name = strdup( TEST_SCN2 );
   DK_dbSceneSave( scn, db1, FALSE );

   /*-----------------------*/
   /* Create a new database */
   /*-----------------------*/
   db2 = (DK_Database *) DK_dbCreate( TEST_DB2, DB2_NAME, FALSE );
   if ( db2 == NULL )
   {
      /* It may already exist. Try to open it */
      sprintf( str, "%s%s", TEST_DB2, DB2_NAME );
      db2 = (DK_Database *) DK_dbOpen( str );
      if ( db2 == NULL )
	 exit( -1 );
   }
      

   /*----------------------------------------------------------------*/
   /* Tell the system not to attempt to delete any old file versions */
   /* (this will have no effect here unless previous versions of the */
   /* scene to save exist.)					     */
   /*----------------------------------------------------------------*/
   DK_dbNoOldVersionsFlag( TRUE );

   /*------------------------------------*/
   /* Save three 'versions' of the scene */
   /*------------------------------------*/
   DK_dbSceneSave( scn, db2, TRUE );
   DK_dbSceneSave( scn, db2, FALSE );
   DK_dbSceneSave( scn, db2, FALSE );

   latest  = DK_dbSceneGetLastVersNum( TEST_SCN2, db2 );
   oldtest = DK_dbSceneGetFirstVersNum( TEST_SCN2, db2 );
   countv  = DK_dbSceneGetVersCount( TEST_SCN2, db2 );

   printf( " Total no. of version for scene [%s] = %d\n",TEST_SCN1, countv );
   printf( " Oldest version = %d   Latest version = %d\n",oldtest, latest );
   

   /*-----------------------------------------*/
   /* Delete the second scene that was saved. */
   /*-----------------------------------------*/
   scn_name = DK_dbSceneGetVersName( TEST_SCN2, latest - 1 );
   DK_dbSceneDelete( scn_name, db2, FALSE );

   /*------------------------------------------------*/
   /* Delete the database.			     */
   /* Flag 'force' set to FALSE: should return a msg */
   /* saying that the database is not empty.	     */
   /*------------------------------------------------*/
   DK_dbDelete( db2, FALSE );
}
