#include "tinyModel.h"
#include "DK_filter.h"

main()
{
   Model	*mdl;
   Mesh		*msh;
   Polygon	*pol;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   mdl = modelAllocate();
   msh = meshAllocate();
   mdl->definition = (Pointer) msh;
   mdl->type = MDL_MESH;

   mdl->name = strdup( "cube" );

  /* Allocate and initializing vertices */
   msh->vertices = vertexAllocate( msh->nbVertices = 8 );
   _VectorInit( msh->vertices[0].position,  0.0,  0.0,  0.0 );
   _VectorInit( msh->vertices[1].position,  0.0,  0.0,  1.0 );
   _VectorInit( msh->vertices[2].position,  0.0,  1.0,  0.0 );
   _VectorInit( msh->vertices[3].position,  0.0,  1.0,  1.0 );
   _VectorInit( msh->vertices[4].position,  1.0,  0.0,  0.0 );
   _VectorInit( msh->vertices[5].position,  1.0,  0.0,  1.0 );
   _VectorInit( msh->vertices[6].position,  1.0,  1.0,  0.0 );
   _VectorInit( msh->vertices[7].position,  1.0,  1.0,  1.0 );

  /* Allocate and initializing polygon */
   pol = msh->polygons = polygonAllocate( msh->nbPolygons = 6 );

   polygonInitializeVertex( pol, 4,  0, 1, 3, 2 );
   _VectorInit( pol->nodes[0].normal, -1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[1].normal, -1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[2].normal, -1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[3].normal, -1.0, 0.0, 0.0 );
   pol++;

   polygonInitializeVertex( pol, 4,  1, 5, 7, 3 );
   _VectorInit( pol->nodes[0].normal, 0.0, 0.0, 1.0 );
   _VectorInit( pol->nodes[1].normal, 0.0, 0.0, 1.0 );
   _VectorInit( pol->nodes[2].normal, 0.0, 0.0, 1.0 );
   _VectorInit( pol->nodes[3].normal, 0.0, 0.0, 1.0 );
   pol++;

   polygonInitializeVertex( pol, 4,  5, 4, 6, 7 );
   _VectorInit( pol->nodes[0].normal, 1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[1].normal, 1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[2].normal, 1.0, 0.0, 0.0 );
   _VectorInit( pol->nodes[3].normal, 1.0, 0.0, 0.0 );
   pol++;

   polygonInitializeVertex( pol, 4,  4, 0, 2, 6 );
   _VectorInit( pol->nodes[0].normal, 0.0, 0.0, -1.0 );
   _VectorInit( pol->nodes[1].normal, 0.0, 0.0, -1.0 );
   _VectorInit( pol->nodes[2].normal, 0.0, 0.0, -1.0 );
   _VectorInit( pol->nodes[3].normal, 0.0, 0.0, -1.0 );
   pol++;

   polygonInitializeVertex( pol, 4,  3, 7, 6, 2 );
   _VectorInit( pol->nodes[0].normal, 0.0, 1.0, 0.0 );
   _VectorInit( pol->nodes[1].normal, 0.0, 1.0, 0.0 );
   _VectorInit( pol->nodes[2].normal, 0.0, 1.0, 0.0 );
   _VectorInit( pol->nodes[3].normal, 0.0, 1.0, 0.0 );
   pol++;

   polygonInitializeVertex( pol, 4,  1, 0, 4, 5 );
   _VectorInit( pol->nodes[0].normal, 0.0, -1.0, 0.0 );
   _VectorInit( pol->nodes[1].normal, 0.0, -1.0, 0.0 );
   _VectorInit( pol->nodes[2].normal, 0.0, -1.0, 0.0 );
   _VectorInit( pol->nodes[3].normal, 0.0, -1.0, 0.0 );
   pol++;


   /* Write model file */
   modelWriteFile( "cube", mdl, FIL_BINARY );
}
