#include "tinySpline.h"
#include "DK_filter.h"

#ifdef _WIN32
#include <irixMath.h>
#endif

main()
{
   Spline	*spl;
   SplineKey	*key;
   int		 i;
   float	 radius = 5.0;
   short	 step = 10;
   float	 angle, angStep;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   angStep = 2.0 * M_PI / (float) step;

   if( (spl = splineAllocate()) != NULL )
   {
      key = spl->keys = splineKeyAllocate( spl->nbKeys = step );
      spl->type = SPL_CARDINAL;
      spl->close = TRUE;
      spl->tension = 0.5;

      for( i = 0, angle = 0.0; i < step; i++, angle += angStep, key++ )
      {
         key->position.x = radius * cos( angle );
         key->position.y = radius * sin( angle );
         key->position.z = 0.0;

	 key->previous = key->position;
	 key->next     = key->position;
      }

      if( ! splineWriteFile( "circle", spl, FIL_BINARY ) )
        printf( "ERROR: Cannot write output file: circle(.spl)\n" );
   }
}

void printUsage()
{
   printf( "usage: splConvert <infile> <outfile> [-a] [-v2.0]\n" );
   printf( "\n" );
   printf( "options: -a      outputs in ASCII format\n" ); 
   printf( "         -v2.0   outputs compatible file with SOFTIMAGE v2.0\n" );
   exit( -1 );
}
