/*
(c) Copyright 1994, SOFTIMAGE Inc.

Mon Mar 28 11:23:04 EST 1994

This custom effect example uses DKit (v1.1) functions and structures to
read, modify, and write SOFTIMAGE model hierarchies.

First, the dialog data is read in from stdin.  This data specifies the
user's choice of using an offset or a scale, and the corresponding value.
Second, a text hierarchy, as selected by the user, is read in.  Third, the
models in the hierarchy are translated according to the dialog data.
The hierarchy is then written back to stdout.

This file is a C version - text_spacing_plus.C is a C++ version.

VL.
--------------------------------------------------------------------------------
*/

#include "tinyModel.h"  /* for DK_fdmodelReadBinaryFile() etc. */

void main(int i, char *argv[])
{
   DK_Model* model;
   DK_Model* base_null;
   int n_base_nulls;

   /*
   -----------------------------------------------------------------------------
   read and parse the dialog data
   (ps. this code assumes a certain order in the data - if the .cus
   file is changed, this code may have to be updated.)
   -----------------------------------------------------------------------------
   */

   char symbol[100];
   int use_offset, use_scale;
   float offset, scale;

#ifdef _WIN32
   DK_streamInitialize();
#endif

   fscanf(stdin, "%s", symbol);
   if (strcmp(symbol, "_DATA") != 0)
   {
      fprintf(stderr, "%s: _DATA token not found, exit.\n", argv[0]);
      exit(1);
   }

   fscanf(stdin, "%s%f", symbol, &offset);
   if (strcmp(symbol, "offset") != 0)
   {
      fprintf(stderr, "%s: offset token not found, exit.\n", argv[0]);
      exit(1);
   }

   fscanf(stdin, "%s%f", symbol, &scale);
   if (strcmp(symbol, "scale") != 0)
   {
      fprintf(stderr, "%s: scale token not found, exit.\n", argv[0]);
      exit(1);
   }

   fscanf(stdin, "%s%d", symbol, &use_offset);
   if (strcmp(symbol, "use_offset") != 0)
   {
      fprintf(stderr, "%s: use_offset token not found, exit.\n", argv[0]);
      exit(1);
   }

   fscanf(stdin, "%s%d", symbol, &use_scale);
   if (strcmp(symbol, "use_scale") != 0)
   {
      fprintf(stderr, "%s: use_scale token not found, exit.\n", argv[0]);
      exit(1);
   }

   if (use_offset * use_scale != 0)
   {
      fprintf(stderr, "%s: both use_scale & use_offset are set, exit.\n",
	      argv[0]);
      exit(1);
   }

   fscanf(stdin, "%s\n", symbol);
   if (strcmp(symbol, "_END") != 0)
   {
      fprintf(stderr, "%s: _END token not found, exit.\n", argv[0]);
      exit(1);
   }

   /*
   -----------------------------------------------------------------------------
   Read in the text model

   (A text hierarchy consists of a null that is the parent to a number
   of "base" nulls, each of these base nulls being the parent of the one
   or more faces of a character, eg. an 'i' would consist of 2 faces ...
   The first base null corresponds to the LAST character in the string.)
   -----------------------------------------------------------------------------
   */

   model = DK_fdmodelReadBinaryFile(stdin);
   if (model == 0)
   {
      fprintf(stderr, "%s: DK_fdmodelReadBinaryFile(stdin) returned 0, exit.\n",
	      argv[0]);
      exit(1);
   }

   base_null = model->child;

   if (base_null == 0 || model->type != DK_MDL_NILL)
   {
      fprintf(stderr, "%s: selected hierarchy is not text, exit.\n ",
	      argv[0]);
      exit(1);
   }

   while (use_scale)
   {
      if (base_null->type != DK_MDL_NILL)
      {
	 fprintf(stderr, "%s: selected hierarchy is not text, exit.\n ",
		 argv[0]);
	 exit(1);
      }

      /* (the base null for a space does not have a child) */

      if (base_null->child && base_null->child->type != DK_MDL_FACE)
      {
	 fprintf(stderr, "%s: base_null->child->type != DK_MDL_FACE, exit.\n",
		 argv[0]);
	 exit(1);
      }

      base_null->translation.x *= scale;

      if (base_null->sibling == 0)
      {
	 /* write out the text model */
	 if (DK_fdmodelWriteBinaryFile(stdout, model) == 0)
	 {
	    fprintf(stderr,
		    "%s: DK_fdmodelWriteBinaryFile() returned 0, exit.\n",
		    argv[0]);
	    exit(1);
	 }
	 exit(0);
      }

      base_null = base_null->sibling;
   }

   n_base_nulls = 1;

   while (1)
   {
      if (base_null->type != DK_MDL_NILL)
      {
	 fprintf(stderr, "%s: selected hierarchy is not text, exit.\n",
		 argv[0]);
	 exit(1);
      }

      /* (the base null for a space does not have a child) */

      if (base_null->child && base_null->child->type != DK_MDL_FACE)
      {
	 fprintf(stderr, "%s: base_null->child->type != DK_MDL_FACE, exit.\n",
		 argv[0]);
	 exit(1);
      }

      if (base_null->sibling == 0)
      {
	 break;
      }

      base_null = base_null->sibling;
      n_base_nulls++;
   }

   base_null = model->child;

   while (--n_base_nulls)
   {
      base_null->translation.x += n_base_nulls * offset;
      base_null = base_null->sibling;
   }

   /* write out the text model */
   if (DK_fdmodelWriteBinaryFile(stdout, model) == 0)
   {
      fprintf(stderr, "%s: DK_fdmodelWriteBinaryFile() returned 0, exit.\n",
	      argv[0]);
      exit(1);
   }
}
