/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/chnlDriver/src/testOut.c,v $
   $Revision: 1.4.14.1 $ $Date: 1995/06/09 22:05:46 $
   Checkin by: $Author: poirierm $
   
   This is a "dummy" output channel driver that receives DOF
   information from SOFTIMAGE 3D.  The DOF data received is simply
   printed on stderr.
   
   (c) Copyright 1994-1995 SOFTIMAGE Inc.
   
********************************************************************************
*******************************************************************************/

#include <stdio.h> 
#include <string.h>
#include <math.h> 
#include <gl.h> 
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>

#include "DK_driver.h"

/******************************************************************************/
/*** Constants ****************************************************************/
/******************************************************************************/

/* maximum number of dofs allowed */
#define	 MAX_DOFS	4

/* error messages information */
#define	 ERR_MISC	0
#define	 ERROR_NUM	1

/***************************/ 
/* custom menu file tokens */
/***************************/
#define	 _DATA		0
#define	 _END		1

#define	 TOKEN_NUM	2

/******************************************************************************/
/*** Type definitions *********************************************************/
/******************************************************************************/

/******************************************************************************/
/*** Private Prototypes *******************************************************/
/******************************************************************************/

static DK_Boolean customMenu( int argc, char *argv[] );
static void	  getConfigInfo( void );

/******************************************************************************/
/*** Private Variables ********************************************************/
/******************************************************************************/

/* Names of the tokens which are transmitted from CE */
static char *tokens[TOKEN_NUM] = 
{
   "_DATA",
   "_END"
};

/* Names of the DOFs which are transmitted to CE */
static char *dofNames[MAX_DOFS] =
{
   "OUT_1",
   "OUT_2",
   "OUT_3",
   "OUT_4"
};

static char *errorInfo[ERROR_NUM] = 
{
   "Output driver error"
};

/******************************************************************************/
/*** Public Functions *********************************************************/
/******************************************************************************/

int main ( int argc, char **argv )
{
   int i;
   int written;

   /*****************************************/
   /* are we being called by a custom menu? */
   /*****************************************/
   if ( customMenu( argc, argv ) )
      exit( 0 );

   /******************************/
   /* initialise communications  */
   /******************************/
   if ( !DK_driverInit( argc, argv, DK_DRV_GL_FALSE ) ) 
   {
      DK_driverExit();
      exit( 1 );
   }
   
   /***************/
   /* ready to go */
   /***************/
   DK_driverReady();
   
   /*********************************************/
   /* get configuration info from custom dialog */
   /*********************************************/
   getConfigInfo();

   while ( TRUE )
   {
      /*****************************/
      /* get next command from S3D */
      /*****************************/
      if ( DK_driverGetOp() == DK_DRV_KILL )
	 break;

      fprintf(stderr, "\n");
      
      /*********************/
      /* get data from S3D */
      /*********************/
      for ( i = 0; i < MAX_DOFS; i++ )
      {
	 float tempValue;

	 written = DK_driverGetDofValue( i, &tempValue );
	 switch ( written )
	 {
	 case DK_CHN_ERROR:
	    /********************************/
	    /* invalid dof number requested */
	    /********************************/
	    fprintf(stderr, "testOut: Invalid DOF (%d)\n", i);
	    break;

	 case DK_CHN_UNCHANGED:
	    /*******************************/
	    /* the dof value was unchanged */
	    /*******************************/
	    break;

	 case DK_CHN_SUCCESS:
	    /****************************/
	    /* obtained a new dof value */
	    /****************************/
	    fprintf(stderr, "testOut: Successfully read DOF (%d): %g\n",
		    i, tempValue);
	    break;
	 }
      }

      /***********************************************************/
      /* copy the driver's drvData array into the shared memory, */
      /* release the semaphore and reset the drvData array.      */
      /***********************************************************/
      DK_driverSendData();
   }

   /********************/
   /* cleanup and exit */
   /********************/
   DK_driverExit();
   return 0;
}

/******************************************************************************/
/*** Private Functions ********************************************************/
/******************************************************************************/

/*******************************************************************************

   $$L customMenu

   Handles the custom configuration menu (send channel names and error
   strings to SOFTIMAGE via pipes).

   Returned value : TRUE if the driver was called from a custom menu,
                    FALSE otherwise.

   (c) Copyright 1994-1995, SOFTIMAGE Inc.

*******************************************************************************/
static DK_Boolean customMenu
   (
      int argc,
      char *argv[]
   )
{
   int i;
   
   /*******************************************************/
   /* if we are not being called by a custom menu (either */
   /* as a stand-alone or as a starting driver) then quit */
   /*******************************************************/
   if (argc > 1)
   {
      if (strcmp( argv[1], "-SI_MENU" ))  return FALSE;
   }
   else return( FALSE );
   
   /**************************/
   /* get configuration info */
   /**************************/
   getConfigInfo();

   /***************************************/
   /* send degrees of freedom information */
   /***************************************/

   fprintf( stdout,"DOF_NUM %d\n", MAX_DOFS );
   fprintf( stdout,"\n" );

   for ( i = 0; i < MAX_DOFS; i++ )
   {
      fprintf( stdout, "DOF_NAME %d %s\n", i, dofNames[ i ] );
   }

   fprintf( stdout, "\n" );

   for ( i = 0; i < MAX_DOFS; i++ )
   {
      fprintf( stdout, "DOF_TYPE %d O ON\n", i );
   }

   fprintf( stdout, "\n" );

   fprintf(stdout, "ERROR_NUM %d\n", ERROR_NUM );

   for ( i = 0; i < ERROR_NUM; i++ )
      fprintf( stdout, "ERROR %d %s\n", i, errorInfo[i] );

   fprintf( stdout, "_END\n" );
   fflush( stdout );
   
   return TRUE;
}


/*******************************************************************************

   $$L getConfigInfo

   Reads configuration info from stdin.

   Returned Value: None

   (c) Copyright 1994-1995 SOFTIMAGE Inc.

*******************************************************************************/
static void getConfigInfo( void )
{
   int token;
   char	finished = FALSE;

   while ( !finished && 
      ((token = DK_driverConfigReadToken( stdin, TOKEN_NUM, tokens ))
      != DK_DRV_TOKEN_NULL ))
   {
      switch( token )
      {
	 case _DATA:
	 {
	    DK_driverConfigReadLine( stdin );
	 }  break;

	 case _END:
	 {
	    DK_driverConfigReadLine( stdin );
	    finished = TRUE;
	 }  break;

	 default:
	    DK_driverConfigReadLine( stdin );
	    break;
      }
   }
}


