/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/chnlDriver/src/mouse.c,v $
   $Revision: 1.13.14.2 $ $Date: 1995/07/07 16:18:30 $
   Checkin by: $Author: xuepingd $

   This channel driver works with the mouse.

   Degrees of freedom output:
      DOF 0: normalized mouse X position (0..1)
      DOF 1: normalized mouse Y position (0..1)

   (c) Copyright 1992-1995 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gl.h>
#include <device.h>

#include "DK_driver.h"

/******************************************************************************/
/*** Constants ****************************************************************/
/******************************************************************************/

/*************************/ 
/* mouse.drv file tokens */
/*************************/ 
#define DEBUG		0

#define TOKEN_NUM	1

/******************************************************************************/
/*** Private Prototypes *******************************************************/
/******************************************************************************/
static DK_Boolean get_config_info( char *name );

/******************************************************************************/
/*** Private Variables ********************************************************/
/******************************************************************************/
static DK_Boolean debug = FALSE;

static char *tokens[TOKEN_NUM] = 
   {
      "DEBUG" 
   };

/******************************************************************************/
/*** Public Functions *********************************************************/
/******************************************************************************/

int main( int argc, char **argv )
{
   float x = 0.0;
   float y = 0.0;
   float xmaxscreen, ymaxscreen;
 
#ifndef _WIN32       
   xmaxscreen = (float) getgdesc( GD_XPMAX );
   ymaxscreen = (float) getgdesc( GD_YPMAX );
#else
   xmaxscreen = (float) GetSystemMetrics (SM_CXSCREEN);
   ymaxscreen = (float) GetSystemMetrics (SM_CYSCREEN);
#endif
   
   if ( !DK_driverInit( argc, argv, DK_DRV_GL_TRUE ) ) 
   {
      DK_driverExit();
      exit(1);
   }

   if ( !get_config_info( argv[0] ) ) exit( 1 );

   DK_driverReady();

   while( TRUE )
   {
      /***************************/
      /* Get operation from soft */
      /***************************/
      if ( DK_driverGetOp() == DK_DRV_KILL) break;

      /************************/
      /* Get data from device */
      /************************/
#ifndef _WIN32
      x = (float)getvaluator(MOUSEX) / xmaxscreen;
      DK_driverSetDofValue( 0, x ); 
      y = (float)getvaluator(MOUSEY) / ymaxscreen;
      DK_driverSetDofValue( 1, y );
#else
   {
	POINT p;
   GetCursorPos (&p);
   x = (float)p.x / xmaxscreen;
   DK_driverSetDofValue( 0, x ); 
   y = (float)(ymaxscreen - p.y) / ymaxscreen;
   DK_driverSetDofValue( 1, y );
   }
#endif

      if (debug) printf( "Mouse pos: %f %f\n", x, y );

      /*********************/
      /* Send data to soft */
      /*********************/
      DK_driverSendData();  
   }

   DK_driverExit();
   return 0;
}


/******************************************************************************/
/*** Private Functions ********************************************************/
/******************************************************************************/

/*******************************************************************************

   $$L get_config_info

   Reads the mouse.drv file and returns relevant configuration 
   information.

   Returned Value: TRUE if file is processed successfully, else FALSE

   (c) Copyright 1992-1995 SOFTIMAGE Inc.

*******************************************************************************/
static DK_Boolean get_config_info
   ( 
      char *name
   )
{
   FILE 	*file;
   int 		token;

   if ( (file = DK_driverConfigOpen( name )) == NULL )
      return( FALSE );

   /*************/
   /* read file */
   /*************/
   while ( (token = DK_driverConfigReadToken( file, TOKEN_NUM, tokens ))
	   != DK_DRV_TOKEN_NULL )
   {
      switch( token )
      {
	 case DEBUG:
	 {
	    debug = TRUE;
	 }  break;

	 default:
	    DK_driverConfigReadLine( file );
	    break;
      }
   }

   DK_driverConfigClose( file );
   return( TRUE );
}

