/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/chnlDriver/src/micro_vol.c,v $
   $Revision: 1.12.14.1 $ $Date: 1995/06/09 22:05:42 $
   Checkin by: $Author: poirierm $

   Channel driver for microphone volume.

   (c) Copyright 1992-1995 SOFTIMAGE Inc.

********************************************************************************
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <gl.h>
#include <device.h>
#include <audio.h>

#include "DK_driver.h"

/******************************************************************************/
/*** Constants ****************************************************************/
/******************************************************************************/

/************************/
/* micro_vol.cus tokens */
/************************/
#define MICRO_FILTER 0
#define _DATA	     1
#define _END	     2

#define TOKEN_NUM    3

#define	MIN_FILTER   1
#define	MAX_FILTER   6

/******************************************************************************/
/*** Private Prototypes *******************************************************/
/******************************************************************************/

static void	  getConfigInfo( void );
static DK_Boolean micMenu( int argc, char *argv[] );

/******************************************************************************/
/*** Private Variables ********************************************************/
/******************************************************************************/

static char *tokens[TOKEN_NUM] = 
   {
      "MICRO_FILTER",
      "_DATA",
      "_END"
   };

static int microFilter = 4;

/******************************************************************************/
/*** Public Functions *********************************************************/
/******************************************************************************/

int main( int argc, char **argv )
{
   float volume;

   /*****************************************/
   /* are we being called by a custom menu? */
   /*****************************************/
   if ( micMenu( argc, argv )) exit( 0 );

   /************************************/
   /* initialise driver communications */
   /************************************/
   if ( !DK_driverInit( argc, argv, DK_DRV_GL_FALSE ) )
   {
      DK_driverExit();
      exit(1);
   }

   /***************/
   /* ready to go */
   /***************/
   DK_driverReady();

   /**************************/
   /* get configuration info */
   /**************************/
   getConfigInfo();

   /********************/
   /* initialise audio */
   /********************/
   if ( !DK_driverMicInit( microFilter ) )
   {
      DK_driverExit();
      exit(1);
   }

   while(1)
   {
      if ( DK_driverGetOp() == DK_DRV_KILL) break;

      /**********************/
      /* get a sound sample */
      /**********************/
      volume = DK_driverMicVolume();
      
      if (volume < 0.1) DK_driverSetDofValue( 0, 0 );
      else DK_driverSetDofValue( 0, volume );

      /*********************/
      /* send data to soft */
      /*********************/
      DK_driverSendData();
   }

   /********************/
   /* cleanup and exit */
   /********************/
   DK_driverMicExit();
   DK_driverExit();
   return 0;
}

/******************************************************************************/
/*** Private Functions ********************************************************/
/******************************************************************************/

/*******************************************************************************

   $$L getConfigInfo

   Reads configuration information from stdin.

   Returned Value: None

   (c) Copyright 1992-1995 SOFTIMAGE Inc.

*******************************************************************************/
static void getConfigInfo( void )
{
   int 	token;
   char	finished = FALSE;

   while ( !finished && 
      ((token = DK_driverConfigReadToken( stdin, TOKEN_NUM, tokens ))
      != DK_DRV_TOKEN_NULL ))
   {
      switch( token )
      {
	 case MICRO_FILTER:
	 {
	    int f;
	    if ( fscanf( stdin, "%d", &f ) == 1 ) 
	       microFilter = f;
            
	    if ( microFilter < MIN_FILTER ) microFilter = MIN_FILTER;
	    else if ( microFilter > MAX_FILTER ) microFilter = MAX_FILTER;
	 }  break;

	 case _DATA:
	 {
	    DK_driverConfigReadLine( stdin );
	 }  break;

	 case _END:
	 {
	    DK_driverConfigReadLine( stdin );
	    finished = TRUE;
	 }  break;

	 default:
	    DK_driverConfigReadLine( stdin );
	    break;
      }
   }
}

/*******************************************************************************

   $$L micMenu

   Handles the micro_vol custom menu (send channel names and error strings
   to SOFTIMAGE via stdout).

   Returned value : TRUE if the driver was called from a custom menu,
                    FALSE otherwise.

   (c) Copyright 1993-1995, SOFTIMAGE Inc.

*******************************************************************************/
static DK_Boolean micMenu( int argc, char *argv[] )
{
   /*******************************************************/
   /* if we are not being called by a custom menu (either */
   /* as a stand-alone or as a starting driver) then quit */
   /*******************************************************/
   if (argc > 1)
   {
      if (strcmp( argv[1], "-SI_MENU" ))  return FALSE;
   }
   else return( FALSE );

   /**************************/
   /* get configuration info */
   /**************************/
   getConfigInfo();

   /***************************************/
   /* send degrees of freedom information */
   /***************************************/
   fprintf(stdout, "DOF_NUM 1\n" );
   fprintf(stdout, "DOF_NAME 0 volume\n" );
   fprintf(stdout, "_END\n" );
   fflush( stdout );
   
   return TRUE;
}
