/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/chnlDriver/src/highRes.c,v $
   $Revision: 1.4.14.1 $ $Date: 1995/06/09 22:05:45 $
   Checkin by: $Author: poirierm $

   This is a "dummy" input channel driver that demonstrates
   high-resolution capture.  There are 3 DOFs, all of which are
   high-res buffered.  The data the DOFs are sending is:

      DOF 0: random walk
             (3 values sent per pass through the loop)
      DOF 1: ever-increasing random walk
             (2 values sent per pass through the loop)
      DOF 2: constant
             (1 value sent per pass through the loop)
   
   (c) Copyright 1994-1995 SOFTIMAGE Inc.
   
********************************************************************************
*******************************************************************************/

#include <stdio.h> 
#include <string.h>
#include <math.h> 
#include <gl.h> 
#include <sys/time.h>
#include <unistd.h>
#include <errno.h>

#include "DK_driver.h"

/******************************************************************************/
/*** Constants ****************************************************************/
/******************************************************************************/

/* maximum number of dofs allowed */
#define	 MAX_DOFS	3

/* error messages information */
#define	 ERR_MISC	0
#define	 ERROR_NUM	1

/***************************/ 
/* custom menu file tokens */
/***************************/
#define	 _DATA		0
#define	 _END		1

#define	 TOKEN_NUM	2

/******************************************************************************/
/*** Type definitions *********************************************************/
/******************************************************************************/

/******************************************************************************/
/*** Private Prototypes *******************************************************/
/******************************************************************************/

static DK_Boolean customMenu( int argc, char *argv[] );
static void	  getConfigInfo( void );

/******************************************************************************/
/*** Private Variables ********************************************************/
/******************************************************************************/

/* Names of the tokens which are transmitted from CE */
static char *tokens[TOKEN_NUM] = 
{
   "_DATA",
   "_END"
};

/* Names of the DOFs which are transmitted to CE */
static char *dofNames[MAX_DOFS] =
{
   "RND_WALK",
   "INC_RND_WALK",
   "CONSTANT"
};

static char *errorInfo[ERROR_NUM] = 
{
   "High-res driver error"
};

/******************************************************************************/
/*** Public Functions *********************************************************/
/******************************************************************************/

int main ( int argc, char **argv )
{
   float time1, time2;
   
   /*****************************************/
   /* are we being called by a custom menu? */
   /*****************************************/
   if ( customMenu( argc, argv ) )
      exit( 0 );

   /******************************/
   /* initialise communications  */
   /******************************/
   if ( !DK_driverInit( argc, argv, DK_DRV_GL_FALSE ) ) 
   {
      DK_driverExit();
      exit( 1 );
   }
   
   /***************/
   /* ready to go */
   /***************/
   DK_driverReady();
   
   /*********************************************/
   /* get configuration info from custom dialog */
   /*********************************************/
   getConfigInfo();

   /*******************************************************************/
   /* set initial time -- we can initialize it to any value we choose */
   /*******************************************************************/
   DK_driverInitTime( 50.0 );
   time1 = time2 = DK_driverGetTime();

   /****************************************************/
   /* tell DKit which DOFs should be high-res buffered */
   /****************************************************/
   DK_driverBuffer( 0 );
   DK_driverBuffer( 1 );
   DK_driverBuffer( 2 );

   while ( TRUE )
   {
      DK_DriverOp op;
      
      /******************************/
      /* get next command from soft */
      /******************************/
      op = DK_driverGetOp();
      if ( op == DK_DRV_KILL )
	 break;
      
      /********************/
      /* get current time */
      /********************/
      time2 = DK_driverGetTime();
      
      /***************************************/
      /* pretend we're busy doing hard work! */
      /* simulate getting data from a device */
      /***************************************/
      sginap( 5 );

      /********************/
      /* send data to  CE */
      /********************/
      {
         static float x = 0.0, y = 0.0, z = 0.0;

	 /*****************************************************************
	    NOTE:

	    In this sample driver, we set DOF values/times more than
	    once each time through the main driver loop.  If we have
	    told DKit to high-res buffer a particular DOF (by calling
	    DK_driverBuffer(dof_no)), then ALL calls to
	    DK_driverSetDofValue/Time during a specific pass through
	    the loop get stored, and that data is available for
	    "downloading" into SOFTIMAGE 3D after a capture.

	    If a channel is not being high-res buffered, then multiple
	    calls to set the DOF value and time are not stored -- each
	    subsequent call replaces the data which will get sent to
	    SOFTIMAGE at DK_driverSendData().

	    Note that a DOF may be buffered, even if it has not been
	    explicitly requested.  This will be the case if the DOF is
	    in a channel expression with at least one DOF which has
	    been set to high-resolution buffering.
	 *****************************************************************/

	 /*****************************/
	 /* figure out the new values */
	 /*****************************/
	 x += ( ( rand() % 999 ) - 499 ) / 499.0;
	 y += ( rand() % 2000 ) / 100000.0;
	 z = 1.0;

	 /******************************/
	 /* send the first set of data */
	 /******************************/
	 DK_driverSetDofValue( 0, x );
	 DK_driverSetDofTime( 0, 0.667*time1 + 0.333*time2 );

	 DK_driverSetDofValue( 1, y );
	 DK_driverSetDofTime( 1, 0.5*time1 + 0.5*time2 );
	 
	 DK_driverSetDofValue( 2, z );
	 DK_driverSetDofTime( 2, time2 - ( rand() % 1000 ) / 1.0e+5 );
	 
	 /*****************************/
	 /* figure out the new values */
	 /*****************************/
	 x += ( ( rand() % 999 ) - 499 ) / 499.0;
	 y += ( rand() % 2000 ) / 100000.0;

	 /*******************************/
	 /* send the second set of data */
	 /*******************************/
	 DK_driverSetDofValue( 0, x );
	 DK_driverSetDofTime( 0, 0.333*time1 + 0.667*time2 );

	 DK_driverSetDofValue( 1, y );
	 DK_driverSetDofTime( 1, time2 );
	 
	 /*****************************/
	 /* figure out the new values */
	 /*****************************/
	 x += ( ( rand() % 999 ) - 499 ) / 499.0;

	 /*******************************/
	 /* send the third set of data */
	 /*******************************/
	 DK_driverSetDofValue( 0, x );
	 DK_driverSetDofTime( 0, time2 );
	 
      }

      /***********************/
      /* backup current time */
      /***********************/
      time1 = time2;

      /***********************************************************/
      /* copy the driver's drvData array into the shared memory, */
      /* release the semaphore and reset the drvData array.      */
      /***********************************************************/
      DK_driverSendData();
   }

   /********************/
   /* cleanup and exit */
   /********************/
   DK_driverExit();
   return 0;
}


/******************************************************************************/
/*** Private Functions ********************************************************/
/******************************************************************************/

/*******************************************************************************

   $$L customMenu

   Handles the custom configuration menu (send channel names and error
   strings to SOFTIMAGE via pipes).

   Returned value : TRUE if the driver was called from a custom menu,
                    FALSE otherwise.

   (c) Copyright 1994-1995, SOFTIMAGE Inc.

*******************************************************************************/
static DK_Boolean customMenu
   (
      int argc,
      char *argv[]
   )
{
   int i;
   
   /*******************************************************/
   /* if we are not being called by a custom menu (either */
   /* as a stand-alone or as a starting driver) then quit */
   /*******************************************************/
   if (argc > 1)
   {
      if (strcmp( argv[1], "-SI_MENU" ))  return FALSE;
   }
   else return( FALSE );
   
   /**************************/
   /* get configuration info */
   /**************************/
   getConfigInfo();

   /***************************************/
   /* send degrees of freedom information */
   /***************************************/

   fprintf( stdout,"DOF_NUM %d\n", MAX_DOFS );
   fprintf( stdout,"\n" );

   for ( i = 0; i < MAX_DOFS; i++ )
   {
      fprintf( stdout, "DOF_NAME %d %s\n", i, dofNames[ i ] );
   }

   fprintf( stdout, "\n" );

   fprintf(stdout, "ERROR_NUM %d\n", ERROR_NUM );

   for ( i = 0; i < ERROR_NUM; i++ )
      fprintf( stdout, "ERROR %d %s\n", i, errorInfo[i] );

   fprintf( stdout, "_END\n" );
   fflush( stdout );
   
   return TRUE;
}


/*******************************************************************************

   $$L getConfigInfo

   Reads configuration info from stdin.

   Returned Value: None

   (c) Copyright 1994-1995 SOFTIMAGE Inc.

*******************************************************************************/
static void getConfigInfo( void )
{
   int token;
   char	finished = FALSE;

   while ( !finished && 
      ((token = DK_driverConfigReadToken( stdin, TOKEN_NUM, tokens ))
      != DK_DRV_TOKEN_NULL ))
   {
      switch( token )
      {
	 case _DATA:
	 {
	    DK_driverConfigReadLine( stdin );
	 }  break;

	 case _END:
	 {
	    DK_driverConfigReadLine( stdin );
	    finished = TRUE;
	 }  break;

	 default:
	    DK_driverConfigReadLine( stdin );
	    break;
      }
   }
}
