
/*******************************************************************************
********************************************************************************

   $Source: /drive3/SI2/creative/RCS/chnlDriver/h/DK_driver.h,v $
   $Revision: 1.12.14.1 $ $Date: 1995/06/09 22:04:37 $
   Checkin by: $Author: poirierm $

   Include file for the channel driver communications interface.

   File supervisor: Lucy Boyd-Wilson

   (c) Copyright 1992 Softimage Inc.

********************************************************************************
*******************************************************************************/


#ifndef __DK_DRIVER_H__
#define __DK_DRIVER_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
typedef HANDLE FILEHANDLE;
#else
typedef int FILEHANDLE;
#endif

#ifndef REBELS
#ifndef __TINY_SOFTTYPE_H__ 
/* also defined in /EX8a/creative/current/computer/sgi/DKit/h/tinySoftType.h */
typedef long	DK_Boolean;
#endif
#endif

typedef				/* Current operation from soft */
   enum 
   {
      DK_DRV_NONE,
      DK_DRV_FRAME_INPUT,      	/* soft is in frame input mode.    */
      DK_DRV_SEQUENCE_INPUT,   	/* soft is in sequence input mode. */
      DK_DRV_SEQUENCE_PAUSE,   	/* soft is pausing in sequence     */                                           /* input mode.                     */
      DK_DRV_KILL              	/* end of capture - driver should  */
			       	/* exit.                           */
   } DK_DriverOp;

#define DK_DRV_TOKEN_NULL   -1	/* Config file NULL token or EOF */

typedef enum 
{
   DK_DRV_GL_FALSE,   		/* device doesn't have SGI GL support */
   DK_DRV_GL_TRUE	    	/* device does have GL support */
} DK_DriverGlDevice;

typedef enum
{
   DK_CHN_NOTYPE,		    /* No mode specified */
   DK_CHN_INPUT,		    /* Input channel */
   DK_CHN_OUTPUT		    /* Output channel */
} DK_ChnType;

typedef enum
{
   DK_CHN_ERROR,                /* Invalid dof index */
   DK_CHN_UNCHANGED,            /* Unwritten dof, nothing changed */
   DK_CHN_SUCCESS               /* Value or time read successfully */
} DK_ChnStatus;

typedef enum
{
   DK_DRV_ERR_WARNING 	= 1,
   DK_DRV_ERR_FATAL 	= 3
} DK_DriverErrorType;

/*******************************************************
 * Communication routines for exchanging data with soft*
 *******************************************************/
extern DK_Boolean 	DK_driverInit( int argc, char **argv, 
				DK_DriverGlDevice gl_device );
extern DK_Boolean 	DK_driverExit(void);
extern DK_Boolean 	DK_driverReady(void);
extern DK_DriverOp 	DK_driverGetOp( void );
extern int		DK_driverGetDofType( int dof_no );
extern int		DK_driverGetDofActive( int dof_no );
extern DK_ChnStatus     DK_driverGetDofValue( int dof_no, float *value );
extern DK_ChnStatus     DK_driverGetDofTime( int dof_no, float *doftime );
extern DK_Boolean 	DK_driverSetDofValue( int dof_no, float value );
extern DK_Boolean 	DK_driverSetDofTime( int dof_no, float doftime );
extern void		DK_driverInitTime( float time );
extern float		DK_driverGetTime( void );
extern DK_Boolean 	DK_driverSendData( void );
extern DK_Boolean 	DK_driverError( 
				int err_num, DK_DriverErrorType type);
extern DK_Boolean	DK_driverBuffer( int dof_no );

/*****************************************************
 * Routines for examining the .drv configuration file*
 *****************************************************/
extern FILE 	       *DK_driverConfigOpen( char *execname );
extern void 		DK_driverConfigClose( FILE *file );
extern int 		DK_driverConfigReadToken( FILE *file, 
				int token_num, char **tokens );
extern void 		DK_driverConfigReadLine( FILE *file );

/**************************************
 * Access routines for the RS232 ports*
 **************************************/
extern DK_Boolean 	DK_driverPortOpen( FILEHANDLE *, char * );
extern void 		DK_driverPortClose( FILEHANDLE  );
extern DK_Boolean 	DK_driverPortSetBaud( FILEHANDLE , int  );
extern DK_Boolean 	DK_driverPortRead( FILEHANDLE ,  char *, int , int  );
extern DK_Boolean 	DK_driverPortWrite( FILEHANDLE , char *, int  );

/*****************************
 * Microphone driver routines*
 *****************************/
extern DK_Boolean 	DK_driverMicInit( int filter_level );
extern void 		DK_driverMicExit( void );
extern float 		DK_driverMicVolume( void );

#ifdef __cplusplus
}
#endif


#endif  /* __DK_DRIVER_H__ */

