;
; QPEG video driver
; for VESA compatible graphics cards
;
; 15-Oct-93:  1st release
; 04-Nov-93:  several bugs fixed
; 01-May-94:  added properties part
;

        .286
Code    Segment Para 'Code'
        Assume  cs:Code
        Org 100h

Procs   dw      Bank,Init,Exit,Props
        dw      0,0,0,0

Bank:   test    cs:VesaMode,0ffh
        jz      SkipIt          ; don't do bank switching if no VESA mode
        pusha
        push    es
        push    ds
        mul     cs:VesaGranularity
        mov     dx,ax
        push    dx
        xor     bx,bx           ; window A
        mov     ax,4f05h
        int     10h
        pop     dx
        mov     bx,1            ; window B
        mov     ax,4f05h
        int     10h
        pop     ds
        pop     es
        popa
SkipIt: retf

VesaGranularity db 0    ; granularity of video bank address
VesaMode        db 0    ; 0 = not a VESA mode (i.e. no bank switching)

Init:   mov     cs:VesaMode,0
        cmp     ax,4f02h
        jne     Ready           ; skip everything if no VESA mode
        mov     cs:VesaMode,1
        push    cx
        mov     dx,cs
        mov     es,dx
        xor     di,di           ; es:di - VESA info table
        mov     cx,bx           ; mode number
        mov     ax,4f01h        ; get VESA mode info
        int     10h
        cmp     ax,004fh
        jne     Fail

        mov     cl,Byte Ptr cs:[00h]
        and     cl,10001b
        cmp     cl,10001b
        je      Supp
Fail:   xor     cx,cx           ; Mode not supported
        pop     ax
        jmp     Short Ready
Supp:   mov     cx,cs:[04h]     ; VESA page granularity (in Kb)
        mov     al,1
        test    cx,cx
        je      Gran64
        mov     ax,64
        div     cl
Gran64: mov     cs:VesaGranularity,al

        pop     ax              ; default = minimum bytes per line
        mov     cx,cs:[10h]     ; VESA bytes per line
        cmp     cx,ax
        jae     Ready
        add     cx,cx           ; double if too small
Ready:  retf

Exit:   retf

; Properties Part (called after Init)
; -> ax,bx: Mode numbers (as for int10h and Init)
; <- VESA-like mode information at cs:[00h]
;      00h: bit 0 and 4 set if mode is supported
;      12h: (word) width (pixels per line)
;      14h: (word) heigth (lines per screen)
;      19h: bits per pixel
; The following are only valid for hicolor and truecolor modes:
;      1fh: bits per red component, 5 (hicolor) or 8 (truecolor)
;      20h: bit offset of red component, 0 (hi/true RGB) or 16 (true BGR)
;      21h: bits per green component, 5/6 (hicolor) or 8 (truecolor)
;      22h: bit offset of green component, 5 (hi) or 8 (true)
;      23h: bits per blue component, 5 (hicolor) or 8 (truecolor)
;      24h: bit offset of blue component, 10/11 (hi), 0 (true BGR) or 16 (true RGB)
;      25h: bits per Rsvd component, 0/1 (hicolor/true) or 8 (true 32bit)
;      26h: bit offset of Rsvd component, 24 (true 32bit) or 0 (else)
; QPEG uses 25h to distinguish between 24bit and 32bit truecolor.

Props:  mov     Byte Ptr cs:[00h],0
        test    cs:VesaMode,0ffh
        jz      Ready2          ; skip everything if no VESA mode
        mov     dx,cs
        mov     es,dx
        xor     di,di           ; es:di - VESA info table
        mov     cx,bx           ; mode number
        mov     ax,4f01h        ; get VESA mode info
        int     10h
Ready2: retf

Code    Ends
        End Procs

; End of source.
