;
; QPEG video driver
; for Chips & Technologies chipsets (82c45x, F655x0)
;

        .286
Code    Segment Para 'Code'
        Assume  cs:Code
        Org 100h

Procs   dw      Bank,Init,Exit,0

Chipset db      0
        ; 0 = 82c451, 82c455, 82c456, 82c457
        ; 1 = 82c452
        ; 2 = 82c450, 82c453, F655x0

Bank:   push    ax
        mov     dl,Chipset
        test    dl,dl
        jz      Bank0
        dec     dl
        jz      Bank1

Bank2:  mov     dx,03d6h
        shl     ax,12
        mov     al,10h
        out     dx,ax
        pop     ax
        retf

Bank1:  mov     dx,03d6h
        shl     ax,10
        mov     al,10h
        out     dx,ax
        pop     ax
        retf

Bank0:  mov     dx,03d6h
        mov     ah,al
        mov     al,0bh
        out     dx,ax
        pop     ax
        retf

Init:   mov     dx,46e8h
        mov     ax,001eh
        out     dx,ax           ; enter setup mode
        push    dx
        mov     dx,0103h
        mov     al,80h
        out     dx,ax           ; enable extended registers
        pop     dx
        mov     al,0eh
        out     dx,ax           ; leave setup mode

        mov     dx,03d6h
        mov     al,04h
        out     dx,al
        inc     dx
        in      al,dx
        or      al,04h
        out     dx,al           ; enable bank access & extended CRTC

        dec     dx
        mov     al,0bh
        out     dx,al
        inc     dx
        in      al,dx
        and     al,0fch
        or      al,01h
        out     dx,al           ; enable extended paging & single page mode

        dec     dx
        xor     ax,ax
        out     dx,al
        inc     dx
        in      al,dx
        shr     al,4
        jz      ready   ; 82c451 -> 0
        dec     al
        jz      ready1  ; 82c452 -> 1
        dec     al
        jz      ready   ; 82c455 -> 0
        cmp     al,3
        jb      ready2  ; 82c453/0 -> 2
        cmp     al,5
        jb      ready   ; 82c456/7 -> 0
                        ; F655x0 -> 2
ready2: inc     ah
ready1: inc     ah
ready:  mov     cs:Chipset,ah
        retf

Exit:   retf

Code    Ends
        End Procs

; End of source.
