{*********************************************************}
{*                                                       *}
{*       Turbo Pascal Version 7.0                        *}
{*       Graphic Vision Unit                             *}
{*                                                       *}
{*       Copyright (c) 1995 Jason G Burgon               *}
{*                                                       *}
{*********************************************************}

unit PalView;

interface

uses CRT, GObjects, ScrnDriv, GDrivers, GViews, GWindows, GDialogs;

type
  PPaletteView = ^TPaletteView;
  TPaletteView = object(TView)
   BoxSpce : TPoint;
   RowCol  : TPoint;
   Info    : PDialog;
   OldPal  : TPalette256RGB;
   constructor Init(var Bounds: TRect; ABoxSpce, ARowCol: TPoint);
   procedure Draw; virtual;
   procedure HandleEvent(var Event: TEvent); virtual;
   procedure Update;
  end;

  PPaletteWindow = ^TPaletteWindow;
  TPaletteWindow = object(TWindow)
   PalView: PPaletteView;
   constructor Init(var R: TRect; ABox, ARowCol: TPoint);
   procedure SizeLimits(var Min,Max: TPoint); virtual;
  end;

implementation

uses GApp;

constructor TPaletteView.Init(var Bounds: TRect; ABoxSpce, ARowCol: TPoint);
var
  D: PDialog;
  P: PView;
  R: TRect;
begin
  LongInt(Bounds.A) := 0;
  Bounds.B.X := (ABoxSpce.X * ARowCol.X) div CharSize.X;
  Bounds.B.Y := (ABoxSpce.Y * ARowCol.Y) div CharSize.Y;
  inherited Init(Bounds);
  SizeAdj.B.X := -((ABoxSpce.X * ARowCol.X) - (Bounds.B.X * CharSize.X));
  SizeAdj.B.Y := -((ABoxSpce.Y * ARowCol.Y) - (Bounds.B.Y * CharSize.Y));
  BoxSpce := ABoxSpce;
  RowCol  := ARowCol;
  EventMask := evMouseDown;

  { Create Colour Info Dialog Box }

  Longint(R.A) := 0;
  R.B.X := 30;  R.B.Y := 8;
  D := New(PDialog, Init(R, 'Details'));
  with D^ do
   begin
     Options := Options or ofCentered;
     Hide;
     SetState(sfDisabled, True);
   end;
  R.A.X := 1; R.A.Y := 2; R.B.X := 15; R.B.Y := 3;
  P := New(PParamText, Init(R, 'Colour   %3d', 1));
  D^.Insert(P);
  Inc(R.A.Y, 2); Inc(R.B.Y, 4);
  P := New(PCheckBoxes, Init(R, NewSItem('Animate',
                                NewSItem('IsSystem',
                                NewSItem('IsUsed', nil)))));
  D^.Insert(P);
  R.A.X := 17; R.B.X := 29; R.A.Y := 2; R.B.Y := 3;
  P := New(PParamText, Init(R, 'Red     %3d', 1));
  D^.Insert(P);
  Inc(R.A.Y); Inc(R.B.Y);
  P := New(PParamText, Init(R, 'Green   %3d', 1));
  D^.Insert(P);
  Inc(R.A.Y); Inc(R.B.Y);
  P := New(PParamText, Init(R, 'Blue    %3d', 1));
  D^.Insert(P);
  Inc(R.A.Y, 2); Inc(R.B.Y, 2);
  P := New(PParamText, Init(R, 'Used by %3d', 1));
  D^.Insert(P);
  PView(Info) := Application^.ValidView(D);
  Application^.Insert(Info);
end;

procedure TPaletteView.Draw;
var
  BoxSize: TPoint;
  Color  : Byte;
  I,J    : Word;
  X,Y    : Integer;
  R      : TRect;
  P      : PColorRGB;
begin
  GetPixExtent(R);
  BoxSize.X := BoxSpce.X -3;
  BoxSize.Y := BoxSpce.Y -3;
  Color:= 0;
  X := R.A.X+1; Y := R.A.Y+1;
  P := PColorRGB(SysPal);
  for I := 0 to RowCol.Y-1 do
   begin
    for J := 0 to RowCol.X-1 do
     begin
       SetBkColor(Color);
       Bar(X, Y, X + BoxSize.X, Y + BoxSize.Y);
       if P^.Flags and pfIsUsed = 0
         then SetColor(Black)
         else SetColor(LightGray);
       Rectangle(X-1, Y-1, X + BoxSize.X +1, Y + BoxSize.Y +1);
       Inc(X, BoxSpce.X);
       Inc(Color);
       Inc(PtrRec(P).Ofs, SizeOf(TColorRGB));
     end;
    X := R.A.X+1;
    Inc(Y, BoxSpce.Y);
   end;
  SetColor(MaxColor);
  X := R.A.X;
  Y := R.A.Y;
end;

procedure TPaletteView.HandleEvent(var Event: TEvent);

function GetColorNum(Where: TPoint): Word;
var
  R       : TRect;
  Row,Col : Word;
begin
  GetPixExtent(R);
  MakePixLocal(Where, Where);
  Row := Where.X div BoxSpce.X;
  Col := Where.Y div BoxSpce.Y;
  Col := (Col * RowCol.X) + Row;
  if Col > MaxColor
    then Col := MaxColor;
  GetColorNum := Col;
end;

 procedure FlashColor;
 var
   C : TColorRGB;
   NC: TColorRGB;
   I : Word;
   ColorNum: Word;
 begin
   ColorNum := GetColorNum(Event.Where);
   GetRGBPalette(ColorNum, 1, @C);
   Longint(NC) := not Longint(C);
   for I := 1 to 10 do
    begin
      SetRGBPalette(ColorNum, 1, @NC);
      Delay(100);
      SetRGBPalette(ColorNum, 1, @C);
      Delay(100);
    end;
 end;

 procedure ShowInfo;
 type
   TColorDialogData = record
     Index: Longint;
     Flags: Word;
     Red  : Longint;
     Green: Longint;
     Blue : Longint;
     Used : Longint;
   end;

 var
   InfoData: TColorDialogData;
   Color   : TColorRGB;
   ColorNum: Word;
   Padder  : Word;
 begin
    if Info <> nil then
     begin
       repeat
         ColorNum := GetColorNum(Event.Where);
         Color := SysPal^[ColorNum];
         with InfoData do
          begin
            Index := Longint(ColorNum);
            Red   := Longint(Color.Red);
            Green := Longint(Color.Green);
            Blue  := Longint(Color.Blue);
            Flags := Color.Flags shr 5;
            Used  := Longint(UsedCount[ColorNum]);
          end;
         Info^.SetData(InfoData);
         Info^.Show;
       until not MouseEvent(Event, evMouseMove);
       Info^.Hide;
     end;
 end;

begin { TPaletteView.HandleEvent }
  inherited HandleEvent(Event);
  if Event.What = evMouseDown then
   begin
     if Event.Buttons = 1
      then FlashColor
      else ShowInfo;
     ClearEvent(Event);
   end;
end;

procedure TPaletteView.Update; assembler;
var
  SaveDS: Word;
asm
            mov   [SaveDS],ds               { Save the global DS            }
            lds   si,[SysPal]               { DS:SI indexes hardware palette}
            les   di,[Self]                 { ES:DI indexes self            }
            mov   cx,256 * 2
            mov   dx,di                     { Save offset to Self in DX     }
            add   di,TPaletteView.OldPal    { ES:DI indexes Self.OldPal     }
@@1:        mov   ax,[es:di]                { Compare SysPal against OldPal }
            cmp   ax,[si]                   { for any changes               }
            jne   @@2                       { Found a change, so update     }
            add   si,2                      { Index next SysPal word        }
            add   di,2                      { Index next OldPal word        }
            loop  @@1
            jmp   @@4                       { No differences, so exit       }

@@2:        rep   movsw                     { Update OldPal                 }
            push  es                        { Push Self argument            }
            push  dx
            mov   ds,[SaveDS]               { Restore DS to global DS       }
            call  TView.DrawView;           { Re-draw ourselves             }
@@4:        mov   ds,[SaveDS]
end;

constructor TPaletteWindow.Init(var R: TRect; ABox, ARowCol: TPoint);
var
  P: PPaletteView;
begin
  P := New(PPaletteView, Init(R, ABox, ARowCol));
  Inc(R.B.Y);
  inherited Init(R, 'Hardware Palette', 0);
  Options := Options and not ofSelectable;
  Flags := wfMove;
  with SizeAdj do
    begin
      A.X := P^.SizeAdj.A.X - FrameSize;
      B.X := P^.SizeAdj.A.X + A.X;
      B.Y := P^.SizeAdj.B.Y - FrameSize;
      if Frame <> nil
       then Frame^.SizeAdj := SizeAdj;
    end;
  P^.MoveTo(0, 1);
  Insert(P);
  PalView := P;
end;

procedure TPaletteWindow.SizeLimits(var Min,Max: TPoint);
begin
  Min := Size;
  Max := Size;
end;

end.