ECHO OFF
REM ===========================================================
REM This batch file generates GVDEMO.EXE, which is an overlaid
REM version GVDEMO that also uses resource files.
REM ===========================================================

REM Compile then run the program which generates the resource file...

BPC /m/l /u\bp\gv\units;\bp\gv\tools;\bp\units; genrdemo
if errorlevel 1 goto fail
GENRDEMO
if errorlevel 1 goto fail

REM Compile the help file

CALL MH.BAT
if errorlevel 1 goto fail

REM ===========================================================
REM To compile this demo with debug information, use the
REM following line:

BPC /m/v/l /u\bp\gv\units;\bp\gv\tools;\bp\units; gvrdemo

REM Or use the following line to compile without debug info:
REM BPC /m/l /u\bp\gv\units;\bp\units gvrdemo

if errorlevel 1 goto fail

REM ===========================================================
REM To generate a Turbo Debugger .TDS file, use the command
REM line above to generate debug info, and remove the REMs
REM from the following 2 lines:

tdstrip -s gvrdemo
touch gvrdemo.tds

if errorlevel 1 goto fail

REM ===========================================================
REM Use the DOS COPY command to append the overlay file and
REM the resource file to the end of the EXE file.  You must
REM specify the /B (binary) option for the COPY command.

COPY /B gvrdemo.exe+gvrdemo.ovr+gvrdemo.gvr gvrdemo.exe
DEL gvrdemo.ovr
goto success

:fail
echo Error encountered building GVRDEMO.EXE

:success
