{***************************************************}
{                                                   }
{   Graphic Vision Demo                             }
{   Copyright (c) 1992 by Borland International and }
{   Copyright (c) 1996 Jason G Burgon               }
{                                                   }
{***************************************************}

{ Graphic Vision demo program. This program demonstrates the use of resource
  files and overlays to build a Graphic Vision application.  This program
  duplicates the functionality of GVDEMO but gets the definition of menus,
  status line, and various dialogs off of a resource file. GENRDEMO.PAS
  generates the resource file that is used by this program.  To build this
  program, execute the batch file,  MKRDEMO.BAT which will create the resource
  file and overlay file and copy them into the GVRDEMO.EXE file where this
  program looks for them.

  Note: The DEBUG conditional directive must be set when compiling for DPMI
        as the resource file cannot be appended to a DPMI .EXE file.
}

program GVRDemo;

{$F+,O+,X+,S-,G+}
{$M 16384,65536,655360}

uses
  Dos, GObjects, Font8x16, ScrnDriv, GDrivers, GMemory, GViews, GWindows,
  GMenus, GDialogs, BitMaps, GStdDlg, GHistLst, GMsgBox, GApp, DemoCmds,
  DemoStrs, Gadgets, Puzzle, Calendar, AsciiTab, GCalc, HelpFile, DemoHelp,
  GColors, MouseDlg, GEditors, ModeSlct {$IFNDEF DPMI} ,Overlay {$ENDIF};

{ If you get a FILE NOT FOUND error when compiling this program,
  use the MKRDEMO.BAT file described above.
}

{$G Font8x16}           { Always put linked-in fonts into their own segment }
{$G GObjects, GDrivers} { These two units are Fixed, Preload, Permanent     }
{$G ScrnDriv }          { Put ScrnDriv in its own segment for speed.        }
{$G GViews, GWindows, GMenus, Gapp, Gadgets, GVRDemo} { Group "hot" units.  }
{$O GDialogs } {$G GDialogs }
{$O GStdDlg  } {$G GStdDlg  }
{$O GMsgBox  } {$G GMsgBox  }
{$O GCalc    } {$G GCalc    }
{$O Calendar } {$G Calendar }
{$O GEditors } {$G GEditors }
{$O GColors  } {$G GColors  }
{$O MouseDlg } {$G MouseDlg }
{$O HelpFile } {$G HelpFile }
{$O ModeSlct } {$G ModeSlct }

const
  HeapSize = 100 * (1024 div 16);       { Save 100k heap for main program   }
  ColorsHistoryID = 1;                  { "Load colour palette" history ID  }

  { Desktop file signature information }
  SignatureLen = 21;
  DSKSignature : string[SignatureLen] = 'GV Demo Desktop File'#26;

var
  ClipWindow: PEditWindow;

type

 PImageBackground = ^TImageBackground;
 TImageBackground = object(TBitMapViewDIB)
   constructor Init(Bounds: TRect; const AFileName: PathStr);
 end;

 PNewDesktop = ^TNewDesktop;
 TNewDesktop = object(TDesktop)
   procedure HandleEvent(var Event: TEvent); virtual;
   procedure InitBackground; virtual;
 end;

  PGVDemo = ^TGVDemo;
  TGVDemo = object(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    constructor Init;
    function  CloseAll: boolean;
    procedure FileOpen(WildCard: PathStr);
    function  OpenEditor(FileName: FNameStr; Visible: Boolean;
                         Number: Word): PEditWindow;
    procedure GetEvent(var Event: TEvent); virtual;
    function GetPalette: PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitDesktop; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure LoadDesktop(var S: TStream);
    procedure OutOfMemory; virtual;
    procedure StoreDesktop(var S: TStream);
  end;

type
  PProtectedStream = ^TProtectedStream;
  TProtectedStream = object(TBufStream)
    procedure Error(Code, Info: Integer); virtual;
  end;

var
  RezFile: TResourceFile;
  RezStream: PStream;
  Strings: PStringList;

{ Stream Registration records }

const
  RImageBackground: TStreamRec = (
     ObjType: 40000;
     VmtLink: Ofs(TypeOf(TImageBackground)^);
     Load:    @TImageBackground.Load;
     Store:   @TImageBackground.Store
  );
const
  RNewDeskTop: TStreamRec = (
     ObjType: 40001;
     VmtLink: Ofs(TypeOf(TNewDeskTop)^);
     Load:    @TNewDeskTop.Load;
     Store:   @TNewDeskTop.Store
  );

{ CalcHelpName }

function CalcHelpName: PathStr;
begin
  CalcHelpName := ExePath + 'GVDEMO.HLP';
end;

{ Resource MessageBox wrappers }

function RMessageBox(StrNum: Word; Param: Pointer; Flags: Word): Word;
begin
  RMessageBox := MessageBox(Strings^.Get(StrNum), Param, Flags);
end;

function RMessageBoxRect(var Rect: TRect; StrNum: Word; Param: Pointer;
  Flags: Word): Word;
begin
  RMessageBoxRect := MessageBoxRect(Rect, Strings^.Get(StrNum), Param,
    Flags);
end;

{ Editor dialog call-back }

function DoEditDialog(Dialog: Integer; Info: Pointer): Word; far;
var
  R: TRect;
  T: TPoint;

  function ExecDialog(const Dialog: String; Param: Pointer): Word;
  begin
    ExecDialog := Application^.ExecuteDialog(PDialog(RezFile.Get(Dialog)),
                                             Param);
  end;

begin
  case Dialog of
    edOutOfMemory:
      DoEditDialog := RMessageBox(sNoMem, nil, mfError + mfOkButton);
    edReadError:
      DoEditDialog := RMessageBox(sErrorReading, @Info, mfError + mfOkButton);
    edWriteError:
      DoEditDialog := RMessageBox(sErrorWriting, @Info, mfError + mfOkButton);
    edCreateError:
      DoEditDialog := RMessageBox(sErrorCreating, @Info, mfError + mfOkButton);
    edSaveModify:
      DoEditDialog := RMessageBox(sModified, @Info,
                                  mfInformation + mfYesNoCancel);
    edSaveUntitled:
      DoEditDialog := RMessageBox(sSaveUntitled, nil,
                                  mfInformation + mfYesNoCancel);
    edSaveAs:
      DoEditDialog := ExecDialog('SaveAsDialog', Info);
    edFind:
      DoEditDialog := ExecDialog('FindDialog', Info);
    edSearchFailed:
      DoEditDialog := RMessageBox(sStrNotFound, nil, mfError + mfOkButton);
    edReplace:
      DoEditDialog := ExecDialog('ReplaceDialog', Info);
    edReplacePrompt:
      begin
        { Avoid placing the dialog on the same line as the cursor }
        R.Assign(0, 1, 40, 8);
        R.Move((Desktop^.Size.X - R.B.X) div 2, 0);
        Desktop^.MakeGlobal(R.B, T);
        Inc(T.Y);
        if TPoint(Info).Y <= T.Y then
          R.Move(0, Desktop^.Size.Y - R.B.Y - 2);
        DoEditDialog := RMessageBoxRect(R, sReplace, nil,
                                        mfYesNoCancel + mfInformation);
      end;
  end;
end;

{ TProtectedStream }

procedure TProtectedStream.Error(Code, Info: Integer);
begin
  DoneHistory;
  DoneSysError;
  DoneEvents;
  DoneVideo;
  DoneMemory;

  Writeln('Error in stream: Code = ', Code, ' Info = ', Info);
  Halt(1);
end;

{ TImageBackground }

constructor TImageBackground.Init(Bounds: TRect; const AFileName: PathStr);
var
  Adj: TRect;
begin
  Adj := ZR;
  inherited Init(Bounds, Adj, bmcClipCentre + bmcTileImages, 0,
                              bmpRoundToDac + bmpLoadPalette +
                              bmpRemoveDups + bmpSavePalette,
                              bmuSaveImage, AFileName);
  GrowMode := gfGrowHiX + gfGrowHiY;
  EventMask := 0;
end;

{ TNewDeskTop }

procedure TNewDeskTop.HandleEvent(var Event: TEvent);
var
  Menu : PMenu;
  PopUp: PMenuPopUp;
  R    : TRect;
  Res  : Word;
begin
  if (Event.What = evMouseDown) and (Event.Buttons = mbRightButton) and
     (TypeOf(DeskTop^.Current^) = TypeOf(TEditWindow)) then
   begin
     Longint(R.A) := 0;
     LongInt(R.B) := 0;
     Menu := NewMenu(
       StdEditMenuItems(
       NewLine(
       NewItem('~S~how clipboard', '', kbNoKey, cmShowClip, hcShowClip,
       nil))));
     New(PopUp, Init(R, Menu));
     Res := ExecView(PopUp);
     DisposeMenu(Menu);
     Dispose(PopUp, Done);
     ClearEvent(Event);
   end
   else inherited HandleEvent(Event);
end;

procedure TNewDeskTop.InitBackground;
var
  R: TRect;
begin
  GetExtent(R);
  Background := PBackground(RezFile.Get('BackGround'));
end;

{ TGVDemo }

constructor TGVDemo.Init;
var
  R       : TRect;
  I       : Integer;
  Event   : TEvent;
  Dir     : DirStr;
  Name    : NameStr;
  Ext     : ExtStr;
  FileName: PathStr;
begin
  ScreenMode := $101;
  RegisterFont(@Sys_8x16);  { Use the linked-in internal font               }
  MaxHeapSize := HeapSize;  { Initalize editor heap                         }

  { Initialize resource file }
  {$IFDEF DEBUG}
  FileName := ExePath + 'GVRDEMO.GVR';
  RezStream := New(PProtectedStream, Init(FileName, stOpenRead, 4096));
  {$ELSE}
  FileName := ExePath + 'GVRDEMO.EXE';
  RezStream := New(PProtectedStream, Init(FileName, stOpenRead, 4096));
  {$ENDIF}
  RezFile.Init(RezStream);

  RegisterObjects;
  RegisterViews;
  RegisterWindows;
  RegisterMenus;
  RegisterDialogs;
  RegisterApp;
  RegisterStdDlg;
  RegisterColors;
  RegisterBitMaps;
  RegisterType(RImageBackground);
  RegisterType(RNewDeskTop);

  RegisterModeSlct;
  RegisterMouseDlg;

  RegisterHelpFile;
  RegisterPuzzle;
  RegisterCalendar;
  RegisterAsciiTab;
  RegisterCalc;
  RegisterEditors;

  RegisterType(RStringList);

  Strings := PStringList(RezFile.Get('Strings'));

  inherited Init;

  { Initialize demo gadgets }

  GetExtent(R);
  R.A.X := R.B.X - 12; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);

  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);

  DisableCommands([cmSave, cmSaveAs, cmCut, cmCopy, cmPaste, cmClear,
    cmUndo, cmFind, cmReplace, cmSearchAgain]);
  EditorDialog := DoEditDialog;
  ClipWindow := OpenEditor('', False, wnNoNumber);
  if ClipWindow <> nil then
  begin
    Clipboard := ClipWindow^.Editor;
    Clipboard^.CanUndo := False;
  end;

  if ParamCount > 0 then
   for I := 1 to ParamCount do
    begin
      FileName := ParamStr(I);
      if FileName[Length(FileName)] = '\'
        then FileName := FileName + '*.*';
      if (Pos('?', FileName) = 0) and (Pos('*', FileName) = 0)
        then OpenEditor(FExpand(FileName), True, wnNoNumber+1)
        else FileOpen(FileName);
    end else
    begin
      Event.What := evCommand;
      Event.Command := cmAbout;
      PutEvent(Event);
    end;
end;

procedure TGVDemo.InitDeskTop;
var
  R: TRect;
begin
  GetExtent(R);
  Inc(R.A.Y);
  Dec(R.B.Y);
  DeskTop := New(PNewDesktop, Init(R));
end;

function TGVDemo.CloseAll: boolean;    { Graphic Vision can close all the   }
                                       { windows on the desktop (unlike     }
 procedure CloseView(P: PView); far;   { Turbo Vision) because of the better}
 begin                                 { TGroup.ForEach function            }
   Message(P, evCommand, cmClose, nil);
 end;

begin { TGVDemo.CloseAll }
 if Desktop^.Valid(cmClose) then
  begin
   DeskTop^.ForEach(@CloseView);
   CloseAll := true;
  end else
   CloseAll := false;
end;

function TGVDemo.OpenEditor(FileName: FNameStr; Visible: Boolean;
                            Number: Word): PEditWindow;
var
  P: PWindow;
  R: TRect;
begin
  DeskTop^.GetExtent(R);
  P := New(PEditWindow, Init(R, FileName, Number));
  if Assigned(P) then
   begin
    if not Visible
     then P^.Hide;
    P^.HelpCtx := hcViewer;
   end;
  OpenEditor := PEditWindow(InsertWindow(P));
end;

procedure TGVDemo.FileOpen(WildCard: PathStr);
var
  FileName: PathStr;
begin
  FileName := '*.*';
  if ExecuteDialog(PDialog(RezFile.Get('FileOpenDialog')),
                   @FileName) <> cmCancel
   then OpenEditor(FileName, True, wnNoNumber+1);
end;

procedure TGVDemo.GetEvent(var Event: TEvent);
var
  W: PWindow;
  HFile: PHelpFile;
  HelpStrm: PDosStream;
const
  HelpInUse: Boolean = False;
begin
  TApplication.GetEvent(Event);
  case Event.What of
    evCommand:
      if (Event.Command = cmHelp) and not HelpInUse then
      begin
        HelpInUse := True;
        HelpStrm := New(PDosStream, Init(CalcHelpName, stOpenRead));
        HFile := New(PHelpFile, Init(HelpStrm));
        if HelpStrm^.Status <> stOk then
        begin
          MessageBox('Could not open help file.', nil, mfError + mfOkButton);
          Dispose(HFile, Done);
        end
        else
        begin
          W := New(PHelpWindow,Init(HFile, GetHelpCtx));
          ExecuteDialog(PDialog(W), nil);
          ClearEvent(Event);
        end;
        HelpInUse := False;
      end;
    evMouseDown:
      if Event.Buttons <> 1 then Event.What := evNothing;
  end;
end;

function TGVDemo.GetPalette: PPalette;
const
  CNewColor = CColor + CHelpColor;
  CNewBlackWhite = CBlackWhite + CHelpBlackWhite;
  CNewMonochrome = CMonochrome + CHelpMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @P[AppPalette];
end;

procedure TGVDemo.HandleEvent(var Event: TEvent);

procedure ChangeDir;
begin
  ExecuteDialog(PDialog(RezFile.Get('ChDirDialog')), nil);
end;

procedure Puzzle;
begin
  InsertWindow(PWindow(RezFile.Get('Puzzle')));
end;

procedure Calendar;
begin
  InsertWindow(PWindow(RezFile.Get('Calendar')));
end;

procedure About;
begin
  ExecuteDialog(PDialog(RezFile.Get('About')), nil);
end;

procedure AsciiTab;
begin
  InsertWindow(PWindow(RezFile.Get('AsciiChart')));
end;

procedure Calculator;
begin
  InsertWindow(PWindow(RezFile.Get('Calculator')));
end;

procedure Colors;
var
  D         : PColorDialog;
  AppPal    : PPalette;
  OldAppPal : TPalette;
  OldRGBPal : TPalette16RGB;
begin
  AppPal    := Application^.GetPalette;     { Indexes Application's Palette }
  OldAppPal := AppPal^;                     { Save the Current App Palette  }
  GetRGBPalette(0, 16, @OldRGBPal);         { Save the current RGB Palette  }
  D:= PColorDialog(RezFile.Get('ColorSelectDialog')); { Get from Res file   }
  if D <> nil then
    if ExecuteDialog(D, @AppPal) = cmCancel then
      begin
        AppPal^ := OldAppPal;               { Restore previous App Palette  }
        SetRGBPalette(0, 16, @OldRGBPal);   { Restore Video Card Palette    }
        DoneMemory;                         { Dispose all group buffers     }
        ReDraw;                             { Redraw app with new palette   }
      end;
end;

procedure ChangeVideoMode;
var
  OldRGBPalette: PPalette256RGB;
  OldMaxColor  : word;
  OldMode      : word;
  Mode         : word;
  ModePtr      : ^word;
  P            : PVideoModeDlg;
begin
  ModePtr := @Mode;
  OldMode := ScreenMode;               { Save the current Video Mode        }
  P := PVideoModeDlg(RezFile.Get('VideoDialog'));
  if P = nil
   then exit;
  if (ExecuteDialog(P, ModePtr) <> cmCancel) and (Mode <> OldMode) then
    begin                              { A new video mode has been selected }
      OldMaxColor := GetMaxColor;
      if OldMaxColor > 2 then          { If the current mode has got a      }
        begin                          { hadware palette then save it       }
          New(OldRGBPalette);
          GetRGBPalette(0, OldMaxColor+1, OldRGBPalette);
        end else OldRGBPalette := nil;
      SetScreenMode(Mode);
      if (OldRGBPalette <> nil) AND (GetMaxColor = OldMaxColor){ restore    }
       then SetRGBPalette(0, OldMaxColor+1, OldRGBPalette);    { the palette}
      if OldRGBPalette <> nil then Dispose(OldRGBPalette);
    end;
end;

procedure Mouse;
begin
  ExecuteDialog(PDialog(RezFile.Get('Mouse')), nil);
end;

procedure RetrieveDesktop;
var
  Mode: word;
  S: TBufStream;
  AppPal: TPalette;
  VgaPal: TPalette16RGB;
  Signature: string[SignatureLen];
begin
  S.Init('GVDEMO.DSK', stOpenRead, 1024);
  if LowMemory
    then OutOfMemory
    else if S.Status <> stOk then
      MessageBox('Could not open desktop file', nil, mfOkButton + mfError)
  else
  begin
    Signature[0] := Char(SignatureLen);
    S.Read(Signature[1], SignatureLen);
    if Signature = DSKSignature then
    begin
      S.Read(Mode, SizeOf(word));
      SetScreenMode(Mode);
      if ReadPalette(S, @AppPal, @VgaPal) = stOk then
        begin
          GetPalette^ := AppPal;
          DoneMemory;
          LoadDesktop(S);
          LoadIndexes(S);
          LoadHistory(S);
          if S.Status <> stOk then
            MessageBox('Error reading desktop file', nil, mfOkButton + mfError);
        end;
    end else
      MessageBox('Error: Invalid Desktop file.', nil, mfOkButton + mfError);
  end;
  S.Done;
end;

procedure SaveDesktop;
var
  S: TBufStream;
  F: File;
begin
  S.Init('GVDEMO.DSK', stCreate, 1024);
  if not LowMemory and (S.Status = stOk) then
  begin
    S.Write(DSKSignature[1], SignatureLen);
    S.Write(ScreenMode, SizeOf(Word));
    StorePalette(S, Application^.GetPalette);
    StoreDesktop(S);
    StoreIndexes(S);
    StoreHistory(S);
    if S.Status <> stOk then
    begin
      MessageBox('Could not create GVDEMO.DSK.', nil, mfOkButton + mfError);
      {$I-}
      S.Done;
      Assign(F, 'GVDEMO.DSK');
      Erase(F);
      Exit;
    end;
  end;
  S.Done;
end;

procedure FastPageTest;
const
  sYes : String[3] = 'Yes';
  sNo  : String[2] = 'No';
var
  P    : PString;
begin
  P := @sYes;
  if ScrnDriv.SwitchTest
   then P := @sNo;
  RMessageBox(sFastPageTest, @P, mfInformation + mfOKButton);
end;

procedure FileNew;
begin
  OpenEditor('', True, wnNoNumber+1);
end;

procedure ShowClip;
begin
  ClipWindow^.Select;
  ClipWindow^.Show;
end;

begin { TGVDemo.HandleEvent }
  inherited HandleEvent(Event);
  case Event.What of
    evCommand:
      begin
        case Event.Command of
          cmOpen: FileOpen('*.*');
          cmNew: FileNew;
          cmCloseAll: CloseAll;
          cmShowClip: ShowClip;
          cmChangeDir: ChangeDir;
          cmAbout: About;
          cmPuzzle: Puzzle;
          cmCalendar: Calendar;
          cmAsciiTab: AsciiTab;
          cmCalculator: Calculator;
          cmColors: Colors;
          cmChangeMode: ChangeVideoMode;
          cmMouse: Mouse;
          cmSaveDesktop: SaveDesktop;
          cmRetrieveDesktop: RetrieveDesktop;
          cmFastPageTest: FastPageTest
        else
          Exit;
        end;
        ClearEvent(Event);
      end;
  end;
end;

procedure TGVDemo.Idle;

function IsTileable(P: PView): Boolean; far;
begin
  IsTileable := (P^.Options and ofTileable <> 0) and
    (P^.State and sfVisible <> 0);
end;

begin
  TApplication.Idle;
  Clock^.Update;
  Heap^.Update;
  if Desktop^.FirstThat(@IsTileable) <> nil then
    EnableCommands([cmTile, cmCascade])
  else
    DisableCommands([cmTile, cmCascade]);
end;

procedure TGVDemo.InitMenuBar;
var
  R: TRect;
begin
  MenuBar := PMenuBar(RezFile.Get('MenuBar'));
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar^.Locate(R);
end;

procedure TGVDemo.InitStatusLine;
var
  R: TRect;
begin
  StatusLine := PStatusLine(RezFile.Get('StatusLine'));
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine^.Locate(R);
end;

procedure TGVDemo.OutOfMemory;
begin
  RMessageBox(sNoMem, nil, mfError + mfOkButton);
end;

{ Since the safety pool is only large enough to guarantee that allocating
  a window will not run out of memory, loading the entire desktop without
  checking LowMemory could cause a heap error.  This means that each
  window should be read individually, instead of using Desktop's Load.
}

procedure TGVDemo.LoadDesktop(var S: TStream);
var
  P,T   : PView;

 procedure CloseView(P: PView); far;
 begin
   Message(P, evCommand, cmClose, nil);
 end;

begin
  if Desktop^.Valid(cmClose) then
   with Desktop^ do
     begin
       ForEach(@CloseView); { Clear the desktop }
       Lock;
       repeat
         P := PView(S.Get);
         Insert(ValidView(P));
       until P = nil;
       Draw;
       Unlock;
     end;
end;

procedure TGVDemo.StoreDesktop(var S: TStream);
var
  P: PView;
begin
  with Desktop^ do
   begin
     P := Last;
     repeat
       P := P^.PrevView;
       if (P = nil) or (P <> PView(ClipWindow))
         then S.Put(P);
     until P = nil;
   end;
end;

{$IFNDEF DPMI}
procedure OvrMessage;
const
  OvrMessage : array[ovrNoEMSMemory..ovrError] of String[53] = (
  'No EMS available for Overlays',
  'No EMS driver for Overlays',
  'Overlay file I/O error',
  'Not enough memory for overlay buffer',
  'Overlay file not found in .EXE file or .EXE directory',
  'Overlay manager error');
begin
  if (OvrResult > ovrError) or (OvrResult < ovrNoEMSMemory)
    then OvrResult := ovrError;
  PrintStr(OvrMessage[ovrResult] + #13#10);
  PrintStr('Unable to run program' + #13#10);
  Halt(1);
end;
{$ENDIF}

var
  Demo: TGVDemo;
begin
{$IFNDEF DPMI}
  OvrInit(ExePath + 'GVRDEMO.EXE');    { initialize overlay system. Look in }
  if OvrResult <> ovrOk then           { the .EXE first, then look in the   }
    OvrInit(ExePath + 'GVRDEMO.OVR');  { .EXE directory for a stand-alone   }
  if OvrResult = ovrOk then            { .OVR file.                         }
   begin
     OvrInitEMS;
     OvrSetBuf(OvrGetBuf  + (1024 * 48));
     OvrSetRetry(OvrGetBuf + (1024 * 48));
   end else OvrMessage;
  if OvrResult <> ovrOk then OvrMessage;
{$ENDIF}
  Demo.Init;
  Demo.Run;
  Demo.Done;
end.

