{***************************************************}
{                                                   }
{   Borland Pascal 7.0                              }
{   Graphic Vision BGI Support Demo                 }
{   Copyright (c) 1990 by Borland International and }
{   Copyright (c) 1995 Jason G Burgon               }
{                                                   }
{***************************************************}

program GVGRAPH;

{$M 8192,8192,655360}
{$S-}

{
  This simple Graphic Vision program shows how to draw graphics in a window.
  Note that for simplicity, the TGraphView view does not store information
  where the randomly generated circles are displayed or in what colours etc,
  so they break one of the golden rules of a GUI;  every view must be able
  to redraw itself at any time.  Dragging a view accoss a TGraphView will
  therefore "rub out" its filled circles.

  If you are running this program in the IDE, be sure to enable
  the full graphics save option when you load TURBO.EXE:

    turbo -g

  This ensures that the IDE fully swaps video RAM and keeps "dustclouds" from
  appearing on the user screen when in graphics mode. You can enable this
  option permanently via the Options|Environment|Startup dialog.
}

{$X+}

uses
  Dos, GObjects, Font8x16, ScrnDriv, GDrivers, GMemory, GViews,
  GWindows, GMenus, GDialogs, GStdDlg, GMsgBox, GApp, ModeSlct;

{$G Font8x16}      { Font units must be put in separate segments.           }
{$G ScrnDriv}      { Put this in its own segment for improved speed.        }

const
  cmNewWin      = 1000;
  cmChangeDir   = 1001;
  cmChangeMode  = 1002;
  cmPaintCircle = 1003;

  hlChangeDir  = 1;     { History list ID }

{ TGraphView Drawing modes }

type
  TGraphDrawMode = (dmNormal, dmFillCircle, dmContinue);


{ TGraphView }

type
  PGraphView = ^TGraphView;
  TGraphView = object(TView)
   DrawMode: TGraphDrawMode;
   Centre  : TPoint;
   Radius  : Word;
   Colors  : Word;
   Fill    : Byte;
   constructor Init(var R: TRect);
   procedure Draw; virtual;
   procedure HandleEvent(var Event: TEvent); virtual;
  end;

{ TGraphApp }

  PGraphApp = ^TGraphApp;
  TGraphApp = object(TApplication)
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure OutOfMemory; virtual;
  end;

{******************************** TGraphView *******************************}

constructor TGraphView.Init(var R: TRect);
begin
  R.Grow(-1, -1);
  inherited Init(R);
  SizeAdj.A.X := -(CharSize.X - FrameSize);
  SizeAdj.B.X := SizeAdj.A.X;
  SizeAdj.B.Y := -(CharSize.Y - FrameSize);
  GrowMode  := gfGrowHiX + gfGrowHiY;
  EventMask := EventMask or evBroadcast;
end;

procedure TGraphView.Draw;
var
  R  : TRect;
begin
  case DrawMode of
   dmNormal:                           { Just draw a "blank" window.        }
    inherited Draw;
   dmFillCircle:                       { Draw another random circle.        }
     begin
       GetPixExtent(R);
       SetColor(Random(White+1));
       SetBkColor(Random(White+1));
       Colors := InkPaper;
       Centre.X := Random(R.B.X - R.A.X);
       Centre.Y := Random(R.B.Y - R.A.Y);
       Radius   := Random(100);
       FillStyle:= Random(BricksFill+1);
       Fill     := FillStyle;
       FillCircle(Centre.X, Centre.Y, Radius);
       FillStyle := EmptyFill;
       DrawMode := dmContinue;         { We might only be doing partial draw}
    end;
   dmContinue:                         { Continue drawing the last circle in}
     begin                             { a view that has been fragmented by }
       SetColors(Colors);              { 1 or more views on top of it.      }
       FillStyle := Fill;
       FillCircle(Centre.X, Centre.Y, Radius);
       FillStyle := EmptyFill;
     end;
  end;
end;

procedure TGraphView.HandleEvent(var Event: TEvent);
begin
  if (Event.What = evBroadcast) and (Event.Command = cmPaintCircle) then
   begin
     DrawMode := dmFillCircle;
     DrawView;
     DrawMode := dmNormal;
   end else
  inherited HandleEvent(Event);
end;

{******************************** TGraphApp ********************************}

constructor TGraphApp.Init;
begin
  ScreenMode  := $101;      { All VGA monitors will support 640 x 480 x 256 }
  RegisterFont(@Sys_8x16);  { Use the linked-in internal font               }
  TApplication.Init;
end;

procedure TGraphApp.HandleEvent(var Event: TEvent);

procedure NewWin;
const
  WinNum: Word = 0;
var
  R: TRect;
  S: string[3];
  P: PWindow;
begin
  Str(WinNum, S);
  DeskTop^.GetExtent(R);
  with DeskTop^.Size do
    R.Assign(WinNum mod Pred(Y), WinNum mod Pred(Y), X, Y);
  Inc(WinNum);
  New(P, Init(R, 'Window ' + S, wnNoNumber));
  with P^ do
   begin
    Options := Options or ofTileable;
    GetExtent(R);
    Insert(New(PGraphView, Init(R)));
   end;
  InsertWindow(P);
end;

procedure ChangeDir;
var
  P: PView;
begin
  P := ValidView(New(PChDirDialog, Init(0, hlChangeDir)));
  if P <> nil then
  begin
    DeskTop^.ExecView(P);
    Dispose(P, Done);
  end;
end;

procedure ChangeMode;
var
  OldRGBPalette: PPalette256RGB;
  OldMaxColor  : Word;
  OldMode      : Word;
  Mode         : Word;
  ModePtr      : PWord;
  P            : PDialog;
begin
  ModePtr := @Mode;
  OldMode := ScreenMode;               { Save the current Video Mode        }
  P := New(PVideoModeDlg, Init);
  if (ExecuteDialog(New(PVideoModeDlg, Init), ModePtr) <> cmCancel) and
     (Mode <> OldMode) then
    begin                              { A new video mode has been selected }
      OldMaxColor := GetMaxColor;
      if OldMaxColor > 2 then          { If the current mode has got a      }
        begin                          { hardware palette then save it      }
          New(OldRGBPalette);
          GetRGBPalette(0, OldMaxColor+1, OldRGBPalette);
        end else OldRGBPalette := nil;
      SetScreenMode(Mode);
      if (OldRGBPalette <> nil) AND (GetMaxColor = OldMaxColor){ restore    }
       then SetRGBPalette(0, OldMaxColor+1, OldRGBPalette);    { the palette}
      if OldRGBPalette <> nil then Dispose(OldRGBPalette);
    end;
end;

begin
  TApplication.HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        cmNewWin    : NewWin;
        cmChangeDir : ChangeDir;
        cmChangeMode: ChangeMode;
      else
        Exit;
      end;
  else
    Exit;
  end;
  ClearEvent(Event);
end;

procedure TGraphApp.Idle;
var
  Event: TEvent;
begin
  inherited Idle;
  Event.What := evBroadcast;
  Event.Command := cmPaintCircle;
  HandleEvent(Event);
end;

procedure TGraphApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~T~est', hcNoContext, NewMenu(
      NewItem('~C~hange dir...', '', kbNoKey, cmChangeDir, hcNoContext,
      NewItem('~C~hange Video Mode...', '', kbNoKey, cmChangeMode, hcNoContext,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)))),
    NewSubMenu('~W~indows', hcNoContext, NewMenu(
      NewItem('~S~ize/move','Ctrl-F5', kbCtrlF5, cmResize, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~T~ile', '', kbNoKey, cmTile, hcNoContext,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcNoContext,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~P~revious', 'Shift-F6', kbShiftF6, cmPrev, hcNoContext,
      NewItem('~C~lose', 'Alt-F3', kbAltF3, cmClose, hcNoContext,
      NewLine(
    NewItem('Add ~w~indow','F4', kbF4, cmNewWin, hcNoContext,
      nil)))))))))),
    nil)))));
end;

procedure TGraphApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  New(StatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F4~ Add window', kbF4, cmNewWin,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbF5, cmZoom,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF6, cmNext,
      nil))))))),
    nil)));
end;

procedure TGraphApp.OutOfMemory;
begin
  MessageBox(#3'Out of memory.', nil, mfError or mfOkButton);
end;

{ Application object }

var
  GraphApp: TGraphApp;

{ Main Program }

begin
  GraphApp.Init;
  GraphApp.Run;
  GraphApp.Done;
end.
