{***************************************************}
{                                                   }
{   Turbo Pascal 7.0                                }
{   Graphic Vision Demo                             }
{   Copyright (c) 1990 by Borland International and }
{   Copyright (c) 1995 Jason G Burgon               }
{                                                   }
{***************************************************}

{ Resource generator for GVRDEMO.EXE. }

program GenRDemo;

{$M 16384,8192,655360}

uses Dos, GObjects, ScrnDriv, Font8x16, GDrivers, GMemory, GViews, GWindows,
     GMenus, BitMaps, GDialogs, GStdDlg, GHistLst, GMsgBox, GApp, GColors,
     MouseDlg, ModeSlct, DemoCmds, DemoStrs, Gadgets, Puzzle, Calendar,
     AsciiTab, GCalc, HelpFile, DemoHelp, GEditors
     {$IFDEF TESTPAL} ,PalView {$ENDIF};

const
  ColorsHistoryID = 1;                  { "Load colour palette" history ID  }
  DesktopImageFile ='GVDSKTOP.BMP';     { Image file name used for desktop. }
  HeapSize = 100 * 1024 div 16;         { Save 100k for normal heap memory. }

type
  PImageBackground = ^TImageBackground;
  TImageBackground = object(TBitMapViewDIB)
   constructor Init(Bounds: TRect; const AFileName: PathStr);
  end;

type
  PProtectedStream = ^TProtectedStream;
  TProtectedStream = object(TBufStream)
    procedure Error(Code, Info: Integer); virtual;
  end;

{ Stream Registration records }

const
  RImageBackground: TStreamRec = (
     ObjType: 40000;
     VmtLink: Ofs(TypeOf(TImageBackground)^);
     Load:    @TImageBackground.Load;
     Store:   @TImageBackground.Store
  );

var
  RezFile: TResourceFile;
  RezStream: PStream;
  App: TApplication;

{ TImageBackground }

constructor TImageBackground.Init(Bounds: TRect; const AFileName: PathStr);
var
  Adj: TRect;
begin
  Adj := ZR;
  inherited Init(Bounds, Adj, bmcClipCentre + bmcTileImages, 0,
                              bmpRoundToDac + bmpLoadPalette +
                              bmpRemoveDups + bmpSavePalette,
                              bmuSaveImage, AFileName);
  GrowMode := gfGrowHiX + gfGrowHiY;
  EventMask := 0;
end;

{ TProtectedStream }

procedure TProtectedStream.Error(Code, Info: Integer);
type
  TErrInfo = record
   Code: Longint;
   Info: Longint;
  end;
var
  ErrInfo: TErrInfo;
begin
  ErrInfo.Code := Code;
  ErrInfo.Info := Info;
  MessageBox('Error in stream: Code = %d'+ #13 + 'Info = $%x', @ErrInfo,
             mfError + mfOKButton);
  Dispose(RezStream, Done);
  App.Done;
  Halt(1);
end;

{ Resource procedures }

procedure CreateStrings;
var
  S: PStrListMaker;
begin
  S := New(PStrListMaker, Init(10000, 100));
  with S^ do
   begin
     Put(sNoMem, 'Not enough memory available to compilete operation.');
     Put(sErrorReading, 'Error reading file %s.');
     Put(sErrorWriting, 'Error writing file %s.');
     Put(sErrorCreating, 'Error creating file %s.');
     Put(sModified, '%s has been modified. Save?');
     Put(sSaveUntitled, 'Save untitled file?');
     Put(sStrNotFound, 'Search string not found.');
     Put(sReplace, 'Replace this occurence?');
     Put(sErrorHelp, 'Could not open help file.');
     Put(sErrorOpenDesk, 'Could not open desktop file');
     Put(sErrorReadingDesk, 'Error reading desktop file');
     Put(sDeskInvalid, 'Error: Invalid Desktop file.');
     Put(sErrorDeskCreate, 'Could not create GVDEMO.DSK.');
     Put(sFastPageTest, 'Fast Page Switch Support: %s');
   end;
  RezFile.Put(S, 'Strings');
  Dispose(S, Done);
end;

procedure CreateBackground;
var
  R: TRect;
  P: PImageBackground;
begin
  Desktop^.GetExtent(R);
  New(P, Init(R, ExePath+DesktopImageFile));
  RezFile.Put(P, 'BackGround');
  Dispose(P, Done);
end;

procedure CreateMenu;
var
  R: TRect;
  P: PView;
begin
  R.Assign(0, 0, 80, 1);
  P := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~'#240'~', hcSystem, NewMenu(
      NewItem('~A~bout', '', kbNoKey, cmAbout, hcSAbout,
      NewLine(
      NewItem('~P~uzzle', '', kbNoKey, cmPuzzle, hcSPuzzle,
      NewItem('Ca~l~endar', '', kbNoKey, cmCalendar, hcSCalendar,
      NewItem('Ascii ~t~able', '', kbNoKey, cmAsciiTab, hcSAsciiTable,
      NewItem('~C~alculator', '', kbNoKey, cmCalculator, hcCalculator, nil))))))),
    NewSubMenu('~F~ile', hcFile, NewMenu(
      StdFileMenuItems(nil)),
    NewSubMenu('~E~dit', hcEdit, NewMenu(
      StdEditMenuItems(
      NewLine(
      NewItem('~S~how clipboard', '', kbNoKey, cmShowClip, hcShowClip,
      nil)))),
    NewSubMenu('~S~earch', hcSearch, NewMenu(
      NewItem('~F~ind...', '', kbNoKey, cmFind, hcFind,
      NewItem('~R~eplace...', '', kbNoKey, cmReplace, hcReplace,
      NewItem('~S~earch again', '', kbNoKey, cmSearchAgain, hcSearchAgain,
      nil)))),
    NewSubMenu('~W~indow', hcWindows, NewMenu(
      StdWindowMenuItems(nil)),
    NewSubMenu('~O~ptions', hcOptions, NewMenu(
      NewItem('~M~ouse...', '', kbNoKey, cmMouse, hcOMouse,
      NewItem('~C~olors...', '', kbNoKey, cmColors, hcOColors,
      NewItem('~V~ideo Mode...','',kbNoKey, cmChangeMode, hcNoContext,
      NewLine(
      NewItem('~S~ave desktop', '', kbNoKey, cmSaveDesktop, hcOSaveDesktop,
      NewItem('~R~etrieve desktop', '', kbNoKey, cmRetrieveDesktop, hcORestoreDesktop,
      NewLine(
      NewItem('~F~ast Switch Test...', '', kbNoKey, cmFastPageTest, hcNoContext,
      nil))))))))),
    nil)))))))));
  RezFile.Put(P, 'MenuBar');
  Dispose(P, Done);
end;

procedure CreateStatusLine;
var
  R: TRect;
  P: PView;
begin
  R.Assign(0, 24, 80, 25);
  P := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F1~ Help', kbF1, cmHelp,
      NewStatusKey('~F3~ Open', kbF3, cmOpen,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      NewStatusKey('~F5~ Zoom', kbF5, cmZoom,
      NewStatusKey('', kbF2, cmSave,
      NewStatusKey('', kbF6, cmNext,
      NewStatusKey('', kbShiftF6, cmPrev,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbCtrlF5, cmResize,
      nil)))))))))),
    nil)));
  RezFile.Put(P, 'StatusLine');
  Dispose(P, Done);
end;

procedure CreateFileOpenDialog;
var
  P: PView;
begin
  P := New(PFileDialog, Init('*.*', 'Open a File',
    '~N~ame', fdOpenButton + fdHelpButton + fdNoLoadDir, 100));
  P^.HelpCtx := hcFOFileOpenDBox;

  RezFile.Put(P, 'FileOpenDialog');
  Dispose(P, Done);
end;

procedure CreateFileSaveAsDialog;
var
  P: PView;
begin
  P := New(PFileDialog, Init('*.*', 'Save File As',
    '~N~ame', fdOpenButton + fdHelpButton + fdNoLoadDir, 100));
  P^.HelpCtx := hcSaveAs;

  RezFile.Put(P, 'FileSaveAsDialog');
  Dispose(P, Done);
end;

procedure CreateAboutDialog; { Construct the "About" dialog, including the  }
var                          { Windows .BMP in the resorce file by passing  }
  D: PDialog;                { bmuSaveImage to PBitMapViewDIB init.         }
  Control: PView;
  R: TRect;
begin
  R.Assign(0, 0, 45, 13);
  D := New(PDialog, Init(R, 'About'));
  with D^ do
  begin
    Options := Options or ofCentered;
    Inc(SizeAdj.B.Y, CharSize.Y shr 1);          { Move the bottom of the   }
    Inc(Frame^.SizeAdj.B.Y, CharSize.Y shr 1);   { dialog box up by half a  }
    R.Grow(-2, -2);                              { character                }
    Dec(R.B.Y, 1);
    Control := New(PPanel, Init(R, 2, 0, true)); { Insert a sunken panel    }
    with Control^.SizeAdj do
     begin
       Dec(A.Y, CharSize.Y shr 1);               { adjust its (pixel) size  }
       Inc(B.Y, CharSize.Y shr 2);               { so it looks pretty       }
      end;
    Insert(Control);
    R.Move(1, 0);
    Control := New(PBitMapViewDIB, Init(R, ZR, 0, 0{bmoUseHeapMem},
                                        bmpLoadPalette + bmpSavePalette +
                                        bmpNoUseSys    + bmpRemoveDups  +
                                        bmpRoundToDac,
                                        bmuSaveImage,
                                        ExePath + 'ABOUT.BMP'));
    Insert(Control);
    R.Assign(17, 10, 27, 12);                    { Insert an OK button      }
    Control := New(PButton, Init(R, 'O~K~', cmOk, bfDefault));
    with Control^.SizeAdj do
     begin
       Inc(A.Y, 2);                              { adjust its (pixel) size  }
       Dec(B.Y, 2);                              { so it looks pretty       }
     end;
    Insert(Control);
  end;
  RezFile.Put(D, 'About');
  Dispose(D, Done);
end;

procedure CreateCalculator;
var
  P: PCalculator;
begin
  New(P, Init);
  P^.HelpCtx := hcCalculator;
  RezFile.Put(P, 'Calculator');
  Dispose(P, Done);
end;

procedure CreatePuzzle;
var
  P: PPuzzleWindow;
begin
  New(P, Init);
  P^.HelpCtx := hcPuzzle;
  RezFile.Put(P, 'Puzzle');
  Dispose(P, Done);
end;

procedure CreateColorSelDialog;
var
  R: TRect;
  D: PDialog;
  AppPal : PPalette;
begin
  D := New(PColorDialog, Init(Application^.GetPalette,
    ColorGroup('Desktop', DesktopColorItems(nil),
    ColorGroup('Menu/Statusline',MenuColorItems(nil),
    ColorGroup('Dialogs & Calc', DialogColorItems(nil),
    ColorGroup('File Editor',    WindowColorItems(wpBlueWindow, nil),
    ColorGroup('Calendar',       CalendarColorItems(wpCyanWindow),
    ColorGroup('Ascii table',    WindowColorItems(wpGrayWindow, nil),
    ColorGroup('Help Window',    HelpWindowColorItems(nil),
    nil))))))), ColorsHistoryID));
  D^.HelpCtx := hcOCColorsDBox;
  RezFile.Put(D, 'ColorSelectDialog');
  Dispose(D, Done);
end;

procedure CreateChDirDialog;
var
  R: TRect;
  D: PDialog;
begin
  D := New(PChDirDialog, Init(cdNormal + cdHelpButton + cdNoLoadDir, 101));
  D^.HelpCtx := hcFCChDirDBox;

  RezFile.Put(D, 'ChDirDialog');
  Dispose(D, Done);
end;

procedure CreateSaveAsDialog;
var
  D: PDialog;
begin
  D := New(PFileDialog, Init('*.*', 'Save file as', '~N~ame',
    fdOkButton + fdHelpButton + fdNoLoadDir, 101));
  RezFile.Put(D, 'SaveAsDialog');
  Dispose(D, Done);
end;

procedure CreateCalendar;              { Create a calendar.  The actual     }
var                                    { Windows bitmaps are not stored in  }
  P : PWindow;                         { the resource file.  This means the }
begin                                  { NAUGHTY.BMP and NICE.BMP files     }
  P := New(PCalendarWindow, Init);     { must reside in the .EXE directory. }
  P^.HelpCtx := hcCalendar;
  RezFile.Put(P, 'Calendar');
  Dispose(P, Done);
end;

procedure CreateAsciiChart;
var
  P : PWindow;
begin
  P := New(PAsciiChart, Init);
  P^.HelpCtx := hcAsciiTable;
  RezFile.Put(P, 'AsciiChart');
  Dispose(P, Done);
end;

procedure CreateMouseDialog;
var
  D: PDialog;
begin
  D := New(PMouseDialog, Init);
  D^.HelpCtx := hcOMMouseDBox;
  RezFile.Put(D, 'Mouse');
  Dispose(D, Done);
end;

procedure CreateVideoDialog;
var
  D: PDialog;
begin
  D := New(PVideoModeDlg, Init);
  D^.HelpCtx := hcOMMouseDBox;
  RezFile.Put(D, 'VideoDialog');
  Dispose(D, Done);
end;

procedure CreateEditDialogs;
var
  D: PDialog;
begin
  D := CreateFindDialog;
  RezFile.Put(D, 'FindDialog');
  Dispose(D, Done);
  D := CreateReplaceDialog;
  RezFile.Put(D, 'ReplaceDialog');
  Dispose(D, Done);
end;

begin
  MaxHeapSize:= HeapSize;

 { Set a screen mode and initialize and switch to graphics mode. This makes }
 { sure the video-mode-dependant variables have proper values.  This is     }
 { important because many of the objects Init methods make calculations on  }
 { some of these variables.                                                 }

  ScreenMode := $101;
  App.Init;

 { Initialize the stream we are going to use to write the resource file.    }

  RezStream := New(PProtectedStream, Init('GVRDEMO.GVR', stCreate, 4096));
  RezFile.Init(RezStream);

 { Register all the objects we are going to store on the stream.            }

  RegisterObjects;
  RegisterType(RStrListMaker);
  RegisterViews;
  RegisterWindows;
  RegisterMenus;
  RegisterDialogs;
  RegisterType(RImageBackground);
  RegisterBitMaps;
  RegisterStdDlg;
  RegisterColors;
  RegisterModeSlct;
  RegisterMouseDlg;
  RegisterCalc;
  RegisterPuzzle;
  RegisterCalendar;
  RegisterASCIITab;

 { We can now create our resources and store them in the resource file.     }

  CreateStrings;
  CreateMenu;
  CreateStatusLine;
  CreateBackground;
  CreateFileOpenDialog;
  CreateFileSaveAsDialog;
  CreateAboutDialog;
  CreateColorSelDialog;
  CreateChDirDialog;
  CreateSaveAsDialog;
  CreateCalculator;
  CreatePuzzle;
  CreateCalendar;
  CreateAsciiChart;
  CreateMouseDialog;
  CreateVideoDialog;
  CreateEditDialogs;

 { Close the stream and tidy up.                                            }

  RezFile.Done;
  App.Done;
end.