{************************************************}
{                                                }
{   Turbo Pascal 7.0                             }
{   Graphic Vision Demo                          }
{   Copyright (c) 1992 Borland International and }
{   Copyright (c) 1995 Jason G Burgon            }
{                                                }
{************************************************}

unit Gadgets;

{$S-,X+,I-}
{$IFNDEF DPMI}
{$F+}
{$ENDIF}

{ Useful gadgets: clock and heap available viewer }

interface

uses Dos, GObjects, GViews, GApp;

type
  PHeapView = ^THeapView;
  THeapView = object(TView)
    OldMem : LongInt;
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    procedure Update;
  end;

  PClockView = ^TClockView;
  TClockView = object(TView)
    Refresh: Byte;
    am     : Char;
    LastTime: DateTime;
    TimeStr: string[10];
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    function FormatTimeStr(H, M, S: Word): string; virtual;
    procedure Update; virtual;
  end;

implementation
uses ScrnDriv, GDrivers;

{------ Heap Window object ----------}

constructor THeapView.Init(var Bounds: TRect);
begin
  Bounds.A.X := Bounds.B.X - 12;
  TView.Init(Bounds);
  OldMem := 0;
  GrowMode := gfGrowAll;
end;

procedure THeapView.Draw;
var
  R       : TRect;
  Num, Loc: Byte;
  S, T    : String[40];

function Comma(N: Longint): String; near;
begin
  Str (N, S);
  Str (N:Size.X, T);
  num := length(S) div 3;
  if (Length(S) mod 3) = 0
   then Dec (Num);
  Delete(T,1,Num);
  Loc := Length(T)-2;
  while Num > 0 do
  begin
    Insert (',',T,Loc);
    Dec (Num);
    Dec (Loc,3);
  end;
  Comma := T;
end;

begin
  OldMem := MemAvail;
  GetPixExtent(R);
  DrawStrRect(R, Comma(OldMem), 2, doMapCols + doSetBack + doVCentred);
  Line(R.A.X, R.A.Y, R.A.X, R.B.Y-1);
  Line(R.A.X, R.A.Y, R.B.X-1, R.A.Y);
end;

procedure THeapView.Update;
begin
  if (OldMem <> MemAvail)
    then DrawView;
end;

{-------- ClockView Object --------}

function LeadingZero(W: Word): String; near;
var S: String;
begin
  Str(W:0, S);
  LeadingZero := Copy('00', 1, 2 - Length(S)) + S;
end;

constructor TClockView.Init(var Bounds: TRect);
begin
  Bounds.A.X  := Bounds.B.X - 13;
  TView.Init(Bounds);
  GrowMode := gfGrowLoX + gfGrowHiX;
  FillChar(LastTime, SizeOf(LastTime), #$FF);
  TimeStr := '';
  Refresh := 1;
end;

procedure TClockView.Draw;
var
  R: TRect;
begin
  GetPixExtent(R);  Dec(R.A.Y);
  DrawStrRect(R, ' ' + TimeStr + ' '+am+'m ', 2,
              doMapCols + doSetBack + doVCentred);
  Dec(R.B.X); Dec(R.B.Y);
  Line(R.A.X, R.A.Y, R.A.X, R.B.Y);
  Line(R.A.X, R.B.Y, R.B.X, R.B.Y);
end;

procedure TClockView.Update;
var
  h,m,s,hund: word;
begin
  GetTime(h,m,s,hund);
  if Abs(LongInt(s) - LastTime.sec) >= Refresh then
  begin
    with LastTime do
    begin
      Hour := h;
      Min := m;
      Sec := s;
    end;
    TimeStr := FormatTimeStr(h, m, s);
    DrawView;
  end;
end;

function TClockView.FormatTimeStr (h,m,s: Word) : String;
begin
  if h = 0 then
  begin
    h := 12;
    am := 'a';
  end
  else if h > 12 then
  begin
    dec (h,12);
    am := 'p';
  end
  else am := 'a';
  FormatTimeStr := LeadingZero(h)+ ':'+ LeadingZero(m) +
    ':' + LeadingZero(s);
end;
end.
