{***************************************************}
{                                                   }
{   Turbo Pascal 6.0                                }
{   Graphic Vision Demo                             }
{   Copyright (c) 1990 by Borland International and }
{   Copyright (c) 1995 Jason G Burgon               }
{                                                   }
{***************************************************}

unit FViewer;

{
 FileViewer object for scrolling through text files. See
 FVIEWER.PAS for an example program that uses this unit.
}

{$X+,S-}
{$IFNDEF DPMI} {$F+,O+} {$ENDIF}

interface

uses Dos, GObjects, LineColl, GViews, GWindows;

const TabSize: byte = 8;  { Tab positions at every 8'th column }
type

  { TFileViewer }

  PFileViewer = ^TFileViewer;
  TFileViewer = object(TScroller)
    FileName: PString;
    FileLines: PCollection;
    IsValid: Boolean;
    constructor Init(var Bounds: TRect; AHScrollBar, AVScrollBar: PScrollBar;
      var AFileName: PathStr);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure Draw; virtual;
    function  FormatLine(const Line: String): String;
    procedure ReadFile(var FName: PathStr);
    procedure SetState(AState: Word; Enable: Boolean); virtual;
    procedure Store(var S: TStream);
    function Valid(Command: Word): Boolean; virtual;
  end;

  { TFileWindow }

  PFileWindow = ^TFileWindow;
  TFileWindow = object(TWindow)
    constructor Init(var FileName: PathStr);
  end;

const

  RFileViewer: TStreamRec = (
     ObjType: 10080;
     VmtLink: Ofs(TypeOf(TFileViewer)^);
     Load:    @TFileViewer.Load;
     Store:   @TFileViewer.Store
  );
  RFileWindow: TStreamRec = (
     ObjType: 10081;
     VmtLink: Ofs(TypeOf(TFileWindow)^);
     Load:    @TFileWindow.Load;
     Store:   @TFileWindow.Store
  );

procedure RegisterFViewer;

implementation

uses GDrivers, Memory, GMsgBox, GApp;

const
 Tab: Char = #9;

{ TFileViewer }
constructor TFileViewer.Init(var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar; var AFileName: PathStr);
begin
  TScroller.Init(Bounds, AHScrollbar, AVScrollBar);
  ID := 10080;
  GrowMode := gfGrowHiX + gfGrowHiY;
  FileName := nil;
  ReadFile(AFileName);
end;

constructor TFileViewer.Load(var S: TStream);
var
  FName: PathStr;
begin
  TScroller.Load(S);
  FileName := S.ReadStr;
  FName := FileName^;
  ReadFile(FName);
end;

destructor TFileViewer.Done;
begin
  Dispose(FileLines, Done);
  TScroller.Done;
end;

procedure TFileViewer.Draw;
var
  C: Word;
  I: Integer;
  P: PString;
  R: TRect;
  S: String;
begin
  C := MapColor(1);
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  for I := 0 to Size.Y - 1 do
  begin
    if Delta.Y + I < FileLines^.Count then
     begin
       P := FileLines^.At(Delta.Y + I);
       if P <> nil then S := Copy(FormatLine(P^), Delta.X + 1, Size.X)
                   else S := '';
     end else S := '';
    DrawStrRect(R, S, C, doSetBack + doCharCell);
    Inc(R.A.Y); Inc(R.B.Y);
  end;
end;

function TFileViewer.FormatLine(const Line: String): String;
var
  S: String;                 { FormatLine takes a line with tab characters  }
  Src, Dest: ^Char;          { in it and converts them to the appropriate   }
  i: word;                   { number spaces in it, based on the TabSize    }
  F: byte;                   { global variable.                             }
begin
  if Length(Line) > 0 then
   begin
    Src := @Line[1];
    Dest:= @S;
    Byte(Dest^) := 0;
    Inc(PtrRec(Dest).Ofs, 1);
    for i := 1 to Length(Line) do
     begin
       if Src^ = Tab then
        begin
         F := TabSize - (Length(S) mod TabSize);
         FillChar(Dest^, F, ' ');
         Inc(PtrRec(Dest).Ofs, F);
         Inc(Byte(S[0]), F);
        end else
        begin
         Dest^ := Src^;
         Inc(PtrRec(Dest).Ofs, 1);
         Inc(Byte(S[0]), 1);
        end;
      Inc(PtrRec(Src).Ofs, 1);
     end;
    FormatLine := S;
  end else FormatLine := '';
end;

procedure TFileViewer.ReadFile(var FName: PathStr);
var
  FileToView: Text;
  Line: String;
  MaxWidth: Integer;
  E: TEvent;
begin
  IsValid := True;
  if FileName <> nil then DisposeStr(FileName);
  FileName := NewStr(FName);
  FileLines := New(PLineCollection, Init(5,5));
  {$I-}
  Assign(FileToView, FName);
  Reset(FileToView);
  if IOResult <> 0 then
  begin
    MessageBox('Cannot open file '+FName+'.', nil, mfError + mfOkButton);
    IsValid := False;
  end
  else
  begin
    MaxWidth := 0;
    while not Eof(FileToView) and not LowMemory do
    begin
      Readln(FileToView, Line);
      Line := FormatLine(Line);
      if Length(Line) > MaxWidth then MaxWidth := Length(Line);
      FileLines^.Insert(NewStr(Line));
    end;
    Close(FileToView);
  end;
  {$I+}
  Limit.X := MaxWidth;
  Limit.Y := FileLines^.Count;
end;

procedure TFileViewer.SetState(AState: Word; Enable: Boolean);
begin
  TScroller.SetState(AState, Enable);
  if Enable and (AState and sfExposed <> 0) then
     SetLimit(Limit.X, Limit.Y);
end;

procedure TFileViewer.Store(var S: TStream);
begin
  TScroller.Store(S);
  S.WriteStr(FileName);
end;

function TFileViewer.Valid(Command: Word): Boolean;
begin
  Valid := IsValid;
end;

{ TFileWindow }

constructor TFileWindow.Init(var FileName: PathStr);
const
  WinNumber: Integer = 1;
var
  R: TRect;
  F: PFileViewer;
begin
  Desktop^.GetExtent(R);
  TWindow.Init(R, Filename, WinNumber);
  ID := 10081;
  Options := Options or ofTileable;
  Inc(WinNumber);
  GetExtent(R);
  F := New(PFileViewer, Init(R,
   StandardScrollBar(sbHorizontal+sbHandleKeyboard+sbUpdateOnTrack),
   StandardScrollBar(sbVertical+sbHandleKeyboard+sbUpdateOnTrack),Filename));
  Inc(R.A.X, 1);                                 { Remove 1 for the frame   }
  Inc(R.A.Y, F^.VScrollBar^.Origin.Y);           { Set the size of the      }
  Dec(R.B.X, F^.VScrollBar^.Size.X);             { FileViewer, taking the   }
  Dec(R.B.Y, F^.HScrollBar^.Size.Y);             { size of the scrollbars   }
  F^.Locate(R);                                  { into account.            }
  Insert(F);
end;

procedure RegisterFViewer;
begin
  RegisterType(RFileViewer);
  RegisterType(RFileWindow);
end;

end.
