/*
 * Copyright (c) 1995 by Sun Microsystems, Inc.
 */

#ifndef __SUNMSG_H__
#define	__SUNMSG_H__

//  The following enum represents WPARAM's  for a registered windows message of "SunDialerMessage" 
//  (i.e. const UINT WM_DIALER_MESSAGE = ::RegisterWindowMessage("SunDialerMessage");).
//  If you use the SUN_CONNECT and SUN_DISCONNECT WPARAMS for the "SunDialerMessage 
//	and you use the HWND_BROADCAST of SendMessage,the Remote Link Manager upon reception of the  
//  message will either connect or disconnect accordingly.   
//  Once connected the Remote Link manager will send a SUN_CONFIRM_CONNECT as an HWND_BROADCAST 
//  of the "SunDialerMessage" to all apps  and will have an LPARAM of 0 if connected. 
//  If there is an error a t.b.d. error message number will be returned. 
//  After disconnecting, a SUN_CONFIRM_DISCONNECT is also sent as an 
//	HWND_BROADCAST of the "SunDialerMessage" to all apps.  The LPARAM value will be set to 0 
//  if all is well and to a t.b.d. error message if there is an error.

enum // WPARAMS of the "SunDialerMessage"
{
	SUN_CONNECT = 1,
	SUN_DISCONNECT,
	SUN_CONFIRM_CONNECT,
	SUN_CONFIRM_DISCONNECT,
	SUN_EXIT
};

#endif  __SUNMSG_H__