unit IcoTypes;
{Data types used in reading/writing .ICO, .EXE, and .DLL files}
interface
TYPE
  {details of DOS header structure aren't important to us,
   so we just read the first 64 (40h) bytes}
  TDOSHeader = ARRAY[0..$3F] OF Byte;

  TNEHeader = RECORD
    {New Executable file header}
    Signature                      : Word;
    LinkerVersion,
    LinkerRevision                 : Byte;
    EntryTableRelOffset,
    EntryTableLength               : Word;
    Reserved                       : LongInt;
    Flags,
    AutomaticDSegNumber,
    LocalHeapSize,
    StackSize                      : Word;
    CSIP,
    SSSP                           : Pointer;
    SegmentTableNumEntries,
    ModuleReferenceTableNumEntries,
    NonresidentNameTableSize,
    SegmentTableRelOffset,
    ResourceTableRelOffset,
    ResidentNameTableRelOffset,
    ModuleReferenceTableRelOffset,
    ImportedNameTableRelOffset     : Word;
    NonresidentNameTableOffset     : LongInt;
    NumberOfMovableEntryPoints,
    ShiftCount,
    NumberOfResourceSegments       : Word;
    TargetOS,
    AdditionalInfo                 : Byte;
    FastLoadAreaOffset,
    FastLoadAreaSectors,
    Reserved2,
    ExpectedWindowsVersion         : Word;
  END;

  ResTypeInfo = RECORD
  {Resource Type Info header}
    rtTypeId,
    rtResourceCount : Word;
    rtReserved      : LongInt;
  END;

  NameInfo = RECORD
  {Resource Table info for one resource}
    niOffset,
    niLength,
    niFlags,
    niID,
    niHandle,
    niUsage   : Word;
  END;

  IconDirEntryShort = RECORD
  {icon directory resource contains one or more of these}
    bWidth,
    bHeight,
    bColorCount,
    bReserved : Byte;
    wPlanes,
    wBitCount : Word;
    dwBytesInRes : LongInt;
    wID : Word;
    {In an icon resource within an .EXE or .DLL file,
     the last field is replaced by a Word that represents
     the ID of this image in the resource table}
  End;

  IconDirEXE = record
  {structure of icon directory resource. actual number of idEntries
   is determins by idCount}
    idReserved : Word;
    idType     : Word;
    idCount    : Word;
    idEntries  : ARRAY[0..11] OF IconDirEntryShort;
  END;

  IconDirectoryEntry = RECORD
  {.ICO icon directory contains one or more of these}
    bWidth,
    bHeight,
    bColorCount,
    bReserved : Byte;
    wPlanes,
    wBitCount : Word;
    dwBytesInRes,
    dwImageOffset : LongInt;
  End;

  IconDirICO = record
  {structure of .ICO header. actual number of idEntries
   is determins by idCount}
    idReserved : Word;
    idType     : Word;
    idCount    : Word;
    idEntries  : ARRAY[0..11] OF IconDirectoryEntry;
  END;

  ICONDIR = record
  {Icon directory header}
    idReserved : Word;
    idType     : Word;
    idCount    : Word;
  END;

  TCursorIconInfo = record
  {undocumented structure is header for icon handle}
    HotSpotX,
    HotSpotY,
    Width,
    Height,
    WidthBytes : Word;
    Planes     : Byte;
    BitsPix    : Byte;
  END;
implementation

end.
