@rem *************************************************************************
@rem
@rem  Module: SMTNDIS.DOS
@rem
@rem                  Copyright (c) Madge Networks Ltd. 1994
@rem
@rem Version: 1.01
@rem
@rem *************************************************************************

@echo off
echo.
echo MADGE SMTNDIS.DOS Creation Utility v1.00
echo       Copyright (c) Madge Networks Ltd. 1994
echo.

if [%1] == [] goto Help
if [%1] == [/?] goto Help
if [%1] == [-?] goto Help
if [%1] == [?] goto Help

set FromPath=%1\

if [%2] == [] goto NoToPath
set ToPath=%2\

set DriverName=SMTNDIS.DOS
set ProtocolList=ndis
set ModuleList0=%FromPath%smart.exe %FromPath%smart.cfg %FromPath%ndis.smt
set ModuleList1=
set ModuleList2=
set ModuleList3=

if not exist %FromPath%smart.exe goto NoSmartEXE
if not exist %FromPath%smart.cfg goto NoSmartCFG
if not exist %FromPath%ndis.smt goto NoNDIS

shift
shift

if [%1] == [] goto FoundAllModules
set Protocol=%1
set SmtModule=%1.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList1=%ModuleList1% %FromPath%%SmtModule%

if [%2] == [] goto FoundAllModules
set Protocol=%2
set SmtModule=%2.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList1=%ModuleList1% %FromPath%%SmtModule%

if [%3] == [] goto FoundAllModules
set Protocol=%3
set SmtModule=%3.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList1=%ModuleList1% %FromPath%%SmtModule%

if [%4] == [] goto FoundAllModules
set Protocol=%4
set SmtModule=%4.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList2=%ModuleList2% %FromPath%%SmtModule%

if [%5] == [] goto FoundAllModules
set Protocol=%5
set SmtModule=%5.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList2=%ModuleList2% %FromPath%%SmtModule%

if [%6] == [] goto FoundAllModules
set Protocol=%6
set SmtModule=%6.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList2=%ModuleList2% %FromPath%%SmtModule%

if [%7] == [] goto FoundAllModules
set Protocol=%7
set SmtModule=%7.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList3=%ModuleList3% %FromPath%%SmtModule%

if [%8] == [] goto FoundAllModules
set Protocol=%8
set SmtModule=%8.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList3=%ModuleList3% %FromPath%%SmtModule%

if [%9] == [] goto FoundAllModules
set Protocol=%9
set SmtModule=%9.smt
if not exist %FromPath%%SmtModule% goto NoSmtModule
set ProtocolList=%ProtocolList% %Protocol%
set ModuleList3=%ModuleList3% %FromPath%%SmtModule%

shift
if [%9] == [] goto FoundAllModules
goto TooManyModules

:FoundAllModules
if exist %ToPath%%DriverName% goto DriverExists

echo For %DriverName% to be properly built %FromPath%SMART.CFG must contain
echo sections for all the cards and protocols you have chosen to use. You
echo have chosen to use the following protocols:
echo.
echo %ProtocolList%
echo.
echo If %FromPath%SMART.CFG is not correct press CTRL and C to abort
echo this program and correct %FromPath%SMART.CFG. Otherwise
pause

echo.
echo Linking from %FromPath% to %ToPath%

smtlink %ToPath%MDG_TMP0.$$$ %ModuleList0% 

if [%ModuleList1%] == [] goto DoneLink
smtlink %ToPath%MDG_TMP1.$$$ %ToPath%MDG_TMP0.$$$ %ModuleList1% 
del %ToPath%MDG_TMP0.$$$
ren %ToPath%MDG_TMP1.$$$ MDG_TMP0.$$$

if [%ModuleList2%] == [] goto DoneLink
smtlink %ToPath%MDG_TMP1.$$$ %ToPath%MDG_TMP0.$$$ %ModuleList2% 
del %ToPath%MDG_TMP0.$$$
ren %ToPath%MDG_TMP1.$$$ MDG_TMP0.$$$

if [%ModuleList3%] == [] goto DoneLink
smtlink %ToPath%MDG_TMP1.$$$ %ToPath%MDG_TMP0.$$$ %ModuleList3% 
del %ToPath%MDG_TMP0.$$$
ren %ToPath%MDG_TMP1.$$$ MDG_TMP0.$$$

:DoneLink
ren %ToPath%MDG_TMP0.$$$ %DriverName%
goto Finished

:NoToPath
echo ERROR: No to path has been specified.
goto Error

:NoSmartEXE
echo ERROR: Cannot find SMART.EXE in %FromPath%
goto Error

:NoSmartCFG
echo ERROR: Cannot find SMART.CFG in %FromPath%
goto Error

:NoNDIS
echo ERROR: Cannot find NDIS.SMT in %FromPath%
goto Error

:NoSmtModule
echo ERROR: Cannot find %SmtModule% in %FromPath%
goto Error

:TooManyModules
echo ERROR: Too many protocols specified (maximum is 9).
goto Error

:DriverExists
echo ERROR: %ToPath%%DriverName% already exists, cannot overwrite it.
goto Error

:Error
echo.
echo An error has occurred. Please correct the cause of the error and
echo run this program again.
echo.
goto Finished

:Help
echo Syntax: SMTNDIS from_path to_path [ protocol_1 .. protocol_n ]
echo.
echo Where:  from_path   Is where SMART.EXE, SMART.CFG, NDIS.SMT and any other
echo                     Smart modules to be linked can be found.
echo.
echo         to_path     Is where %DriverName% should be put. 
echo.
echo         protocol_i  Is the name of a protocol to be linked. The appropriate 
echo                     Smart modules to support the chosen protocols will be 
echo                     linked. If no protocols are specified then only NDIS 
echo                     support will be linked.
echo.
echo Example: SMTNDIS a:\smart c:\madge ipx llc
echo.
echo          Will produce a SMTNDIS.DOS containing support for NDIS, IPX
echo          and LLC. SMART.EXE, SMART.CFG, NDIS.SMT, IPX.SMT and LLC.SMT
echo          will be taken from a:\smart and %DriverName% will be built
echo          in c:\madge.
echo.

:Finished

rem End of SMTNDIS.DOS

