unit Icospace;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Spin, ExtCtrls;

type
  TIconSpacingForm = class(TForm)
    VertSpinEdit: TSpinEdit;
    HorzSpinEdit: TSpinEdit;
    PaintBox1: TPaintBox;
    Label1: TLabel;
    HelpButton: TBitBtn;
    procedure BothSpinEditChange(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure PaintBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure HelpButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IconSpacingForm: TIconSpacingForm;

implementation
USES IniFiles;
{$R *.DFM}

procedure TIconSpacingForm.BothSpinEditChange(Sender: TObject);
begin
  WITH Sender AS TSpinEdit DO
    IF (StrToIntDef(Text, 0) >= MinValue) AND
       (StrToIntDef(Text, 0) <= MaxValue) THEN
      PaintBox1.Refresh;
end;

procedure TIconSpacingForm.PaintBox1Paint(Sender: TObject);
begin
  WITH PaintBox1, Canvas DO
    BEGIN
      Brush.Color := clBtnFace;
      Rectangle(0,0,Width,Height);
      Brush.Color := clWindow;
      Rectangle(8, 8, 8+HorzSpinEdit.Value, 8+VertSpinEdit.Value);
      Draw(8+(HorzSpinEdit.Value-32) DIV 2,
           8+(VertSpinEdit.Value-32) DIV 2, Icon);
    END;
end;

procedure TIconSpacingForm.PaintBox1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  IF Source = Sender THEN
    BEGIN
      VertSpinEdit.Value := Y-8;
      HorzSpinEdit.Value := X-8;
    END
  ELSE Accept := False;
end;

procedure TIconSpacingForm.HelpButtonClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTEXT, 8);
end;

end.

