@echo off

rem Run this installation script only after you have read the installation
rem instructions!

echo.
echo =========================================================================
echo.
echo UZPronto 1.20 installation...
echo -----------------------------
echo.

rem make sure we are in the correct place
if exist uzpronto.exe goto install

echo You need to invoke INSTALL.BAT from the directory where you installed
echo the software.
goto abort

:install
echo This script moves files within the current directory, changes permissions,
echo and copies files into your system area.  You will be notified and prompted
echo before any changes are done to your system area!
echo.

echo.
choice /c:yn /t:n,30 Continue with the installation?
if errorlevel 2 goto abort


rem move files to appropriate subdirectories, in case pkunzip -d was not done
echo.
echo.
echo Moving files to appropriate subdirectories...
echo.

ctty nul
mkdir data > nul
ctty con
move *.uzc data > nul
attrib +r data\*.uzc

ctty nul
mkdir system > nul
ctty con
move ctl3dv2.dll system > nul


rem need to copy ctl3dv2.dll to c:\windows\system
echo.
echo UZPronto needs the dynamic link library CTL3DV2.DLL in C:\WINDOWS\SYSTEM .
echo.

if not exist c:\windows\system\ctl3dv2.dll goto skipcheck
echo CTL3DV2.DLL already exists in your system area. Here is the version of
echo the file:
dir c:\windows\system\ctl3dv2.dll | find "CTL"
echo Here is the version we need
dir system\ctl3dv2.dll | find "CTL"
echo If the version we need is newer than the one in your system area,
echo we recommend that you install the newer version.
goto copydll

:skipcheck
echo CTL3DV2.DLL is not in your system area. We recommend to install it.
goto copydll

:copydll
echo.
choice /c:yn /t:n,30 Copy CTL3DV2.DLL to C:\WINDOWS\SYSTEM?
if errorlevel 2 goto skipcopy
move c:\windows\system\ctl3dv2.dll c:\windows\system\ctl3dv2.old > nul
copy system\ctl3dv2.dll c:\windows\system > nul
goto success

:skipcopy
echo If the correct version is not there, you can copy the file by hand.
goto success

:success
echo.
echo Installation finished!
echo.
goto end

:abort
echo.
echo Installation aborted. UZPronto may not run successfully!
echo.
goto end

:end
echo =========================================================================
echo.
