//
// Copyright (c) 1995 Process Software Corporation
//
// Module Name:
//
//    purvcnum.h
//
// Abstract:
//
//    Offset definitions for extensible counter objects and counters
//
//    These "relative" offsets must start at 0 and be multiples of 2 (i.e.
//    even numbers). In the Open Procedure, they will be added to the 
//    "First Counter" and "First Help" values for the Purveyor performance 
//    counters in order to determine the absolute location of the counter and 
//    object names and corresponding Explain text in the registry.
//    
//    NOTE: When adding new counters, remember to update the LAST_PERF_COUNTER 
//          constant to be set equal to the last counter.
//

#define PURVEYOR_PERF_OBJ 0
#define BYTES_RECEIVED_SEC 2
#define BYTES_SENT_SEC 4
#define BYTES_TOTAL_SEC 6
#define CONNECTIONS_SEC 8
#define CONNECTIONS_TOT 10
#define CONNECTIONS_CUR 12
#define ISAPI_REQUESTS_SEC 14
#define ISAPI_REQUESTS_TOT 16
#define ISAPI_REQUESTS_CUR 18
#define CGI_REQUESTS_SEC 20
#define CGI_REQUESTS_TOT 22
#define CGI_REQUESTS_CUR 24
#define GET_REQUESTS_SEC 26
#define HEAD_REQUESTS_SEC 28
#define POST_REQUESTS_SEC 30
#define PROXY_REQUESTS_SEC 32
#define FILES_RECEIVED_TOT 34
#define FILES_SENT_TOT 36
#define FILES_TOT 38
#define FILE_NOT_FOUND_REQUESTS 40
#define ACCESS_DENIED_REQUESTS 42
#define LAST_PERF_COUNTER 42        // This constant should be kept at the end of the list and
                                    // should be set equal to the value of the last counter.
