unit Install;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TInstallDialog = class(TForm)
    Bevel1: TBevel;
    btBefore: TButton;
    btINext: TButton;
    btCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Target: TEdit;
    UnInstCopy: TCheckBox;
    UnInstFile: TCheckBox;
    procedure btCancelClick(Sender: TObject);
    procedure btBeforeClick(Sender: TObject);
    procedure btINextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Initialisation(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var InstallDialog: TInstallDialog;

implementation

uses Decla,Generale;

{$R *.DFM}


(* cancel button *)
procedure TInstallDialog.btCancelClick(Sender: TObject);
begin
 MainBack.Close;
end;

(* before button *)
procedure TInstallDialog.btBeforeClick(Sender: TObject);
begin
 CurrentWin := 3;
 Direction := 1;
 Close;
end;

(* Install button (Next) *)
procedure TInstallDialog.btINextClick(Sender: TObject);
begin
 CurrentWin := 5;
 Direction := 0;
 Close;
end;

(* closing dialog *)
procedure TInstallDialog.FormClose(Sender: TObject;var Action: TCloseAction);
begin
 MainBack.Initialisation (Sender);
end;

(* dialog init *)
procedure TInstallDialog.Initialisation(Sender: TObject);
begin
 if UnInstallFil = true then UnInstFile.State := cbChecked
                        else UnInstFile.State := cbUnChecked;
 if UnInstallCop = true then UnInstCopy.State := cbChecked
                        else UnInstCopy.State := cbUnChecked;
 Target.Text := VPath [2].LettDriv + ':' + VPath [2].PathDriv;
end;

end.
