(*********************************)
(*                               *)
(* Functions to install programs *)
(* (c)1996 by J. BERTRAND        *)
(*                               *)
(* ----------------------------- *)
(*                               *)
(* windows function (directory)  *)
(* directory functions           *)
(* file functions                *)
(* group & icons functions       *)
(*                               *)
(*********************************)
unit Disque;

interface

Const DiskName = 'DISK.';

(*******************)
(* extra functions *)
(*******************)
function WinDir : string;
                  {Windows directory without '\' at the end
                   none if can't find it}
function SysDir : string;
                  {Windows system directory without '\' at the end
                   none if can't find it}
function WinVersion : real;
                  {Return version of Windows in real like 3.11 or 3.9}
function DosVersion : real;
                  {Return version of dos in real like 6.22 or 7.0}
function StartApp (AppName,AppParams,AppDir : string) : integer;
                  {0..32 : Error look to ShellExecute for explanations of error
                   other values > 32 : Ok application lauched Return = Handle of App}
function CheckDsk (Path : string;Number : integer) : integer;
                  {0 : OK it is the right disk in
                   1 : It isn't the right disk}

(***********************)
(* directory functions *)
(***********************)

function CreateDirectory (DirectoryName : string) : integer;
                  {0 : OK   directory created
                   1 : Unable to create}
function DestroyDirectory (DirectoryName : string) : integer;
                  {0 : OK directory deleted
                   1 : Unable to destroy}

(******************)
(* file functions *)
(******************)

function DiskIDCorrect (Floppy : char;PathAccess : string;ID : integer) : integer;
                  { 0 : Yes this good floppy
                    1 : Wrong floppy and ok button
                    2 : Wrong floppy but cancel button}
function SizeFile (Fichier : string) : longint;
                  {-2 : Unable to set size
                   -1 : File doesn't exist
                   >0 : Size of the file}
function DeleteFile (Fichier : string) : integer;
                  {0 : OK file deleted
                   1 : File doesn't exist
                   2 : Unable to delete}
function ExistFile (Fichier : string) : integer;
                  {0 : File doesn't exist
                   1 : File exist}
function RenameFile (OldName,NewName : string) : integer;
                  {0 : OK file renammed
                   1 : OldName does't exist
                   2 : NewNameAlReadyExist
                   3 : Unable to rename}
function EnougthSpace (DriveUnit: char;Fichier : string) : integer;
                  {0 : OK enougth space
                   1 : File Doesn't exist
                   2 : Not enougth space
                   3 : Wrong letter Drive}
function CopyFile (FromFile,ToFile : string;Switch : byte) : integer;
		  {Switch         000 = Do nothing
			  bit 0 : 001 = Overwrite if ToFile exits
			      1 : 002 =
			      2 : 004 =
			      3 : 008 =
			      4 : 016 =
 			      5 : 032 =
                              6 : 064 =
                              7 : 128 =}
                  {0 : OK file copied
                   1 : File already exist and Switch = 0
                   2 : Unable to open Source File
                   3 : Unable to open destination file
                   4 : Unable to read from Source File
                   5 : Unable to write to destination file}

(**********************)
(* Ini file functions *)
(**********************)

{
 0 : All thing are Ok
 1 : problem
}
function CreateIniFile    (FileName : string) : integer;
function DeleteIniFile    (FileName : string) : integer;
function CreateIniSection (FileName,Section : string) : integer;
function DeleteIniSection (FileName,Section : string) : integer;
function CreateIniField   (FileName,Section,Field : string) : integer;
function DeleteIniField   (FileName,Section,Field : string) : integer;
function ModifyIniValue   (FileName,Section,Field,Value : string) : integer;

implementation

uses Forms,SysUtils,WinProcs,DdeMan,ShellAPI,FileCtrl,Dialogs,LZExpand,
     IniFiles,Controls,Decla;

(*********************)
(*                   *)
(* FONCTIONS EN PLUS *)
(*                   *)
(*********************)

(*************************)
(* repertoire de windows *)
(*************************)
function WinDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetWindowsDirectory(Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 WinDir := Tmp;
end;

(*********************)
(* repertoire system *)
(*********************)
function SysDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetSystemDirectory (Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 SysDir := Tmp;
end;

(*******************)
(* windows version *)
(*******************)
function WinVersion : real;
var version : longint;
    winveri : word;
    tempo   : string;
    Temp    : real;
    err     : integer;
begin
 version := GetVersion;
 winveri := version shl 32;
 Tempo  := inttostr (lo (WinVeri)) + '.' + inttostr (hi (winveri));
 val (tempo,temp,err);
 WinVersion := Temp;
end;

(***************)
(* dos version *)
(***************)
function DosVersion : real;
var version : longint;
    dosveri : word;
    tempo   : string;
    temp    : real;
    err     : integer;
begin
 version := GetVersion;
 dosveri := version shr 24;
 tempo := inttostr (lo (dosveri)) + '.' + inttostr (hi (dosveri));
 val (tempo,temp,err);
 DosVersion := Temp;
end;

(*******************************)
(* lancement d'une application *)
(*******************************)
function StartApp (AppName,AppParams,AppDir : string) : integer;
var Tmp : Integer;
    zFileName : array [0 .. 79] of char;
    zParams   : array [0 .. 79] of char;
    zDir      : array [0 .. 79] of Char;
begin
 Tmp := 0;
 StrPCopy (zFileName,AppName);
 StrPCopy (zParams,AppParams);
 StrPCopy (zDir,AppDir);
 Tmp := ShellExecute (0,Nil,zFileName,zParams,zDir,1);
 StartApp := Tmp;
end;

(********************************)
(* verification d'une disquette *)
(********************************)
function CheckDsk (Path : string;Number : integer) : integer;
var Tmp : integer;
    Nbr : string [3];
    Nam : string [12];
begin
 Tmp := 0;
 str (Number:3,Nbr);
 while pos (' ',Nbr) <> 0 do Nbr [pos (' ',Nbr)] := '0';
 while length (Nbr) < 3 do Nbr := '0' + Nbr;
 Nam := DiskName + Nbr;
 if ExistFile (Path + Nam) = 0 then
  Tmp := 1;
 CheckDsk := Tmp;
end;

(*********************************)
(*                               *)
(* FONCTIONS SUR LES REPERTOIRES *)
(*                               *)
(*********************************)

(****************************)
(* creation d'un repertoire *)
(****************************)
function CreateDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 {$I-}; ForceDirectories (DirectoryName) {$I+};
 if DirectoryExists (DirectoryName) = false then Tmp := 1;
 CreateDirectory := tmp;
end;

(**************************)
(* destruction repertoire *)
(**************************)
function DestroyDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 {$I-}; RmDir (DirectoryName); {$I+};
 if ioresult <> 0 then Tmp := 1;
 DestroyDirectory := Tmp;
end;

(******************************)
(*                            *)
(* FONCTIONS SUR LES FICHIERS *)
(*                            *)
(******************************)

(************************************)
(* check if floppy containt DISK.ID *)
(************************************)
function DiskIDCorrect (Floppy : char;PathAccess : string;ID : integer) : integer;
var Tmp : integer;
    Suf : string [3];
    Dsk : string;
    cur : TCursor;
begin
 Tmp := 0;
 Str (ID:3,Suf);
 If pathAccess [length (PathAccess)] = '\' then
 begin
  if length (PathAccess) > 1 then
  begin
   repeat
    PathAccess := copy (PathAccess,1,length (PathAccess) - 1)
   until PathAccess [length (PathAccess)] <> '\';
  end
  else
   PathAccess := '';
 end;
 While pos (' ',Suf) <> 0 do Suf [Pos (' ',Suf)] := '0';
 Dsk := Floppy + ':' + PathAccess + '\DISK.' + Suf;
 if ExistFile (Dsk) = 1 then
  Tmp := 0
 else
 begin
  Cur := Screen.Cursor;
  Screen.Cursor := crDefault;
  Tmp := MessageDlg ('Please insert disk #' + Suf +
                     ' into drive ' + upcase (Floppy) + ':' + PathAccess,
                     mtConfirmation,[mbOk,mbCancel],0);
  Screen.Cursor := Cur;
 end;
 DiskIDCorrect := tmp;
end;

(***********************)
(* taille d'un fichier *)
(***********************)
function SizeFile (Fichier : string) : longint;
var Tmp : longint;
    Siz : longint;
    Fch : file;
begin
 if ExistFile (Fichier) = 0 then
  Tmp := -1
 else
 begin
  assign (Fch,Fichier);
  {$I-}; Siz := FileSize (Fch); {$I+};
  if ioresult <> 0 then Tmp := -2
                   else Tmp := Siz;
 end;
 SizeFile := Tmp;
end;

(*********************)
(* efface un fichier *)
(*********************)
function DeleteFile (Fichier : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (Fichier) = 0 then
  Tmp := 1
 else
 begin
  Assign (Fch,Fichier);
  {$I-}; Erase (Fch); {$I+};
  if ioresult <> 0 then Tmp := 2;
 end;
 DeleteFile := Tmp;
end;

(******************************)
(* teste si un fichier existe *)
(******************************)
function ExistFile (Fichier : string) : integer;
var Fch : file;
    Tmp : integer;
begin
 Tmp := 1;
 assign (Fch,Fichier);
 {$I-}; reset (Fch); {$I+};
 if ioresult = 0 then Close (Fch)
                 else Tmp := 0;
 ExistFile := Tmp;
end;

(**********************)
(* renomme un fichier *)
(**********************)
function RenameFile (OldName,NewName : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (OldName) = 1 then
  Tmp := 1
 else
  if ExistFile (NewName) = 1 then
   Tmp := 2
  else
  begin
   assign (Fch,OldName);
   {$I-}; rename (Fch,NewName) {$I+};
   if ioresult <> 0 then Tmp := 3;
  end;
 RenameFile := Tmp;
end;

(***************************)
(* y a t il assez de place *)
(***************************)
function EnougthSpace (DriveUnit : char;Fichier : string) : integer;
var Tmp : integer;
    Siz : longint;
    Dsk : integer;
    DFr : longint;
begin
 Tmp := 0;
 Dsk := ord (upcase (DriveUnit)) - 64;
 if Dsk < 1 then
  Tmp := 3
 else
 begin
  if ExistFile (Fichier) = 0 then
   Tmp := 1
  else
  begin
   Siz := SizeFile (Fichier);
   if Siz > -1 then
   begin
    DFr := DiskFree (Dsk);
    if Dfr < 0 then
     tmp := 3
    else
     if Siz > DiskFree (Dsk) then Tmp := 2;
   end;
  end;
 end;
 EnougthSpace := Tmp;
end;

(**********************)
(* copie d'un fichier *)
(**********************)
function CopyFile (FromFile,ToFile : string ; Switch : byte) : integer;
var Tmp : integer;
    FromF, ToF: file;
    NumRead, NumWritten: Word;
    iHandle : Integer;
    iNewHandle : Integer;
    iReturn : Integer;
    iLongReturn : LongInt;
    pFrom : Array[0..256] of Char;
    pTo : Array[0..256] of Char;
begin
 Tmp := 0;
 If (ExistFile (ToFile) = 1) and (Switch = 0) then
  Tmp := 1
 else
 begin
  StrPCopy( pFrom, FromFile );
  iReturn := GetExpandedName( pFrom, pTo );
  if iReturn = -1 then
   Tmp := 2
  else
  begin
   if iReturn = -2 then
    Tmp := 3
   else
   begin
    if ( StrEnd( pTo ) - pTo ) > 0 then
    begin
     ToFile := ExtractFilePath( ToFile ) +
               ExtractFileName( strPas( pTo ) );
     LZStart;
     iHandle := FileOpen( FromFile, fmShareDenyWrite );
     if iHandle < 1 then
      Tmp := 2
     else
     begin
      iNewHandle := FileCreate( ToFile );
      if iNewHandle < 1 then
       Tmp := 3
      else
      begin
       iLongReturn := CopyLZFile( iHandle , iNewHandle );
       if iLongReturn = LZERROR_UNKNOWNALG then
        Tmp := 5
       else
       begin
        FileClose( iHandle );
        FileClose( iNewHandle );
        LZDone;
       end;
      end;
     end;
    end
    else
     Tmp := 3;
   end
  end;
 end;
 CopyFile := Tmp;
end;


(**********************)
(* Ini file functions *)
(**********************)

{
 0 : All thing are Ok
 1 : problem
}
(* create an Ini file : it is a text file in fact *)
function CreateIniFile    (FileName : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.rewrite (Fch); {$I+};
 if ioresult = 0 then
  System.Close (Fch)
 else
  Tmp := 1;
 CreateIniFile := Tmp;
end;

(* delete an Ini file *)
function DeleteIniFile    (FileName : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.Erase (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 1;
 DeleteIniFile := Tmp;
end;

(* create a new section at the end of Ini file *)
function CreateIniSection (FileName,Section : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.Append (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 1
 else
 begin
  System.Writeln (Fch);
  System.Writeln (Fch,'[' + Section + ']');
  Close (Fch);
 end;
 CreateIniSection := Tmp;
end;

(* delete entire section *)
function DeleteIniSection (FileName,Section : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.EraseSection (Section);
 Fch.Free;
 DeleteIniSection := Tmp;
end;

(* Create a Ini Field *)
function CreateIniField   (FileName,Section,Field : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,'');
 Fch.Free;
 CreateIniField := Tmp;
end;

(* Delete an Ini Field *)
function DeleteIniField   (FileName,Section,Field : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,'');
 Fch.Free;
 DeleteIniField := Tmp;
end;

(* modify, add a new value *)
function ModifyIniValue   (FileName,Section,Field,Value : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,Value);
 Fch.Free;
 ModifyIniValue := Tmp;
end;

end.

