(********************************)
(* global declaration for setup *)
(********************************)
unit Decla;

interface

const Max_Group = 05;
      Max_Files = 120;
      Max_Icons = 40;
      Max_Run   = 05;
      Max_Path  = 11;
      Max_Unin  = 50;
      Max_IniF  = 40;
      Fch_UnIns = 'UNSETUP.';
      Fch_Ins   = 'SETUP.';
      PrgVersio = '4.50a';
      One_Meg   = 1048576;
      New_Win   = 3.95;
      Old_Win   = 3.1;

      (* vecteur des groupes *)
Type TVect_Group = record
                    GroupName : string [25];    (* Nom du groupe      *)
                    GroupFile : string [79];    (* Fichier de groupe  *)
                   end;
     (* vecteur des icones a creer *)
     TVect_Icons = record
                    DiskNumb : byte;            (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [79];     (* access au fichier  *)
                    IconName : string [25];     (* nom de l'icone     *)
                    Compress : byte;            (* Compress Yes / No  *)
                    GroupNum : byte;            (* number of group    *)
                   end;
     (* vecteur des fichier a copier *)
     TVect_Files = record
                    DiskNumb : byte;            (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [79];     (* chemin destination *)
                    Compress : byte;            (* Compress Yes / No  *)
                   end;
     (* vecteurs des fichier a lancer *)
     TVect_Run =   record
                    FileName : string [12];     (* fichier a lancer   *)
                    FilePath : string [79];     (* chemin d'access    *)
                    DocsName : string [12];     (* document associe   *)
                    DocsPath : string [79];     (* chemin document    *)
                   end;
     (* vecteur des disques *)
     TVect_Path =  record
                    LettDriv : char;            (* la lettre lecteur  *)
                    PathDriv : string [79];     (* chemin lecteur     *)
                   end;
     (* vecteur pour la deinstallation *)
     TVect_Unins = record
                    TypeCase : integer;         (* 0:Dir 1:File 2:Grp *)
                    FullName : string [79];     (* Directory + Name   *)
                   end;
     (* vecteur des files INI *)
     TVect_IniFi = record
                    FileName : string [12];     (* name of ini file   *)
                    FilePath : string [79];     (* path to access     *)
                    INISecti : string [50];     (* name of section    *)
                    INIField : string [50];     (* name of filed      *)
                    INIValue : string [50];     (* name of value(s)   *)
                   end;

var VGroup : array [1 .. max_group] of TVect_Group;   (* les groupes    *)
    VIcons : array [1 .. max_icons] of TVect_Icons;   (* les icones     *)
    VFiles : array [1 .. max_files] of TVect_Files;   (* les fichiers   *)
    VRun   : array [1 .. max_run]   of TVect_Run;     (* les lancements *)
    VPath  : array [1 .. max_path]  of TVect_Path;    (* origine/desti. *)
    VIniF  : array [1 .. max_inif]  of TVect_IniFi;   (* ini files      *)
    VUnins : array [1 .. max_Unin] of TVect_Unins;    (* desinstallation*)
    Title,SubTitle,Version,Author,Copyright : string; (* informations   *)
    Disk_Number  : integer;                           (* nbr de dsk < 2 *)
    Disk_Space   : longint;                           (* space needed   *)
    Number_Direc : integer;                           (* nbr of target  *)
    Number_Group : integer;                           (* nbr de groupes *)
    Number_Icons : integer;                           (* nbr d'icones   *)
    Number_Files : integer;                           (* nbr de fichiers*)
    Number_Run   : integer;                           (* nbr de lance.  *)
    Number_Ini   : integer;                           (* Nbr of ini line*)
    Error        : integer;                           (* <>0 err append *)
    First        : boolean;                           (* =true Creation *)
    CurrentWin   : integer;                           (* win dialog     *)
    Direction    : byte;                              (* =0 up 1= down  *)
    UnInstallCop : boolean;                           (* Copy to Hard D *)
    UnInstallFil : boolean;                           (* Make File      *)
    CustomizeFlg : boolean;                           (* Custom install?*)

implementation

end.

