(**********************************)
(* Lecture du fichier INSTALL.INS *)
(**********************************)
unit Lecture;

interface

uses Dialogs;

const Title_Parag : array [1 .. 8] of string =
                    ('INFORMATION', (* Info about program to install       *)
                     'DISKS',       (* Number of disk                      *)
                     'ORIGIN',      (* Origin informations                 *)
                     'DESTINATION', (* Destination informations            *)
                     'GROUP',       (* Groups to create                    *)
                     'ICONS',       (* Icons to create                     *)
                     'FILES',       (* Files to copy                       *)
                     'RUN');        (* Files to run                        *)
      Number_Para = 8;              (* number of <> paragrafs              *)
      lgn_Remarks = ';';            (* ligne en remarque                   *)
      lgn_Paragrf = '[';            (* marque de paragraphe                *)
      lgn_EqualSi = '=';            (* marque de debut des parametres      *)
      lgn_Separat = ',';            (* marque de separateur des parametres *)
      lgn_Pat_Red = '%';            (* marque d'indicateur de repertoire   *)
      lgn_Pat_Trg = '1';            (* repertoire de destination           *)
      lgn_Pat_Win = 'W';            (* repertoire de Windows               *)
      lgn_Pat_Sys = 'S';            (* repertoire de Windows/System        *)
      lgn_Pat_Rot = 'R';            (* repertoire racine                   *)

function ReadUnsFile : integer;
         { 0 : OK Uninstall readed correctly
           1 : File doesn't exist
           2 : Unable to read one line
           3 : Error on number in line
           4 : Maximum of file reach
           5 : Wrong number in line}

implementation

uses SysUtils,Decla,Disque;

(* lecture fichier de deinstallation *)
function ReadUnsFile : integer;
var Tmp : integer;
    Fch : System.Text;
    Lgn : string;
    Num : integer;
    Err : integer;
    Oth : string;
    Ite : integer;
begin
 Tmp := 0;
 For Ite := 1 to Max_Unin do
 begin
  with VUnins [Ite] do
  begin
   TypeCase := -1;
   FullName := '';
  end;
 end;
 assign (Fch,UnSetupPath + Fch_UnIns + 'INS');
 {$I-}; Reset (Fch); {$I+};
 if IoResult <> 0 then
 (* file doesn't exist *)
  Tmp := 1
 else
 begin
  Ite := 0;
  while not (eof (Fch)) do
  begin
   {$I-}; Readln (Fch,Lgn); {$I+};
   if ioresult <> 0 then
   (* unable to read *)
    Tmp := 2
   else
   begin
    if (pos (';',Lgn) = 0) and (Lgn <> '') then
    begin
     (* takes number *)
     val (copy (Lgn,1,pos (',',lgn) - 1),Num,Err);
     if Err <> 0 then
     (* not a number *)
      Tmp := 3
     else
     begin
      if Ite > Max_Unin then
      (* out of range *)
       Tmp := 4
      else
      begin
       (* assign names of files etc ... *)
       case Num of
        0,1,2 : (* Correct type *)
                begin
                 Inc (Ite);
                 VUnins [Ite].TypeCase := Num;
                 VUnins [Ite].FullName := copy (Lgn,pos (',',Lgn) + 1,
                                                length (Lgn) - Pos (',',Lgn) + 1);
                end;
       else
       (* wrong number *)
        Tmp := 5;
       end;
      end;
     end;
    end;
   end;
  end;
 end;
 ReadUnsFile := Tmp;
end;

end.
