unit Source;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, FileCtrl;

type
  TSourceDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    SourceDrive: TDriveComboBox;
    Label1: TLabel;
    Label2: TLabel;
    SourceDirectory: TEdit;
    SourceList: TDirectoryListBox;
    DriveList: TDriveComboBox;
    Bevel2: TBevel;
    Label3: TLabel;
    Bevel3: TBevel;
    Label4: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SourceDialog: TSourceDialog;

implementation

uses Decla;

{$R *.DFM}

(* Ok Button *)
procedure TSourceDialog.OKBtnClick(Sender: TObject);
var Tmp : string;
begin
 With VPath [Max_Path] do
 begin
  LettDriv := SourceDrive.Drive;
  Tmp := SourceDirectory.Text;
  if pos (':',Tmp) <> 0 then
   Delete (Tmp,1,pos (':',Tmp));
  PathDriv := Tmp;
 end;
 ModalResult := mrOk;
end;

(* Cancel button *)
procedure TSourceDialog.CancelBtnClick(Sender: TObject);
begin
 ModalResult := mrCancel;
end;

(* init dialog *)
procedure TSourceDialog.Initialise(Sender: TObject);
begin
 With VPath [10] do
 begin
  DriveList.Drive := 'C';
  SourceList.Drive := 'C';
  SourceList.Directory := '\';
  SourceDrive.Drive := LettDriv;
  SourceDirectory.Text := PathDriv;
 end;
end;

(* changing directory *)
procedure TSourceDialog.ChangeDir(Sender: TObject);
begin
 SourceDirectory.Text := SourceList.Directory;
end;

end.
