unit Jinifile;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls, FileCtrl,Dialogs,IniFiles,SysUtils;

type
  TIniDialog = class(TForm)
    CancelBtn: TBitBtn;
    ListDire: TDirectoryListBox;
    ListDrive: TDriveComboBox;
    ListFile: TFileListBox;
    Label1: TLabel;
    Label2: TLabel;
    ListSection: TListBox;
    Label3: TLabel;
    ListField: TListBox;
    IniFileName: TEdit;
    SectionName: TEdit;
    FieldName: TEdit;
    Value: TEdit;
    Bevel1: TBevel;
    btDelFile: TButton;
    btDelSection: TButton;
    btDelField: TButton;
    btSetValue: TButton;
    Bevel2: TBevel;
    DefDir: TListBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure SetIniFile(Sender: TObject);
    procedure SetSection(Sender: TObject);
    procedure SetField(Sender: TObject);
    procedure btDelFileClick(Sender: TObject);
    procedure btDelSectionClick(Sender: TObject);
    procedure btDelFieldClick(Sender: TObject);
    procedure btSetValueClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure SetDefDir(Sender: TObject);
  private
    { Private declarations }
    procedure CheckPath (Position : integer);
  public
    { Public declarations }
  end;

var
  IniDialog: TIniDialog;

implementation

uses Decla,Disque;

{$R *.DFM}

(* Translate name of Ini file and set section listbox *)
procedure TIniDialog.SetIniFile(Sender: TObject);
var Fch : System.Text;
    Lgn : string;
begin
 if ListFile.ItemIndex <> - 1 then
 begin
  IniFileName.Text := ListDire.Directory + '\' +
                      ListFile.Items [ListFile.ItemIndex];
  if (ListFile.Items [ListFile.ItemIndex] = 'SYSTEM.INI') or
     (ListFile.Items [ListFile.ItemIndex] = 'system.ini') or
     (ListFile.Items [ListFile.ItemIndex] = 'WIN.INI') or
     (ListFile.Items [ListFile.ItemIndex] = 'win.ini') then
   btDelFile.Enabled := false
  else
   btDelFile.Enabled := true;
  SectionName.Text := '';
  FieldName.Text := '';
  Value.Text := '';
  System.Assign(Fch,ListDire.Directory+'\'+ListFile.Items [ListFile.ItemIndex]);
  {$I-}; reset (Fch); {$I+};
  if ioresult <> 0 then
   MessageDlg ('Unabled to read section of this Ini file',mtError,[mbok],0)
  else
  begin
   ListSection.Clear;
   ListField.Clear;
   while not (eof (Fch)) do
   begin
    System.Readln (Fch,Lgn);
    if (pos ('[',Lgn) <> 0) and (pos (']',Lgn) <> 0) and (Lgn [1] <> ';') then
     ListSection.Items.Add (copy (Lgn,2,length (Lgn) - 2));
   end;
   System.Close (fch);
   ListSection.ItemIndex := -1;
  end;
 end;
end;

(* translate section name and set field list box *)
procedure TIniDialog.SetSection(Sender: TObject);
var FIni: TIniFile;
begin
 if ListSection.ItemIndex <> - 1 then
 begin
  SectionName.Text := ListSection.Items [ListSection.ItemIndex];
  FieldName.Text := '';
  Value.Text := '';
  ListField.Clear;
  Fini := TIniFile.Create(ListDire.Directory + '\' +
                          ListFile.Items [ListFile.ItemIndex]);
  Fini.ReadSection(ListSection.Items [ListSection.ItemIndex], ListField.Items);
  Fini.Free;
  ListField.ItemIndex := -1;
 end;
end;

(* translate field name and set value*)
procedure TIniDialog.SetField(Sender: TObject);
var Fini : TIniFile;
begin
 if ListField.ItemIndex <> -1 then
 begin
  FieldName.Text := ListField.Items [ListField.ItemIndex];
  Value.Text := '';
  Fini := TIniFile.Create(ListDire.Directory + '\' +
                          ListFile.Items [ListFile.ItemIndex]);
  With Fini do
   Value.Text :=
    ReadString (ListSection.Items [ListSection.ItemIndex],
                ListField.Items [ListField.ItemIndex],'');
  Fini.Free;
 end;
end;

(* delete file *)
procedure TIniDialog.btDelFileClick(Sender: TObject);
var Tmp : integer;
begin
 if (Number_Ini + 1) > Max_Inif then
  MessageDlg ('Maximum of ini file functions reached',mtInformation,[mbOk],0)
 else
 begin
  if IniFileName.Text <> '' then
  begin
   if VTrans.Number = 0 then
   begin
    Inc (Number_Ini);
    Tmp := Number_Ini;
   end
   else
    Tmp := VTrans.Number;
   with VInif [Tmp] do
   begin
    INISecti := '';
    INIField := '';
    INIValue := '';
   end;
   CheckPath (Tmp);
   Close;
  end
  else
  begin
   MessageDlg ('You must specify a Ini file name',mtInformation,[mbOk],0);
   ModalResult := 0;
  end;
 end;
end;

(* delete section *)
procedure TIniDialog.btDelSectionClick(Sender: TObject);
var Tmp : integer;
begin
 if (Number_Ini + 1) > Max_Inif then
  MessageDlg ('Maximum of ini file functions reached',mtInformation,[mbOk],0)
 else
 begin
  if IniFileName.Text <> '' then
  begin
   if SectionName.Text <> '' then
   begin
    if VTrans.Number = 0 then
    begin
     Inc (Number_Ini);
     Tmp := Number_Ini;
    end
    else
     Tmp := VTrans.Number;
    with VInif [Tmp] do
    begin
     INISecti := SectionName.Text;
     INIField := '';
     INIValue := '';
    end;
    CheckPath (Tmp);
    Close;
   end
   else
   begin
    MessageDlg ('You must specify a section',mtInformation,[mbOk],0);
    ModalResult := 0;
   end;
  end
  else
  begin
   MessageDlg ('You must specify a Ini file name',mtInformation,[mbOk],0);
   ModalResult := 0;
  end;
 end;
end;

(* delete field *)
procedure TIniDialog.btDelFieldClick(Sender: TObject);
var Tmp : integer;
begin
 if (Number_Ini + 1) > Max_Inif then
  MessageDlg ('Maximum of ini file functions reached',mtInformation,[mbOk],0)
 else
 begin
  if IniFileName.Text <> '' then
  begin
   if SectionName.Text <> '' then
   begin
    if FieldName.Text <> '' then
    begin
     if VTrans.Number = 0 then
     begin
      Inc (Number_Ini);
      Tmp := Number_Ini;
     end
     else
      Tmp := VTrans.Number;
     with VInif [Tmp] do
     begin
      INISecti := SectionName.Text;
      INIField := FieldName.Text;
      INIValue := '';
     end;
     CheckPath (Tmp);
     Close;
    end
    else
    begin
     MessageDlg ('You must specify a field',mtInformation,[mbok],0);
     ModalResult := 0;
    end;
   end
   else
   begin
    MessageDlg ('You must specify a section',mtInformation,[mbOk],0);
    ModalResult := 0;
   end;
  end
  else
  begin
   MessageDlg ('You must specify a Ini file name',mtInformation,[mbOk],0);
   ModalResult := 0;
  end;
 end;
end;

(* set value *)
procedure TIniDialog.btSetValueClick(Sender: TObject);
var Tmp : integer;
begin
 if (Number_Ini + 1) > Max_Inif then
  MessageDlg ('Maximum of ini file functions reached',mtInformation,[mbOk],0)
 else
 begin
  if IniFileName.Text <> '' then
  begin
   if SectionName.Text <> '' then
   begin
    if FieldName.Text <> '' then
    begin
     if VTrans.Number = 0 then
     begin
      Inc (Number_Ini);
      Tmp := Number_Ini;
     end
     else
      Tmp := VTrans.Number;
     with VInif [Tmp] do
     begin
      INISecti := SectionName.Text;
      INIField := FieldName.Text;
      INIValue := Value.Text;
     end;
     CheckPath (Tmp);
     Close;
    end
    else
    begin
     MessageDlg ('You must specify a field',mtInformation,[mbok],0);
     ModalResult := 0;
    end;
   end
   else
   begin
    MessageDlg ('You must specify a section',mtInformation,[mbOk],0);
    ModalResult := 0;
   end;
  end
  else
  begin
   MessageDlg ('You must specify a Ini file name',mtInformation,[mbOk],0);
   ModalResult := 0;
  end;
 end;
end;

(* put defined directory *)
procedure TIniDialog.SetDefDir(Sender: TObject);
begin
 if DefDir.ItemIndex <> -1 then
  IniFileName.Text := DefDir.Items [DefDir.ItemIndex] + '\';
end;

(* Init dialog *)
procedure TIniDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Err : integer;
begin
 DefDir.Clear;
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
   with VPath [Bcl] do
    DefDir.Items.Add (LettDriv + ':' + PathDriv);
 end;
 if VTrans.Number = 0 then
 begin
  Caption := 'Functions on Ini files (creation)';
  ListFile.ItemIndex := -1;
  DefDir.ItemIndex := -1;
  ListSection.Clear;
  ListField.Clear;
  IniFileName.Text := '';
  SectionName.Text := '';
  FieldName.Text := '';
  Value.Text := '';
 end
 else
 begin
  Caption := 'Functions on Ini files (modification)';
  with VIniF [VTrans.Number] do
  begin
   (* Ini file *)
   if FilePath [1] = '%' then
   begin
    case FilePath [2] of
     'W' : begin
            ListDrive.Drive := WinDir [1];
            ListDire.Directory := lowercase (WinDir);
           end;
     'S' : begin
            ListDrive.Drive := SysDir [1];
            ListDire.Directory := lowercase (SysDir);
           end;
    else
     begin
      val (FilePath [2],Bcl,Err);
      if Err <> 0 then Bcl := 1;
      if DirectoryExists (VPath [Bcl].LettDriv + ':' +
                          VPath [Bcl].PathDriv) = true then
      begin
       ListDrive.Drive := VPath [Bcl].LettDriv;
       ListDire.Directory := lowercase (VPath [Bcl].LettDriv + ':' +
                                        VPath [Bcl].PathDriv);
      end;
      DefDir.ItemIndex := Bcl - 1;
     end;
    end;
   end
   else
   begin
    ListDrive.Drive := FilePath [1];
    ListDire.Directory := lowercase (FilePath);
    DefDir.ItemIndex := -1;
   end;
   (* section *)
   SetIniFile (Sender);
   for Bcl := 0 to (ListFile.Items.Count - 1) do
   begin
    if ListFile.Items [Bcl] = lowercase (FileName) then
     ListFile.ItemIndex := Bcl;
   end;
   if FilePath [1] = '%' then
   begin
    case FilePath [2] of
     'W' : IniFileName.Text := lowercase (WinDir) + '\' + lowercase (FileName);
     'S' : IniFileName.Text := lowercase (SysDir) + '\' + lowercase (FileName);
    else
     begin
      val (FilePath [2],Bcl,Err);
      if Err <> 0 then Bcl := 1;
      IniFileName.text := lowercase (VPath [Bcl].LettDriv) + ':' +
                          lowercase (VPath [Bcl].PathDriv) + '\' +
                          lowercase (FileName);
      DefDir.ItemIndex := Bcl - 1;
     end;
    end;
   end
   else
   begin
    IniFileName.Text := lowercase (FilePath) + '\' + lowercase (FileName);
    DefDir.ItemIndex := -1;
   end;
   for Bcl := 0 to (ListSection.Items.Count - 1) do
    if ListSection.Items [Bcl] = IniSecti then
     ListSection.ItemIndex := Bcl;
   (* field *)
   SetSection (Sender);
   SectionName.Text := INISecti;
   for Bcl := 0 to (ListField.Items.Count - 1) do
    if ListField.Items [Bcl] = IniField then
     ListField.ItemIndex := Bcl;
   (* value & other *)
   SetField (Sender);
   FieldName.Text := INIField;
   if FilePath [1] <> '%' then
    IniFileName.Text := FilePath + '\' + FileName;
   SectionName.Text := INISecti;
   FieldName.Text := INIField;
   Value.Text := INIValue;
   (* verify on defined directory list *)
  end;
 end;
end;

(* check all path *)
procedure TIniDialog.CheckPath (Position : integer);
var Bcl : integer;
    Err : integer;
    Tmp : string;
    Tm1 : integer;
    Pat : string;
    Fil : string;
    Tm2 : string;
    Tm3 : string;
begin
 With VInif [Position] do
 begin
  (* convert path and file name *)
  Pat := IniFileName.Text;
  Fil := IniFileName.Text;
  while pos ('\',Fil) <> 0 do
   Delete (Fil,1,pos ('\',Fil));
  FileName := Fil;
  FilePath := copy (Pat,1,pos (Fil,Pat) - 2);
  if Pos (':',FilePath) <> 0 then
   Delete (FilePath,1,pos (':',FilePath));
  (* check defined path *)
  if Number_Direc > 0 then
  begin
   Tmp := FilePath;
   for Bcl := 1 to Number_Direc do
   begin
    if VPath [Bcl].PathDriv = Tmp then
    begin
     Str (Bcl:1,FilePath);
     FilePath := '%' + FilePath;
    end;
   end;
  end;
  (* check for Windows and System directories *)
  Tm2 := lowercase (WinDir); if pos (':',Tm2) <> 0 then delete (Tm2,1,pos (':',Tm2));
  if FilePath  = Tm2 then FilePath := '%W';
  Tm2 := lowercase (SysDir); if pos (':',Tm2) <> 0 then delete (Tm2,1,pos (':',Tm2));
  if FilePath  = Tm2 then FilePath := '%S';
 end;
end;

end.
