unit Icomod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,SysUtils;

type
  TIconModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label2: TLabel;
    DNameFile: TEdit;
    Label1: TLabel;
    DDrivFile: TEdit;
    DFilePath: TEdit;
    Liste: TListBox;
    Label5: TLabel;
    Label6: TLabel;
    DSizeTarg: TEdit;
    DSizeSour: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    DCompFile: TCheckBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    DIconName: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    PListGroup: TListBox;
    procedure Initialise(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
    procedure KeepIt(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IconModDialog: TIconModDialog;

implementation

uses Decla;

{$R *.DFM}

(* init dialog *)
procedure TIconModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 (* init *)
 PListGroup.Clear;
 if Number_Group > 0 then
 begin
  for Bcl := 1 to Number_Group do
  begin
   With VGroup [Bcl] do
    PListGroup.Items.Add (GroupName);
  end;
 end;
 PListGroup.ItemIndex := -1;
 Liste.Clear;
 Liste.Items.Add ('Other');
 if Number_Direc > 1 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 with VIcons [VTrans.Number] do
 begin
  (* name *)
  DNameFile.Text := FileName;
  (* drive *)
  DDrivFile.Text := FileDriv;
  (* path *)
  if FilePath [1] = '%' then
  begin
   Val (FilePath [2],Num,Err);
   if Err = 0 then
   begin
    DFilePath.Text := VPath [Bcl].PathDriv;
    Liste.ItemIndex := Num;
   end
   else
   begin
    DFilePath.Text := FilePath;
    Liste.ItemIndex := 0;
   end;
  end
  else
  begin
   DFilePath.Text := FilePath;
   Liste.ItemIndex := 0;
  end;
  (* sizes *)
  DSizeSour.Text := IntToStr (SizeNorm);
  if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                  else DSizeTarg.Text := IntToStr (SizeNorm);
  (* compress *)
  if Compress = 1 then DCompFile.State := cbChecked
                  else DCompFile.State := cbUnChecked;
  (* iconname*)
  DIconName.Text := IconName;
  (* group name *)
  if GroupNum > Number_Group then GroupNum := 0;
  PListGroup.ItemIndex := VIcons [VTrans.Number].GroupNum - 1;
 end;
end;

(* change directory *)
procedure TIconModDialog.ChangeDir(Sender: TObject);
begin
 if Liste.ItemIndex = 0 then
  DFilePath.Text := VIcons [VTrans.Number].FilePath
 else
  DFilePath.Text := VPath [Liste.ItemIndex].PathDriv;
end;

(* keep compress file *)
procedure TIconModDialog.KeepIt(Sender: TObject);
begin
 With VIcons [VTrans.Number] do
 begin
  if Compress = 1 then DCompFile.State := cbChecked
                  else DCompFile.State := cbUnChecked;
 end;
end;

(* Ok button *)
procedure TIconModDialog.OKBtnClick(Sender: TObject);
begin
 With VIcons [VTrans.Number] do
 begin
  IconName := DIconName.Text;
  if Liste.ItemIndex = 0 then
   FilePath := DFilePath.Text
  else
  begin
   Str (Liste.ItemIndex:1,FilePath);
   FilePath := '%' + FilePath;
  end;
  if PListGroup.ItemIndex <> -1 then GroupNum := PListGroup.ItemIndex + 1
                                else GroupNum := 1;
 end;
 ModalResult := mrOk;
end;

end.
