unit Filmod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,SysUtils;

type
  TFileModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    DNameFile: TEdit;
    DCompFile: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    DSizeSour: TEdit;
    DSizeTarg: TEdit;
    DCopyFile: TCheckBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    DFilePath: TEdit;
    Liste: TListBox;
    Label5: TLabel;
    Label6: TLabel;
    DDrivFile: TEdit;
    procedure Initialise(Sender: TObject);
    procedure KeepIt(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ChangeCop(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FileModDialog: TFileModDialog;

implementation

uses Decla;

{$R *.DFM}

(* init dialog *)
procedure TFileModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 (* init *)
 Liste.Clear;
 Liste.Items.Add ('Other');
 if Number_Direc > 1 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 with VFiles [VTrans.Number] do
 begin
  (* name *)
  DNameFile.Text := FileName;
  (* drive *)
  DDrivFile.Text := FileDriv;
  (* path *)
  if FilePath [1] = '%' then
  begin
   Val (FilePath [2],Num,Err);
   if Err = 0 then
   begin
    DFilePath.Text := VPath [Bcl].PathDriv;
    Liste.ItemIndex := Num;
   end
   else
   begin
    DFilePath.Text := FilePath;
    Liste.ItemIndex := 0;
   end;
  end
  else
  begin
   DFilePath.Text := FilePath;
   Liste.ItemIndex := 0;
  end;
  (* sizes *)
  if CopyFile = 1 then
  begin
   DSizeSour.Text := IntToStr (SizeNorm);
   if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                   else DSizeTarg.Text := IntToStr (SizeNorm);
  end
  else
  begin
   DSizeSour.Text := IntToStr (SizeNorm);
   DSizeTarg.Text := '0';
  end;
  (* compress *)
  if Compress = 1 then DCompFile.State := cbChecked
                  else DCompFile.State := cbUnChecked;
  (* copy *)
  if CopyFile = 1 then DCopyFile.State := cbChecked
                  else DCopyFile.State := cbUnChecked;
 end;
end;

(* do not modify this flag *)
procedure TFileModDialog.KeepIt(Sender: TObject);
begin
 With VFiles [VTrans.Number] do
 begin
  if Compress = 1 then DCompFile.State := cbChecked
                  else DCompFile.State := cbUnChecked;
 end;
end;

(* synchronize listbox and editzone*)
procedure TFileModDialog.ChangeDir(Sender: TObject);
begin
 if Liste.ItemIndex = 0 then
  DFilePath.Text := VFiles [VTrans.Number].FilePath
 else
  DFilePath.Text := VPath [Liste.ItemIndex].PathDriv;
end;

(* Ok button *)
procedure TFileModDialog.OKBtnClick(Sender: TObject);
begin
 With VFiles [VTrans.Number] do
 begin
  if Liste.ItemIndex = 0 then
   FilePath := DFilePath.Text
  else
  begin
   Str (Liste.ItemIndex:1,FilePath);
   FilePath := '%' + FilePath;
  end;
  if DCopyFile.State = cbChecked then
   CopyFile := 1
  else
  begin
   CopyFile := 0;
   FilePath := '';
  end;
 end;
 ModalResult := mrOk;
end;

(* Canging copy *)
procedure TFileModDialog.ChangeCop(Sender: TObject);
begin
 With VFiles [VTrans.Number] do
 begin
  if DCopyFile.State = cbChecked then CopyFile := 1
                                 else CopyFile := 0;
  (* sizes *)
  if CopyFile = 1 then
  begin
   DSizeSour.Text := IntToStr (SizeNorm);
   if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                   else DSizeTarg.Text := IntToStr (SizeNorm);
  end
  else
  begin
   DSizeSour.Text := IntToStr (SizeNorm);
   DSizeTarg.Text := '0';
  end;
 end;
end;

end.
