unit Appmod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,Dialogs;

const AppMaxi = 3;
      AppName : array [1 .. AppMaxi] of string =
                ('NOTEPAD.EXE (Text editor)',
                 'WRITE.EXE (Word Processor)',
                 'WINHELP.EXE (Help visualiser)');
type
  TAppModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Liste: TListBox;
    DDocsPath: TEdit;
    DDocsDriv: TEdit;
    Label1: TLabel;
    DDocsFile: TEdit;
    Label2: TLabel;
    Appli: TListBox;
    Label7: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label3: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AppModDialog: TAppModDialog;

implementation

Uses Decla;

{$R *.DFM}

(* Ok button *)
procedure TAppModDialog.OKBtnClick(Sender: TObject);
var Tmp : string;
begin
 With VRun [VTrans.Number] do
 begin
  if Appli.ItemIndex <> -1 then
  begin
   Tmp := Appli.Items [Appli.ItemIndex];
   FileName := copy (Tmp,1,pos ('(',Tmp) - 2);
   FilePath := '%W';
  end;
  if Liste.ItemIndex = 0 then
   DocsPath := DDocsPath.Text
  else
  begin
   Str (Liste.ItemIndex:1,DocsPath);
   DocsPath := '%' + DocsPath;
  end;
 end;
 ModalResult := mrOk;
end;

(* init dialog *)
procedure TAppModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 (* init *)
 Liste.Clear;
 Liste.Items.Add ('Other');
 if Number_Direc > 1 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 Liste.ItemIndex := -1;
 Appli.Clear;
 for Bcl := 1 to AppMaxi do
  Appli.Items.Add (AppName [Bcl]);
 Appli.ItemIndex := -1;
 with VRun [VTrans.Number] do
 begin
  (* name *)
  DDocsFile.Text := DocsName;
  (* drive *)
  DDocsDriv.Text := DocsDriv;
  (* path *)
  if DocsPath [1] = '%' then
  begin
   Val (DocsPath [2],Num,Err);
   if Err = 0 then
   begin
    DDocsPath.Text := VPath [Bcl].PathDriv;
    Liste.ItemIndex := Num;
   end
   else
   begin
    DDocsPath.Text := DocsPath;
    Liste.ItemIndex := 0;
   end;
  end
  else
  begin
   DDocsPath.Text := DocsPath;
   Liste.ItemIndex := 0;
  end;
  (* laucher *)
  for Bcl := 1 to AppMaxi do
  begin
   if FileName = copy (AppName [Bcl],1,pos ('(',AppName [Bcl]) - 2) then
    Appli.ItemIndex := (Bcl - 1);
  end;
 end;
end;

(* changing directory *)
procedure TAppModDialog.ChangeDir(Sender: TObject);
begin
 if Liste.ItemIndex = 0 then
  DDocsPath.Text := VRun [VTrans.Number].DocsPath
 else
  DDocsPath.Text := VPath [Liste.ItemIndex].PathDriv;
end;

end.
